/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.List;
import org.springframework.data.mongodb.core.ExecutableMapReduceOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableMapReduceOperationSupport
implements ExecutableMapReduceOperation {
    private static final Query ALL_QUERY = new Query();
    private final MongoTemplate template;

    ExecutableMapReduceOperationSupport(MongoTemplate template) {
        Assert.notNull((Object)template, "Template must not be null!");
        this.template = template;
    }

    public <T> ExecutableMapReduceSupport<T> mapReduce(Class<T> domainType) {
        Assert.notNull(domainType, "DomainType must not be null!");
        return new ExecutableMapReduceSupport<T>(this.template, domainType, domainType, null, ALL_QUERY, null, null, null);
    }

    static class ExecutableMapReduceSupport<T>
    implements ExecutableMapReduceOperation.ExecutableMapReduce<T>,
    ExecutableMapReduceOperation.MapReduceWithOptions<T>,
    ExecutableMapReduceOperation.MapReduceWithCollection<T>,
    ExecutableMapReduceOperation.MapReduceWithProjection<T>,
    ExecutableMapReduceOperation.MapReduceWithQuery<T>,
    ExecutableMapReduceOperation.MapReduceWithReduceFunction<T>,
    ExecutableMapReduceOperation.MapReduceWithMapFunction<T> {
        private final MongoTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        @Nullable
        private final String collection;
        private final Query query;
        @Nullable
        private final String mapFunction;
        @Nullable
        private final String reduceFunction;
        @Nullable
        private final MapReduceOptions options;

        ExecutableMapReduceSupport(MongoTemplate template, Class<?> domainType, Class<T> returnType, @Nullable String collection, Query query, @Nullable String mapFunction, @Nullable String reduceFunction, @Nullable MapReduceOptions options) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.collection = collection;
            this.query = query;
            this.mapFunction = mapFunction;
            this.reduceFunction = reduceFunction;
            this.options = options;
        }

        @Override
        public List<T> all() {
            return this.template.mapReduce(this.query, this.domainType, this.getCollectionName(), this.mapFunction, this.reduceFunction, this.options, this.returnType);
        }

        @Override
        public ExecutableMapReduceOperation.MapReduceWithProjection<T> inCollection(String collection) {
            Assert.hasText(collection, "Collection name must not be null nor empty!");
            return new ExecutableMapReduceSupport<T>(this.template, this.domainType, this.returnType, collection, this.query, this.mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public ExecutableMapReduceOperation.TerminatingMapReduce<T> matching(Query query) {
            Assert.notNull((Object)query, "Query must not be null!");
            return new ExecutableMapReduceSupport<T>(this.template, this.domainType, this.returnType, this.collection, query, this.mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public <R> ExecutableMapReduceOperation.MapReduceWithQuery<R> as(Class<R> resultType) {
            Assert.notNull(resultType, "ResultType must not be null!");
            return new ExecutableMapReduceSupport<R>(this.template, this.domainType, resultType, this.collection, this.query, this.mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public ExecutableMapReduceOperation.ExecutableMapReduce<T> with(MapReduceOptions options) {
            Assert.notNull((Object)options, "Options must not be null! Please consider empty MapReduceOptions#options() instead.");
            return new ExecutableMapReduceSupport<T>(this.template, this.domainType, this.returnType, this.collection, this.query, this.mapFunction, this.reduceFunction, options);
        }

        @Override
        public ExecutableMapReduceOperation.MapReduceWithReduceFunction<T> map(String mapFunction) {
            Assert.hasText(mapFunction, "MapFunction name must not be null nor empty!");
            return new ExecutableMapReduceSupport<T>(this.template, this.domainType, this.returnType, this.collection, this.query, mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public ExecutableMapReduceOperation.ExecutableMapReduce<T> reduce(String reduceFunction) {
            Assert.hasText(reduceFunction, "ReduceFunction name must not be null nor empty!");
            return new ExecutableMapReduceSupport<T>(this.template, this.domainType, this.returnType, this.collection, this.query, this.mapFunction, reduceFunction, this.options);
        }

        private String getCollectionName() {
            return StringUtils.hasText(this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }
    }
}

