/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.bulk.BulkWriteResult;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.ExecutableInsertOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableInsertOperationSupport
implements ExecutableInsertOperation {
    private final MongoTemplate template;

    ExecutableInsertOperationSupport(MongoTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, "DomainType must not be null!");
        return new ExecutableInsertSupport<T>(this.template, domainType, null, null);
    }

    static class ExecutableInsertSupport<T>
    implements ExecutableInsertOperation.ExecutableInsert<T> {
        private final MongoTemplate template;
        private final Class<T> domainType;
        @Nullable
        private final String collection;
        @Nullable
        private final BulkOperations.BulkMode bulkMode;

        ExecutableInsertSupport(MongoTemplate template, Class<T> domainType, String collection, BulkOperations.BulkMode bulkMode) {
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.bulkMode = bulkMode;
        }

        @Override
        public T one(T object) {
            Assert.notNull(object, "Object must not be null!");
            return this.template.insert(object, this.getCollectionName());
        }

        @Override
        public Collection<T> all(Collection<? extends T> objects) {
            Assert.notNull(objects, "Objects must not be null!");
            return this.template.insert(objects, this.getCollectionName());
        }

        @Override
        public BulkWriteResult bulk(Collection<? extends T> objects) {
            Assert.notNull(objects, "Objects must not be null!");
            return this.template.bulkOps(this.bulkMode != null ? this.bulkMode : BulkOperations.BulkMode.ORDERED, this.domainType, this.getCollectionName()).insert(new ArrayList<T>(objects)).execute();
        }

        @Override
        public ExecutableInsertOperation.InsertWithBulkMode<T> inCollection(String collection) {
            Assert.hasText(collection, "Collection must not be null nor empty.");
            return new ExecutableInsertSupport<T>(this.template, this.domainType, collection, this.bulkMode);
        }

        @Override
        public ExecutableInsertOperation.TerminatingBulkInsert<T> withBulkMode(BulkOperations.BulkMode bulkMode) {
            Assert.notNull((Object)bulkMode, "BulkMode must not be null!");
            return new ExecutableInsertSupport<T>(this.template, this.domainType, this.collection, bulkMode);
        }

        private String getCollectionName() {
            return StringUtils.hasText(this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }
    }
}

