/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import org.springframework.data.mongodb.core.ExecutableAggregationOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableAggregationOperationSupport
implements ExecutableAggregationOperation {
    private final MongoTemplate template;

    ExecutableAggregationOperationSupport(MongoTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableAggregationOperation.ExecutableAggregation<T> aggregateAndReturn(Class<T> domainType) {
        Assert.notNull(domainType, "DomainType must not be null!");
        return new ExecutableAggregationSupport<T>(this.template, domainType, null, null);
    }

    static class ExecutableAggregationSupport<T>
    implements ExecutableAggregationOperation.AggregationWithAggregation<T>,
    ExecutableAggregationOperation.ExecutableAggregation<T>,
    ExecutableAggregationOperation.TerminatingAggregation<T> {
        private final MongoTemplate template;
        private final Class<T> domainType;
        private final Aggregation aggregation;
        private final String collection;

        public ExecutableAggregationSupport(MongoTemplate template, Class<T> domainType, Aggregation aggregation, String collection) {
            this.template = template;
            this.domainType = domainType;
            this.aggregation = aggregation;
            this.collection = collection;
        }

        @Override
        public ExecutableAggregationOperation.AggregationWithAggregation<T> inCollection(String collection) {
            Assert.hasText(collection, "Collection must not be null nor empty!");
            return new ExecutableAggregationSupport<T>(this.template, this.domainType, this.aggregation, collection);
        }

        @Override
        public ExecutableAggregationOperation.TerminatingAggregation<T> by(Aggregation aggregation) {
            Assert.notNull((Object)aggregation, "Aggregation must not be null!");
            return new ExecutableAggregationSupport<T>(this.template, this.domainType, aggregation, this.collection);
        }

        @Override
        public AggregationResults<T> all() {
            return this.template.aggregate(this.aggregation, this.getCollectionName(this.aggregation), this.domainType);
        }

        @Override
        public CloseableIterator<T> stream() {
            return this.template.aggregateStream(this.aggregation, this.getCollectionName(this.aggregation), this.domainType);
        }

        private String getCollectionName(Aggregation aggregation) {
            TypedAggregation typedAggregation;
            if (StringUtils.hasText(this.collection)) {
                return this.collection;
            }
            if (aggregation instanceof TypedAggregation && (typedAggregation = (TypedAggregation)aggregation).getInputType() != null) {
                return this.template.getCollectionName(typedAggregation.getInputType());
            }
            return this.template.getCollectionName(this.domainType);
        }
    }
}

