/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.bson.json.JsonParseException;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.MappedDocument;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.mapping.TimeSeries;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class EntityOperations {
    private static final String ID_FIELD = "_id";
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context;

    EntityOperations(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
        this.context = context;
    }

    <T> Entity<T> forEntity(T entity) {
        Assert.notNull(entity, "Bean must not be null!");
        if (entity instanceof String) {
            return new UnmappedEntity<Document>(EntityOperations.parse(entity.toString()));
        }
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return MappedEntity.of(entity, this.context);
    }

    <T> AdaptibleEntity<T> forEntity(T entity, ConversionService conversionService) {
        Assert.notNull(entity, "Bean must not be null!");
        Assert.notNull((Object)conversionService, "ConversionService must not be null!");
        if (entity instanceof String) {
            return new UnmappedEntity<Document>(EntityOperations.parse(entity.toString()));
        }
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return AdaptibleMappedEntity.of(entity, this.context, conversionService);
    }

    static boolean isCollectionLike(@Nullable Object source) {
        if (source == null) {
            return false;
        }
        return ObjectUtils.isArray(source) || source instanceof Collection || source instanceof Iterator;
    }

    public String determineCollectionName(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined!");
        }
        return this.context.getRequiredPersistentEntity((MongoPersistentProperty)((Object)entityClass)).getCollection();
    }

    public Query getByIdInQuery(Collection<?> entities) {
        LinkedMultiValueMap byIds = new LinkedMultiValueMap();
        entities.stream().map(this::forEntity).forEach(it -> byIds.add(it.getIdFieldName(), it.getId()));
        Criteria[] criterias = (Criteria[])byIds.entrySet().stream().map(it -> Criteria.where((String)it.getKey()).in((Collection)it.getValue())).toArray(Criteria[]::new);
        return new Query(criterias.length == 1 ? criterias[0] : new Criteria().orOperator(criterias));
    }

    public String getIdPropertyName(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        MongoPersistentEntity<?> persistentEntity = this.context.getPersistentEntity((MongoPersistentProperty)((Object)type));
        if (persistentEntity != null && persistentEntity.getIdProperty() != null) {
            return ((MongoPersistentProperty)persistentEntity.getRequiredIdProperty()).getName();
        }
        return ID_FIELD;
    }

    public String nearQueryDistanceFieldName(Class<?> domainType) {
        MongoPersistentEntity<?> persistentEntity = this.context.getPersistentEntity((MongoPersistentProperty)((Object)domainType));
        if (persistentEntity == null || persistentEntity.getPersistentProperty("dis") == null) {
            return "dis";
        }
        String distanceFieldName = "calculated-distance";
        int counter = 0;
        while (persistentEntity.getPersistentProperty(distanceFieldName) != null) {
            distanceFieldName = distanceFieldName + "-" + counter++;
        }
        return distanceFieldName;
    }

    private static Document parse(String source) {
        try {
            return Document.parse(source);
        }
        catch (JsonParseException o_O) {
            throw new MappingException("Could not parse given String to save into a JSON document!", o_O);
        }
        catch (RuntimeException o_O) {
            if (ClassUtils.matchesTypeName(o_O.getClass(), "JSONParseException")) {
                throw new MappingException("Could not parse given String to save into a JSON document!", o_O);
            }
            throw o_O;
        }
    }

    public <T> TypedOperations<T> forType(@Nullable Class<T> entityClass) {
        MongoPersistentEntity<?> entity;
        if (entityClass != null && (entity = this.context.getPersistentEntity((MongoPersistentProperty)((Object)entityClass))) != null) {
            return new TypedEntityOperations(entity);
        }
        return UntypedOperations.instance();
    }

    static class TypedEntityOperations<T>
    implements TypedOperations<T> {
        private final MongoPersistentEntity<T> entity;

        protected TypedEntityOperations(MongoPersistentEntity<T> entity) {
            this.entity = entity;
        }

        @Override
        public Optional<Collation> getCollation() {
            return Optional.ofNullable(this.entity.getCollation());
        }

        @Override
        public Optional<Collation> getCollation(Query query) {
            if (query.getCollation().isPresent()) {
                return query.getCollation();
            }
            return Optional.ofNullable(this.entity.getCollation());
        }

        @Override
        public CollectionOptions getCollectionOptions() {
            CollectionOptions collectionOptions = CollectionOptions.empty();
            if (this.entity.hasCollation()) {
                collectionOptions = collectionOptions.collation(this.entity.getCollation());
            }
            if (this.entity.isAnnotationPresent(TimeSeries.class)) {
                TimeSeries timeSeries = this.entity.getRequiredAnnotation(TimeSeries.class);
                if (this.entity.getPersistentProperty(timeSeries.timeField()) == null) {
                    throw new MappingException(String.format("Time series field '%s' does not exist in type %s", timeSeries.timeField(), this.entity.getName()));
                }
                CollectionOptions.TimeSeriesOptions options = CollectionOptions.TimeSeriesOptions.timeSeries(timeSeries.timeField());
                if (StringUtils.hasText(timeSeries.metaField())) {
                    if (this.entity.getPersistentProperty(timeSeries.metaField()) == null) {
                        throw new MappingException(String.format("Meta field '%s' does not exist in type %s", timeSeries.metaField(), this.entity.getName()));
                    }
                    options = options.metaField(timeSeries.metaField());
                }
                if (!Granularity.DEFAULT.equals(timeSeries.granularity())) {
                    options = options.granularity(timeSeries.granularity());
                }
                collectionOptions = collectionOptions.timeSeries(options);
            }
            return collectionOptions;
        }

        @Override
        public CollectionOptions.TimeSeriesOptions mapTimeSeriesOptions(CollectionOptions.TimeSeriesOptions source) {
            CollectionOptions.TimeSeriesOptions target = CollectionOptions.TimeSeriesOptions.timeSeries(this.mappedNameOrDefault(source.getTimeField()));
            if (StringUtils.hasText(source.getMetaField())) {
                target = target.metaField(this.mappedNameOrDefault(source.getMetaField()));
            }
            return target.granularity(source.getGranularity());
        }

        private String mappedNameOrDefault(String name) {
            MongoPersistentProperty persistentProperty = (MongoPersistentProperty)this.entity.getPersistentProperty(name);
            return persistentProperty != null ? persistentProperty.getFieldName() : name;
        }
    }

    static enum UntypedOperations implements TypedOperations<Object>
    {
        INSTANCE;


        public static <T> TypedOperations<T> instance() {
            return INSTANCE;
        }

        @Override
        public Optional<Collation> getCollation() {
            return Optional.empty();
        }

        @Override
        public Optional<Collation> getCollation(Query query) {
            if (query == null) {
                return Optional.empty();
            }
            return query.getCollation();
        }

        @Override
        public CollectionOptions getCollectionOptions() {
            return CollectionOptions.empty();
        }

        @Override
        public CollectionOptions.TimeSeriesOptions mapTimeSeriesOptions(CollectionOptions.TimeSeriesOptions options) {
            return options;
        }
    }

    static interface TypedOperations<T> {
        public Optional<Collation> getCollation();

        public Optional<Collation> getCollation(Query var1);

        public CollectionOptions getCollectionOptions();

        public CollectionOptions.TimeSeriesOptions mapTimeSeriesOptions(CollectionOptions.TimeSeriesOptions var1);
    }

    private static class AdaptibleMappedEntity<T>
    extends MappedEntity<T>
    implements AdaptibleEntity<T> {
        private final MongoPersistentEntity<?> entity;
        private final ConvertingPropertyAccessor<T> propertyAccessor;
        private final IdentifierAccessor identifierAccessor;

        private AdaptibleMappedEntity(MongoPersistentEntity<?> entity, IdentifierAccessor identifierAccessor, ConvertingPropertyAccessor<T> propertyAccessor) {
            super(entity, identifierAccessor, propertyAccessor);
            this.entity = entity;
            this.propertyAccessor = propertyAccessor;
            this.identifierAccessor = identifierAccessor;
        }

        private static <T> AdaptibleEntity<T> of(T bean2, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, ConversionService conversionService) {
            MongoPersistentEntity<?> entity = context.getRequiredPersistentEntity((MongoPersistentProperty)((Object)bean2.getClass()));
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean2);
            PersistentPropertyAccessor<T> propertyAccessor = entity.getPropertyAccessor(bean2);
            return new AdaptibleMappedEntity<T>(entity, identifierAccessor, new ConvertingPropertyAccessor<T>(propertyAccessor, conversionService));
        }

        @Override
        @Nullable
        public T populateIdIfNecessary(@Nullable Object id) {
            if (id == null) {
                return (T)this.propertyAccessor.getBean();
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty == null) {
                return (T)this.propertyAccessor.getBean();
            }
            if (this.identifierAccessor.getIdentifier() != null) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty(idProperty, id);
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        @Nullable
        public Number getVersion() {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            return this.propertyAccessor.getProperty(versionProperty, Number.class);
        }

        @Override
        public T initializeVersionProperty() {
            MongoPersistentProperty versionProperty;
            if (!this.entity.hasVersionProperty()) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty(versionProperty, (Object)((versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty()).getType().isPrimitive() ? 1 : 0));
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public T incrementVersion() {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            Number version = this.getVersion();
            Long nextVersion = version == null ? 0L : version.longValue() + 1L;
            this.propertyAccessor.setProperty(versionProperty, (Object)nextVersion);
            return (T)this.propertyAccessor.getBean();
        }
    }

    private static class MappedEntity<T>
    implements Entity<T> {
        private final MongoPersistentEntity<?> entity;
        private final IdentifierAccessor idAccessor;
        private final PersistentPropertyAccessor<T> propertyAccessor;

        protected MappedEntity(MongoPersistentEntity<?> entity, IdentifierAccessor idAccessor, PersistentPropertyAccessor<T> propertyAccessor) {
            this.entity = entity;
            this.idAccessor = idAccessor;
            this.propertyAccessor = propertyAccessor;
        }

        private static <T> MappedEntity<T> of(T bean2, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
            MongoPersistentEntity<?> entity = context.getRequiredPersistentEntity((MongoPersistentProperty)((Object)bean2.getClass()));
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean2);
            PersistentPropertyAccessor<T> propertyAccessor = entity.getPropertyAccessor(bean2);
            return new MappedEntity<T>(entity, identifierAccessor, propertyAccessor);
        }

        @Override
        public String getIdFieldName() {
            return ((MongoPersistentProperty)this.entity.getRequiredIdProperty()).getFieldName();
        }

        @Override
        public Object getId() {
            return this.idAccessor.getRequiredIdentifier();
        }

        @Override
        public Query getByIdQuery() {
            if (!this.entity.hasIdProperty()) {
                throw new MappingException("No id property found for object of type " + this.entity.getType() + "!");
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            return Query.query(Criteria.where(idProperty.getName()).is(this.getId()));
        }

        @Override
        public Query getQueryForVersion() {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            return new Query(Criteria.where(idProperty.getName()).is(this.getId()).and(versionProperty.getName()).is(this.getVersion()));
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            T bean2 = this.propertyAccessor.getBean();
            Document document = new Document();
            writer.write(bean2, document);
            if (document.containsKey(EntityOperations.ID_FIELD) && document.get(EntityOperations.ID_FIELD) == null) {
                document.remove(EntityOperations.ID_FIELD);
            }
            return MappedDocument.of(document);
        }

        @Override
        public void assertUpdateableIdIfNotSet() {
            if (!this.entity.hasIdProperty()) {
                return;
            }
            MongoPersistentProperty property = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            Object propertyValue = this.idAccessor.getIdentifier();
            if (propertyValue != null) {
                return;
            }
            if (!MongoSimpleTypes.AUTOGENERATED_ID_TYPES.contains(property.getType())) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot autogenerate id of type %s for entity of type %s!", property.getType().getName(), this.entity.getType().getName()));
            }
        }

        @Override
        public boolean isVersionedEntity() {
            return this.entity.hasVersionProperty();
        }

        @Override
        @Nullable
        public Object getVersion() {
            return this.propertyAccessor.getProperty((PersistentProperty<?>)this.entity.getRequiredVersionProperty());
        }

        @Override
        public T getBean() {
            return this.propertyAccessor.getBean();
        }

        @Override
        public boolean isNew() {
            return this.entity.isNew(this.propertyAccessor.getBean());
        }
    }

    private static class SimpleMappedEntity<T extends Map<String, Object>>
    extends UnmappedEntity<T> {
        protected SimpleMappedEntity(T map) {
            super(map);
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            Object bean2 = this.getBean();
            bean2 = bean2 instanceof Document ? (Document)bean2 : new Document((Map<String, Object>)bean2);
            Document document = new Document();
            writer.write(bean2, document);
            return MappedDocument.of(document);
        }
    }

    private static class UnmappedEntity<T extends Map<String, Object>>
    implements AdaptibleEntity<T> {
        private final T map;

        protected UnmappedEntity(T map) {
            this.map = map;
        }

        @Override
        public String getIdFieldName() {
            return EntityOperations.ID_FIELD;
        }

        @Override
        public Object getId() {
            return this.map.get(EntityOperations.ID_FIELD);
        }

        @Override
        public Query getByIdQuery() {
            return Query.query(Criteria.where(EntityOperations.ID_FIELD).is(this.map.get(EntityOperations.ID_FIELD)));
        }

        @Override
        @Nullable
        public T populateIdIfNecessary(@Nullable Object id) {
            this.map.put((String)EntityOperations.ID_FIELD, (Object)id);
            return this.map;
        }

        @Override
        public Query getQueryForVersion() {
            throw new MappingException("Cannot query for version on plain Documents!");
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            return MappedDocument.of(this.map instanceof Document ? (Document)this.map : new Document((Map<String, Object>)this.map));
        }

        @Override
        public T initializeVersionProperty() {
            return this.map;
        }

        @Override
        @Nullable
        public Number getVersion() {
            return null;
        }

        @Override
        public T incrementVersion() {
            return this.map;
        }

        @Override
        public T getBean() {
            return this.map;
        }

        @Override
        public boolean isNew() {
            return this.map.get(EntityOperations.ID_FIELD) != null;
        }
    }

    static interface AdaptibleEntity<T>
    extends Entity<T> {
        @Nullable
        public T populateIdIfNecessary(@Nullable Object var1);

        public T initializeVersionProperty();

        public T incrementVersion();

        @Override
        @Nullable
        public Number getVersion();
    }

    static interface Entity<T> {
        public String getIdFieldName();

        public Object getId();

        public Query getByIdQuery();

        default public Query getRemoveByQuery() {
            return this.isVersionedEntity() ? this.getQueryForVersion() : this.getByIdQuery();
        }

        public Query getQueryForVersion();

        public MappedDocument toMappedDocument(MongoWriter<? super T> var1);

        default public void assertUpdateableIdIfNotSet() {
        }

        default public boolean isVersionedEntity() {
            return false;
        }

        @Nullable
        public Object getVersion();

        public T getBean();

        public boolean isNew();
    }
}

