/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import java.util.Optional;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.data.mongodb.core.timeseries.GranularityDefinition;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CollectionOptions {
    @Nullable
    private Long maxDocuments;
    @Nullable
    private Long size;
    @Nullable
    private Boolean capped;
    @Nullable
    private Collation collation;
    private ValidationOptions validationOptions;
    @Nullable
    private TimeSeriesOptions timeSeriesOptions;

    @Deprecated
    public CollectionOptions(@Nullable Long size, @Nullable Long maxDocuments, @Nullable Boolean capped) {
        this(size, maxDocuments, capped, null, ValidationOptions.none(), null);
    }

    private CollectionOptions(@Nullable Long size, @Nullable Long maxDocuments, @Nullable Boolean capped, @Nullable Collation collation, ValidationOptions validationOptions, @Nullable TimeSeriesOptions timeSeriesOptions) {
        this.maxDocuments = maxDocuments;
        this.size = size;
        this.capped = capped;
        this.collation = collation;
        this.validationOptions = validationOptions;
        this.timeSeriesOptions = timeSeriesOptions;
    }

    public static CollectionOptions just(Collation collation) {
        Assert.notNull((Object)collation, "Collation must not be null!");
        return new CollectionOptions(null, null, null, collation, ValidationOptions.none(), null);
    }

    public static CollectionOptions empty() {
        return new CollectionOptions(null, null, null, null, ValidationOptions.none(), null);
    }

    public static CollectionOptions timeSeries(String timeField) {
        return CollectionOptions.empty().timeSeries(TimeSeriesOptions.timeSeries(timeField));
    }

    public CollectionOptions capped() {
        return new CollectionOptions(this.size, this.maxDocuments, true, this.collation, this.validationOptions, null);
    }

    public CollectionOptions maxDocuments(long maxDocuments) {
        return new CollectionOptions(this.size, maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions);
    }

    public CollectionOptions size(long size) {
        return new CollectionOptions(size, this.maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions);
    }

    public CollectionOptions collation(@Nullable Collation collation) {
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, collation, this.validationOptions, this.timeSeriesOptions);
    }

    public CollectionOptions schema(@Nullable MongoJsonSchema schema) {
        return this.validator(Validator.schema(schema));
    }

    public CollectionOptions validator(@Nullable Validator validator) {
        return this.validation(this.validationOptions.validator(validator));
    }

    public CollectionOptions disableValidation() {
        return this.schemaValidationLevel(ValidationLevel.OFF);
    }

    public CollectionOptions strictValidation() {
        return this.schemaValidationLevel(ValidationLevel.STRICT);
    }

    public CollectionOptions moderateValidation() {
        return this.schemaValidationLevel(ValidationLevel.MODERATE);
    }

    public CollectionOptions warnOnValidationError() {
        return this.schemaValidationAction(ValidationAction.WARN);
    }

    public CollectionOptions failOnValidationError() {
        return this.schemaValidationAction(ValidationAction.ERROR);
    }

    public CollectionOptions schemaValidationLevel(ValidationLevel validationLevel) {
        Assert.notNull((Object)validationLevel, "ValidationLevel must not be null!");
        return this.validation(this.validationOptions.validationLevel(validationLevel));
    }

    public CollectionOptions schemaValidationAction(ValidationAction validationAction) {
        Assert.notNull((Object)validationAction, "ValidationAction must not be null!");
        return this.validation(this.validationOptions.validationAction(validationAction));
    }

    public CollectionOptions validation(ValidationOptions validationOptions) {
        Assert.notNull((Object)validationOptions, "ValidationOptions must not be null!");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, validationOptions, this.timeSeriesOptions);
    }

    public CollectionOptions timeSeries(TimeSeriesOptions timeSeriesOptions) {
        Assert.notNull((Object)timeSeriesOptions, "TimeSeriesOptions must not be null!");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, this.validationOptions, timeSeriesOptions);
    }

    public Optional<Long> getMaxDocuments() {
        return Optional.ofNullable(this.maxDocuments);
    }

    public Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    public Optional<Boolean> getCapped() {
        return Optional.ofNullable(this.capped);
    }

    public Optional<Collation> getCollation() {
        return Optional.ofNullable(this.collation);
    }

    public Optional<ValidationOptions> getValidationOptions() {
        return this.validationOptions.isEmpty() ? Optional.empty() : Optional.of(this.validationOptions);
    }

    public Optional<TimeSeriesOptions> getTimeSeriesOptions() {
        return Optional.ofNullable(this.timeSeriesOptions);
    }

    public static class TimeSeriesOptions {
        private final String timeField;
        @Nullable
        private final String metaField;
        private final GranularityDefinition granularity;

        private TimeSeriesOptions(String timeField, @Nullable String metaField, GranularityDefinition granularity) {
            Assert.hasText(timeField, "Time field must not be empty or null!");
            this.timeField = timeField;
            this.metaField = metaField;
            this.granularity = granularity;
        }

        public static TimeSeriesOptions timeSeries(String timeField) {
            return new TimeSeriesOptions(timeField, null, Granularity.DEFAULT);
        }

        public TimeSeriesOptions metaField(String metaField) {
            return new TimeSeriesOptions(this.timeField, metaField, this.granularity);
        }

        public TimeSeriesOptions granularity(GranularityDefinition granularity) {
            return new TimeSeriesOptions(this.timeField, this.metaField, granularity);
        }

        public String getTimeField() {
            return this.timeField;
        }

        @Nullable
        public String getMetaField() {
            return this.metaField;
        }

        public GranularityDefinition getGranularity() {
            return this.granularity;
        }
    }

    public static class ValidationOptions {
        private static final ValidationOptions NONE = new ValidationOptions(null, null, null);
        @Nullable
        private final Validator validator;
        @Nullable
        private final ValidationLevel validationLevel;
        @Nullable
        private final ValidationAction validationAction;

        public ValidationOptions(Validator validator, ValidationLevel validationLevel, ValidationAction validationAction) {
            this.validator = validator;
            this.validationLevel = validationLevel;
            this.validationAction = validationAction;
        }

        public static ValidationOptions none() {
            return NONE;
        }

        public ValidationOptions validator(@Nullable Validator validator) {
            return new ValidationOptions(validator, this.validationLevel, this.validationAction);
        }

        public ValidationOptions validationLevel(ValidationLevel validationLevel) {
            return new ValidationOptions(this.validator, validationLevel, this.validationAction);
        }

        public ValidationOptions validationAction(ValidationAction validationAction) {
            return new ValidationOptions(this.validator, this.validationLevel, validationAction);
        }

        public Optional<Validator> getValidator() {
            return Optional.ofNullable(this.validator);
        }

        public Optional<ValidationLevel> getValidationLevel() {
            return Optional.ofNullable(this.validationLevel);
        }

        public Optional<ValidationAction> getValidationAction() {
            return Optional.ofNullable(this.validationAction);
        }

        boolean isEmpty() {
            return !Optionals.isAnyPresent(this.getValidator(), this.getValidationAction(), this.getValidationLevel());
        }
    }
}

