/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.ConnectionStringPropertyEditor;
import org.springframework.data.mongodb.config.MongoCredentialPropertyEditor;
import org.springframework.data.mongodb.config.ReadConcernPropertyEditor;
import org.springframework.data.mongodb.config.ReadPreferencePropertyEditor;
import org.springframework.data.mongodb.config.UUidRepresentationPropertyEditor;
import org.springframework.data.mongodb.config.WriteConcernPropertyEditor;
import org.springframework.data.mongodb.core.MongoClientSettingsFactoryBean;
import org.springframework.data.mongodb.core.MongoServerApiFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class MongoParsingUtils {
    private MongoParsingUtils() {
    }

    public static boolean parseMongoClientSettings(Element element, BeanDefinitionBuilder mongoClientBuilder) {
        Element settingsElement = DomUtils.getChildElementByTagName(element, "client-settings");
        if (settingsElement == null) {
            return false;
        }
        BeanDefinitionBuilder clientOptionsDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoClientSettingsFactoryBean.class);
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "application-name", "applicationName");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "read-preference", "readPreference");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "read-concern", "readConcern");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "write-concern", "writeConcern");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "retry-reads", "retryReads");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "retry-writes", "retryWrites");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "uuid-representation", "uUidRepresentation");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "socket-connect-timeout", "socketConnectTimeoutMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "socket-read-timeout", "socketReadTimeoutMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "socket-receive-buffer-size", "socketReceiveBufferSize");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "socket-send-buffer-size", "socketSendBufferSize");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "server-heartbeat-frequency", "serverHeartbeatFrequencyMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "server-min-heartbeat-frequency", "serverMinHeartbeatFrequencyMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "cluster-srv-host", "clusterSrvHost");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "cluster-hosts", "clusterHosts");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "cluster-connection-mode", "clusterConnectionMode");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "cluster-type", "custerRequiredClusterType");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "cluster-local-threshold", "clusterLocalThresholdMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "cluster-server-selection-timeout", "clusterServerSelectionTimeoutMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "connection-pool-max-size", "poolMaxSize");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "connection-pool-min-size", "poolMinSize");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "connection-pool-max-wait-time", "poolMaxWaitTimeMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "connection-pool-max-connection-life-time", "poolMaxConnectionLifeTimeMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "connection-pool-max-connection-idle-time", "poolMaxConnectionIdleTimeMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "connection-pool-maintenance-initial-delay", "poolMaintenanceInitialDelayMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "connection-pool-maintenance-frequency", "poolMaintenanceFrequencyMS");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "ssl-enabled", "sslEnabled");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "ssl-invalid-host-name-allowed", "sslInvalidHostNameAllowed");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, settingsElement, "ssl-provider", "sslProvider");
        ParsingUtils.setPropertyReference(clientOptionsDefBuilder, settingsElement, "encryption-settings-ref", "autoEncryptionSettings");
        if (StringUtils.hasText(settingsElement.getAttribute("server-api-version"))) {
            MongoServerApiFactoryBean serverApiFactoryBean = new MongoServerApiFactoryBean();
            serverApiFactoryBean.setVersion(settingsElement.getAttribute("server-api-version"));
            try {
                clientOptionsDefBuilder.addPropertyValue("serverApi", serverApiFactoryBean.getObject());
            }
            catch (Exception exception) {
                throw new BeanDefinitionValidationException("Non parsable server-api.", exception);
            }
        } else {
            ParsingUtils.setPropertyReference(clientOptionsDefBuilder, settingsElement, "server-api-ref", "serverApi");
        }
        mongoClientBuilder.addPropertyValue("mongoClientSettings", clientOptionsDefBuilder.getBeanDefinition());
        return true;
    }

    static BeanDefinitionBuilder getWriteConcernPropertyEditorBuilder() {
        ManagedMap<String, Class<WriteConcernPropertyEditor>> customEditors = new ManagedMap<String, Class<WriteConcernPropertyEditor>>();
        customEditors.put("com.mongodb.WriteConcern", WriteConcernPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getReadConcernPropertyEditorBuilder() {
        ManagedMap<String, Class<ReadConcernPropertyEditor>> customEditors = new ManagedMap<String, Class<ReadConcernPropertyEditor>>();
        customEditors.put("com.mongodb.ReadConcern", ReadConcernPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getServerAddressPropertyEditorBuilder() {
        ManagedMap<String, String> customEditors = new ManagedMap<String, String>();
        customEditors.put("com.mongodb.ServerAddress[]", "org.springframework.data.mongodb.config.ServerAddressPropertyEditor");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getReadPreferencePropertyEditorBuilder() {
        ManagedMap<String, Class<ReadPreferencePropertyEditor>> customEditors = new ManagedMap<String, Class<ReadPreferencePropertyEditor>>();
        customEditors.put("com.mongodb.ReadPreference", ReadPreferencePropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getMongoCredentialPropertyEditor() {
        ManagedMap<String, Class<MongoCredentialPropertyEditor>> customEditors = new ManagedMap<String, Class<MongoCredentialPropertyEditor>>();
        customEditors.put("com.mongodb.MongoCredential[]", MongoCredentialPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getConnectionStringPropertyEditorBuilder() {
        ManagedMap<String, Class<ConnectionStringPropertyEditor>> customEditors = new ManagedMap<String, Class<ConnectionStringPropertyEditor>>();
        customEditors.put("com.mongodb.ConnectionString", ConnectionStringPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getUUidRepresentationEditorBuilder() {
        ManagedMap<String, Class<UUidRepresentationPropertyEditor>> customEditors = new ManagedMap<String, Class<UUidRepresentationPropertyEditor>>();
        customEditors.put("org.bson.UuidRepresentation", UUidRepresentationPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }
}

