/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoParsingUtils;
import org.springframework.data.mongodb.core.MongoClientFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoClientParser
implements BeanDefinitionParser {
    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource(element);
        String id = element.getAttribute("id");
        BeanComponentDefinitionBuilder helper = new BeanComponentDefinitionBuilder(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MongoClientFactoryBean.class);
        ParsingUtils.setPropertyValue(builder, element, "port", "port");
        ParsingUtils.setPropertyValue(builder, element, "host", "host");
        ParsingUtils.setPropertyValue(builder, element, "credential", "credential");
        ParsingUtils.setPropertyValue(builder, element, "replica-set", "replicaSet");
        ParsingUtils.setPropertyValue(builder, element, "connection-string", "connectionString");
        MongoParsingUtils.parseMongoClientSettings(element, builder);
        String defaultedId = StringUtils.hasText(id) ? id : "mongoClient";
        parserContext.pushContainingComponent(new CompositeComponentDefinition("Mongo", source));
        BeanComponentDefinition mongoComponent = helper.getComponent(builder, defaultedId);
        parserContext.registerBeanComponent(mongoComponent);
        BeanComponentDefinition connectionStringPropertyEditor = helper.getComponent(MongoParsingUtils.getConnectionStringPropertyEditorBuilder());
        parserContext.registerBeanComponent(connectionStringPropertyEditor);
        BeanComponentDefinition serverAddressPropertyEditor = helper.getComponent(MongoParsingUtils.getServerAddressPropertyEditorBuilder());
        parserContext.registerBeanComponent(serverAddressPropertyEditor);
        BeanComponentDefinition writeConcernEditor = helper.getComponent(MongoParsingUtils.getWriteConcernPropertyEditorBuilder());
        parserContext.registerBeanComponent(writeConcernEditor);
        BeanComponentDefinition readConcernEditor = helper.getComponent(MongoParsingUtils.getReadConcernPropertyEditorBuilder());
        parserContext.registerBeanComponent(readConcernEditor);
        BeanComponentDefinition readPreferenceEditor = helper.getComponent(MongoParsingUtils.getReadPreferencePropertyEditorBuilder());
        parserContext.registerBeanComponent(readPreferenceEditor);
        BeanComponentDefinition credentialsEditor = helper.getComponent(MongoParsingUtils.getMongoCredentialPropertyEditor());
        parserContext.registerBeanComponent(credentialsEditor);
        BeanComponentDefinition uuidRepresentationEditor = helper.getComponent(MongoParsingUtils.getUUidRepresentationEditorBuilder());
        parserContext.registerBeanComponent(uuidRepresentationEditor);
        parserContext.popAndRegisterContainingComponent();
        return mongoComponent.getBeanDefinition();
    }
}

