/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.auditing.config.IsNewAwareAuditingHandlerBeanDefinitionParser;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoAuditingRegistrar;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.event.AuditingEntityCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveAuditingEntityCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoAuditingBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static boolean PROJECT_REACTOR_AVAILABLE = ClassUtils.isPresent("reactor.core.publisher.Mono", MongoAuditingRegistrar.class.getClassLoader());

    @Override
    protected Class<?> getBeanClass(Element element) {
        return AuditingEntityCallback.class;
    }

    @Override
    protected boolean shouldGenerateId() {
        return true;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String mappingContextRef = element.getAttribute("mapping-context-ref");
        if (!StringUtils.hasText(mappingContextRef)) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            if (!registry.containsBeanDefinition("mongoMappingContext")) {
                registry.registerBeanDefinition("mongoMappingContext", new RootBeanDefinition(MongoMappingContext.class));
            }
            mappingContextRef = "mongoMappingContext";
        }
        IsNewAwareAuditingHandlerBeanDefinitionParser parser = new IsNewAwareAuditingHandlerBeanDefinitionParser(mappingContextRef);
        parser.parse(element, parserContext);
        AbstractBeanDefinition isNewAwareAuditingHandler = ParsingUtils.getObjectFactoryBeanDefinition(parser.getResolvedBeanName(), parserContext.extractSource(element));
        builder.addConstructorArgValue(isNewAwareAuditingHandler);
        if (PROJECT_REACTOR_AVAILABLE) {
            this.registerReactiveAuditingEntityCallback(parserContext.getRegistry(), isNewAwareAuditingHandler, parserContext.extractSource(element));
        }
    }

    private void registerReactiveAuditingEntityCallback(BeanDefinitionRegistry registry, AbstractBeanDefinition isNewAwareAuditingHandler, @Nullable Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReactiveAuditingEntityCallback.class);
        builder.addConstructorArgValue(isNewAwareAuditingHandler);
        builder.getRawBeanDefinition().setSource(source);
        registry.registerBeanDefinition(ReactiveAuditingEntityCallback.class.getName(), builder.getBeanDefinition());
    }
}

