/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.mapping.model.CamelCaseAbbreviatingFieldNamingStrategy;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.event.ValidatingMongoEventListener;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MappingMongoConverterParser
implements BeanDefinitionParser {
    private static final String BASE_PACKAGE = "base-package";
    private static final boolean JSR_303_PRESENT = ClassUtils.isPresent("javax.validation.Validator", MappingMongoConverterParser.class.getClassLoader());

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        if (parserContext.isNested()) {
            parserContext.getReaderContext().error("Mongo Converter must not be defined as nested bean.", element);
        }
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String id = element.getAttribute("id");
        id = StringUtils.hasText(id) ? id : "mappingConverter";
        String autoIndexCreation = element.getAttribute("auto-index-creation");
        boolean autoIndexCreationEnabled = StringUtils.hasText(autoIndexCreation) && Boolean.valueOf(autoIndexCreation) != false;
        parserContext.pushContainingComponent(new CompositeComponentDefinition("Mapping Mongo Converter", element));
        BeanDefinition conversionsDefinition = this.getCustomConversions(element, parserContext);
        String ctxRef = MappingMongoConverterParser.potentiallyCreateMappingContext(element, parserContext, conversionsDefinition, id);
        String dbFactoryRef = element.getAttribute("db-factory-ref");
        if (!StringUtils.hasText(dbFactoryRef)) {
            dbFactoryRef = "mongoDbFactory";
        }
        BeanDefinitionBuilder converterBuilder = BeanDefinitionBuilder.genericBeanDefinition(MappingMongoConverter.class);
        converterBuilder.addConstructorArgReference(dbFactoryRef);
        converterBuilder.addConstructorArgReference(ctxRef);
        String typeMapperRef = element.getAttribute("type-mapper-ref");
        if (StringUtils.hasText(typeMapperRef)) {
            converterBuilder.addPropertyReference("typeMapper", typeMapperRef);
        }
        if (conversionsDefinition != null) {
            converterBuilder.addPropertyValue("customConversions", conversionsDefinition);
        }
        if (!registry.containsBeanDefinition("indexOperationsProvider")) {
            BeanDefinitionBuilder indexOperationsProviderBuilder = BeanDefinitionBuilder.genericBeanDefinition("org.springframework.data.mongodb.core.DefaultIndexOperationsProvider");
            indexOperationsProviderBuilder.addConstructorArgReference(dbFactoryRef);
            indexOperationsProviderBuilder.addConstructorArgValue(BeanDefinitionBuilder.genericBeanDefinition(QueryMapper.class).addConstructorArgReference(id).getBeanDefinition());
            parserContext.registerBeanComponent(new BeanComponentDefinition(indexOperationsProviderBuilder.getBeanDefinition(), "indexOperationsProvider"));
        }
        try {
            registry.getBeanDefinition("indexCreationHelper");
        }
        catch (NoSuchBeanDefinitionException ignored) {
            BeanDefinitionBuilder indexHelperBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoPersistentEntityIndexCreator.class);
            indexHelperBuilder.addConstructorArgReference(ctxRef);
            indexHelperBuilder.addConstructorArgReference("indexOperationsProvider");
            indexHelperBuilder.addDependsOn(ctxRef);
            parserContext.registerBeanComponent(new BeanComponentDefinition(indexHelperBuilder.getBeanDefinition(), "indexCreationHelper"));
        }
        BeanDefinition validatingMongoEventListener = this.potentiallyCreateValidatingMongoEventListener(element, parserContext);
        if (validatingMongoEventListener != null) {
            parserContext.registerBeanComponent(new BeanComponentDefinition(validatingMongoEventListener, "validatingMongoEventListener"));
        }
        parserContext.registerBeanComponent(new BeanComponentDefinition(converterBuilder.getBeanDefinition(), id));
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    @Nullable
    private BeanDefinition potentiallyCreateValidatingMongoEventListener(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        RuntimeBeanReference validator;
        boolean validationDisabled;
        String disableValidation = element.getAttribute("disable-validation");
        boolean bl = validationDisabled = StringUtils.hasText(disableValidation) && Boolean.valueOf(disableValidation) != false;
        if (!validationDisabled && (validator = this.getValidator(builder = BeanDefinitionBuilder.genericBeanDefinition(), parserContext)) != null) {
            builder.getRawBeanDefinition().setBeanClass(ValidatingMongoEventListener.class);
            builder.addConstructorArgValue(validator);
            return builder.getBeanDefinition();
        }
        return null;
    }

    @Nullable
    private RuntimeBeanReference getValidator(Object source, ParserContext parserContext) {
        if (!JSR_303_PRESENT) {
            return null;
        }
        RootBeanDefinition validatorDef = new RootBeanDefinition("org.springframework.validation.beanvalidation.LocalValidatorFactoryBean");
        validatorDef.setSource(source);
        validatorDef.setRole(2);
        String validatorName = parserContext.getReaderContext().registerWithGeneratedName(validatorDef);
        parserContext.registerBeanComponent(new BeanComponentDefinition(validatorDef, validatorName));
        return new RuntimeBeanReference(validatorName);
    }

    public static String potentiallyCreateMappingContext(Element element, ParserContext parserContext, @Nullable BeanDefinition conversionsDefinition, @Nullable String converterId) {
        return MappingMongoConverterParser.potentiallyCreateMappingContext(element, parserContext, conversionsDefinition, converterId, false);
    }

    public static String potentiallyCreateMappingContext(Element element, ParserContext parserContext, @Nullable BeanDefinition conversionsDefinition, @Nullable String converterId, boolean autoIndexCreation) {
        String ctxRef = element.getAttribute("mapping-context-ref");
        if (StringUtils.hasText(ctxRef)) {
            return ctxRef;
        }
        BeanComponentDefinitionBuilder componentDefinitionBuilder = new BeanComponentDefinitionBuilder(element, parserContext);
        BeanDefinitionBuilder mappingContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoMappingContext.class);
        Set<String> classesToAdd = MappingMongoConverterParser.getInitialEntityClasses(element);
        if (classesToAdd != null) {
            mappingContextBuilder.addPropertyValue("initialEntitySet", classesToAdd);
        }
        if (conversionsDefinition != null) {
            GenericBeanDefinition simpleTypesDefinition = new GenericBeanDefinition();
            simpleTypesDefinition.setFactoryBeanName("customConversions");
            simpleTypesDefinition.setFactoryMethodName("getSimpleTypeHolder");
            mappingContextBuilder.addPropertyValue("simpleTypeHolder", simpleTypesDefinition);
        }
        mappingContextBuilder.addPropertyValue("autoIndexCreation", autoIndexCreation);
        MappingMongoConverterParser.parseFieldNamingStrategy(element, parserContext.getReaderContext(), mappingContextBuilder);
        ctxRef = converterId == null || "mappingConverter".equals(converterId) ? "mongoMappingContext" : converterId + "." + "mongoMappingContext";
        parserContext.registerBeanComponent(componentDefinitionBuilder.getComponent(mappingContextBuilder, ctxRef));
        return ctxRef;
    }

    private static void parseFieldNamingStrategy(Element element, ReaderContext context, BeanDefinitionBuilder builder) {
        boolean abbreviationActivated;
        String abbreviateFieldNames = element.getAttribute("abbreviate-field-names");
        String fieldNamingStrategy = element.getAttribute("field-naming-strategy-ref");
        boolean fieldNamingStrategyReferenced = StringUtils.hasText(fieldNamingStrategy);
        boolean bl = abbreviationActivated = StringUtils.hasText(abbreviateFieldNames) && Boolean.parseBoolean(abbreviateFieldNames);
        if (fieldNamingStrategyReferenced && abbreviationActivated) {
            context.error("Field name abbreviation cannot be activated if a field-naming-strategy-ref is configured!", element);
            return;
        }
        BeanMetadataElement value = null;
        if ("true".equals(abbreviateFieldNames)) {
            value = new RootBeanDefinition(CamelCaseAbbreviatingFieldNamingStrategy.class);
        } else if (fieldNamingStrategyReferenced) {
            value = new RuntimeBeanReference(fieldNamingStrategy);
        }
        if (value != null) {
            builder.addPropertyValue("fieldNamingStrategy", value);
        }
    }

    @Nullable
    private BeanDefinition getCustomConversions(Element element, ParserContext parserContext) {
        List<Element> customConvertersElements = DomUtils.getChildElementsByTagName(element, "custom-converters");
        if (customConvertersElements.size() == 1) {
            String packageToScan;
            Element customerConvertersElement = customConvertersElements.get(0);
            ManagedList<BeanMetadataElement> converterBeans = new ManagedList<BeanMetadataElement>();
            List<Element> converterElements = DomUtils.getChildElementsByTagName(customerConvertersElement, "converter");
            if (converterElements != null) {
                for (Element listenerElement : converterElements) {
                    converterBeans.add(this.parseConverter(listenerElement, parserContext));
                }
            }
            if (StringUtils.hasText(packageToScan = customerConvertersElement.getAttribute(BASE_PACKAGE))) {
                ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
                provider.addExcludeFilter(new NegatingFilter(new AssignableTypeFilter(Converter.class), new AssignableTypeFilter(GenericConverter.class)));
                converterBeans.addAll(provider.findCandidateComponents(packageToScan));
            }
            BeanDefinitionBuilder conversionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(MongoCustomConversions.class);
            conversionsBuilder.addConstructorArgValue(converterBeans);
            AbstractBeanDefinition conversionsBean = conversionsBuilder.getBeanDefinition();
            conversionsBean.setSource(parserContext.extractSource(element));
            parserContext.registerBeanComponent(new BeanComponentDefinition(conversionsBean, "customConversions"));
            return conversionsBean;
        }
        return null;
    }

    @Nullable
    private static Set<String> getInitialEntityClasses(Element element) {
        String basePackage = element.getAttribute(BASE_PACKAGE);
        if (!StringUtils.hasText(basePackage)) {
            return null;
        }
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter(new AnnotationTypeFilter(Document.class));
        componentProvider.addIncludeFilter(new AnnotationTypeFilter(Persistent.class));
        ManagedSet<String> classes = new ManagedSet<String>();
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
            classes.add(candidate.getBeanClassName());
        }
        return classes;
    }

    @Nullable
    public BeanMetadataElement parseConverter(Element element, ParserContext parserContext) {
        String converterRef = element.getAttribute("ref");
        if (StringUtils.hasText(converterRef)) {
            return new RuntimeBeanReference(converterRef);
        }
        Element beanElement = DomUtils.getChildElementByTagName(element, "bean");
        if (beanElement != null) {
            BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(beanElement);
            beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDef);
            return beanDef;
        }
        parserContext.getReaderContext().error("Element <converter> must specify 'ref' or contain a bean definition for the converter", element);
        return null;
    }

    private static class NegatingFilter
    implements TypeFilter {
        private final Set<TypeFilter> delegates;

        public NegatingFilter(TypeFilter ... filters) {
            Assert.notNull((Object)filters, "TypeFilters must not be null");
            this.delegates = new HashSet<TypeFilter>(Arrays.asList(filters));
        }

        @Override
        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            for (TypeFilter delegate : this.delegates) {
                if (!delegate.match(metadataReader, metadataReaderFactory)) continue;
                return false;
            }
            return true;
        }
    }
}

