/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoResourceHolder;
import org.springframework.data.mongodb.SessionSynchronization;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoDatabaseUtils {
    public static MongoDatabase getDatabase(MongoDatabaseFactory factory) {
        return MongoDatabaseUtils.doGetMongoDatabase(null, factory, SessionSynchronization.ON_ACTUAL_TRANSACTION);
    }

    public static MongoDatabase getDatabase(MongoDatabaseFactory factory, SessionSynchronization sessionSynchronization) {
        return MongoDatabaseUtils.doGetMongoDatabase(null, factory, sessionSynchronization);
    }

    public static MongoDatabase getDatabase(@Nullable String dbName, MongoDatabaseFactory factory) {
        return MongoDatabaseUtils.doGetMongoDatabase(dbName, factory, SessionSynchronization.ON_ACTUAL_TRANSACTION);
    }

    public static MongoDatabase getDatabase(@Nullable String dbName, MongoDatabaseFactory factory, SessionSynchronization sessionSynchronization) {
        return MongoDatabaseUtils.doGetMongoDatabase(dbName, factory, sessionSynchronization);
    }

    private static MongoDatabase doGetMongoDatabase(@Nullable String dbName, MongoDatabaseFactory factory, SessionSynchronization sessionSynchronization) {
        Assert.notNull((Object)factory, "Factory must not be null!");
        if (sessionSynchronization == SessionSynchronization.NEVER || !TransactionSynchronizationManager.isSynchronizationActive()) {
            return StringUtils.hasText(dbName) ? factory.getMongoDatabase(dbName) : factory.getMongoDatabase();
        }
        ClientSession session = MongoDatabaseUtils.doGetSession(factory, sessionSynchronization);
        if (session == null) {
            return StringUtils.hasText(dbName) ? factory.getMongoDatabase(dbName) : factory.getMongoDatabase();
        }
        MongoDatabaseFactory factoryToUse = factory.withSession(session);
        return StringUtils.hasText(dbName) ? factoryToUse.getMongoDatabase(dbName) : factoryToUse.getMongoDatabase();
    }

    public static boolean isTransactionActive(MongoDatabaseFactory dbFactory) {
        if (dbFactory.isTransactionActive()) {
            return true;
        }
        MongoResourceHolder resourceHolder = (MongoResourceHolder)TransactionSynchronizationManager.getResource(dbFactory);
        return resourceHolder != null && resourceHolder.hasActiveTransaction();
    }

    @Nullable
    private static ClientSession doGetSession(MongoDatabaseFactory dbFactory, SessionSynchronization sessionSynchronization) {
        MongoResourceHolder resourceHolder = (MongoResourceHolder)TransactionSynchronizationManager.getResource(dbFactory);
        if (resourceHolder != null && (resourceHolder.hasSession() || resourceHolder.isSynchronizedWithTransaction())) {
            if (!resourceHolder.hasSession()) {
                resourceHolder.setSession(MongoDatabaseUtils.createClientSession(dbFactory));
            }
            return resourceHolder.getSession();
        }
        if (SessionSynchronization.ON_ACTUAL_TRANSACTION.equals((Object)sessionSynchronization)) {
            return null;
        }
        resourceHolder = new MongoResourceHolder(MongoDatabaseUtils.createClientSession(dbFactory), dbFactory);
        resourceHolder.getRequiredSession().startTransaction();
        TransactionSynchronizationManager.registerSynchronization(new MongoSessionSynchronization(resourceHolder, dbFactory));
        resourceHolder.setSynchronizedWithTransaction(true);
        TransactionSynchronizationManager.bindResource(dbFactory, resourceHolder);
        return resourceHolder.getSession();
    }

    private static ClientSession createClientSession(MongoDatabaseFactory dbFactory) {
        return dbFactory.getSession(ClientSessionOptions.builder().causallyConsistent(true).build());
    }

    private static class MongoSessionSynchronization
    extends ResourceHolderSynchronization<MongoResourceHolder, Object> {
        private final MongoResourceHolder resourceHolder;

        MongoSessionSynchronization(MongoResourceHolder resourceHolder, MongoDatabaseFactory dbFactory) {
            super(resourceHolder, dbFactory);
            this.resourceHolder = resourceHolder;
        }

        @Override
        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        @Override
        protected void processResourceAfterCommit(MongoResourceHolder resourceHolder) {
            if (resourceHolder.hasActiveTransaction()) {
                resourceHolder.getRequiredSession().commitTransaction();
            }
        }

        @Override
        public void afterCompletion(int status) {
            if (status == 1 && this.resourceHolder.hasActiveTransaction()) {
                this.resourceHolder.getRequiredSession().abortTransaction();
            }
            super.afterCompletion(status);
        }

        @Override
        protected void releaseResource(MongoResourceHolder resourceHolder, Object resourceKey) {
            if (resourceHolder.hasActiveSession()) {
                resourceHolder.getRequiredSession().close();
            }
        }
    }
}

