/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackBiFunction;
import com.mongodb.internal.async.function.AsyncCallbackFunction;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.bulk.DeleteRequest;
import com.mongodb.internal.bulk.IndexRequest;
import com.mongodb.internal.bulk.UpdateRequest;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.QueryResult;
import com.mongodb.internal.operation.AsyncQueryBatchCursor;
import com.mongodb.internal.operation.AsyncSingleBatchQueryCursor;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.QueryBatchCursor;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.codecs.Decoder;
import org.bson.conversions.Bson;

final class OperationHelper {
    public static final Logger LOGGER = Loggers.getLogger("operation");

    static void validateReadConcern(Connection connection, ReadConcern readConcern) {
        OperationHelper.validateReadConcern(connection.getDescription(), readConcern);
    }

    static void validateReadConcern(ConnectionDescription description, ReadConcern readConcern) {
        if (!ServerVersionHelper.serverIsAtLeastVersionThreeDotTwo(description) && !readConcern.isServerDefault()) {
            throw new IllegalArgumentException(String.format("ReadConcern not supported by wire version: %s", description.getMaxWireVersion()));
        }
    }

    static void validateReadConcern(AsyncConnection connection, ReadConcern readConcern, AsyncCallableWithConnection callable) {
        IllegalArgumentException throwable = null;
        if (!ServerVersionHelper.serverIsAtLeastVersionThreeDotTwo(connection.getDescription()) && !readConcern.isServerDefault()) {
            throwable = new IllegalArgumentException(String.format("ReadConcern not supported by wire version: %s", connection.getDescription().getMaxWireVersion()));
        }
        callable.call(connection, throwable);
    }

    static void validateReadConcern(final AsyncConnectionSource source, AsyncConnection connection, ReadConcern readConcern, final AsyncCallableWithConnectionAndSource callable) {
        OperationHelper.validateReadConcern(connection, readConcern, new AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t2) {
                callable.call(source, connection, t2);
            }
        });
    }

    static void validateCollation(Connection connection, Collation collation) {
        OperationHelper.validateCollation(connection.getDescription(), collation);
    }

    static void validateCollation(ConnectionDescription connectionDescription, Collation collation) {
        if (collation != null && !ServerVersionHelper.serverIsAtLeastVersionThreeDotFour(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Collation not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
    }

    static void validateCollationAndWriteConcern(ConnectionDescription connectionDescription, Collation collation, WriteConcern writeConcern) {
        if (collation != null && !ServerVersionHelper.serverIsAtLeastVersionThreeDotFour(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Collation not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
        if (collation != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying collation with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateArrayFilters(ConnectionDescription connectionDescription, WriteConcern writeConcern) {
        if (ServerVersionHelper.serverIsLessThanVersionThreeDotSix(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Array filters not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying array filters with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateWriteRequestHint(ConnectionDescription connectionDescription, WriteConcern writeConcern, WriteRequest request) {
        if (ServerVersionHelper.serverIsLessThanVersionThreeDotFour(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
        if ((request instanceof DeleteRequest || request instanceof UpdateRequest) && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying hints with an unacknowledged WriteConcern is not supported");
        }
    }

    static void validateHint(ConnectionDescription connectionDescription, WriteConcern writeConcern) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying hints with an unacknowledged WriteConcern is not supported");
        }
    }

    static void validateAllowDiskUse(Connection connection, Boolean allowDiskUse) {
        OperationHelper.validateAllowDiskUse(connection.getDescription(), allowDiskUse).ifPresent(throwable -> {
            throw new IllegalArgumentException(throwable.getMessage());
        });
    }

    static void validateAllowDiskUse(AsyncConnection connection, Boolean allowDiskUse, AsyncCallableWithConnection callable) {
        Optional<Throwable> throwable = OperationHelper.validateAllowDiskUse(connection.getDescription(), allowDiskUse);
        callable.call(connection, throwable.isPresent() ? throwable.get() : null);
    }

    static void validateCollation(AsyncConnection connection, Collation collation, AsyncCallableWithConnection callable) {
        IllegalArgumentException throwable = null;
        if (!ServerVersionHelper.serverIsAtLeastVersionThreeDotFour(connection.getDescription()) && collation != null) {
            throwable = new IllegalArgumentException(String.format("Collation not supported by wire version: %s", connection.getDescription().getMaxWireVersion()));
        }
        callable.call(connection, throwable);
    }

    static void validateCollation(final AsyncConnectionSource source, AsyncConnection connection, Collation collation, final AsyncCallableWithConnectionAndSource callable) {
        OperationHelper.validateCollation(connection, collation, new AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t2) {
                callable.call(source, connection, t2);
            }
        });
    }

    static void validateWriteRequestCollations(ConnectionDescription connectionDescription, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        Collation collation = null;
        for (WriteRequest writeRequest : requests) {
            if (writeRequest instanceof UpdateRequest) {
                collation = ((UpdateRequest)writeRequest).getCollation();
            } else if (writeRequest instanceof DeleteRequest) {
                collation = ((DeleteRequest)writeRequest).getCollation();
            }
            if (collation == null) continue;
            break;
        }
        OperationHelper.validateCollationAndWriteConcern(connectionDescription, collation, writeConcern);
    }

    static void validateUpdateRequestArrayFilters(ConnectionDescription connectionDescription, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : requests) {
            List<BsonDocument> arrayFilters = null;
            if (writeRequest instanceof UpdateRequest) {
                arrayFilters = ((UpdateRequest)writeRequest).getArrayFilters();
            }
            if (arrayFilters == null) continue;
            OperationHelper.validateArrayFilters(connectionDescription, writeConcern);
            break;
        }
    }

    static void validateWriteRequestHints(ConnectionDescription connectionDescription, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : requests) {
            Bson hint = null;
            String hintString = null;
            if (writeRequest instanceof UpdateRequest) {
                hint = ((UpdateRequest)writeRequest).getHint();
                hintString = ((UpdateRequest)writeRequest).getHintString();
            } else if (writeRequest instanceof DeleteRequest) {
                hint = ((DeleteRequest)writeRequest).getHint();
                hintString = ((DeleteRequest)writeRequest).getHintString();
            }
            if (hint == null && hintString == null) continue;
            OperationHelper.validateWriteRequestHint(connectionDescription, writeConcern, writeRequest);
            break;
        }
    }

    static void validateWriteRequests(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        OperationHelper.checkBypassDocumentValidationIsSupported(connectionDescription, bypassDocumentValidation, writeConcern);
        OperationHelper.validateWriteRequestCollations(connectionDescription, requests, writeConcern);
        OperationHelper.validateUpdateRequestArrayFilters(connectionDescription, requests, writeConcern);
        OperationHelper.validateWriteRequestHints(connectionDescription, requests, writeConcern);
    }

    static <R> boolean validateWriteRequestsAndCompleteIfInvalid(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, List<? extends WriteRequest> requests, WriteConcern writeConcern, SingleResultCallback<R> callback) {
        try {
            OperationHelper.validateWriteRequests(connectionDescription, bypassDocumentValidation, requests, writeConcern);
            return false;
        }
        catch (Throwable validationT) {
            callback.onResult(null, validationT);
            return true;
        }
    }

    static void validateIndexRequestCollations(Connection connection, List<IndexRequest> requests) {
        for (IndexRequest request : requests) {
            if (request.getCollation() == null) continue;
            OperationHelper.validateCollation(connection, request.getCollation());
            break;
        }
    }

    static void validateIndexRequestCollations(AsyncConnection connection, List<IndexRequest> requests, final AsyncCallableWithConnection callable) {
        boolean calledTheCallable = false;
        for (IndexRequest request : requests) {
            if (request.getCollation() == null) continue;
            calledTheCallable = true;
            OperationHelper.validateCollation(connection, request.getCollation(), new AsyncCallableWithConnection(){

                @Override
                public void call(AsyncConnection connection, Throwable t2) {
                    callable.call(connection, t2);
                }
            });
            break;
        }
        if (!calledTheCallable) {
            callable.call(connection, null);
        }
    }

    static void validateFindOptions(Connection connection, ReadConcern readConcern, Collation collation, Boolean allowDiskUse) {
        OperationHelper.validateReadConcernAndCollation(connection, readConcern, collation);
        OperationHelper.validateAllowDiskUse(connection, allowDiskUse);
    }

    static void validateFindOptions(ConnectionDescription description, ReadConcern readConcern, Collation collation, Boolean allowDiskUse) {
        OperationHelper.validateReadConcernAndCollation(description, readConcern, collation);
        OperationHelper.validateAllowDiskUse(description, allowDiskUse).ifPresent(throwable -> {
            throw new IllegalArgumentException(throwable.getMessage());
        });
    }

    static void validateReadConcernAndCollation(Connection connection, ReadConcern readConcern, Collation collation) {
        OperationHelper.validateReadConcern(connection, readConcern);
        OperationHelper.validateCollation(connection, collation);
    }

    static void validateReadConcernAndCollation(ConnectionDescription description, ReadConcern readConcern, Collation collation) {
        OperationHelper.validateReadConcern(description, readConcern);
        OperationHelper.validateCollation(description, collation);
    }

    static void validateFindOptions(AsyncConnection connection, ReadConcern readConcern, Collation collation, final Boolean allowDiskUse, final AsyncCallableWithConnection callable) {
        OperationHelper.validateReadConcernAndCollation(connection, readConcern, collation, new AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t2) {
                if (t2 != null) {
                    callable.call(connection, t2);
                } else {
                    OperationHelper.validateAllowDiskUse(connection, allowDiskUse, callable);
                }
            }
        });
    }

    static void validateFindOptions(final AsyncConnectionSource source, AsyncConnection connection, ReadConcern readConcern, Collation collation, Boolean allowDiskUse, final AsyncCallableWithConnectionAndSource callable) {
        OperationHelper.validateFindOptions(connection, readConcern, collation, allowDiskUse, new AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t2) {
                callable.call(source, connection, t2);
            }
        });
    }

    static void validateReadConcernAndCollation(AsyncConnection connection, ReadConcern readConcern, final Collation collation, final AsyncCallableWithConnection callable) {
        OperationHelper.validateReadConcern(connection, readConcern, new AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t2) {
                if (t2 != null) {
                    callable.call(connection, t2);
                } else {
                    OperationHelper.validateCollation(connection, collation, callable);
                }
            }
        });
    }

    static void validateReadConcernAndCollation(final AsyncConnectionSource source, AsyncConnection connection, ReadConcern readConcern, Collation collation, final AsyncCallableWithConnectionAndSource callable) {
        OperationHelper.validateReadConcernAndCollation(connection, readConcern, collation, new AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t2) {
                callable.call(source, connection, t2);
            }
        });
    }

    static void checkBypassDocumentValidationIsSupported(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, WriteConcern writeConcern) {
        if (bypassDocumentValidation != null && ServerVersionHelper.serverIsAtLeastVersionThreeDotTwo(connectionDescription) && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying bypassDocumentValidation with an unacknowledged WriteConcern is not supported");
        }
    }

    static boolean isRetryableWrite(boolean retryWrites, WriteConcern writeConcern, ServerDescription serverDescription, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (!retryWrites) {
            return false;
        }
        if (!writeConcern.isAcknowledged()) {
            LOGGER.debug("retryWrites set to true but the writeConcern is unacknowledged.");
            return false;
        }
        if (sessionContext.hasActiveTransaction()) {
            LOGGER.debug("retryWrites set to true but in an active transaction.");
            return false;
        }
        return OperationHelper.canRetryWrite(serverDescription, connectionDescription, sessionContext);
    }

    static boolean canRetryWrite(ServerDescription serverDescription, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (ServerVersionHelper.serverIsLessThanVersionThreeDotSix(connectionDescription)) {
            LOGGER.debug("retryWrites set to true but the server does not support retryable writes.");
            return false;
        }
        if (serverDescription.getLogicalSessionTimeoutMinutes() == null && serverDescription.getType() != ServerType.LOAD_BALANCER) {
            LOGGER.debug("retryWrites set to true but the server does not have 3.6 feature compatibility enabled.");
            return false;
        }
        if (connectionDescription.getServerType().equals((Object)ServerType.STANDALONE)) {
            LOGGER.debug("retryWrites set to true but the server is a standalone server.");
            return false;
        }
        if (!sessionContext.hasSession()) {
            LOGGER.debug("retryWrites set to true but there is no implicit session, likely because the MongoClient was created with multiple MongoCredential instances and sessions can only be used with a single MongoCredential");
            return false;
        }
        return true;
    }

    static boolean isRetryableRead(boolean retryReads, ServerDescription serverDescription, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (!retryReads) {
            return false;
        }
        if (sessionContext.hasActiveTransaction()) {
            LOGGER.debug("retryReads set to true but in an active transaction.");
            return false;
        }
        return OperationHelper.canRetryRead(serverDescription, connectionDescription, sessionContext);
    }

    static boolean canRetryRead(ServerDescription serverDescription, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (ServerVersionHelper.serverIsLessThanVersionThreeDotSix(connectionDescription)) {
            LOGGER.debug("retryReads set to true but the server does not support retryable reads.");
            return false;
        }
        if (serverDescription.getLogicalSessionTimeoutMinutes() == null && serverDescription.getType() != ServerType.LOAD_BALANCER) {
            LOGGER.debug("retryReads set to true but the server does not have 3.6 feature compatibility enabled.");
            return false;
        }
        if (serverDescription.getType() != ServerType.STANDALONE && !sessionContext.hasSession()) {
            LOGGER.debug("retryReads set to true but there is no implicit session, likely because the MongoClient was created with multiple MongoCredential instances and sessions can only be used with a single MongoCredential");
            return false;
        }
        return true;
    }

    static <T> QueryBatchCursor<T> createEmptyBatchCursor(MongoNamespace namespace, Decoder<T> decoder, ServerAddress serverAddress, int batchSize) {
        return new QueryBatchCursor(new QueryResult(namespace, Collections.emptyList(), 0L, serverAddress), 0, batchSize, decoder);
    }

    static <T> AsyncBatchCursor<T> createEmptyAsyncBatchCursor(MongoNamespace namespace, ServerAddress serverAddress) {
        return new AsyncSingleBatchQueryCursor(new QueryResult(namespace, Collections.emptyList(), 0L, serverAddress));
    }

    static <T> BatchCursor<T> cursorDocumentToBatchCursor(BsonDocument cursorDocument, Decoder<T> decoder, ConnectionSource source, Connection connection, int batchSize) {
        return new QueryBatchCursor<T>(OperationHelper.cursorDocumentToQueryResult(cursorDocument, source.getServerDescription().getAddress()), 0, batchSize, 0L, decoder, source, connection);
    }

    static <T> AsyncBatchCursor<T> cursorDocumentToAsyncBatchCursor(BsonDocument cursorDocument, Decoder<T> decoder, AsyncConnectionSource source, AsyncConnection connection, int batchSize) {
        return new AsyncQueryBatchCursor<T>(OperationHelper.cursorDocumentToQueryResult(cursorDocument, source.getServerDescription().getAddress()), 0, batchSize, 0L, decoder, source, connection, cursorDocument);
    }

    static <T> QueryResult<T> cursorDocumentToQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        return OperationHelper.cursorDocumentToQueryResult(cursorDocument, serverAddress, "firstBatch");
    }

    static <T> QueryResult<T> getMoreCursorDocumentToQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        return OperationHelper.cursorDocumentToQueryResult(cursorDocument, serverAddress, "nextBatch");
    }

    private static <T> QueryResult<T> cursorDocumentToQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress, String fieldNameContainingBatch) {
        long cursorId = ((BsonInt64)cursorDocument.get("id")).getValue();
        MongoNamespace queryResultNamespace = new MongoNamespace(cursorDocument.getString("ns").getValue());
        return new QueryResult(queryResultNamespace, BsonDocumentWrapperHelper.toList(cursorDocument, fieldNameContainingBatch), cursorId, serverAddress);
    }

    static <T> SingleResultCallback<T> releasingCallback(SingleResultCallback<T> wrapped, AsyncConnection connection) {
        return new ReferenceCountedReleasingWrappedCallback<T>(wrapped, Collections.singletonList(connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withReadConnectionSource(ReadBinding binding, CallableWithSource<T> callable) {
        ConnectionSource source = binding.getReadConnectionSource();
        try {
            T t2 = callable.call(source);
            return t2;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnection(WriteBinding binding, CallableWithConnection<T> callable) {
        ConnectionSource source = binding.getWriteConnectionSource();
        try {
            T t2 = OperationHelper.withConnectionSource(source, callable);
            return t2;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnectionSource(ConnectionSource source, CallableWithConnection<T> callable) {
        Connection connection = source.getConnection();
        try {
            T t2 = callable.call(connection);
            return t2;
        }
        finally {
            connection.release();
        }
    }

    static <R> R withSourceAndConnection(Supplier<ConnectionSource> sourceSupplier, boolean wrapSourceConnectionException, BiFunction<ConnectionSource, Connection, R> function) throws ResourceSupplierInternalException {
        return (R)OperationHelper.withSuppliedResource(sourceSupplier, wrapSourceConnectionException, source -> OperationHelper.withSuppliedResource(source::getConnection, wrapSourceConnectionException, connection -> function.apply((ConnectionSource)source, (Connection)connection)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R, T extends ReferenceCounted> R withSuppliedResource(Supplier<T> resourceSupplier, boolean wrapSupplierException, Function<T, R> function) throws ResourceSupplierInternalException {
        ReferenceCounted resource = null;
        try {
            try {
                resource = (ReferenceCounted)resourceSupplier.get();
            }
            catch (RuntimeException supplierException) {
                if (wrapSupplierException) {
                    throw new ResourceSupplierInternalException(supplierException);
                }
                throw supplierException;
            }
            R r = function.apply(resource);
            return r;
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
    }

    static void withAsyncConnection(AsyncWriteBinding binding, AsyncCallableWithConnection callable) {
        binding.getWriteConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionCallback(callable), LOGGER));
    }

    static void withAsyncConnection(AsyncWriteBinding binding, AsyncCallableWithConnectionAndSource callable) {
        binding.getWriteConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionAndSourceCallback(callable), LOGGER));
    }

    static void withAsyncReadConnection(AsyncReadBinding binding, AsyncCallableWithSource callable) {
        binding.getReadConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithSourceCallback(callable), LOGGER));
    }

    static <R> void withAsyncSourceAndConnection(AsyncCallbackSupplier<AsyncConnectionSource> sourceAsyncSupplier, boolean wrapSourceConnectionException, SingleResultCallback<R> callback, AsyncCallbackBiFunction<AsyncConnectionSource, AsyncConnection, R> asyncFunction) throws ResourceSupplierInternalException {
        SingleResultCallback<R> errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        OperationHelper.withAsyncSuppliedResource(sourceAsyncSupplier, wrapSourceConnectionException, errorHandlingCallback, (source, sourceReleasingCallback) -> OperationHelper.withAsyncSuppliedResource(source::getConnection, wrapSourceConnectionException, sourceReleasingCallback, (connection, connectionAndSourceReleasingCallback) -> asyncFunction.apply((AsyncConnectionSource)source, (AsyncConnection)connection, connectionAndSourceReleasingCallback)));
    }

    static <R, T extends ReferenceCounted> void withAsyncSuppliedResource(AsyncCallbackSupplier<T> resourceSupplier, boolean wrapSourceConnectionException, SingleResultCallback<R> callback, AsyncCallbackFunction<T, R> function) throws ResourceSupplierInternalException {
        SingleResultCallback errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        resourceSupplier.get((resource, supplierException) -> {
            if (supplierException != null) {
                if (wrapSourceConnectionException) {
                    supplierException = new ResourceSupplierInternalException(supplierException);
                }
                errorHandlingCallback.onResult(null, supplierException);
            } else {
                AsyncCallbackSupplier curriedFunction = clbk -> function.apply(resource, clbk);
                curriedFunction.whenComplete(resource::release).get(errorHandlingCallback);
            }
        });
    }

    private static void withAsyncConnectionSourceCallableConnection(final AsyncConnectionSource source, final AsyncCallableWithConnection callable) {
        source.getConnection(new SingleResultCallback<AsyncConnection>(){

            @Override
            public void onResult(AsyncConnection connection, Throwable t2) {
                source.release();
                if (t2 != null) {
                    callable.call(null, t2);
                } else {
                    callable.call(connection, null);
                }
            }
        });
    }

    private static void withAsyncConnectionSource(AsyncConnectionSource source, AsyncCallableWithSource callable) {
        callable.call(source, null);
    }

    private static void withAsyncConnectionSource(final AsyncConnectionSource source, final AsyncCallableWithConnectionAndSource callable) {
        source.getConnection(new SingleResultCallback<AsyncConnection>(){

            @Override
            public void onResult(AsyncConnection result, Throwable t2) {
                callable.call(source, result, t2);
            }
        });
    }

    private static Optional<Throwable> validateAllowDiskUse(ConnectionDescription description, Boolean allowDiskUse) {
        Optional<Throwable> throwable = Optional.empty();
        if (allowDiskUse != null && ServerVersionHelper.serverIsLessThanVersionThreeDotTwo(description)) {
            throwable = Optional.of(new IllegalArgumentException(String.format("allowDiskUse not supported by wire version: %s", description.getMaxWireVersion())));
        }
        return throwable;
    }

    private OperationHelper() {
    }

    static final class ResourceSupplierInternalException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private ResourceSupplierInternalException(Throwable cause) {
            super(Assertions.assertNotNull(cause));
        }

        @Override
        @NonNull
        public Throwable getCause() {
            return Assertions.assertNotNull(super.getCause());
        }
    }

    private static class AsyncCallableWithConnectionAndSourceCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithConnectionAndSource callable;

        AsyncCallableWithConnectionAndSourceCallback(AsyncCallableWithConnectionAndSource callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(AsyncConnectionSource source, Throwable t2) {
            if (t2 != null) {
                this.callable.call(null, null, t2);
            } else {
                OperationHelper.withAsyncConnectionSource(source, this.callable);
            }
        }
    }

    private static class AsyncCallableWithSourceCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithSource callable;

        AsyncCallableWithSourceCallback(AsyncCallableWithSource callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(AsyncConnectionSource source, Throwable t2) {
            if (t2 != null) {
                this.callable.call(null, t2);
            } else {
                OperationHelper.withAsyncConnectionSource(source, this.callable);
            }
        }
    }

    private static class AsyncCallableWithConnectionCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithConnection callable;

        AsyncCallableWithConnectionCallback(AsyncCallableWithConnection callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(AsyncConnectionSource source, Throwable t2) {
            if (t2 != null) {
                this.callable.call(null, t2);
            } else {
                OperationHelper.withAsyncConnectionSourceCallableConnection(source, this.callable);
            }
        }
    }

    private static class ReferenceCountedReleasingWrappedCallback<T>
    implements SingleResultCallback<T> {
        private final SingleResultCallback<T> wrapped;
        private final List<? extends ReferenceCounted> referenceCounted;

        ReferenceCountedReleasingWrappedCallback(SingleResultCallback<T> wrapped, List<? extends ReferenceCounted> referenceCounted) {
            this.wrapped = wrapped;
            this.referenceCounted = Assertions.notNull("referenceCounted", referenceCounted);
        }

        @Override
        public void onResult(T result, Throwable t2) {
            for (ReferenceCounted referenceCounted : this.referenceCounted) {
                if (referenceCounted == null) continue;
                referenceCounted.release();
            }
            this.wrapped.onResult(result, t2);
        }
    }

    static interface AsyncCallableWithConnectionAndSource {
        public void call(AsyncConnectionSource var1, AsyncConnection var2, Throwable var3);
    }

    static interface AsyncCallableWithSource {
        public void call(AsyncConnectionSource var1, Throwable var2);
    }

    static interface AsyncCallableWithConnection {
        public void call(AsyncConnection var1, Throwable var2);
    }

    static interface CallableWithSource<T> {
        public T call(ConnectionSource var1);
    }

    static interface CallableWithConnection<T> {
        public T call(Connection var1);
    }
}

