/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.QueryResult;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.session.SessionContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class EstimatedDocumentCountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private long maxTimeMS;

    public EstimatedDocumentCountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public EstimatedDocumentCountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public EstimatedDocumentCountOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public Long execute(ReadBinding binding) {
        try {
            return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.transformer(), this.retryReads);
        }
        catch (MongoCommandException e) {
            return CommandOperationHelper.rethrowIfNotNamespaceError(e, 0L);
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.asyncTransformer(), this.retryReads, (result, t2) -> {
            if (CommandOperationHelper.isNamespaceError(t2)) {
                callback.onResult(0L, null);
            } else {
                callback.onResult((Long)result, t2);
            }
        });
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private long transformResult(BsonDocument result, ConnectionDescription connectionDescription) {
        if (ServerVersionHelper.serverIsAtLeastVersionFiveDotZero(connectionDescription)) {
            QueryResult queryResult = OperationHelper.cursorDocumentToQueryResult(result.getDocument("cursor"), connectionDescription.getServerAddress());
            return ((BsonDocument)queryResult.getResults().get(0)).getNumber("n").longValue();
        }
        return result.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> {
            if (ServerVersionHelper.serverIsAtLeastVersionFiveDotZero(connectionDescription)) {
                return this.getAggregateCommand(sessionContext, connectionDescription);
            }
            OperationHelper.validateReadConcern(connectionDescription, sessionContext.getReadConcern());
            return this.getCountCommand(sessionContext, connectionDescription);
        };
    }

    private BsonDocument getAggregateCommand(SessionContext sessionContext, ConnectionDescription connectionDescription) {
        BsonDocument document = new BsonDocument("aggregate", new BsonString(this.namespace.getCollectionName())).append("cursor", new BsonDocument()).append("pipeline", new BsonArray(Arrays.asList(new BsonDocument("$collStats", new BsonDocument("count", new BsonDocument())), new BsonDocument("$group", new BsonDocument("_id", new BsonInt32(1)).append("n", new BsonDocument("$sum", new BsonString("$count")))))));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), document);
        DocumentHelper.putIfNotZero(document, "maxTimeMS", this.maxTimeMS);
        return document;
    }

    private BsonDocument getCountCommand(SessionContext sessionContext, ConnectionDescription connectionDescription) {
        BsonDocument document = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), document);
        DocumentHelper.putIfNotZero(document, "maxTimeMS", this.maxTimeMS);
        return document;
    }
}

