/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import java.util.Arrays;
import java.util.List;

final class ChangeStreamBatchCursorHelper {
    static final List<Integer> RETRYABLE_SERVER_ERROR_CODES = Arrays.asList(6, 7, 63, 89, 91, 133, 150, 189, 234, 262, 9001, 10107, 11600, 11602, 13388, 13435, 13436);
    static final String RESUMABLE_CHANGE_STREAM_ERROR_LABEL = "ResumableChangeStreamError";

    static boolean isResumableError(Throwable t2, int maxWireVersion) {
        if (!(t2 instanceof MongoException) || t2 instanceof MongoChangeStreamException || t2 instanceof MongoInterruptedException) {
            return false;
        }
        if (t2 instanceof MongoNotPrimaryException || t2 instanceof MongoCursorNotFoundException || t2 instanceof MongoSocketException | t2 instanceof MongoClientException) {
            return true;
        }
        if (maxWireVersion >= 9) {
            return ((MongoException)t2).getErrorLabels().contains(RESUMABLE_CHANGE_STREAM_ERROR_LABEL);
        }
        return RETRYABLE_SERVER_ERROR_CODES.contains(((MongoException)t2).getCode());
    }

    private ChangeStreamBatchCursorHelper() {
    }
}

