/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerType;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.CommandProtocol;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.ConnectionFactory;
import com.mongodb.internal.connection.ConnectionPool;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.ProtocolExecutor;
import com.mongodb.internal.session.SessionContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.types.ObjectId;

@ThreadSafe
public class LoadBalancedServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ConnectionFactory connectionFactory;
    private final ServerListener serverListener;
    private final ClusterClock clusterClock;

    public LoadBalancedServer(ServerId serverId, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerListener serverListener, ClusterClock clusterClock) {
        this.serverId = serverId;
        this.connectionPool = connectionPool;
        this.connectionFactory = connectionFactory;
        this.serverListener = serverListener;
        this.clusterClock = clusterClock;
        serverListener.serverOpening(new ServerOpeningEvent(serverId));
        serverListener.serverDescriptionChanged(new ServerDescriptionChangedEvent(serverId, ServerDescription.builder().ok(true).state(ServerConnectionState.CONNECTED).type(ServerType.LOAD_BALANCER).address(serverId.getAddress()).build(), ServerDescription.builder().address(serverId.getAddress()).state(ServerConnectionState.CONNECTING).build()));
    }

    @Override
    public void resetToConnecting() {
    }

    @Override
    public void invalidate() {
    }

    private void invalidate(Throwable t2, ObjectId serviceId, int generation) {
        if (!this.isClosed()) {
            if (t2 instanceof MongoSocketException && !(t2 instanceof MongoSocketReadTimeoutException)) {
                if (serviceId != null) {
                    this.connectionPool.invalidate(serviceId, generation);
                }
            } else if ((t2 instanceof MongoNotPrimaryException || t2 instanceof MongoNodeIsRecoveringException) && SHUTDOWN_CODES.contains(((MongoCommandException)t2).getErrorCode()) && serviceId != null) {
                this.connectionPool.invalidate(serviceId, generation);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.connectionPool.close();
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void connect() {
    }

    @Override
    public Connection getConnection() {
        Assertions.isTrue("open", !this.isClosed());
        return this.connectionFactory.create(this.connectionPool.get(), new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED);
    }

    @Override
    public void getConnectionAsync(SingleResultCallback<AsyncConnection> callback) {
        Assertions.isTrue("open", !this.isClosed());
        this.connectionPool.getAsync((result, t2) -> {
            if (t2 != null) {
                callback.onResult(null, t2);
            } else {
                callback.onResult(this.connectionFactory.createAsync((InternalConnection)result, new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED), null);
            }
        });
    }

    @Override
    public int operationCount() {
        return -1;
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private class LoadBalancedServerProtocolExecutor
    implements ProtocolExecutor {
        private LoadBalancedServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext) {
            try {
                protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock));
                return protocol.execute(connection);
            }
            catch (MongoWriteConcernWithResponseException e) {
                return (T)e.getResponse();
            }
            catch (MongoException e) {
                this.handleExecutionException(connection, sessionContext, e);
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext, SingleResultCallback<T> callback) {
            protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock));
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback((result, t2) -> {
                if (t2 != null) {
                    if (t2 instanceof MongoWriteConcernWithResponseException) {
                        callback.onResult(((MongoWriteConcernWithResponseException)t2).getResponse(), null);
                    } else {
                        this.handleExecutionException(connection, sessionContext, t2);
                        callback.onResult(null, t2);
                    }
                } else {
                    callback.onResult(result, null);
                }
            }, LOGGER));
        }

        private void handleExecutionException(InternalConnection connection, SessionContext sessionContext, Throwable t2) {
            LoadBalancedServer.this.invalidate(t2, connection.getDescription().getServiceId(), connection.getGeneration());
            if (t2 instanceof MongoSocketException && sessionContext.hasSession()) {
                sessionContext.markSessionDirty();
            }
        }
    }
}

