/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.binding;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.connection.ServerTuple;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import com.mongodb.internal.selector.ServerAddressSelector;
import com.mongodb.internal.selector.WritableServerSelector;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;

public class AsyncClusterBinding
extends AbstractReferenceCounted
implements AsyncClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    @Nullable
    private final ServerApi serverApi;
    private final RequestContext requestContext;

    public AsyncClusterBinding(Cluster cluster, ReadPreference readPreference, ReadConcern readConcern, @Nullable ServerApi serverApi, RequestContext requestContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.serverApi = serverApi;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
    }

    @Override
    public AsyncReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public SessionContext getSessionContext() {
        return new ReadConcernAwareNoOpSessionContext(this.readConcern);
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Override
    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    @Override
    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new ReadPreferenceServerSelector(this.readPreference), callback);
    }

    @Override
    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, final SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            this.getReadConnectionSource(callback);
        } else {
            final ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, minWireVersion, fallbackReadPreference);
            this.cluster.selectServerAsync(readPreferenceWithFallbackServerSelector, new SingleResultCallback<ServerTuple>(){

                @Override
                public void onResult(ServerTuple result, Throwable t2) {
                    if (t2 != null) {
                        callback.onResult(null, t2);
                    } else {
                        callback.onResult(new AsyncClusterBindingConnectionSource(result.getServer(), result.getServerDescription(), readPreferenceWithFallbackServerSelector.getAppliedReadPreference()), null);
                    }
                }
            });
        }
    }

    @Override
    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new WritableServerSelector(), callback);
    }

    @Override
    public void getConnectionSource(ServerAddress serverAddress, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new ServerAddressSelector(serverAddress), callback);
    }

    private void getAsyncClusterBindingConnectionSource(ServerSelector serverSelector, final SingleResultCallback<AsyncConnectionSource> callback) {
        this.cluster.selectServerAsync(serverSelector, new SingleResultCallback<ServerTuple>(){

            @Override
            public void onResult(ServerTuple result, Throwable t2) {
                if (t2 != null) {
                    callback.onResult(null, t2);
                } else {
                    callback.onResult(new AsyncClusterBindingConnectionSource(result.getServer(), result.getServerDescription(), AsyncClusterBinding.this.readPreference), null);
                }
            }
        });
    }

    private final class AsyncClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements AsyncConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private AsyncClusterBindingConnectionSource(Server server, ServerDescription serverDescription, ReadPreference appliedReadPreference) {
            this.server = server;
            this.serverDescription = serverDescription;
            this.appliedReadPreference = appliedReadPreference;
            AsyncClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public SessionContext getSessionContext() {
            return new ReadConcernAwareNoOpSessionContext(AsyncClusterBinding.this.readConcern);
        }

        @Override
        @Nullable
        public ServerApi getServerApi() {
            return AsyncClusterBinding.this.serverApi;
        }

        @Override
        public RequestContext getRequestContext() {
            return AsyncClusterBinding.this.requestContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            this.server.getConnectionAsync(callback);
        }

        @Override
        public AsyncConnectionSource retain() {
            super.retain();
            AsyncClusterBinding.this.retain();
            return this;
        }

        @Override
        public void release() {
            super.release();
            AsyncClusterBinding.this.release();
        }
    }
}

