/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.SimpleExpression;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;

public final class Accumulators {
    public static <TExpression> BsonField sum(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$sum", fieldName, expression);
    }

    public static <TExpression> BsonField avg(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$avg", fieldName, expression);
    }

    public static <TExpression> BsonField first(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$first", fieldName, expression);
    }

    public static <TExpression> BsonField last(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$last", fieldName, expression);
    }

    public static <TExpression> BsonField max(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$max", fieldName, expression);
    }

    public static <TExpression> BsonField min(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$min", fieldName, expression);
    }

    public static <TExpression> BsonField push(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$push", fieldName, expression);
    }

    public static <TExpression> BsonField addToSet(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$addToSet", fieldName, expression);
    }

    public static <TExpression> BsonField mergeObjects(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$mergeObjects", fieldName, expression);
    }

    public static <TExpression> BsonField stdDevPop(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$stdDevPop", fieldName, expression);
    }

    public static <TExpression> BsonField stdDevSamp(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$stdDevSamp", fieldName, expression);
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, null, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, initArgs, accumulateFunction, accumulateArgs, mergeFunction, finalizeFunction, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, lang);
    }

    public static BsonField accumulator(String fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        BsonDocument accumulatorStage = new BsonDocument("init", new BsonString(initFunction)).append("initArgs", initArgs != null ? new BsonArray(initArgs.stream().map(initArg -> new BsonString((String)initArg)).collect(Collectors.toList())) : new BsonArray()).append("accumulate", new BsonString(accumulateFunction)).append("accumulateArgs", accumulateArgs != null ? new BsonArray(accumulateArgs.stream().map(accumulateArg -> new BsonString((String)accumulateArg)).collect(Collectors.toList())) : new BsonArray()).append("merge", new BsonString(mergeFunction)).append("lang", new BsonString(lang));
        if (finalizeFunction != null) {
            accumulatorStage.append("finalize", new BsonString(finalizeFunction));
        }
        return Accumulators.accumulatorOperator("$accumulator", fieldName, accumulatorStage);
    }

    private static <TExpression> BsonField accumulatorOperator(String name, String fieldName, TExpression expression) {
        return new BsonField(fieldName, new SimpleExpression<TExpression>(name, expression));
    }

    private Accumulators() {
    }
}

