/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.warlords;

import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.LocationBuilder;
import com.ebicep.warlords.util.java.Pair;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class Utils {
    public static final String[] specsOrdered = new String[]{"Pyromancer", "Cryomancer", "Aquamancer", "Berserker", "Defender", "Revenant", "Avenger", "Crusader", "Protector", "Thunderlord", "Spiritguard", "Earthwarden", "Assassin", "Vindicator", "Apothecary"};
    public static final ItemStack[] woolSortedByColor = new ItemStack[]{new ItemStack(Material.WOOL, 1, 0), new ItemStack(Material.WOOL, 1, 8), new ItemStack(Material.WOOL, 1, 7), new ItemStack(Material.WOOL, 1, 15), new ItemStack(Material.WOOL, 1, 12), new ItemStack(Material.WOOL, 1, 14), new ItemStack(Material.WOOL, 1, 1), new ItemStack(Material.WOOL, 1, 4), new ItemStack(Material.WOOL, 1, 5), new ItemStack(Material.WOOL, 1, 13), new ItemStack(Material.WOOL, 1, 9), new ItemStack(Material.WOOL, 1, 3), new ItemStack(Material.WOOL, 1, 11), new ItemStack(Material.WOOL, 1, 10), new ItemStack(Material.WOOL, 1, 2), new ItemStack(Material.WOOL, 1, 6)};
    private static final Location LOCATION_CACHE_SORT = new Location(null, 0.0, 0.0, 0.0);
    private static final Location LOCATION_CACHE_DISTANCE = new Location(null, 0.0, 0.0, 0.0);

    private Utils() {
    }

    public static double getDotToPlayer(LivingEntity player1, LivingEntity player2, double yIncrease) {
        return Utils.getDotToLocation(new LocationBuilder(player1.getEyeLocation()).addY(yIncrease).get(), player2.getEyeLocation());
    }

    public static double getDotToPlayerEye(LivingEntity player1, LivingEntity player2) {
        return Utils.getDotToLocation(player1.getEyeLocation(), player2.getEyeLocation());
    }

    public static double getDotToPlayerCenter(LivingEntity player1, LivingEntity player2) {
        return Utils.getDotToLocation(new LocationBuilder(player1.getEyeLocation()).addY(0.7).get(), player2.getEyeLocation());
    }

    public static double getDotToLocation(Location location1, Location location2) {
        Vector toEntity = location2.toVector().subtract(location1.toVector());
        return toEntity.normalize().dot(location1.getDirection());
    }

    public static boolean isLookingAt(LivingEntity player1, LivingEntity player2) {
        Location eye = new LocationBuilder(player1.getEyeLocation()).backward(4.0f).addY(0.7).get();
        return Utils.getDotToLocation(eye, player2.getEyeLocation()) > 0.925;
    }

    public static boolean isLookingAtIntervene(LivingEntity player1, LivingEntity player2) {
        Location eye = new LocationBuilder(player1.getEyeLocation()).backward(4.0f).addY(0.7).get();
        return Utils.getDotToLocation(eye, player2.getEyeLocation()) > 0.96;
    }

    public static boolean isLookingAtMark(LivingEntity player1, LivingEntity player2) {
        Location eye = new LocationBuilder(player1.getEyeLocation()).backward(5.0f).addY(0.7).get();
        return Utils.getDotToLocation(eye, player2.getEyeLocation()) > 0.95;
    }

    public static boolean isLineOfSightAssassin(LivingEntity player1, LivingEntity player2) {
        Location eye = new LocationBuilder(player1.getEyeLocation()).backward(1.0f).addY(0.7).get();
        return Utils.getDotToLocation(eye, player2.getEyeLocation()) > 0.7;
    }

    public static boolean isLookingAtChain(LivingEntity player1, LivingEntity player2) {
        Location eye = new LocationBuilder(player1.getEyeLocation()).backward(4.0f).addY(0.7).get();
        return Utils.getDotToLocation(eye, player2.getEyeLocation()) > 0.95 + player1.getLocation().distanceSquared(player2.getLocation()) / 10000.0;
    }

    public static boolean isLookingAtWave(LivingEntity player1, LivingEntity player2) {
        Location eye = new LocationBuilder(player1.getEyeLocation()).addY(0.7).pitch(0.0f).get();
        return Utils.getDotToLocation(eye, player2.getEyeLocation()) > 0.91;
    }

    public static double lerp(double a, double b, double target) {
        return a + target * (b - a);
    }

    public static float lerp(float point1, float point2, float alpha) {
        return point1 + alpha * (point2 - point1);
    }

    public static boolean hasLineOfSight(LivingEntity player, LivingEntity player2) {
        return player.hasLineOfSight((Entity)player2);
    }

    public static Predicate<WarlordsPlayer> filterOnlyEnemies(@Nullable WarlordsPlayer wp) {
        return wp == null ? player -> false : wp::isEnemyAlive;
    }

    public static Predicate<WarlordsPlayer> filterOnlyTeammates(@Nullable WarlordsPlayer wp) {
        return wp == null ? player -> false : wp::isTeammateAlive;
    }

    public static Comparator<Entity> sortClosestBy(Location loc) {
        return Utils.sortClosestBy(Entity::getLocation, loc);
    }

    public static <T> Comparator<T> sortClosestBy(BiConsumer<T, Location> map, Location loc) {
        return Comparator.comparing(e -> {
            map.accept(e, LOCATION_CACHE_SORT);
            return LOCATION_CACHE_SORT.distanceSquared(loc);
        });
    }

    public static Predicate<Entity> radiusAround(Location loc, double radius) {
        return Utils.radiusAround(loc, radius, radius, radius);
    }

    public static Predicate<Entity> radiusAround(Location loc, double x, double y, double z) {
        return Utils.radiusAround(Entity::getLocation, loc, x, y, z);
    }

    public static <T> Predicate<T> radiusAround(BiConsumer<T, Location> map, Location loc, double radius) {
        return Utils.radiusAround(map, loc, radius, radius, radius);
    }

    public static <T> Predicate<T> radiusAround(BiConsumer<T, Location> map, Location loc, double x, double y, double z) {
        return entity -> {
            map.accept(entity, LOCATION_CACHE_DISTANCE);
            double xDif = (loc.getX() - LOCATION_CACHE_DISTANCE.getX()) / x;
            double yDif = (loc.getY() - LOCATION_CACHE_DISTANCE.getY()) / y;
            double zDif = (loc.getZ() - LOCATION_CACHE_DISTANCE.getZ()) / z;
            return xDif * xDif + yDif * yDif + zDif * zDif <= 1.0;
        };
    }

    public static Vector getRightDirection(Location location) {
        Vector direction = location.getDirection().normalize();
        return new Vector(-direction.getZ(), 0.0, direction.getX()).normalize();
    }

    public static Vector getLeftDirection(Location location) {
        Vector direction = location.getDirection().normalize();
        return new Vector(direction.getZ(), 0.0, -direction.getX()).normalize();
    }

    public static double getDistance(WarlordsPlayer e, double accuracy) {
        return Utils.getDistance(e.getLocation(), accuracy);
    }

    public static double getDistance(Entity e, double accuracy) {
        return Utils.getDistance(e.getLocation(), accuracy);
    }

    public static double getDistance(Location original, double accuracy) {
        Location loc = original.clone();
        double distance = 0.0;
        for (double i = loc.getY(); i >= -100.0; i -= accuracy) {
            loc.setY(i);
            if (loc.getBlock().getType().isSolid()) break;
            distance += accuracy;
        }
        return distance -= accuracy;
    }

    public static void resetPlayerMovementStatistics(Player player) {
        player.setStatistic(Statistic.WALK_ONE_CM, 0);
        player.setStatistic(Statistic.HORSE_ONE_CM, 0);
    }

    public static int getPlayerMovementStatistics(Player player) {
        int walkStatistic = player.getStatistic(Statistic.WALK_ONE_CM);
        int horseStatistic = player.getStatistic(Statistic.HORSE_ONE_CM);
        return walkStatistic + horseStatistic;
    }

    public static boolean blocksInFrontOfLocation(Location location) {
        location = location.clone();
        location.setPitch(0.0f);
        Location headLocationForward = location.clone().add(location.getDirection().multiply(1)).add(0.0, 1.0, 0.0);
        Location footLocationForward = location.clone().add(location.getDirection().multiply(1));
        return location.getWorld().getBlockAt(headLocationForward).getType() != Material.AIR && location.getWorld().getBlockAt(headLocationForward).getType() != Material.WOOD_STEP && location.getWorld().getBlockAt(headLocationForward).getType() != Material.STEP && location.getWorld().getBlockAt(footLocationForward).getType() != Material.AIR;
    }

    public static boolean isMountableZone(Location location) {
        if (location.getWorld().getBlockAt(new LocationBuilder(location.clone()).y(2.0).get()).getType() == Material.NETHERRACK) {
            return location.getWorld().getBlockAt(new LocationBuilder(location.clone()).y(4.0).get()).getType() == Material.SOUL_SAND && !Utils.insideTunnel(location);
        }
        return true;
    }

    public static boolean insideTunnel(Location location) {
        Location aboveLocation = location.clone().add(0.0, 2.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            if (aboveLocation.getBlock().getType() != Material.AIR) {
                return true;
            }
            aboveLocation.add(0.0, 1.0, 0.0);
        }
        return false;
    }

    public static boolean isInCircleRadiusFast(Location locA, Location locB, double radius) {
        double radiusMin = -radius;
        double diffX = locA.getX() - locB.getX();
        if (diffX < radiusMin || diffX > radius) {
            return false;
        }
        double diffY = locA.getY() - locB.getY();
        if (diffY < radiusMin || diffY > radius) {
            return false;
        }
        double diffZ = locA.getZ() - locB.getZ();
        if (diffZ < radiusMin || diffZ > radius) {
            return false;
        }
        return diffX * diffX + diffY * diffY + diffZ * diffZ < radius * radius;
    }

    public static <T> boolean collectionHasItem(@Nonnull Iterable<T> iterable, @Nonnull Predicate<? super T> matcher) {
        for (T item : iterable) {
            if (!matcher.test(item)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> T arrayGetItem(@Nonnull T[] iterable, @Nonnull Predicate<? super T> matcher) {
        for (T item : iterable) {
            if (!matcher.test(item)) continue;
            return item;
        }
        return null;
    }

    @Nonnull
    public static <T> Iterable<T> iterable(@Nonnull Stream<T> stream) {
        return stream::iterator;
    }

    public static <T> Collector<T, Pair<Integer, T>, T> randomElement() {
        return Collector.of(() -> new Pair<Integer, Object>(0, null), (i, a) -> {
            int count = (Integer)i.getA();
            if (count == 0) {
                i.setA(1);
                i.setB(a);
            } else {
                i.setA(count + 1);
                if (Math.random() < 1.0 / (double)count) {
                    i.setB(a);
                }
            }
        }, (a, b) -> {
            int count = (Integer)a.getA() + (Integer)b.getA();
            if (Math.random() * (double)count >= (double)((Integer)a.getA()).intValue()) {
                a.setB(b.getB());
            }
            a.setA(count);
            return a;
        }, i -> i.getB(), Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED);
    }

    public static void formatTimeLeft(StringBuilder message, long seconds) {
        long minute = seconds / 60L;
        long second = seconds % 60L;
        if (minute < 10L) {
            message.append('0');
        }
        message.append(minute);
        message.append(':');
        if (second < 10L) {
            message.append('0');
        }
        message.append(second == -1L ? 0L : second);
    }

    public static String formatTimeLeft(long seconds) {
        StringBuilder message = new StringBuilder();
        Utils.formatTimeLeft(message, seconds);
        return message.toString();
    }

    public static String toTitleCase(Object input) {
        return Utils.toTitleCase(String.valueOf(input));
    }

    public static String toTitleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1).toLowerCase(Locale.ROOT);
    }

    public static String toTitleHumanCase(Object input) {
        return Utils.toTitleHumanCase(String.valueOf(input));
    }

    public static String toTitleHumanCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.replace('_', ' ').substring(1).toLowerCase(Locale.ROOT);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static void playGlobalSound(@Nonnull Location location, Sound sound, float volume, float pitch) {
        for (Player p : location.getWorld().getPlayers()) {
            p.playSound(location, sound, volume, pitch);
        }
    }

    public static void playGlobalSound(@Nonnull Location location, String soundString, float volume, float pitch) {
        for (Player p : location.getWorld().getPlayers()) {
            p.playSound(location, soundString, volume, pitch);
        }
    }

    public static class ArmorStandComparator
    implements Comparator<Entity> {
        @Override
        public int compare(Entity a, Entity b) {
            return a instanceof ArmorStand && b instanceof ArmorStand ? 0 : (a instanceof ArmorStand ? -1 : (b instanceof ArmorStand ? 1 : 0));
        }
    }
}

