/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.warlords;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class PlayerFilter
implements Iterable<WarlordsPlayer> {
    private static final Location LOCATION_CACHE_ENTITIES_AROUND = new Location(null, 0.0, 0.0, 0.0);
    private static final Location LOCATION_CACHE_CLOSEST = new Location(null, 0.0, 0.0, 0.0);
    private final Stream<WarlordsPlayer> stream;

    protected PlayerFilter(@Nonnull Stream<WarlordsPlayer> stream) {
        this.stream = stream;
    }

    @Nonnull
    public Stream<WarlordsPlayer> stream() {
        return this.stream;
    }

    @Nonnull
    public PlayerFilter concat(WarlordsPlayer ... player) {
        return new PlayerFilter(Stream.concat(this.stream, Stream.of(player)));
    }

    @Nonnull
    public PlayerFilter limit(long maxSize) {
        return new PlayerFilter(this.stream.limit(maxSize));
    }

    @Nonnull
    public PlayerFilter filter(@Nonnull Predicate<? super WarlordsPlayer> filter) {
        return new PlayerFilter(this.stream.filter(filter));
    }

    @Nonnull
    public PlayerFilter skip(long n) {
        return new PlayerFilter(this.stream.skip(n));
    }

    @Nonnull
    public PlayerFilter sorted(@Nonnull Comparator<? super WarlordsPlayer> comparator) {
        return new PlayerFilter(this.stream.sorted(comparator));
    }

    @Nonnull
    public PlayerFilter closestFirst(@Nonnull Location loc) {
        return this.sorted(Utils.sortClosestBy(WarlordsPlayer::getLocation, loc));
    }

    @Nonnull
    public PlayerFilter closestFirst(@Nonnull WarlordsPlayer loc) {
        loc.getLocation(LOCATION_CACHE_CLOSEST);
        return this.sorted(Utils.sortClosestBy(WarlordsPlayer::getLocation, LOCATION_CACHE_CLOSEST));
    }

    @Nonnull
    public PlayerFilter closestFirst(@Nonnull Entity loc) {
        loc.getLocation(LOCATION_CACHE_CLOSEST);
        return this.sorted(Utils.sortClosestBy(WarlordsPlayer::getLocation, LOCATION_CACHE_CLOSEST));
    }

    @Nonnull
    public PlayerFilter leastAliveFirst() {
        return this.sorted(Comparator.comparing(wp -> (double)wp.getHealth() / (double)wp.getMaxHealth()));
    }

    @Nonnull
    public PlayerFilter mostAliveFirst() {
        return this.sorted(Comparator.comparing(wp -> (double)wp.getHealth() / (double)wp.getMaxHealth()).reversed());
    }

    @Nonnull
    public PlayerFilter leastEnergeticFirst() {
        return this.sorted(Comparator.comparing(wp -> (double)wp.getEnergy() / (double)wp.getMaxEnergy()));
    }

    @Nonnull
    public PlayerFilter mostEnergeticFirst() {
        return this.sorted(Comparator.comparing(wp -> (double)wp.getEnergy() / (double)wp.getMaxEnergy()).reversed());
    }

    @Nonnull
    public PlayerFilter soulBindedFirst(WarlordsPlayer owner) {
        return this.sorted(Comparator.comparing(wp -> !owner.getCooldownManager().hasBoundPlayer((WarlordsPlayer)wp)));
    }

    @Nonnull
    public PlayerFilter lookingAtFirst(WarlordsPlayer user) {
        return this.sorted((wp1, wp2) -> {
            double wp1Dot = -Utils.getDotToPlayer(user.getEntity(), wp1.getEntity(), 0.0);
            double wp2Dot = -Utils.getDotToPlayer(user.getEntity(), wp2.getEntity(), 0.0);
            int output = Double.compare(wp1Dot, wp2Dot);
            if (Math.abs(wp1Dot - wp2Dot) < 0.0125) {
                Location userLocation = user.getLocation();
                Location w1Location = wp1.getLocation();
                Location w2Location = wp2.getLocation();
                output = Double.compare(userLocation.distanceSquared(w1Location), userLocation.distanceSquared(w2Location));
            }
            return output;
        });
    }

    @Nonnull
    public PlayerFilter isAlive() {
        return this.filter(WarlordsPlayer::isAlive);
    }

    @Nonnull
    public PlayerFilter isDead() {
        return this.filter(WarlordsPlayer::isAlive);
    }

    @Nonnull
    public PlayerFilter enemiesOf(@Nonnull WarlordsPlayer player) {
        return this.filter(wp -> player.isEnemy((WarlordsPlayer)wp));
    }

    @Nonnull
    public PlayerFilter aliveEnemiesOf(@Nonnull WarlordsPlayer player) {
        return this.filter(wp -> player.isEnemyAlive((WarlordsPlayer)wp));
    }

    @Nonnull
    public PlayerFilter teammatesOf(@Nonnull WarlordsPlayer player) {
        return this.filter(wp -> player.isTeammate((WarlordsPlayer)wp));
    }

    @Nonnull
    public PlayerFilter aliveTeammatesOf(@Nonnull WarlordsPlayer player) {
        return this.filter(wp -> player.isTeammateAlive((WarlordsPlayer)wp));
    }

    @Nonnull
    public PlayerFilter teammatesOfExcludingSelf(@Nonnull WarlordsPlayer player) {
        return this.filter(wp -> player != wp && player.isTeammate((WarlordsPlayer)wp));
    }

    @Nonnull
    public PlayerFilter aliveTeammatesOfExcludingSelf(@Nonnull WarlordsPlayer player) {
        return this.filter(wp -> player != wp && player.isTeammateAlive((WarlordsPlayer)wp));
    }

    @Nonnull
    public PlayerFilter aliveMatchingTeam(@Nonnull Team team) {
        return this.filter(wp -> wp.getTeam() == team && wp.isAlive());
    }

    @Nonnull
    public PlayerFilter matchingTeam(@Nonnull Team team) {
        return this.filter(wp -> wp.getTeam() == team);
    }

    @Nonnull
    public PlayerFilter excluding(WarlordsPlayer ... exclude) {
        return exclude.length == 0 ? this : this.excluding0(new HashSet<WarlordsPlayer>(Arrays.asList(exclude)));
    }

    @Nonnull
    public PlayerFilter excluding(@Nonnull Collection<WarlordsPlayer> exclude) {
        return exclude.isEmpty() ? this : this.excluding0((Set<WarlordsPlayer>)(exclude instanceof Set ? (Set<Object>)exclude : new HashSet<WarlordsPlayer>(exclude)));
    }

    @Nonnull
    protected PlayerFilter excluding0(@Nonnull Set<WarlordsPlayer> exclude) {
        return this.filter(p -> !exclude.contains(p));
    }

    @Override
    public void forEach(@Nonnull Consumer<? super WarlordsPlayer> action) {
        this.stream.forEach(action);
        this.stream.close();
    }

    public boolean first(@Nonnull Consumer<? super WarlordsPlayer> action) {
        Optional<WarlordsPlayer> findAny = this.findAny();
        if (!findAny.isPresent()) {
            return false;
        }
        action.accept(findAny.get());
        return true;
    }

    @Override
    @Nonnull
    public Iterator<WarlordsPlayer> iterator() {
        return this.stream.iterator();
    }

    @Nonnull
    public static PlayerFilter entitiesAround(@Nonnull WarlordsPlayer entity, double x, double y, double z) {
        return PlayerFilter.entitiesAround(entity.getLocation(LOCATION_CACHE_ENTITIES_AROUND), x, y, z);
    }

    @Nonnull
    public static PlayerFilter entitiesAround(@Nonnull Entity entity, double x, double y, double z) {
        return PlayerFilter.entitiesAround(entity.getLocation(LOCATION_CACHE_ENTITIES_AROUND), x, y, z);
    }

    @Nonnull
    public static PlayerFilter entitiesAround(@Nonnull Location location, double x, double y, double z) {
        return new PlayerFilter(PlayerFilter.entitiesAround0(location, x, y, z));
    }

    @Nonnull
    protected static Stream<WarlordsPlayer> entitiesAround0(@Nonnull Location location, double x, double y, double z) {
        return PlayerFilter.entitiesAroundRectangle0(location, x, y, z).filter(Utils.radiusAround(WarlordsPlayer::getLocation, location, x, y, z));
    }

    @Nonnull
    public static PlayerFilter entitiesAroundRectangle(@Nonnull WarlordsPlayer entity, double x, double y, double z) {
        return PlayerFilter.entitiesAroundRectangle(entity.getLocation(LOCATION_CACHE_ENTITIES_AROUND), x, y, z);
    }

    @Nonnull
    public static PlayerFilter entitiesAroundRectangle(@Nonnull Entity entity, double x, double y, double z) {
        return PlayerFilter.entitiesAroundRectangle(entity.getLocation(LOCATION_CACHE_ENTITIES_AROUND), x, y, z);
    }

    @Nonnull
    public static PlayerFilter entitiesAroundRectangle(@Nonnull Location location, double x, double y, double z) {
        return new PlayerFilter(PlayerFilter.entitiesAroundRectangle0(location, x, y, z));
    }

    @Nonnull
    protected static Stream<WarlordsPlayer> entitiesAroundRectangle0(@Nonnull Location location, double x, double y, double z) {
        return PlayerFilter.entities0(location.getWorld().getNearbyEntities(location, x, y, z).stream());
    }

    @Nonnull
    public static PlayerFilter entitiesInRectangle(@Nonnull World world, double x1, double y1, double z1, double x2, double y2, double z2) {
        double minX = Math.min(x1, x2);
        double minY = Math.min(y1, y2);
        double minZ = Math.min(z1, z2);
        double maxX = Math.max(x1, x2);
        double maxY = Math.max(y1, y2);
        double maxZ = Math.max(z1, z2);
        return new PlayerFilter(world.getEntities().stream().filter((? super T e) -> {
            e.getLocation(LOCATION_CACHE_ENTITIES_AROUND);
            double x = LOCATION_CACHE_ENTITIES_AROUND.getX();
            double y = LOCATION_CACHE_ENTITIES_AROUND.getY();
            double z = LOCATION_CACHE_ENTITIES_AROUND.getZ();
            return x > minX && x < maxX && y > minY && y < maxY && z > minZ && z < maxZ;
        }).map(e -> Warlords.getPlayer(e)).filter(Objects::nonNull));
    }

    @Nonnull
    public static PlayerFilter playingGame(@Nonnull Game game) {
        return new PlayerFilter(game.warlordsPlayers());
    }

    @Nonnull
    public static PlayerFilter entities(@Nonnull Collection<Entity> entities) {
        return new PlayerFilter(PlayerFilter.entities0(entities.stream()));
    }

    @Nonnull
    public static PlayerFilter entities(@Nonnull Iterable<Entity> entities) {
        return PlayerFilter.entities(entities.iterator());
    }

    @Nonnull
    public static PlayerFilter entities(@Nonnull Iterator<Entity> entities) {
        return new PlayerFilter(PlayerFilter.entities0(StreamSupport.stream(Spliterators.spliteratorUnknownSize(entities, 16), false)));
    }

    @Nonnull
    public static PlayerFilter entities(Entity ... entities) {
        return new PlayerFilter(PlayerFilter.entities0(Stream.of(entities)));
    }

    @Nonnull
    protected static Stream<WarlordsPlayer> entities0(@Nonnull Stream<Entity> entities) {
        return entities.map(e -> Warlords.getPlayer(e)).filter(Objects::nonNull);
    }

    @Nonnull
    public Optional<WarlordsPlayer> findAny() {
        return this.stream.findAny();
    }

    @Nonnull
    public Optional<WarlordsPlayer> findFirst() {
        return this.stream.findFirst();
    }

    @Nullable
    public WarlordsPlayer findAnyOrNull() {
        return this.findAny().orElse(null);
    }

    @Nullable
    public WarlordsPlayer findFirstOrNull() {
        return this.findFirst().orElse(null);
    }

    @Nonnull
    public PlayerFilter requireLineOfSight(@Nonnull WarlordsPlayer warlordsPlayer) {
        return this.requireLineOfSight(warlordsPlayer.getEntity());
    }

    @Nonnull
    public PlayerFilter requireLineOfSight(@Nonnull LivingEntity entity) {
        return this.filter(wp -> Utils.isLookingAt(entity, wp.getEntity()) && Utils.hasLineOfSight(entity, wp.getEntity()));
    }

    @Nonnull
    public PlayerFilter requireLineOfSightIntervene(@Nonnull WarlordsPlayer warlordsPlayer) {
        return this.requireLineOfSightIntervene(warlordsPlayer.getEntity());
    }

    @Nonnull
    public PlayerFilter requireLineOfSightIntervene(@Nonnull LivingEntity entity) {
        return this.filter(wp -> Utils.isLookingAtIntervene(entity, wp.getEntity()));
    }

    @Nonnull
    public PlayerFilter lookingAtWave(@Nonnull WarlordsPlayer warlordsPlayer) {
        return this.lookingAtWave(warlordsPlayer.getEntity());
    }

    @Nonnull
    public PlayerFilter lookingAtWave(@Nonnull LivingEntity entity) {
        return this.filter(wp -> Utils.isLookingAtWave(entity, wp.getEntity()));
    }

    public List<WarlordsPlayer> toList() {
        return this.stream.collect(Collectors.toCollection(ArrayList::new));
    }
}

