/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.warlords;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class GameRunnable
implements Runnable {
    public static final boolean DEFAULT_RUN_IN_PAUSE_MODE = false;
    public static final int SECOND = 20;
    private int taskId = -1;
    @Nonnull
    private final Game game;
    private final boolean runInPauseMode;
    private long delay = 0L;
    private long period = 0L;
    private int ticksElapsed = 0;
    private boolean shouldCancel = false;

    public GameRunnable(@Nonnull Game game) {
        this(game, false);
    }

    public GameRunnable(@Nonnull Game game, boolean runInPauseMode) {
        this.game = Objects.requireNonNull(game, "game");
        this.runInPauseMode = runInPauseMode;
    }

    @Nonnull
    public Game getGame() {
        return this.game;
    }

    public boolean runInPauseMode() {
        return this.runInPauseMode;
    }

    public synchronized void cancel() throws IllegalStateException {
        Bukkit.getScheduler().cancelTask(this.getTaskId());
    }

    public synchronized BukkitTask runTask() throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        return this.setupId(Bukkit.getScheduler().runTask((Plugin)Warlords.getInstance(), this.getRunnable()));
    }

    public synchronized BukkitTask runTaskLater(long delay) throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        this.delay = delay;
        this.shouldCancel = true;
        return this.setupId(Bukkit.getScheduler().runTaskTimer((Plugin)Warlords.getInstance(), this.getRunnable(), 0L, 0L));
    }

    public synchronized BukkitTask runTaskTimer(long delay, long period) throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        this.delay = delay;
        this.period = period;
        return this.setupId(Bukkit.getScheduler().runTaskTimer((Plugin)Warlords.getInstance(), this.getRunnable(), 0L, period));
    }

    public synchronized int getTaskId() throws IllegalStateException {
        int id = this.taskId;
        if (id == -1) {
            throw new IllegalStateException("Not scheduled yet");
        }
        return id;
    }

    private void checkState() {
        if (this.taskId != -1) {
            throw new IllegalStateException("Already scheduled as " + this.taskId);
        }
    }

    private Runnable getRunnable() {
        if (this.runInPauseMode) {
            return this;
        }
        return () -> {
            if (!this.game.isFrozen()) {
                long delayCheck;
                ++this.ticksElapsed;
                long l = delayCheck = this.period <= 0L ? this.delay : this.delay / this.period;
                if ((long)(this.ticksElapsed - 1) < delayCheck) {
                    return;
                }
                this.run();
                if (this.shouldCancel) {
                    this.cancel();
                }
            }
        };
    }

    private BukkitTask setupId(BukkitTask task) {
        this.taskId = task.getTaskId();
        this.game.registerGameTask(task);
        return task;
    }

    public static GameRunnable create(Game game, Runnable runner) {
        return GameRunnable.create(game, runner, false);
    }

    public static GameRunnable create(Game game, final Runnable runner, boolean runInPauseMode) {
        return new GameRunnable(game, runInPauseMode){

            @Override
            public void run() {
                runner.run();
            }

            public String toString() {
                return "GameRunnable{" + runner.toString() + '}';
            }
        };
    }
}

