/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.java;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class NumberFormat {
    public static final DecimalFormat decimalFormatOptionalHundredths = new DecimalFormat("#.##");
    static final DecimalFormat decimalFormatOptionalTenths = new DecimalFormat("#.#");
    static final DecimalFormat decimalFormatTenths = new DecimalFormat("0.0");
    static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static String formatOptionalHundredths(double value) {
        return decimalFormatOptionalHundredths.format(value);
    }

    public static String formatOptionalTenths(double value) {
        return decimalFormatOptionalTenths.format(value);
    }

    public static String formatTenths(double value) {
        return decimalFormatTenths.format(value);
    }

    public static String getSimplifiedNumber(long value) {
        if (value == Long.MIN_VALUE) {
            return NumberFormat.getSimplifiedNumber(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + NumberFormat.getSimplifiedNumber(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String addCommaAndRound(double amount) {
        amount = Math.round(amount);
        DecimalFormat formatter = new DecimalFormat("#,###");
        return formatter.format(amount);
    }

    static {
        decimalFormatOptionalTenths.setDecimalSeparatorAlwaysShown(false);
        decimalFormatTenths.setDecimalSeparatorAlwaysShown(false);
        decimalFormatOptionalHundredths.setDecimalSeparatorAlwaysShown(false);
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "m");
        suffixes.put(1000000000L, "b");
        suffixes.put(1000000000000L, "t");
        suffixes.put(1000000000000000L, "p");
        suffixes.put(1000000000000000000L, "e");
    }
}

