/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.chat;

import com.ebicep.warlords.util.chat.DefaultFontInfo;
import java.util.List;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChatUtils {
    public static final TextComponent SPACER = new TextComponent(ChatColor.GRAY + " - ");
    private static final int CENTER_PX = 164;

    public static void sendMessage(Player player, boolean centered, String message) {
        if (centered) {
            ChatUtils.sendCenteredMessage(player, message);
        } else {
            player.sendMessage(message);
        }
    }

    public static void sendMessageToPlayer(Player player, String message, ChatColor borderColor, boolean centered) {
        if (centered) {
            String[] messages;
            if (borderColor != null) {
                ChatUtils.sendCenteredMessage(player, borderColor.toString() + ChatColor.BOLD + "------------------------------------------");
            }
            for (String s2 : messages = message.split("\n")) {
                ChatUtils.sendCenteredMessage(player, s2);
            }
            if (borderColor != null) {
                ChatUtils.sendCenteredMessage(player, borderColor.toString() + ChatColor.BOLD + "------------------------------------------");
            }
        } else {
            if (borderColor != null) {
                player.sendMessage(borderColor.toString() + ChatColor.BOLD + "------------------------------------------");
            }
            player.sendMessage(message);
            if (borderColor != null) {
                player.sendMessage(borderColor.toString() + ChatColor.BOLD + "------------------------------------------");
            }
        }
    }

    public static void sendMessageToPlayer(Player player, List<TextComponent> textComponents, ChatColor borderColor, boolean centered) {
        if (centered) {
            if (borderColor != null) {
                ChatUtils.sendCenteredMessage(player, borderColor.toString() + ChatColor.BOLD + "------------------------------------------");
            }
            ChatUtils.sendCenteredMessageWithEvents(player, textComponents);
            if (borderColor != null) {
                ChatUtils.sendCenteredMessage(player, borderColor.toString() + ChatColor.BOLD + "------------------------------------------");
            }
        } else {
            if (borderColor != null) {
                player.sendMessage(borderColor.toString() + ChatColor.BOLD + "------------------------------------------");
            }
            ChatUtils.sendCenteredMessageWithEvents(player, textComponents);
            if (borderColor != null) {
                player.sendMessage(borderColor.toString() + ChatColor.BOLD + "------------------------------------------");
            }
        }
    }

    public static void sendCenteredMessage(Player player, String message) {
        if (message == null || message.isEmpty()) {
            player.sendMessage("");
            return;
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 164 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        player.sendMessage(sb + message);
    }

    public static void sendCenteredMessageWithEvents(Player player, List<TextComponent> textComponents) {
        if (textComponents == null || textComponents.isEmpty()) {
            return;
        }
        String message = "";
        for (TextComponent textComponent : textComponents) {
            message = message + textComponent.getText();
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 164 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        ComponentBuilder componentBuilder = new ComponentBuilder(sb.toString());
        for (TextComponent textComponent : textComponents) {
            componentBuilder.append(textComponent.getText());
            componentBuilder.event(textComponent.getHoverEvent());
            componentBuilder.event(textComponent.getClickEvent());
        }
        player.spigot().sendMessage(componentBuilder.create());
    }

    public static String convertItemStackToJsonRegular(ItemStack itemStack) {
        net.minecraft.server.v1_8_R3.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound compound = new NBTTagCompound();
        nmsItemStack.save(compound);
        return compound.toString();
    }
}

