/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.bukkit.signgui;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.util.bukkit.packets.WrapperPlayClientUpdateSign;
import com.ebicep.warlords.util.bukkit.packets.WrapperPlayServerBlockChange;
import com.ebicep.warlords.util.bukkit.packets.WrapperPlayServerOpenSignEntity;
import com.ebicep.warlords.util.bukkit.packets.WrapperPlayServerUpdateSign;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SignGUI {
    public static ProtocolManager protocolManager;
    public static PacketAdapter packetListener;
    public static Map<UUID, SignGUIListener> listeners;
    public static Map<UUID, BlockPosition> signLocations;

    public static void init(Warlords warlords) {
        protocolManager = ProtocolLibrary.getProtocolManager();
        packetListener = new SignPacketListener((Plugin)warlords);
        protocolManager.addPacketListener((PacketListener)packetListener);
        listeners = new ConcurrentHashMap<UUID, SignGUIListener>();
        signLocations = new ConcurrentHashMap<UUID, BlockPosition>();
    }

    public static void open(Player player, SignGUIListener response) {
        SignGUI.open(player, new String[]{"", "", "", ""}, response);
    }

    public static void open(Player player, String[] text, SignGUIListener response) {
        String[] textFilled = new String[]{"", "", "", ""};
        System.arraycopy(text, 0, textFilled, 0, text.length);
        int x = player.getLocation().getBlockX();
        int y = 255;
        int z = player.getLocation().getBlockZ();
        BlockPosition blockPosition = new BlockPosition(x, y, z);
        WrapperPlayServerBlockChange blockChangePacket = new WrapperPlayServerBlockChange();
        WrappedBlockData blockData = WrappedBlockData.createData((Material)Material.SIGN_POST);
        blockChangePacket.setBlockData(blockData);
        blockChangePacket.setLocation(blockPosition);
        blockChangePacket.sendPacket(player);
        WrapperPlayServerUpdateSign updateSignPacket = new WrapperPlayServerUpdateSign();
        updateSignPacket.setLocation(new BlockPosition(x, y, z));
        WrappedChatComponent[] lines = new WrappedChatComponent[]{WrappedChatComponent.fromText((String)textFilled[0]), WrappedChatComponent.fromText((String)textFilled[1]), WrappedChatComponent.fromText((String)textFilled[2]), WrappedChatComponent.fromText((String)textFilled[3])};
        updateSignPacket.setLines(lines);
        updateSignPacket.sendPacket(player);
        WrapperPlayServerOpenSignEntity packet = new WrapperPlayServerOpenSignEntity();
        packet.setLocation(new BlockPosition(x, y, z));
        packet.sendPacket(player);
        signLocations.put(player.getUniqueId(), blockPosition);
        listeners.put(player.getUniqueId(), response);
    }

    public static void destroy() {
        protocolManager.removePacketListener((PacketListener)packetListener);
        listeners.clear();
        signLocations.clear();
    }

    static class SignPacketListener
    extends PacketAdapter {
        private final Plugin plugin;

        public SignPacketListener(Plugin plugin) {
            super(plugin, new PacketType[]{PacketType.Play.Client.UPDATE_SIGN});
            this.plugin = plugin;
        }

        public void onPacketReceiving(PacketEvent event) {
            String[] text = new String[4];
            Player player = event.getPlayer();
            WrapperPlayClientUpdateSign packet = new WrapperPlayClientUpdateSign(event.getPacket());
            BlockPosition blockPosition = packet.getLocation();
            BlockPosition playerBlockPos = signLocations.get(player.getUniqueId());
            if (playerBlockPos != null) {
                if (!blockPosition.equals((Object)playerBlockPos)) {
                    return;
                }
                for (int i = 0; i < packet.getLines().length; ++i) {
                    WrappedChatComponent chat = packet.getLines()[i];
                    String str = StringEscapeUtils.unescapeJavaScript((String)chat.getJson());
                    text[i] = str = str.substring(1, str.length() - 1);
                }
                WrapperPlayServerBlockChange blockChangePacket = new WrapperPlayServerBlockChange();
                WrappedBlockData blockData = WrappedBlockData.createData((Material)Material.AIR);
                blockChangePacket.setBlockData(blockData);
                blockChangePacket.setLocation(playerBlockPos);
                blockChangePacket.sendPacket(player);
                signLocations.remove(player.getUniqueId());
                SignGUIListener listener = listeners.remove(player.getUniqueId());
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, () -> listener.onSignDone(player, text));
            }
        }
    }

    public static interface SignGUIListener {
        public void onSignDone(Player var1, String[] var2);
    }
}

