/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.bukkit;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TeleportUtils {
    private static Set<Object> teleportFlags;
    private static Constructor packetConstructor;
    private static Constructor vec3D;
    private static Method position;
    private static Method closeInventory;
    private static Method sendMethod;
    private static Field connectionField;
    private static Field justTeleportedField;
    private static Field teleportPosField;
    private static Field lastPosXField;
    private static Field lastPosYField;
    private static Field lastPosZField;
    private static Field teleportAwaitField;
    private static Field AField;
    private static Field eField;
    private static Field yaw;
    private static Field pitch;
    private static Field activeContainer;
    private static Field defaultContainer;

    private static Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    public static void teleport(Player player, Location location) {
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        Object handle = TeleportUtils.getHandle((Entity)player);
        try {
            if (activeContainer.get(handle) != defaultContainer.get(handle)) {
                closeInventory.invoke(handle, new Object[0]);
            }
            position.invoke(handle, x, y, z, yaw.get(handle), pitch.get(handle));
            Object connection = connectionField.get(handle);
            justTeleportedField.set(connection, true);
            lastPosXField.set(connection, x);
            lastPosYField.set(connection, y);
            lastPosZField.set(connection, z);
            Object packet = packetConstructor.newInstance(x, y, z, 0, 0, teleportFlags);
            TeleportUtils.sendPacket(packet, player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sendPacket(Object packet, Player p) {
        try {
            Object handle = TeleportUtils.getHandle((Entity)p);
            Object pConnection = connectionField.get(handle);
            sendMethod.invoke(pConnection, packet);
        }
        catch (Exception var9) {
            var9.printStackTrace();
        }
    }

    private static Object getHandle(Entity entity) {
        try {
            Method entity_getHandle = entity.getClass().getMethod("getHandle", new Class[0]);
            return entity_getHandle.invoke((Object)entity, new Object[0]);
        }
        catch (Exception var2) {
            var2.printStackTrace();
            return null;
        }
    }

    private static Class<?> getNmsClass(String name) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("net.minecraft.server." + TeleportUtils.getVersion() + "." + name);
        }
        catch (ClassNotFoundException var3) {
            var3.printStackTrace();
        }
        return clazz;
    }

    private static String getVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().substring(23);
    }

    static {
        Class<?> packet = TeleportUtils.getNmsClass("Packet");
        Class<?> entity = TeleportUtils.getNmsClass("Entity");
        Class<?> entityPlayer = TeleportUtils.getNmsClass("EntityPlayer");
        Class<?> entityHuman = TeleportUtils.getNmsClass("EntityHuman");
        Class<?> connectionClass = TeleportUtils.getNmsClass("PlayerConnection");
        Class<?> packetClass = TeleportUtils.getNmsClass("PacketPlayOutPosition");
        Class<?> vecClass = TeleportUtils.getNmsClass("Vec3D");
        try {
            sendMethod = connectionClass.getMethod("sendPacket", packet);
            position = entity.getDeclaredMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            closeInventory = entityPlayer.getDeclaredMethod("closeInventory", new Class[0]);
            yaw = TeleportUtils.getField(entity, "yaw");
            pitch = TeleportUtils.getField(entity, "pitch");
            connectionField = TeleportUtils.getField(entityPlayer, "playerConnection");
            activeContainer = TeleportUtils.getField(entityHuman, "activeContainer");
            defaultContainer = TeleportUtils.getField(entityHuman, "defaultContainer");
            packetConstructor = packetClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Set.class);
            vec3D = vecClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
            ?[] enumObjects = TeleportUtils.getNmsClass("PacketPlayOutPosition$EnumPlayerTeleportFlags").getEnumConstants();
            teleportFlags = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(enumObjects[4], enumObjects[3])));
            justTeleportedField = TeleportUtils.getField(connectionClass, "justTeleported");
            lastPosXField = TeleportUtils.getField(connectionClass, "lastPosX");
            lastPosYField = TeleportUtils.getField(connectionClass, "lastPosY");
            lastPosZField = TeleportUtils.getField(connectionClass, "lastPosZ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

