/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.bukkit;

import com.ebicep.warlords.util.bukkit.LocationBuilder;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class LocationFactory {
    @Nonnull
    private final Location location;

    public LocationFactory(@Nonnull Location location) {
        this.location = Objects.requireNonNull(location, "location");
    }

    public LocationFactory(@Nonnull World world) {
        this(new Location(Objects.requireNonNull(world, "world"), 0.0, 0.0, 0.0));
    }

    public LocationBuilder x(double x) {
        return new LocationBuilder(this.location.clone()).x(x);
    }

    public LocationBuilder y(double y) {
        return new LocationBuilder(this.location.clone()).y(y);
    }

    public LocationBuilder z(double z) {
        return new LocationBuilder(this.location.clone()).z(z);
    }

    public LocationBuilder addXYZ(double x, double y, double z) {
        return new LocationBuilder(this.location.clone()).addXYZ(x, y, z);
    }

    public LocationBuilder addXYZ(double x, double y, double z, float yaw, float pitch) {
        return new LocationBuilder(this.location.clone()).addXYZ(x, y, z).yaw(yaw).pitch(pitch);
    }

    public LocationBuilder addX(double amount) {
        return new LocationBuilder(this.location.clone()).addX(amount);
    }

    public LocationBuilder addY(double amount) {
        return new LocationBuilder(this.location.clone()).addY(amount);
    }

    public LocationBuilder addZ(double amount) {
        return new LocationBuilder(this.location.clone()).addZ(amount);
    }

    public LocationBuilder add(Vector vector) {
        return new LocationBuilder(this.location.clone()).add(vector);
    }

    public LocationBuilder subtract(Vector vector) {
        return new LocationBuilder(this.location.clone()).subtract(vector);
    }

    public LocationBuilder direction(Vector vector) {
        return new LocationBuilder(this.location.clone()).direction(vector);
    }

    public LocationBuilder pitch(float pitch) {
        return new LocationBuilder(this.location.clone()).pitch(pitch);
    }

    public LocationBuilder yaw(float yaw) {
        return new LocationBuilder(this.location.clone()).yaw(yaw);
    }

    public LocationBuilder forward(float amount) {
        return new LocationBuilder(this.location.clone()).forward(amount);
    }

    public LocationBuilder backward(float amount) {
        return new LocationBuilder(this.location.clone()).backward(amount);
    }

    public LocationBuilder left(float amount) {
        return new LocationBuilder(this.location.clone()).left(amount);
    }

    public LocationBuilder right(float amount) {
        return new LocationBuilder(this.location.clone()).right(amount);
    }

    public Location getBaseLocation() {
        return this.location;
    }

    public World getWorld() {
        return this.location.getWorld();
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public double getZ() {
        return this.location.getZ();
    }

    public float getYaw() {
        return this.location.getYaw();
    }

    public float getPitch() {
        return this.location.getPitch();
    }

    public String toString() {
        return "LocationFactory{" + this.location + '}';
    }

    public int hashCode() {
        return Objects.hashCode(this.location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationFactory other = (LocationFactory)obj;
        return Objects.equals(this.location, other.location);
    }
}

