/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.util.bukkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.Potion;

public class ItemBuilder {
    @Nonnull
    private final ItemStack item;
    @Nullable
    private ItemMeta meta = null;

    public ItemBuilder(@Nonnull Material type) {
        this.item = new ItemStack(type);
    }

    public ItemBuilder(@Nonnull Material type, int amount) {
        this.item = new ItemStack(type, amount);
    }

    public ItemBuilder(@Nonnull Material type, int amount, short damage) {
        this.item = new ItemStack(type, amount, damage);
    }

    public ItemBuilder(@Nonnull ItemStack stack) throws IllegalArgumentException {
        this.item = new ItemStack(stack);
    }

    public ItemBuilder(@Nonnull Potion potion, int amount, boolean splash) {
        potion.setSplash(splash);
        this.item = potion.toItemStack(amount);
    }

    protected ItemMeta meta() {
        if (this.meta == null) {
            this.meta = this.item.getItemMeta();
            if (this.meta == null) {
                throw new IllegalStateException("Unable to get item meta for " + this.item);
            }
        }
        return this.meta;
    }

    public ItemBuilder name(@Nonnull String name) {
        this.meta().setDisplayName(name);
        return this;
    }

    public ItemBuilder enchant(@Nonnull Enchantment enchant, int level) {
        this.meta().addEnchant(enchant, level, true);
        return this;
    }

    public ItemBuilder flags(ItemFlag ... ifs) {
        this.meta().addItemFlags(ifs);
        return this;
    }

    public ItemBuilder lore(String ... lore) {
        return this.lore(Arrays.asList(lore));
    }

    public ItemBuilder lore(Collection<String> lore) {
        for (String row : lore) {
            if (row != null && !row.contains("\n")) continue;
            ArrayList<String> newLore = new ArrayList<String>(Math.max(lore.size() * 2, 16));
            for (String loreRow : lore) {
                if (loreRow == null) continue;
                if (loreRow.contains("\n")) {
                    String chatColor = "";
                    for (String split : loreRow.split("\n")) {
                        String combined = !split.isEmpty() && split.charAt(0) == '\u00a7' ? split : chatColor + split;
                        newLore.add(combined);
                        chatColor = ChatColor.getLastColors((String)combined);
                    }
                    continue;
                }
                newLore.add(loreRow);
            }
            this.meta().setLore(newLore);
            return this;
        }
        this.meta().setLore((List)(lore instanceof List ? (List<Object>)lore : new ArrayList<String>(lore)));
        return this;
    }

    public ItemBuilder unbreakable() {
        return this.unbreakable(true);
    }

    public ItemBuilder unbreakable(boolean unbreakable) {
        this.meta().spigot().setUnbreakable(true);
        return this;
    }

    public ItemStack get() {
        if (this.meta != null) {
            this.item.setItemMeta(this.meta);
            this.meta = null;
        }
        return this.item;
    }
}

