/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.poll.polls;

import com.ebicep.warlords.party.Party;
import com.ebicep.warlords.poll.AbstractPoll;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class PartyPoll
extends AbstractPoll<PartyPoll> {
    private Party party;

    @Override
    public int getNumberOfPlayersThatCanVote() {
        return this.party.getPartyPlayers().size() - this.excludedPlayers.size();
    }

    @Override
    public List<Player> getPlayersAllowedToVote() {
        return this.party.getAllPartyPeoplePlayerOnline().stream().filter(player -> !this.excludedPlayers.contains(player.getUniqueId())).collect(Collectors.toList());
    }

    @Override
    public boolean sendNonVoterMessage(Player player) {
        return this.getNumberOfPlayersThatCanVote() != this.playerAnsweredWithOption.size() && (this.party.getPartyLeader().getUuid().equals(player.getUniqueId()) || this.party.getPartyModerators().stream().anyMatch(partyPlayer -> partyPlayer.getUuid().equals(player.getUniqueId())));
    }

    @Override
    public void onPollEnd() {
        this.party.getPolls().remove(this);
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public static class Builder
    extends AbstractPoll.Builder<PartyPoll, Builder> {
        public Builder() {
        }

        public Builder(Party party) {
            this.setParty(party);
        }

        @Override
        public PartyPoll createPoll() {
            return new PartyPoll();
        }

        @Override
        public Builder thisBuilder() {
            return this;
        }

        public Builder setParty(Party party) {
            ((PartyPoll)this.poll).setParty(party);
            return (Builder)this.builder;
        }
    }
}

