/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.poll.polls;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.poll.AbstractPoll;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class GamePoll
extends AbstractPoll<GamePoll> {
    private Game game;

    @Override
    public int getNumberOfPlayersThatCanVote() {
        return this.game.playersCount() - this.excludedPlayers.size();
    }

    @Override
    public List<Player> getPlayersAllowedToVote() {
        return this.game.onlinePlayers().filter(playerTeamEntry -> !this.excludedPlayers.contains(((Player)playerTeamEntry.getKey()).getUniqueId())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public boolean sendNonVoterMessage(Player player) {
        return true;
    }

    @Override
    public void onPollEnd() {
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public static class Builder
    extends AbstractPoll.Builder<GamePoll, Builder> {
        public Builder() {
        }

        public Builder(Game game) {
            this.setGame(game);
        }

        @Override
        public GamePoll createPoll() {
            return new GamePoll();
        }

        @Override
        public Builder thisBuilder() {
            return this;
        }

        public Builder setGame(Game game) {
            ((GamePoll)this.poll).setGame(game);
            return (Builder)this.builder;
        }
    }
}

