/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.poll;

import com.ebicep.warlords.Warlords;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbstractPoll<T extends AbstractPoll<T>> {
    public static List<AbstractPoll<?>> polls = new ArrayList();
    protected String id;
    protected String question;
    protected List<String> options;
    protected int timeLeft = 30;
    protected boolean infiniteVotingTime = false;
    protected List<UUID> excludedPlayers = new ArrayList<UUID>();
    protected Consumer<T> onPollEnd;
    protected final HashMap<UUID, Integer> playerAnsweredWithOption = new HashMap();

    public static Optional<AbstractPoll<?>> getPoll(String pollID) {
        return polls.stream().filter(p -> AbstractPoll.getPollID(p).equals(pollID)).findAny();
    }

    public static String getPollID(AbstractPoll<?> poll) {
        String toString = poll.toString();
        return toString.substring(toString.indexOf("@") + 1);
    }

    public void init() {
        polls.add(this);
        this.id = AbstractPoll.getPollID(this);
        this.sendPollAnnouncement(true);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (AbstractPoll.this.timeLeft <= 0 || AbstractPoll.this.getNumberOfPlayersThatCanVote() == AbstractPoll.this.playerAnsweredWithOption.size()) {
                    AbstractPoll.this.sendPollResults();
                    AbstractPoll.this.onPollEnd();
                    polls.remove(AbstractPoll.this);
                    this.cancel();
                } else if (!AbstractPoll.this.infiniteVotingTime) {
                    if (AbstractPoll.this.timeLeft == 15) {
                        AbstractPoll.this.sendPollAnnouncement(false);
                    }
                    --AbstractPoll.this.timeLeft;
                } else if (this.counter % 15 == 0) {
                    AbstractPoll.this.sendPollAnnouncement(false);
                }
            }
        }.runTaskTimer((Plugin)Warlords.getInstance(), 0L, 20L);
    }

    public abstract int getNumberOfPlayersThatCanVote();

    public abstract List<Player> getPlayersAllowedToVote();

    public abstract boolean sendNonVoterMessage(Player var1);

    public abstract void onPollEnd();

    private void sendPollAnnouncement(boolean first) {
        this.getPlayersAllowedToVote().forEach(player -> {
            player.sendMessage(ChatColor.BLUE.toString() + ChatColor.BOLD + "------------------------------------------");
            if (first) {
                player.sendMessage(ChatColor.YELLOW + "There is a new poll! Answer it below by clicking on an option!");
            }
            player.sendMessage(ChatColor.YELLOW + "Question: " + ChatColor.GREEN + this.question);
            for (int i = 0; i < this.options.size(); ++i) {
                TextComponent message = new TextComponent(ChatColor.YELLOW + " - " + (i + 1) + ". " + ChatColor.GOLD + this.options.get(i));
                message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.GREEN + "Click here to vote for " + this.options.get(i)).create()));
                message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poll answer " + this.id + " " + (i + 1)));
                player.spigot().sendMessage((BaseComponent)message);
            }
            if (!this.infiniteVotingTime) {
                player.sendMessage(ChatColor.YELLOW + "The poll will end in " + this.timeLeft + " seconds! - " + this.id);
            } else {
                player.sendMessage(ChatColor.YELLOW + "The poll will end in when everyone has voted!");
            }
            player.sendMessage(ChatColor.BLUE.toString() + ChatColor.BOLD + "------------------------------------------");
        });
    }

    private void sendPollResults() {
        int[] numberOfVote = new int[this.options.size()];
        String[] squareRatio = new String[this.options.size()];
        for (int i = 0; i < this.options.size(); ++i) {
            int j;
            int finalI = i;
            numberOfVote[i] = (int)this.playerAnsweredWithOption.values().stream().filter(v -> v == finalI + 1).count();
            int counter = (int)Math.round((double)numberOfVote[i] / (double)this.playerAnsweredWithOption.size() * 10.0);
            squareRatio[i] = ChatColor.GREEN.toString();
            for (j = 0; j < counter; ++j) {
                int n = i;
                squareRatio[n] = squareRatio[n] + "\u25a0";
            }
            int n = i;
            squareRatio[n] = squareRatio[n] + ChatColor.GRAY;
            for (j = 0; j < 10 - counter; ++j) {
                int n2 = i;
                squareRatio[n2] = squareRatio[n2] + "\u25a0";
            }
        }
        this.getPlayersAllowedToVote().forEach(player -> {
            player.sendMessage(ChatColor.BLUE.toString() + ChatColor.BOLD + "------------------------------------------");
            player.sendMessage(ChatColor.YELLOW + "Question: " + ChatColor.GREEN + this.question);
            for (int i = 0; i < this.options.size(); ++i) {
                player.sendMessage(ChatColor.GOLD + this.options.get(i) + ChatColor.DARK_GRAY + " - " + ChatColor.YELLOW + numberOfVote[i] + " (" + Math.round((double)numberOfVote[i] / (double)this.playerAnsweredWithOption.size() * 100.0) + "%) " + ChatColor.GOLD + "[" + squareRatio[i] + ChatColor.GOLD + "]");
            }
            Set nonVoters = this.getPlayersAllowedToVote().stream().map(Entity::getUniqueId).collect(Collectors.toSet());
            nonVoters.removeAll(this.playerAnsweredWithOption.keySet());
            StringBuilder playersThatDidntVote = new StringBuilder(ChatColor.YELLOW + "Non Voters: " + ChatColor.AQUA);
            for (UUID nonVoter : nonVoters) {
                playersThatDidntVote.append(ChatColor.AQUA).append(Bukkit.getOfflinePlayer((UUID)nonVoter).getName()).append(ChatColor.GRAY).append(", ");
            }
            playersThatDidntVote.setLength(playersThatDidntVote.length() - 2);
            if (this.sendNonVoterMessage((Player)player)) {
                player.sendMessage(playersThatDidntVote.toString());
            }
            player.sendMessage(ChatColor.BLUE.toString() + ChatColor.BOLD + "------------------------------------------");
        });
        if (this.onPollEnd != null) {
            this.onPollEnd.accept(this);
        }
    }

    public HashMap<String, Integer> getOptionsWithVotes() {
        HashMap<String, Integer> votes = new HashMap<String, Integer>();
        this.options.forEach(s2 -> votes.put((String)s2, 0));
        this.playerAnsweredWithOption.forEach((uuid, integer) -> {
            String option = this.options.get(integer - 1);
            votes.put(option, (Integer)votes.get(option) + 1);
        });
        return votes;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }

    public boolean isInfiniteVotingTime() {
        return this.infiniteVotingTime;
    }

    public void setInfiniteVotingTime(boolean infiniteVotingTime) {
        this.infiniteVotingTime = infiniteVotingTime;
    }

    public List<UUID> getExcludedPlayers() {
        return this.excludedPlayers;
    }

    public void setExcludedPlayers(List<UUID> excludedPlayers) {
        this.excludedPlayers = excludedPlayers;
    }

    public Consumer<T> getOnPollEnd() {
        return this.onPollEnd;
    }

    public void setOnPollEnd(Consumer<T> onPollEnd) {
        this.onPollEnd = onPollEnd;
    }

    public HashMap<UUID, Integer> getPlayerAnsweredWithOption() {
        return this.playerAnsweredWithOption;
    }

    protected static abstract class Builder<T extends AbstractPoll<T>, B extends Builder<T, B>> {
        protected T poll = this.createPoll();
        protected B builder = this.thisBuilder();

        public T get() {
            ((AbstractPoll)this.poll).init();
            return this.poll;
        }

        public abstract T createPoll();

        public abstract B thisBuilder();

        public B setQuestion(String question) {
            ((AbstractPoll)this.poll).setQuestion(question);
            return this.builder;
        }

        public B setInfiniteVotingTime(boolean infiniteVotingTime) {
            ((AbstractPoll)this.poll).setInfiniteVotingTime(infiniteVotingTime);
            return this.builder;
        }

        public B setOptions(List<String> options) {
            ((AbstractPoll)this.poll).setOptions(options);
            return this.builder;
        }

        public B setTimeLeft(int timeLeft) {
            ((AbstractPoll)this.poll).setTimeLeft(timeLeft);
            return this.builder;
        }

        public B setExcludedPlayers(List<UUID> excludedPlayers) {
            ((AbstractPoll)this.poll).setExcludedPlayers(excludedPlayers);
            return this.builder;
        }

        public B setRunnableAfterPollEnded(Consumer<T> runnableAfterPollEnded) {
            ((AbstractPoll)this.poll).setOnPollEnd(runnableAfterPollEnded);
            return this.builder;
        }
    }
}

