/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player.cooldowns.cooldowns;

import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.AbstractCooldown;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.TriConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.ChatColor;

public class RegularCooldown<T>
extends AbstractCooldown<T> {
    protected int startingTicks;
    protected int ticksLeft;
    protected int counter;
    protected final List<TriConsumer<RegularCooldown<T>, Integer, Integer>> consumers;

    public RegularCooldown(String name, String nameAbbreviation, Class<T> cooldownClass, T cooldownObject, WarlordsPlayer from, CooldownTypes cooldownType, Consumer<CooldownManager> onRemove, int ticksLeft) {
        super(name, nameAbbreviation, cooldownClass, cooldownObject, from, cooldownType, onRemove);
        this.startingTicks = ticksLeft;
        this.ticksLeft = ticksLeft;
        this.consumers = new ArrayList<TriConsumer<RegularCooldown<T>, Integer, Integer>>();
    }

    @SafeVarargs
    public RegularCooldown(String name, String nameAbbreviation, Class<T> cooldownClass, T cooldownObject, WarlordsPlayer from, CooldownTypes cooldownType, Consumer<CooldownManager> onRemove, int ticksLeft, TriConsumer<RegularCooldown<T>, Integer, Integer> ... triConsumers) {
        super(name, nameAbbreviation, cooldownClass, cooldownObject, from, cooldownType, onRemove);
        this.startingTicks = ticksLeft;
        this.ticksLeft = ticksLeft;
        this.consumers = new ArrayList<TriConsumer<RegularCooldown<T>, Integer, Integer>>(Arrays.asList(triConsumers));
    }

    @Override
    public String getNameAbbreviation() {
        if (this.ticksLeft <= 0) {
            return "";
        }
        return (this.nameAbbreviation.equals("WND") || this.nameAbbreviation.equals("CRIP") || this.nameAbbreviation.equals("LCH") || this.nameAbbreviation.equals("MIAS") || this.nameAbbreviation.equals("AVE MARK") || this.nameAbbreviation.equals("SILENCE") ? ChatColor.RED : ChatColor.GREEN) + this.nameAbbreviation + ChatColor.GRAY + ":" + ChatColor.GOLD + (this.ticksLeft / 20 + 1) + " ";
    }

    @Override
    public void onTick() {
        this.consumers.forEach(integerConsumer -> integerConsumer.accept(this, this.ticksLeft, this.counter));
        ++this.counter;
        this.subtractTime(1);
    }

    @Override
    public boolean removeCheck() {
        return this.ticksLeft <= 0;
    }

    public void subtractTime(int amount) {
        this.ticksLeft = this.ticksLeft - amount <= 0 ? 0 : (this.ticksLeft -= amount);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticksLeft) {
        this.ticksLeft = ticksLeft;
    }

    public boolean hasTicksLeft() {
        return this.ticksLeft > 0;
    }

    public int getStartingTicks() {
        return this.startingTicks;
    }

    public void addTriConsumer(TriConsumer<RegularCooldown<T>, Integer, Integer> triConsumer) {
        this.consumers.add(triConsumer);
    }

    public void removeTriConsumer(TriConsumer<RegularCooldown<T>, Integer, Integer> triConsumer) {
        this.consumers.remove(triConsumer);
    }
}

