/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player.cooldowns.cooldowns;

import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.TriConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.ChatColor;

public class PersistentCooldown<T>
extends RegularCooldown<T> {
    protected Predicate<T> objectCheck;
    protected boolean hidden = false;

    public PersistentCooldown(String name, String nameAbbreviation, Class<T> cooldownClass, T cooldownObject, WarlordsPlayer from, CooldownTypes cooldownType, Consumer<CooldownManager> onRemove, int ticksLeft, Predicate<T> objectCheck) {
        super(name, nameAbbreviation, cooldownClass, cooldownObject, from, cooldownType, onRemove, ticksLeft);
        this.objectCheck = objectCheck;
    }

    public PersistentCooldown(String name, String nameAbbreviation, Class<T> cooldownClass, T cooldownObject, WarlordsPlayer from, CooldownTypes cooldownType, Consumer<CooldownManager> onRemove, int ticksLeft, Predicate<T> objectCheck, TriConsumer<RegularCooldown<T>, Integer, Integer> ... triConsumers) {
        super(name, nameAbbreviation, cooldownClass, cooldownObject, from, cooldownType, onRemove, ticksLeft, triConsumers);
        this.objectCheck = objectCheck;
    }

    @Override
    public String getNameAbbreviation() {
        if (this.hidden) {
            return "";
        }
        return ChatColor.GREEN + this.nameAbbreviation + ChatColor.GRAY + ":" + ChatColor.GOLD + (this.ticksLeft / 20 + 1) + " ";
    }

    @Override
    public boolean removeCheck() {
        if (this.ticksLeft <= 0) {
            if (this.objectCheck.test(this.cooldownObject)) {
                return true;
            }
            this.hidden = true;
        }
        return false;
    }

    public boolean isShown() {
        return !this.hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

