/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player.cooldowns;

import com.ebicep.warlords.abilties.Consecrate;
import com.ebicep.warlords.abilties.HammerOfLight;
import com.ebicep.warlords.abilties.HealingRain;
import com.ebicep.warlords.abilties.HealingTotem;
import com.ebicep.warlords.abilties.Intervene;
import com.ebicep.warlords.abilties.OrbsOfLife;
import com.ebicep.warlords.abilties.Soulbinding;
import com.ebicep.warlords.abilties.UndyingArmy;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.AbstractCooldown;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.PersistentCooldown;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CooldownManager {
    private final WarlordsPlayer warlordsPlayer;
    private final List<AbstractCooldown<?>> abstractCooldowns;
    private int totalCooldowns = 0;

    public CooldownManager(WarlordsPlayer warlordsPlayer) {
        this.warlordsPlayer = warlordsPlayer;
        this.abstractCooldowns = new ArrayList();
    }

    public boolean hasCooldownFromName(String name) {
        return this.abstractCooldowns.stream().anyMatch(cooldown -> cooldown.getName().equalsIgnoreCase(name));
    }

    public boolean hasCooldown(AbstractCooldown<?> abstractCooldown) {
        return this.abstractCooldowns.contains(abstractCooldown);
    }

    public boolean hasCooldown(Class<?> cooldownClass) {
        return this.abstractCooldowns.stream().anyMatch(cooldown -> cooldown.getCooldownClass() != null && cooldown.getCooldownClass().equals(cooldownClass));
    }

    public boolean hasCooldown(Object cooldownObject) {
        return this.abstractCooldowns.stream().anyMatch(cooldown -> cooldown.getCooldownObject() != null && cooldown.getCooldownObject() == cooldownObject);
    }

    public void reduceCooldowns() {
        for (int i = 0; i < this.abstractCooldowns.size(); ++i) {
            AbstractCooldown<?> abstractCooldown = this.abstractCooldowns.get(i);
            abstractCooldown.onTick();
            if (!abstractCooldown.removeCheck()) continue;
            abstractCooldown.getOnRemove().accept(this);
            this.abstractCooldowns.remove(i);
            --i;
        }
    }

    public List<AbstractCooldown<?>> getCooldowns() {
        return this.abstractCooldowns;
    }

    public List<AbstractCooldown<?>> getCooldownsDistinct() {
        ArrayList cooldowns = new ArrayList();
        ArrayList previousCooldowns = new ArrayList();
        for (AbstractCooldown<?> abstractCooldown : this.abstractCooldowns) {
            if (abstractCooldown.distinct() && previousCooldowns.stream().anyMatch(classStringPair -> ((Class)classStringPair.getA()).equals(abstractCooldown.getCooldownClass()) && ((String)classStringPair.getB()).equals(abstractCooldown.getName()))) continue;
            cooldowns.add(abstractCooldown);
            if (!abstractCooldown.distinct()) continue;
            previousCooldowns.add(new Pair(abstractCooldown.getCooldownClass(), abstractCooldown.getName()));
        }
        return cooldowns;
    }

    public int getTotalCooldowns() {
        return this.totalCooldowns;
    }

    public void addTicksToRegularCooldowns(CooldownTypes cooldownTypes, int ticks) {
        this.abstractCooldowns.stream().filter(abstractCooldown -> abstractCooldown.getCooldownType() == cooldownTypes).filter(RegularCooldown.class::isInstance).map(RegularCooldown.class::cast).forEachOrdered(regularCooldown -> {
            regularCooldown.setTicksLeft(regularCooldown.getTicksLeft() + ticks);
            if (Objects.equals(regularCooldown.getCooldownClass(), Intervene.class)) {
                Intervene intervene = (Intervene)regularCooldown.getCooldownObject();
                if (regularCooldown.getFrom() == this.warlordsPlayer) {
                    new CooldownFilter<RegularCooldown>(intervene.getTarget(), RegularCooldown.class).filterCooldownObject(intervene).findFirst().ifPresent(cooldown -> cooldown.setTicksLeft(cooldown.getTicksLeft() + ticks));
                } else {
                    new CooldownFilter<RegularCooldown>(intervene.getCaster(), RegularCooldown.class).filterCooldownObject(intervene).findFirst().ifPresent(cooldown -> cooldown.setTicksLeft(cooldown.getTicksLeft() + ticks));
                }
            }
        });
    }

    public void subtractTicksOnRegularCooldowns(CooldownTypes cooldownTypes, int ticks) {
        this.abstractCooldowns.stream().filter(abstractCooldown -> abstractCooldown.getCooldownType() == cooldownTypes).filter(RegularCooldown.class::isInstance).map(RegularCooldown.class::cast).forEachOrdered(regularCooldown -> {
            regularCooldown.setTicksLeft(regularCooldown.getTicksLeft() - ticks);
            if (Objects.equals(regularCooldown.getCooldownClass(), Intervene.class)) {
                Intervene intervene = (Intervene)regularCooldown.getCooldownObject();
                if (regularCooldown.getFrom() == this.warlordsPlayer) {
                    new CooldownFilter<RegularCooldown>(intervene.getTarget(), RegularCooldown.class).filterCooldownObject(intervene).findFirst().ifPresent(cooldown -> cooldown.setTicksLeft(cooldown.getTicksLeft() - ticks));
                } else {
                    new CooldownFilter<RegularCooldown>(intervene.getCaster(), RegularCooldown.class).filterCooldownObject(intervene).findFirst().ifPresent(cooldown -> cooldown.setTicksLeft(cooldown.getTicksLeft() - ticks));
                }
            }
        });
    }

    public List<AbstractCooldown<?>> getBuffCooldowns() {
        return this.abstractCooldowns.stream().filter(cooldown -> cooldown.getCooldownType() == CooldownTypes.BUFF).collect(Collectors.toList());
    }

    public void removeBuffCooldowns() {
        this.abstractCooldowns.removeIf(cd2 -> cd2.getCooldownType() == CooldownTypes.BUFF);
    }

    public List<AbstractCooldown<?>> getDebuffCooldowns() {
        return this.abstractCooldowns.stream().filter(cooldown -> cooldown.getCooldownType() == CooldownTypes.DEBUFF).collect(Collectors.toList());
    }

    public int removeDebuffCooldowns() {
        List toRemove = this.abstractCooldowns.stream().filter(cooldown -> cooldown.getCooldownType() == CooldownTypes.DEBUFF).collect(Collectors.toList());
        this.abstractCooldowns.removeAll(toRemove);
        return toRemove.size();
    }

    public List<AbstractCooldown<?>> getAbilityCooldowns() {
        return this.abstractCooldowns.stream().filter(cooldown -> cooldown.getCooldownType() == CooldownTypes.ABILITY).collect(Collectors.toList());
    }

    public void removeAbilityCooldowns() {
        this.abstractCooldowns.removeIf(cd2 -> cd2.getCooldownType() == CooldownTypes.ABILITY);
    }

    @SafeVarargs
    public final <T> void addRegularCooldown(String name, String actionBarName, Class<T> cooldownClass, T cooldownObject, WarlordsPlayer from, CooldownTypes cooldownType, Consumer<CooldownManager> onRemove, int timeLeft, TriConsumer<RegularCooldown<T>, Integer, Integer> ... triConsumers) {
        this.addCooldown(new RegularCooldown<T>(name, actionBarName, cooldownClass, cooldownObject, from, cooldownType, onRemove, timeLeft, triConsumers));
    }

    @SafeVarargs
    public final <T> void addPersistentCooldown(String name, String actionBarName, Class<T> cooldownClass, T cooldownObject, WarlordsPlayer from, CooldownTypes cooldownType, Consumer<CooldownManager> onRemove, int timeLeft, Predicate<T> objectCheck, TriConsumer<RegularCooldown<T>, Integer, Integer> ... triConsumers) {
        this.addCooldown(new PersistentCooldown<T>(name, actionBarName, cooldownClass, cooldownObject, from, cooldownType, onRemove, timeLeft, objectCheck, triConsumers));
    }

    public void addCooldown(AbstractCooldown<?> abstractCooldown) {
        if (this.hasCooldownFromName("Vindicate Debuff Immunity") && abstractCooldown.getCooldownType() == CooldownTypes.DEBUFF) {
            return;
        }
        ++this.totalCooldowns;
        this.abstractCooldowns.add(abstractCooldown);
    }

    public <T> void incrementCooldown(RegularCooldown<T> regularCooldown, int ticksToAdd, int tickCap) {
        Optional<RegularCooldown> optionalRegularCooldown = new CooldownFilter<RegularCooldown>(this, RegularCooldown.class).filterCooldownClass(regularCooldown.cooldownClass).filterName(regularCooldown.name).findAny();
        if (optionalRegularCooldown.isPresent()) {
            RegularCooldown cd2 = optionalRegularCooldown.get();
            if (cd2.getTicksLeft() + ticksToAdd >= tickCap) {
                cd2.setTicksLeft(tickCap);
            } else {
                cd2.subtractTime(-ticksToAdd);
            }
        } else {
            this.addCooldown(regularCooldown);
        }
    }

    public void removeCooldown(AbstractCooldown<?> abstractCooldown) {
        this.abstractCooldowns.remove(abstractCooldown);
    }

    public void removeCooldown(Class<?> cooldownClass) {
        this.abstractCooldowns.removeIf(cd2 -> cd2.getCooldownClass() == cooldownClass);
    }

    public void removeCooldownByObject(Object cooldownObject) {
        this.abstractCooldowns.removeIf(cd2 -> cd2.getCooldownObject() == cooldownObject);
    }

    public void removeCooldownByName(String cooldownName) {
        this.abstractCooldowns.removeIf(cd2 -> cd2.getName().equals(cooldownName));
    }

    public void clearAllCooldowns() {
        this.abstractCooldowns.clear();
    }

    public void clearCooldowns() {
        List<AbstractCooldown> cooldownsToRemove = this.abstractCooldowns.stream().filter(cd2 -> cd2.getCooldownClass() != OrbsOfLife.class && (cd2.getCooldownClass() != HammerOfLight.class || !((HammerOfLight)cd2.getCooldownObject()).isHammer()) && cd2.getCooldownClass() != HealingRain.class && cd2.getCooldownClass() != HealingTotem.class && cd2.getCooldownClass() != Consecrate.class).collect(Collectors.toList());
        cooldownsToRemove.forEach(abstractCooldown -> abstractCooldown.getOnRemove().accept(this));
        this.abstractCooldowns.removeAll(cooldownsToRemove);
        PlayerFilter.playingGame(this.warlordsPlayer.getGame()).teammatesOf(this.warlordsPlayer).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)wp -> wp.getCooldownManager().getCooldowns().removeIf(cd2 -> cd2.getFrom() == this.warlordsPlayer && cd2.getCooldownClass() == Intervene.class)));
    }

    public boolean hasBoundPlayer(WarlordsPlayer warlordsPlayer) {
        for (Soulbinding soulbinding : new CooldownFilter<PersistentCooldown>(this, PersistentCooldown.class).filterCooldownClassAndMapToObjectsOfClass(Soulbinding.class).collect(Collectors.toList())) {
            if (!soulbinding.hasBoundPlayer(warlordsPlayer)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfBoundPlayersLink(WarlordsPlayer warlordsPlayer) {
        int counter = 0;
        for (Soulbinding soulbinding : new CooldownFilter<RegularCooldown>(this, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(Soulbinding.class).collect(Collectors.toList())) {
            if (!soulbinding.hasBoundPlayerLink(warlordsPlayer)) continue;
            this.warlordsPlayer.doOnStaticAbility(Soulbinding.class, Soulbinding::addLinkProcs);
            ++counter;
        }
        this.incrementCooldown(new RegularCooldown<Object>("KB Resistance", "KB", null, null, this.warlordsPlayer, CooldownTypes.BUFF, cooldownManager -> {}, counter * 20), (int)((double)counter * 1.2 * 20.0), 72);
        return counter;
    }

    public boolean checkUndyingArmy(boolean popped) {
        for (UndyingArmy undyingArmy : new CooldownFilter<RegularCooldown>(this, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(UndyingArmy.class).collect(Collectors.toList())) {
            if (!(popped ? undyingArmy.isArmyDead(this.warlordsPlayer) : !undyingArmy.isArmyDead(this.warlordsPlayer))) continue;
            return true;
        }
        return false;
    }
}

