/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player.cooldowns;

import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.AbstractCooldown;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class CooldownFilter<T extends AbstractCooldown<?>>
implements Iterable<T> {
    private final Stream<T> stream;
    private Class<T> clazz;

    public CooldownFilter(Stream<T> stream) {
        this.stream = stream;
    }

    public CooldownFilter(List<AbstractCooldown<?>> abstractCooldownList, Class<T> clazz) {
        this.stream = abstractCooldownList.stream().filter(clazz::isInstance).map(clazz::cast);
        this.clazz = clazz;
    }

    public CooldownFilter(CooldownManager cooldownManager, Class<T> clazz) {
        this.stream = cooldownManager.getCooldowns().stream().filter(clazz::isInstance).map(clazz::cast);
        this.clazz = clazz;
    }

    public CooldownFilter(WarlordsPlayer warlordsPlayer, Class<T> clazz) {
        this.stream = warlordsPlayer.getCooldownManager().getCooldowns().stream().filter(clazz::isInstance).map(clazz::cast);
        this.clazz = clazz;
    }

    public CooldownFilter<T> filterName(String name) {
        return new CooldownFilter<AbstractCooldown>(this.stream.filter((? super T abstractCooldown) -> abstractCooldown.getName() != null && abstractCooldown.getName().equalsIgnoreCase(name)));
    }

    public CooldownFilter<T> filterNameActionBar(String name) {
        return new CooldownFilter<AbstractCooldown>(this.stream.filter((? super T abstractCooldown) -> abstractCooldown.getActionBarName() != null && abstractCooldown.getActionBarName().equalsIgnoreCase(name)));
    }

    public <R> CooldownFilter<T> filterCooldownClass(Class<R> clazz) {
        return new CooldownFilter<AbstractCooldown>(this.stream.filter((? super T cd2) -> Objects.equals(clazz, cd2.getCooldownClass())));
    }

    public CooldownFilter<T> filterCooldownObject(Object object) {
        return new CooldownFilter<AbstractCooldown>(this.stream.filter((? super T cd2) -> Objects.equals(object, cd2.getCooldownObject())));
    }

    public CooldownFilter<T> filterCooldownFrom(WarlordsPlayer warlordsPlayer) {
        return new CooldownFilter<AbstractCooldown>(this.stream.filter((? super T cd2) -> Objects.equals(warlordsPlayer, cd2.getFrom())));
    }

    public CooldownFilter<T> filter(Predicate<T> predicate) {
        return new CooldownFilter<T>(this.stream.filter(predicate));
    }

    public <R> Stream<R> filterCooldownClassAndMapToObjectsOfClass(Class<R> clazz) {
        return this.stream.filter((? super T cd2) -> Objects.equals(clazz, cd2.getCooldownClass())).map(t2 -> t2.getCooldownObject()).filter(Objects::nonNull).map(clazz::cast);
    }

    public <R> Stream<R> mapToObjectsOfClass(Class<R> clazz) {
        return this.stream.map(t2 -> t2.getCooldownObject()).filter(Objects::nonNull).map(clazz::cast);
    }

    public <R> Optional<R> findFirstObject(Object object, Class<R> clazz) {
        assert (object.getClass() == clazz);
        return this.stream.filter((? super T cd2) -> cd2.getCooldownObject() != null && cd2.getCooldownObject().equals(object)).map(cd2 -> cd2.getCooldownObject()).filter(Objects::nonNull).findFirst().map(clazz::cast);
    }

    public Optional<T> findFirst() {
        return this.stream.findFirst();
    }

    public Optional<T> findAny() {
        return this.stream.findAny();
    }

    public <R> Optional<R> findFirstObjectOfClass(Class<R> clazz) {
        return this.stream.findFirst().map(t2 -> clazz.cast(t2.getCooldownObject()));
    }

    public Stream<T> stream() {
        return this.stream;
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.stream.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream.forEach(action);
        this.stream.close();
    }
}

