/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player;

import com.ebicep.customentities.CustomHorse;
import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.ArcaneShield;
import com.ebicep.warlords.abilties.HammerOfLight;
import com.ebicep.warlords.abilties.Intervene;
import com.ebicep.warlords.abilties.OrderOfEviscerate;
import com.ebicep.warlords.abilties.Repentance;
import com.ebicep.warlords.abilties.SoulShackle;
import com.ebicep.warlords.abilties.Soulbinding;
import com.ebicep.warlords.abilties.UndyingArmy;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.abilties.internal.HealingPowerup;
import com.ebicep.warlords.achievements.Achievement;
import com.ebicep.warlords.achievements.types.ChallengeAchievements;
import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.events.WarlordsDamageHealingFinalEvent;
import com.ebicep.warlords.events.WarlordsDeathEvent;
import com.ebicep.warlords.events.WarlordsRespawnEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.flags.FlagInfo;
import com.ebicep.warlords.game.flags.PlayerFlagLocation;
import com.ebicep.warlords.game.option.marker.CompassTargetMarker;
import com.ebicep.warlords.game.option.marker.FlagHolder;
import com.ebicep.warlords.game.option.marker.SpawnLocationMarker;
import com.ebicep.warlords.game.state.PlayingState;
import com.ebicep.warlords.player.ArmorManager;
import com.ebicep.warlords.player.CalculateSpeed;
import com.ebicep.warlords.player.PlayerSettings;
import com.ebicep.warlords.player.PlayerStatisticsMinute;
import com.ebicep.warlords.player.PlayerStatisticsSecond;
import com.ebicep.warlords.player.SkillBoosts;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.player.Weapons;
import com.ebicep.warlords.player.cooldowns.AbstractCooldown;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import com.ebicep.warlords.player.cooldowns.cooldowns.DamageHealCompleteCooldown;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.bukkit.TeleportUtils;
import com.ebicep.warlords.util.java.NumberFormat;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public final class WarlordsPlayer {
    public static final String RECEIVE_ARROW_RED = ChatColor.RED + "\u00ab";
    public static final String RECEIVE_ARROW_GREEN = ChatColor.GREEN + "\u00ab";
    public static final String GIVE_ARROW_RED = ChatColor.RED + "\u00bb";
    public static final String GIVE_ARROW_GREEN = ChatColor.GREEN + "\u00bb";
    @Deprecated
    private final PlayingState gameState;
    private final Game game;
    private final List<Float> recordDamage = new ArrayList<Float>();
    private final PlayerStatisticsMinute minuteStats;
    private final PlayerStatisticsSecond secondStats;
    private final List<Achievement.AbstractAchievementRecord<?>> achievementsUnlocked = new ArrayList();
    private final LinkedHashMap<WarlordsPlayer, Integer> hitBy = new LinkedHashMap();
    private final LinkedHashMap<WarlordsPlayer, Integer> healedBy = new LinkedHashMap();
    private final List<Location> locations = new ArrayList<Location>();
    private final CalculateSpeed speed;
    private final Location deathLocation;
    private final CooldownManager cooldownManager = new CooldownManager(this);
    private String name;
    private UUID uuid;
    private Team team;
    private AbstractPlayerClass spec;
    private Specializations specClass;
    private Weapons weapon;
    private int health;
    private int maxHealth;
    private int regenTimer;
    private int respawnTimer = -1;
    private boolean dead = false;
    private float energy;
    private float maxEnergy;
    private CustomHorse horse;
    private float horseCooldown;
    private float currentHealthModifier = 1.0f;
    private int flagDropCooldown;
    private int flagPickCooldown;
    private int hitCooldown;
    private boolean wasSneaking = false;
    private float walkspeed = 1.0f;
    private int blocksTravelledCM = 0;
    private boolean noEnergyConsumption;
    private boolean disableCooldowns;
    private double energyModifier;
    private double cooldownModifier;
    private boolean takeDamage = true;
    private boolean canCrit = true;
    private double flagDamageMultiplier = 0.0;
    private boolean teamFlagCompass = true;
    private LivingEntity entity;
    @Nullable
    private FlagInfo carriedFlag = null;
    @Nullable
    private CompassTargetMarker compassTarget;

    public WarlordsPlayer(@Nonnull OfflinePlayer player, @Nonnull PlayingState gameState, @Nonnull Team team, @Nonnull PlayerSettings settings) {
        this.name = player.getName();
        this.uuid = player.getUniqueId();
        this.gameState = gameState;
        this.game = gameState.getGame();
        this.minuteStats = new PlayerStatisticsMinute();
        this.secondStats = new PlayerStatisticsSecond(gameState);
        this.team = team;
        this.specClass = settings.getSelectedSpec();
        this.spec = this.specClass.create.get();
        this.health = this.maxHealth = this.spec.getMaxHealth();
        this.energy = 0.0f;
        this.energyModifier = 1.0;
        this.maxEnergy = this.spec.getMaxEnergy();
        this.horseCooldown = 0.0f;
        this.flagDropCooldown = 0;
        this.flagPickCooldown = 0;
        this.cooldownModifier = 1.0;
        this.hitCooldown = 20;
        this.speed = new CalculateSpeed(this::setWalkSpeed, 13);
        Player p = player.getPlayer();
        this.entity = this.spawnJimmy(p == null ? Warlords.getRejoinPoint(this.uuid) : p.getLocation(), null);
        this.weapon = Weapons.getSelected(player, settings.getSelectedSpec());
        this.deathLocation = this.entity.getLocation();
        this.updatePlayerReference(p);
        this.compassTarget = gameState.getGame().getMarkers(CompassTargetMarker.class).stream().filter(c -> c.isEnabled()).sorted(Comparator.comparing(c -> c.getCompassTargetPriority(this)).reversed()).findFirst().orElse(null);
        this.horse = new CustomHorse((net.minecraft.server.v1_8_R3.World)((CraftWorld)this.entity.getWorld()).getHandle(), this);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public String toString() {
        return "WarlordsPlayer{name='" + this.name + '\'' + ", uuid=" + this.uuid + '}';
    }

    private Optional<WarlordsDamageHealingFinalEvent> addHealingDamageInstance(WarlordsDamageHealingEvent event) {
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        if (event.isHealingInstance()) {
            return this.addHealingInstance(event);
        }
        return this.addDamageInstance(event);
    }

    public Optional<WarlordsDamageHealingFinalEvent> addDamageInstance(WarlordsPlayer attacker, String ability, float min2, float max, int critChance, int critMultiplier, boolean ignoreReduction) {
        return this.addHealingDamageInstance(new WarlordsDamageHealingEvent(this, attacker, ability, min2, max, critChance, critMultiplier, ignoreReduction, false, true));
    }

    private Optional<WarlordsDamageHealingFinalEvent> addDamageInstance(WarlordsDamageHealingEvent event) {
        WarlordsPlayer attacker = event.getAttacker();
        String ability = event.getAbility();
        float min2 = event.getMin();
        float max = event.getMax();
        int critChance = event.getCritChance();
        int critMultiplier = event.getCritMultiplier();
        boolean ignoreReduction = event.isIgnoreReduction();
        boolean isLastStandFromShield = event.isIsLastStandFromShield();
        boolean isMeleeHit = ability.isEmpty();
        boolean isFallDamage = ability.equals("Fall");
        WarlordsDamageHealingFinalEvent finalEvent = null;
        if (this.dead && !this.cooldownManager.checkUndyingArmy(false) || this.getGameState() != this.getGame().getState()) {
            return Optional.empty();
        }
        int initialHealth = this.health;
        for (AbstractCooldown<?> abstractCooldown : this.getCooldownManager().getCooldownsDistinct()) {
            abstractCooldown.doBeforeReductionFromSelf(event);
        }
        for (AbstractCooldown<?> abstractCooldown : attacker.getCooldownManager().getCooldownsDistinct()) {
            abstractCooldown.doBeforeReductionFromAttacker(event);
        }
        for (AbstractCooldown<?> abstractCooldown : attacker.getCooldownManager().getCooldownsDistinct()) {
            critChance = abstractCooldown.addCritChanceFromAttacker(event, critChance);
            critMultiplier = abstractCooldown.addCritMultiplierFromAttacker(event, critMultiplier);
        }
        float damageValue = (int)(Math.random() * (double)(max - min2) + (double)min2);
        int crit = (int)(Math.random() * 100.0);
        boolean isCrit = false;
        if (crit <= critChance && attacker.canCrit) {
            isCrit = true;
            damageValue *= (float)critMultiplier / 100.0f;
        }
        float damageHealValueBeforeAllReduction = damageValue;
        this.addAbsorbed(Math.abs(damageValue - (damageValue *= 1.0f - (float)this.spec.getDamageResistance() / 100.0f)));
        if (attacker == this && (isFallDamage || isMeleeHit)) {
            if (isMeleeHit) {
                this.sendMessage(RECEIVE_ARROW_RED + ChatColor.GRAY + " You took " + ChatColor.RED + Math.round(min2) + ChatColor.GRAY + " melee damage.");
                this.regenTimer = 10;
                if ((float)this.health - min2 <= 0.0f && !this.cooldownManager.checkUndyingArmy(false)) {
                    if (this.entity instanceof Player) {
                        PacketUtils.sendTitle((Player)this.entity, ChatColor.RED + "YOU DIED!", ChatColor.GRAY + "You took " + ChatColor.RED + Math.round(min2) + ChatColor.GRAY + " melee damage and died.", 0, 40, 0);
                    }
                    this.health = 0;
                    this.die(attacker);
                } else {
                    this.health = (int)((float)this.health - min2);
                    this.playHurtAnimation(this.entity, attacker);
                }
            } else {
                this.sendMessage(RECEIVE_ARROW_RED + ChatColor.GRAY + " You took " + ChatColor.RED + Math.round(damageValue) + ChatColor.GRAY + " fall damage.");
                this.regenTimer = 10;
                if ((float)this.health - damageValue < 0.0f && !this.cooldownManager.checkUndyingArmy(false)) {
                    if (this.entity instanceof Player) {
                        PacketUtils.sendTitle((Player)this.entity, ChatColor.RED + "YOU DIED!", ChatColor.GRAY + "You took " + ChatColor.RED + Math.round(damageValue) + ChatColor.GRAY + " fall damage and died.", 0, 40, 0);
                    }
                    this.health = 0;
                    this.die(attacker);
                } else {
                    this.health = (int)((float)this.health - damageValue);
                    this.playHurtAnimation(this.entity, attacker);
                }
                for (OrderOfEviscerate orderOfEviscerate : new CooldownFilter<RegularCooldown>(attacker, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(OrderOfEviscerate.class).collect(Collectors.toList())) {
                    orderOfEviscerate.addAndCheckDamageThreshold(damageValue, attacker);
                }
                this.addAbsorbed(Math.abs(damageValue * (float)this.spec.getDamageResistance() / 100.0f));
            }
            this.cancelHealingPowerUp();
            return Optional.empty();
        }
        if (!ignoreReduction) {
            damageValue = (float)((double)damageValue * this.getFlagDamageMultiplier());
            if (!HammerOfLight.isStandingInHammer(attacker, this)) {
                for (AbstractCooldown<?> abstractCooldown : this.getCooldownManager().getCooldownsDistinct()) {
                    damageValue = abstractCooldown.modifyDamageBeforeInterveneFromSelf(event, damageValue);
                }
                for (AbstractCooldown<?> abstractCooldown : attacker.getCooldownManager().getCooldownsDistinct()) {
                    damageValue = abstractCooldown.modifyDamageBeforeInterveneFromAttacker(event, damageValue);
                }
            }
        }
        float damageHealValueBeforeInterveneReduction = damageValue;
        Optional<RegularCooldown> optionalInterveneCooldown = new CooldownFilter<RegularCooldown>(this, RegularCooldown.class).filterCooldownClass(Intervene.class).filter(regularCooldown -> regularCooldown.getFrom() != this).findFirst();
        if (optionalInterveneCooldown.isPresent() && optionalInterveneCooldown.get().getTicksLeft() > 0 && !HammerOfLight.isStandingInHammer(attacker, this) && this.isEnemy(attacker)) {
            Intervene intervene = (Intervene)optionalInterveneCooldown.get().getCooldownObject();
            WarlordsPlayer intervenedBy = optionalInterveneCooldown.get().getFrom();
            damageValue = (float)((double)damageValue * 0.5);
            intervenedBy.addAbsorbed(damageValue);
            intervenedBy.setRegenTimer(10);
            intervene.addDamagePrevented(damageValue);
            if (intervene.getDamagePrevented() >= intervene.getMaxDamagePrevented() / 2.0f) {
                new CooldownFilter<RegularCooldown>(intervenedBy, RegularCooldown.class).filterCooldownObject(intervene).findFirst().ifPresent(regularCooldown -> regularCooldown.setTicksLeft(0));
                optionalInterveneCooldown.get().setTicksLeft(0);
                float remainingVeneDamage = intervene.getMaxDamagePrevented() / 2.0f - (intervene.getDamagePrevented() - damageValue);
                intervenedBy.addDamageInstance(attacker, "Intervene", remainingVeneDamage, remainingVeneDamage, isCrit ? 100 : -1, 100, true);
                float overVeneDamage = intervene.getDamagePrevented() - intervene.getMaxDamagePrevented() / 2.0f;
                this.addDamageInstance(attacker, ability, overVeneDamage, overVeneDamage, isCrit ? 100 : -1, 100, true);
            } else {
                intervenedBy.addDamageInstance(attacker, "Intervene", damageValue, damageValue, isCrit ? 100 : -1, 100, false);
            }
            Location loc = this.getLocation();
            Utils.playGlobalSound(loc, "warrior.intervene.block", 2.0f, 1.0f);
            this.playHitSound(attacker);
            this.entity.playEffect(EntityEffect.HURT);
            intervenedBy.getEntity().playEffect(EntityEffect.HURT);
            EffectUtils.playParticleLinkAnimation(this.getLocation(), intervenedBy.getLocation(), 255, 0, 0, 2);
            this.removeHorse();
            intervenedBy.removeHorse();
            for (AbstractCooldown<?> abstractCooldown : attacker.getCooldownManager().getCooldownsDistinct()) {
                abstractCooldown.onInterveneFromAttacker(event, damageValue);
            }
        } else {
            if (!ignoreReduction && !HammerOfLight.isStandingInHammer(attacker, this)) {
                for (AbstractCooldown<?> abstractCooldown : this.getCooldownManager().getCooldownsDistinct()) {
                    damageValue = abstractCooldown.modifyDamageAfterInterveneFromSelf(event, damageValue);
                }
                for (AbstractCooldown<?> abstractCooldown : attacker.getCooldownManager().getCooldownsDistinct()) {
                    damageValue = abstractCooldown.modifyDamageAfterInterveneFromAttacker(event, damageValue);
                }
            }
            float damageHealValueBeforeShieldReduction = damageValue;
            List arcaneShields = new CooldownFilter<RegularCooldown>(this, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(ArcaneShield.class).collect(Collectors.toList());
            if (!arcaneShields.isEmpty() && this.isEnemy(attacker) && !HammerOfLight.isStandingInHammer(attacker, this)) {
                ArcaneShield arcaneShield = (ArcaneShield)arcaneShields.get(0);
                arcaneShield.addShieldHealth(-damageValue);
                if (arcaneShield.getShieldHealth() < 0.0f) {
                    if (this.entity instanceof Player) {
                        ((CraftPlayer)this.entity).getHandle().setAbsorptionHearts(0.0f);
                    }
                    this.cooldownManager.removeCooldownByObject(arcaneShield);
                    this.addDamageInstance(new WarlordsDamageHealingEvent(this, attacker, ability, -arcaneShield.getShieldHealth(), -arcaneShield.getShieldHealth(), isCrit ? 100 : -1, 1, false, true, true));
                    this.addAbsorbed(-arcaneShield.getShieldHealth());
                    this.doOnStaticAbility(ArcaneShield.class, ArcaneShield::addTimesBroken);
                    return Optional.empty();
                }
                if (this.entity instanceof Player) {
                    ((CraftPlayer)this.entity).getHandle().setAbsorptionHearts((float)((double)arcaneShield.getShieldHealth() / ((double)this.maxHealth * 0.5) * 20.0));
                }
                if (isMeleeHit) {
                    this.sendMessage(RECEIVE_ARROW_RED + ChatColor.GRAY + " You absorbed " + attacker.getName() + "'s melee " + ChatColor.GRAY + "hit.");
                    attacker.sendMessage(GIVE_ARROW_GREEN + ChatColor.GRAY + " Your melee hit was absorbed by " + this.name);
                } else {
                    this.sendMessage(RECEIVE_ARROW_RED + ChatColor.GRAY + " You absorbed " + attacker.getName() + "'s " + ability + " " + ChatColor.GRAY + "hit.");
                    attacker.sendMessage(GIVE_ARROW_GREEN + ChatColor.GRAY + " Your " + ability + " was absorbed by " + this.name + ChatColor.GRAY + ".");
                }
                this.addAbsorbed(Math.abs(damageHealValueBeforeAllReduction));
                for (AbstractCooldown<?> abstractCooldown : this.getCooldownManager().getCooldownsDistinct()) {
                    abstractCooldown.onShieldFromSelf(event, damageValue, isCrit);
                }
                for (AbstractCooldown<?> abstractCooldown : attacker.getCooldownManager().getCooldownsDistinct()) {
                    abstractCooldown.onShieldFromAttacker(event, damageValue, isCrit);
                }
                this.playHurtAnimation(this.entity, attacker);
                if (!isMeleeHit) {
                    this.playHitSound(attacker);
                }
                this.removeHorse();
                finalEvent = new WarlordsDamageHealingFinalEvent(this, attacker, ability, initialHealth, damageHealValueBeforeAllReduction, damageHealValueBeforeInterveneReduction, damageHealValueBeforeShieldReduction, damageValue, critChance, critMultiplier, isCrit, true);
            } else {
                boolean debt = this.getCooldownManager().hasCooldownFromName("Spirits Respite");
                if (this.isEnemy(attacker)) {
                    this.hitBy.put(attacker, 10);
                    this.cancelHealingPowerUp();
                    this.removeHorse();
                    this.sendDamageMessage(attacker, this, ability, damageValue, isCrit, isMeleeHit);
                    float finalDamageValue = damageValue;
                    this.doOnStaticAbility(SoulShackle.class, soulShackle -> soulShackle.addToShacklePool(finalDamageValue));
                    this.doOnStaticAbility(Repentance.class, repentance -> repentance.addToPool(finalDamageValue));
                    for (AbstractCooldown<?> abstractCooldown : this.getCooldownManager().getCooldownsDistinct()) {
                        abstractCooldown.onDamageFromSelf(event, damageValue, isCrit);
                    }
                    for (AbstractCooldown<?> abstractCooldown : attacker.getCooldownManager().getCooldownsDistinct()) {
                        abstractCooldown.onDamageFromAttacker(event, damageValue, isCrit);
                    }
                }
                this.regenTimer = 10;
                this.updateJimmyHealth();
                if (!debt && this.takeDamage) {
                    this.health -= Math.round(damageValue);
                }
                attacker.addDamage(damageValue, FlagHolder.isPlayerHolderFlag(this));
                this.playHurtAnimation(this.entity, attacker);
                this.recordDamage.add(Float.valueOf(damageValue));
                finalEvent = new WarlordsDamageHealingFinalEvent(this, attacker, ability, initialHealth, damageHealValueBeforeAllReduction, damageHealValueBeforeInterveneReduction, damageHealValueBeforeShieldReduction, damageValue, critChance, critMultiplier, isCrit, true);
                if (this.health <= 0 && !this.cooldownManager.checkUndyingArmy(false)) {
                    if (attacker.entity instanceof Player) {
                        ((Player)attacker.entity).playSound(attacker.getLocation(), Sound.ORB_PICKUP, 500.0f, 1.0f);
                        ((Player)attacker.entity).playSound(attacker.getLocation(), Sound.ORB_PICKUP, 500.0f, 0.5f);
                    }
                    attacker.addKill();
                    attacker.sendMessage(ChatColor.GRAY + "You killed " + this.getColoredName());
                    this.sendMessage(ChatColor.GRAY + "You were killed by " + attacker.getColoredName());
                    this.gameState.getGame().forEachOnlinePlayer((p, t2) -> {
                        if (p != this.entity && p != attacker.entity) {
                            p.sendMessage(this.getColoredName() + ChatColor.GRAY + " was killed by " + attacker.getColoredName());
                        }
                    });
                    for (WarlordsPlayer enemy : PlayerFilter.playingGame(this.game).enemiesOf(this).stream().collect(Collectors.toList())) {
                        for (AbstractCooldown<?> abstractCooldown : enemy.getCooldownManager().getCooldownsDistinct()) {
                            abstractCooldown.onDeathFromEnemies(event, damageValue, isCrit, enemy == attacker);
                        }
                    }
                    if (this.entity instanceof Player) {
                        PacketUtils.sendTitle((Player)this.entity, ChatColor.RED + "YOU DIED!", ChatColor.GRAY + attacker.getName() + " killed you.", 0, 40, 0);
                    }
                    this.die(attacker);
                } else if (!isMeleeHit && this != attacker && damageValue != 0.0f) {
                    this.playHitSound(attacker);
                }
            }
        }
        for (AbstractCooldown<?> abstractCooldown : this.getCooldownManager().getCooldownsDistinct()) {
            abstractCooldown.onEndFromSelf(event, damageValue, isCrit);
        }
        for (AbstractCooldown<?> abstractCooldown : attacker.getCooldownManager().getCooldownsDistinct()) {
            abstractCooldown.onEndFromAttacker(event, damageValue, isCrit);
        }
        this.getCooldownManager().getCooldowns().removeAll(new CooldownFilter<DamageHealCompleteCooldown>(attacker, DamageHealCompleteCooldown.class).stream().collect(Collectors.toList()));
        attacker.getCooldownManager().getCooldowns().removeAll(new CooldownFilter<DamageHealCompleteCooldown>(attacker, DamageHealCompleteCooldown.class).stream().collect(Collectors.toList()));
        return Optional.ofNullable(finalEvent);
    }

    public Optional<WarlordsDamageHealingFinalEvent> addHealingInstance(WarlordsPlayer attacker, String ability, float min2, float max, int critChance, int critMultiplier, boolean ignoreReduction, boolean isLastStandFromShield) {
        return this.addHealingDamageInstance(new WarlordsDamageHealingEvent(this, attacker, ability, min2, max, critChance, critMultiplier, ignoreReduction, isLastStandFromShield, false));
    }

    private Optional<WarlordsDamageHealingFinalEvent> addHealingInstance(WarlordsDamageHealingEvent event) {
        WarlordsPlayer attacker = event.getAttacker();
        String ability = event.getAbility();
        float min2 = event.getMin();
        float max = event.getMax();
        int critChance = event.getCritChance();
        int critMultiplier = event.getCritMultiplier();
        boolean ignoreReduction = event.isIgnoreReduction();
        boolean isLastStandFromShield = event.isIsLastStandFromShield();
        boolean isMeleeHit = ability.isEmpty();
        WarlordsDamageHealingFinalEvent finalEvent = null;
        if (this.dead && !this.cooldownManager.checkUndyingArmy(false) || this.getGameState() != this.getGame().getState()) {
            return Optional.empty();
        }
        int initialHealth = this.health;
        float healValue = (int)(Math.random() * (double)(max - min2) + (double)min2);
        int crit = (int)(Math.random() * 100.0);
        boolean isCrit = false;
        if (crit <= critChance && attacker.canCrit) {
            isCrit = true;
            healValue *= (float)critMultiplier / 100.0f;
        }
        float healValueBeforeReduction = healValue;
        for (AbstractCooldown<?> abstractCooldown : this.getCooldownManager().getCooldownsDistinct()) {
            if (!abstractCooldown.isHealing()) continue;
            healValue = abstractCooldown.doBeforeHealFromSelf(event, healValue);
        }
        if (this == attacker) {
            if ((float)this.health + healValue > (float)this.maxHealth) {
                healValue = this.maxHealth - this.health;
            }
            if (healValue < 0.0f) {
                return Optional.empty();
            }
            if (healValue != 0.0f) {
                this.sendHealingMessage(this, healValue, ability, isCrit, isLastStandFromShield, false);
                this.health = (int)((float)this.health + healValue);
                this.addHealing(healValue, FlagHolder.isPlayerHolderFlag(this));
                if (!(isMeleeHit || ability.equals("Healing Rain") || ability.equals("Blood Lust"))) {
                    this.playHitSound(attacker);
                }
            }
        } else if (this.isTeammate(attacker)) {
            boolean isOverheal;
            int maxHealth = this.maxHealth;
            if (ability.equals("Water Bolt") || ability.equals("Water Breath") || ability.equals("Healing Rain")) {
                maxHealth = (int)((double)maxHealth * 1.1);
            }
            if ((float)this.health + healValue > (float)maxHealth) {
                healValue = maxHealth - this.health;
            }
            if (healValue < 0.0f) {
                return Optional.empty();
            }
            boolean bl = isOverheal = maxHealth > this.maxHealth && healValue + (float)this.health > (float)this.maxHealth;
            if (healValue != 0.0f) {
                this.sendHealingMessage(attacker, this, healValue, ability, isCrit, isLastStandFromShield, isOverheal);
            }
            this.health = (int)((float)this.health + healValue);
            attacker.addHealing(healValue, FlagHolder.isPlayerHolderFlag(this));
            if (!isMeleeHit && !ability.equals("Healing Rain")) {
                this.playHitSound(attacker);
            }
        }
        finalEvent = new WarlordsDamageHealingFinalEvent(this, attacker, ability, initialHealth, healValueBeforeReduction, healValueBeforeReduction, healValueBeforeReduction, healValue, critChance, critMultiplier, isCrit, false);
        return Optional.of(finalEvent);
    }

    private void sendHealingMessage(@Nonnull WarlordsPlayer player, float healValue, String ability, boolean isCrit, boolean isLastStandFromShield, boolean isOverHeal) {
        StringBuilder ownFeed = new StringBuilder();
        ownFeed.append(GIVE_ARROW_GREEN).append(ChatColor.GRAY).append(" Your ").append(ability);
        if (isCrit) {
            ownFeed.append(" critically");
        }
        ownFeed.append(" healed you for ").append(ChatColor.GREEN);
        if (isCrit) {
            ownFeed.append("\u00a7l");
        }
        ownFeed.append(Math.round(healValue));
        ownFeed.append(isCrit ? "!" : "");
        if (isLastStandFromShield) {
            ownFeed.append(" Absorbed!");
        }
        ownFeed.append(ChatColor.GRAY).append(" health.");
        player.sendMessage(ownFeed.toString());
    }

    private void sendHealingMessage(@Nonnull WarlordsPlayer sender, @Nonnull WarlordsPlayer receiver, float healValue, String ability, boolean isCrit, boolean isLastStandFromShield, boolean isOverHeal) {
        StringBuilder ownFeed = new StringBuilder();
        ownFeed.append(GIVE_ARROW_GREEN).append(ChatColor.GRAY).append(" Your ").append(ability);
        if (isCrit) {
            ownFeed.append(" critically");
        }
        if (isOverHeal) {
            ownFeed.append(" overhealed ").append(this.name).append(" for ").append(ChatColor.GREEN);
        } else {
            ownFeed.append(" healed ").append(this.name).append(" for ").append(ChatColor.GREEN);
        }
        if (isCrit) {
            ownFeed.append("\u00a7l");
        }
        ownFeed.append(Math.round(healValue));
        ownFeed.append(isCrit ? "!" : "");
        if (isLastStandFromShield) {
            ownFeed.append(" Absorbed!");
        }
        ownFeed.append(ChatColor.GRAY).append(" health.");
        sender.sendMessage(ownFeed.toString());
        StringBuilder allyFeed = new StringBuilder();
        allyFeed.append(RECEIVE_ARROW_GREEN).append(ChatColor.GRAY).append(" ").append(sender.getName()).append("'s ").append(ability);
        if (isCrit) {
            allyFeed.append(" critically");
        }
        if (isOverHeal) {
            allyFeed.append(" overhealed you for ").append(ChatColor.GREEN);
        } else {
            allyFeed.append(" healed you for ").append(ChatColor.GREEN);
        }
        if (isCrit) {
            allyFeed.append("\u00a7l");
        }
        allyFeed.append(Math.round(healValue));
        allyFeed.append(isCrit ? "!" : "");
        if (isLastStandFromShield) {
            allyFeed.append(" Absorbed!");
        }
        allyFeed.append(ChatColor.GRAY).append(" health.");
        receiver.sendMessage(allyFeed.toString());
    }

    private void sendDamageMessage(@Nonnull WarlordsPlayer sender, @Nonnull WarlordsPlayer receiver, String ability, float damageValue, boolean isCrit, boolean isMeleeHit) {
        StringBuilder enemyFeed = new StringBuilder();
        enemyFeed.append(RECEIVE_ARROW_RED).append(ChatColor.GRAY).append(" ").append(sender.getName());
        if (!isMeleeHit) {
            enemyFeed.append("'s ").append(ability);
        }
        enemyFeed.append(" hit you for ").append(ChatColor.RED);
        if (isCrit) {
            enemyFeed.append("\u00a7l");
        }
        enemyFeed.append(Math.round(damageValue));
        if (isCrit) {
            enemyFeed.append("! ").append(ChatColor.GRAY).append("critical");
        }
        if (isMeleeHit) {
            enemyFeed.append(ChatColor.GRAY).append(" melee");
        }
        enemyFeed.append(ChatColor.GRAY).append(" damage.");
        receiver.sendMessage(enemyFeed.toString());
        StringBuilder ownFeed = new StringBuilder();
        ownFeed.append(GIVE_ARROW_GREEN).append(ChatColor.GRAY).append(" ");
        if (isMeleeHit) {
            ownFeed.append("You hit ");
        } else {
            ownFeed.append("Your ").append(ability).append(" hit ");
        }
        ownFeed.append(this.name);
        ownFeed.append(" for ").append(ChatColor.RED);
        if (isCrit) {
            ownFeed.append("\u00a7l");
        }
        ownFeed.append(Math.round(damageValue));
        if (isCrit) {
            ownFeed.append("! ").append(ChatColor.GRAY).append("critical");
        }
        if (isMeleeHit) {
            ownFeed.append(ChatColor.GRAY).append(" melee");
        }
        ownFeed.append(ChatColor.GRAY).append(" damage.");
        sender.sendMessage(ownFeed.toString());
    }

    private void playHitSound(WarlordsPlayer attacker) {
        if (attacker.entity instanceof Player) {
            ((Player)attacker.entity).playSound(attacker.getLocation(), Sound.ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    private void playHurtAnimation(LivingEntity entity, WarlordsPlayer hurtPlayer) {
        entity.playEffect(EntityEffect.HURT);
        for (Player player1 : hurtPlayer.getWorld().getPlayers()) {
            player1.playSound(entity.getLocation(), Sound.HURT_FLESH, 2.0f, 1.0f);
        }
    }

    public void cancelHealingPowerUp() {
        if (this.getCooldownManager().hasCooldown(HealingPowerup.class)) {
            this.sendMessage(ChatColor.GOLD + "Your \u00a7a\u00a7lHEALING \u00a76powerup has worn off.");
            this.getCooldownManager().removeCooldown(HealingPowerup.class);
        }
    }

    public void removeHorse() {
        if (this.entity.getVehicle() != null) {
            this.entity.getVehicle().remove();
        }
    }

    public void die(@Nullable WarlordsPlayer attacker) {
        this.dead = true;
        this.removeHorse();
        this.getLocation(this.deathLocation);
        this.showDeathAnimation();
        this.cooldownManager.clearCooldowns();
        if (attacker != null) {
            if (attacker != this) {
                this.hitBy.putAll(attacker.getHealedBy());
            }
            this.hitBy.remove(attacker);
        }
        this.addDeath();
        FlagHolder.dropFlagForPlayer(this);
        if (this.entity instanceof Player) {
            Player player = (Player)this.entity;
            player.setGameMode(GameMode.SPECTATOR);
            ((CraftPlayer)this.entity).getHandle().setAbsorptionHearts(0.0f);
            ItemStack item = ((CraftPlayer)this.entity).getInventory().getItem(0);
            if (item != null) {
                item.removeEnchantment(Enchantment.OXYGEN);
            }
            player.getInventory().remove(UndyingArmy.BONE);
        }
        Bukkit.getPluginManager().callEvent((Event)new WarlordsDeathEvent(this, attacker));
        this.hitBy.forEach((assisted, value) -> {
            if (attacker == assisted || attacker == this) {
                assisted.sendMessage(ChatColor.GRAY + "You assisted in killing " + this.getColoredName());
            } else if (attacker != null) {
                assisted.sendMessage(ChatColor.GRAY + "You assisted " + attacker.getColoredName() + ChatColor.GRAY + " in killing " + this.getColoredName());
            }
            assisted.addAssist();
        });
        this.hitBy.clear();
        this.regenTimer = 0;
        this.heal();
    }

    private void checkForAchievementsDamage(WarlordsPlayer attacker) {
        ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.BLITZKRIEG);
        ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.SNIPE_SHOT);
        ChallengeAchievements.checkForAchievement(this, ChallengeAchievements.DUCK_TANK);
        ChallengeAchievements.checkForAchievement(this, ChallengeAchievements.SPLIT_SECOND);
        ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.REVENGE_BLAST);
        if (this.hasFlag()) {
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.ASSASSINATE);
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.SILENCE_PEON);
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.ORBIFICATOR);
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.HOUR_OF_RECKONING);
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.TALENT_SHREDDER);
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.PERSISTENT_THREAT);
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.WHERE_ARE_YOU_GOING);
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.EXTENDED_COMBAT);
        }
        ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.ROADBLOCK);
    }

    private void checkForAchievementsHealing(WarlordsPlayer attacker) {
        ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.LYCHEESIS);
        if (this.hasFlag()) {
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.REJUVENATION);
            ChallengeAchievements.checkForAchievement(attacker, ChallengeAchievements.CLERICAL_PRODIGY);
        }
    }

    public Zombie spawnJimmy(@Nonnull Location loc, @Nullable EntityEquipment inv) {
        Zombie jimmy = (Zombie)loc.getWorld().spawn(loc, Zombie.class);
        jimmy.setBaby(false);
        jimmy.setCustomNameVisible(true);
        jimmy.setCustomName(this.getSpec().getClassNameShortWithBrackets() + " " + this.getColoredName() + " " + ChatColor.RED + this.health + "\u2764");
        jimmy.setMetadata("WARLORDS_PLAYER", (MetadataValue)new FixedMetadataValue((Plugin)Warlords.getInstance(), (Object)this));
        ((EntityLiving)((CraftEntity)jimmy).getHandle()).getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(0.0);
        ((EntityLiving)((CraftEntity)jimmy).getHandle()).getAttributeInstance(GenericAttributes.FOLLOW_RANGE).setValue(0.0);
        net.minecraft.server.v1_8_R3.Entity nmsEn = ((CraftEntity)jimmy).getHandle();
        NBTTagCompound compound = new NBTTagCompound();
        nmsEn.c(compound);
        compound.setByte("NoAI", (byte)1);
        nmsEn.f(compound);
        if (inv != null) {
            jimmy.getEquipment().setBoots(inv.getBoots());
            jimmy.getEquipment().setLeggings(inv.getLeggings());
            jimmy.getEquipment().setChestplate(inv.getChestplate());
            jimmy.getEquipment().setHelmet(inv.getHelmet());
            jimmy.getEquipment().setItemInHand(inv.getItemInHand());
        } else {
            jimmy.getEquipment().setHelmet(new ItemStack(Material.DIAMOND_HELMET));
        }
        if (this.dead) {
            jimmy.remove();
        }
        return jimmy;
    }

    public void updateJimmyHealth() {
        if (this.getEntity() instanceof Zombie) {
            if (this.isDead()) {
                this.getEntity().setCustomName("");
            } else {
                String oldName = this.getEntity().getCustomName();
                String newName = oldName.substring(0, oldName.lastIndexOf(32) + 1) + ChatColor.RED + this.getHealth() + "\u2764";
                this.getEntity().setCustomName(newName);
            }
        }
    }

    public <T extends AbstractAbility> void doOnStaticAbility(Class<T> abilityClass, Consumer<T> consumer) {
        for (AbstractAbility ability : this.spec.getAbilities()) {
            if (!ability.getClass().equals(abilityClass)) continue;
            consumer.accept(abilityClass.cast(ability));
        }
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    private void setWalkSpeed(float walkspeed) {
        this.walkspeed = walkspeed;
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player != null) {
            player.setWalkSpeed(this.walkspeed);
        }
    }

    public void displayActionBar() {
        StringBuilder actionBarMessage = new StringBuilder(ChatColor.GOLD + "\u00a7lHP: ");
        float healthRatio = (float)this.health / (float)this.maxHealth;
        if ((double)healthRatio >= 0.75) {
            actionBarMessage.append(ChatColor.DARK_GREEN);
        } else if ((double)healthRatio >= 0.25) {
            actionBarMessage.append(ChatColor.YELLOW);
        } else {
            actionBarMessage.append(ChatColor.RED);
        }
        actionBarMessage.append("\u00a7l").append(this.health).append(ChatColor.GOLD).append("\u00a7l/\u00a7l").append(this.maxHealth).append("    ");
        actionBarMessage.append(this.team.boldColoredPrefix()).append(" TEAM  ");
        for (AbstractCooldown<?> abstractCooldown : this.cooldownManager.getCooldowns()) {
            actionBarMessage.append(abstractCooldown.getNameAbbreviation());
        }
        if (this.entity instanceof Player) {
            PacketUtils.sendActionBar((Player)this.entity, actionBarMessage.toString());
        }
    }

    public void displayFlagActionBar(@Nonnull Player player) {
        if (this.compassTarget != null) {
            PacketUtils.sendActionBar(player, this.compassTarget.getToolbarName(this));
        } else {
            PacketUtils.sendActionBar(player, "");
        }
    }

    public void applySkillBoost(Player player) {
        SkillBoosts selectedBoost = Warlords.getPlayerSettings(Bukkit.getOfflinePlayer((UUID)this.uuid).getUniqueId()).getSkillBoostForClass();
        if (selectedBoost != null) {
            if (this.spec.getWeapon().getClass() == selectedBoost.ability) {
                this.spec.getWeapon().boostSkill(selectedBoost, this.spec);
                this.spec.getWeapon().updateDescription(player);
            } else if (this.spec.getRed().getClass() == selectedBoost.ability) {
                this.spec.getRed().boostSkill(selectedBoost, this.spec);
                this.spec.getRed().updateDescription(player);
            } else if (this.spec.getPurple().getClass() == selectedBoost.ability) {
                this.spec.getPurple().boostSkill(selectedBoost, this.spec);
                this.spec.getPurple().updateDescription(player);
            } else if (this.spec.getBlue().getClass() == selectedBoost.ability) {
                this.spec.getBlue().boostSkill(selectedBoost, this.spec);
                this.spec.getBlue().updateDescription(player);
            } else if (this.spec.getOrange().getClass() == selectedBoost.ability) {
                this.spec.getOrange().boostSkill(selectedBoost, this.spec);
                this.spec.getOrange().updateDescription(player);
            }
        }
    }

    public void updateArmor() {
        if (!(this.entity instanceof Player)) {
            return;
        }
        Player player = (Player)this.entity;
        if (!this.cooldownManager.hasCooldownFromName("Cloaked") || this.hasFlag()) {
            ArmorManager.resetArmor(player, this.getSpecClass(), this.getTeam());
            this.getEntity().removePotionEffect(PotionEffectType.INVISIBILITY);
            for (Player otherPlayer : player.getWorld().getPlayers()) {
                otherPlayer.showPlayer(player);
            }
        }
        if (this.hasFlag()) {
            ItemStack item = new ItemStack(Material.BANNER);
            BannerMeta banner = (BannerMeta)item.getItemMeta();
            banner.setBaseColor(this.getTeam() == Team.RED ? DyeColor.BLUE : DyeColor.RED);
            banner.addPattern(new Pattern(DyeColor.BLACK, PatternType.SKULL));
            banner.addPattern(new Pattern(DyeColor.BLACK, PatternType.TRIANGLES_TOP));
            item.setItemMeta((ItemMeta)banner);
            player.getInventory().setHelmet(item);
        }
    }

    public void assignItemLore(Player player) {
        ItemStack weapon = new ItemStack(this.weapon.item);
        ItemMeta weaponMeta = weapon.getItemMeta();
        weaponMeta.setDisplayName("\u00a7cWarlord's Felflame of the " + this.spec.getWeapon().getName());
        ArrayList<String> weaponLore = new ArrayList<String>();
        weaponLore.add("\u00a77Damage: \u00a7c132 \u00a77- \u00a7c179");
        weaponLore.add("\u00a77Crit Chance: \u00a7c25%");
        weaponLore.add("\u00a77Crit Multiplier: \u00a7c200%");
        weaponLore.add("");
        String classNamePath = this.spec.getClass().getGenericSuperclass().getTypeName();
        weaponLore.add("\u00a7a" + classNamePath.substring(classNamePath.indexOf("Abstract") + 8) + " (" + this.spec.getClass().getSimpleName() + "):");
        weaponLore.add("\u00a7aIncreases the damage you");
        weaponLore.add("\u00a7adeal with " + this.spec.getWeapon().getName() + " by \u00a7c20%");
        weaponLore.add("");
        weaponLore.add("\u00a77Health: \u00a7a+800");
        weaponLore.add("\u00a77Max Energy: \u00a7a+35");
        weaponLore.add("\u00a77Cooldown Reduction: \u00a7a+13%");
        weaponLore.add("\u00a77Speed: \u00a7a+13%");
        weaponLore.add("");
        weaponLore.add("\u00a76Skill Boost Unlocked");
        weaponLore.add("\u00a73Crafted");
        weaponLore.add("\u00a7dVoid Forged [4/4]");
        weaponLore.add("\u00a7aEQUIPPED");
        weaponLore.add("\u00a7bBOUND");
        weaponMeta.setLore(weaponLore);
        weapon.setItemMeta(weaponMeta);
        weaponMeta.spigot().setUnbreakable(true);
        player.getInventory().setItem(0, weapon);
        this.weaponLeftClick(player);
        this.updateRedItem(player);
        this.updatePurpleItem(player);
        this.updateBlueItem(player);
        this.updateOrangeItem(player);
        this.updateHorseItem(player);
        ItemStack compass = new ItemStack(Material.COMPASS);
        ItemMeta compassMeta = compass.getItemMeta();
        compassMeta.setDisplayName(ChatColor.GREEN + "Flag Finder");
        compass.setItemMeta(compassMeta);
        compassMeta.spigot().setUnbreakable(true);
        player.getInventory().setItem(8, compass);
    }

    public void weaponLeftClick(Player player) {
        player.getInventory().setItem(0, new ItemBuilder(this.weapon.item).name(ChatColor.GOLD + "Warlord's " + this.weapon.name + " of the " + this.spec.getClass().getSimpleName()).lore(ChatColor.GRAY + "Damage: " + ChatColor.RED + "132 " + ChatColor.GRAY + "- " + ChatColor.RED + "179", ChatColor.GRAY + "Crit Chance: " + ChatColor.RED + "25%", ChatColor.GRAY + "Crit Multiplier: " + ChatColor.RED + "200%", "", ChatColor.GREEN + this.spec.getClassName() + " (" + this.spec.getClass().getSimpleName() + "):", Warlords.getPlayerSettings((UUID)player.getUniqueId()).getSkillBoostForClass().selectedDescription, "", ChatColor.GRAY + "Health: " + ChatColor.GREEN + "+800", ChatColor.GRAY + "Max Energy: " + ChatColor.GREEN + "+35", ChatColor.GRAY + "Cooldown Reduction: " + ChatColor.GREEN + "+13%", ChatColor.GRAY + "Speed: " + ChatColor.GREEN + "+13%", "", ChatColor.GOLD + "Skill Boost Unlocked", ChatColor.DARK_AQUA + "Crafted", ChatColor.LIGHT_PURPLE + "Void Forged [4/4]", ChatColor.GREEN + "EQUIPPED", ChatColor.AQUA + "BOUND", "", ChatColor.YELLOW + ChatColor.BOLD.toString() + "RIGHT-CLICK " + ChatColor.GREEN + "to view " + ChatColor.YELLOW + this.spec.getWeapon().getName(), ChatColor.GREEN + "stats!").unbreakable().flags(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE).get());
    }

    public void weaponRightClick(Player player) {
        player.getInventory().setItem(0, new ItemBuilder(this.weapon.item).name(ChatColor.GREEN + this.spec.getWeapon().getName() + ChatColor.GRAY + " - " + ChatColor.YELLOW + "Right-Click!").lore(ChatColor.GRAY + "Energy Cost: " + ChatColor.YELLOW + this.spec.getWeapon().getEnergyCost(), ChatColor.GRAY + "Crit Chance: " + ChatColor.RED + this.spec.getWeapon().getCritChance() + "%", ChatColor.GRAY + "Crit Multiplier: " + ChatColor.RED + this.spec.getWeapon().getCritMultiplier() + "%", "", this.spec.getWeapon().getDescription(), "", ChatColor.YELLOW + ChatColor.BOLD.toString() + "LEFT-CLICK " + ChatColor.GREEN + "to view weapon stats!").unbreakable().flags(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE).get());
    }

    public void updateItem(Player player, int slot, AbstractAbility ability, ItemStack item) {
        if (ability.getCurrentCooldown() > 0.0f) {
            ItemBuilder cooldown = new ItemBuilder(Material.INK_SACK, ability.getCurrentCooldownItem(), 8).flags(ItemFlag.HIDE_ENCHANTS);
            if (!ability.getSecondaryAbilities().isEmpty()) {
                cooldown.enchant(Enchantment.OXYGEN, 1);
            }
            player.getInventory().setItem(slot, cooldown.get());
        } else {
            player.getInventory().setItem(slot, ability.getItem(item));
        }
    }

    public void updateRedItem() {
        if (this.entity instanceof Player) {
            this.updateRedItem((Player)this.entity);
        }
    }

    public void updateRedItem(Player player) {
        this.updateItem(player, 1, this.spec.getRed(), new ItemStack(Material.INK_SACK, 1, 1));
    }

    public void updatePurpleItem() {
        if (this.entity instanceof Player) {
            this.updatePurpleItem((Player)this.entity);
        }
    }

    public void updatePurpleItem(Player player) {
        this.updateItem(player, 2, this.spec.getPurple(), new ItemStack(Material.GLOWSTONE_DUST));
    }

    public void updateBlueItem() {
        if (this.entity instanceof Player) {
            this.updateBlueItem((Player)this.entity);
        }
    }

    public void updateBlueItem(Player player) {
        this.updateItem(player, 3, this.spec.getBlue(), new ItemStack(Material.INK_SACK, 1, 10));
    }

    public void updateOrangeItem() {
        if (this.entity instanceof Player) {
            this.updateOrangeItem((Player)this.entity);
        }
    }

    public void updateOrangeItem(Player player) {
        this.updateItem(player, 4, this.spec.getOrange(), new ItemStack(Material.INK_SACK, 1, 14));
    }

    public void updateHorseItem() {
        if (this.entity instanceof Player) {
            this.updateHorseItem((Player)this.entity);
        }
    }

    public void updateHorseItem(Player player) {
        if (this.horseCooldown > 0.0f) {
            ItemStack cooldown = new ItemStack(Material.IRON_BARDING, (int)this.horseCooldown + 1);
            player.getInventory().setItem(7, cooldown);
        } else {
            ItemStack horse = new ItemStack(Material.GOLD_BARDING);
            ItemMeta horseMeta = horse.getItemMeta();
            horseMeta.setDisplayName(ChatColor.GREEN + "Mount " + ChatColor.GRAY + "- \u00a7eRight-Click!");
            ArrayList<String> horseLore = new ArrayList<String>();
            horseLore.add(ChatColor.GRAY + "Cooldown: \u00a7b15 seconds");
            horseLore.add("");
            horseLore.add(ChatColor.GRAY + "Call your steed to assists you in battle");
            horseMeta.setLore(horseLore);
            horse.setItemMeta(horseMeta);
            horseMeta.spigot().setUnbreakable(true);
            player.getInventory().setItem(7, horse);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public AbstractPlayerClass getSpec() {
        return this.spec;
    }

    public void setSpec(AbstractPlayerClass spec, SkillBoosts skillBoost) {
        Warlords.getPlayerSettings(this.uuid).setSelectedSpec(Specializations.getSpecFromName(spec.getName()));
        Warlords.getPlayerSettings(this.uuid).setSkillBoostForSelectedSpec(skillBoost);
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        this.spec = spec;
        this.specClass = Warlords.getPlayerSettings(this.uuid).getSelectedSpec();
        this.weapon = Weapons.getSelected((OfflinePlayer)player, this.specClass);
        this.health = this.maxHealth = (int)((double)this.spec.getMaxHealth() * (this.gameState.getGame().getAddons().contains((Object)GameAddon.COOLDOWN_MODE) ? 1.5 : 1.0));
        this.energy = this.maxEnergy = (float)this.spec.getMaxEnergy();
        ArmorManager.resetArmor(player, this.specClass, this.team);
        this.applySkillBoost(player);
        this.spec.getWeapon().updateDescription(player);
        this.spec.getRed().updateDescription(player);
        this.spec.getPurple().updateDescription(player);
        this.spec.getBlue().updateDescription(player);
        this.spec.getOrange().updateDescription(player);
        this.assignItemLore(Bukkit.getPlayer((UUID)this.uuid));
        if (DatabaseManager.playerService == null) {
            return;
        }
        DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(player.getUniqueId());
        databasePlayer.getSpec(this.specClass).setSkillBoost(skillBoost);
        DatabaseManager.updatePlayerAsync(databasePlayer);
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(int maxHealth) {
        this.maxHealth = maxHealth;
    }

    public void showDeathAnimation() {
        if (this.entity instanceof Zombie) {
            this.entity.damage(200.0);
        } else {
            Player player = (Player)this.entity;
            Zombie zombie = (Zombie)player.getWorld().spawn(player.getLocation(), Zombie.class);
            zombie.getEquipment().setBoots(player.getInventory().getBoots());
            zombie.getEquipment().setLeggings(player.getInventory().getLeggings());
            zombie.getEquipment().setChestplate(player.getInventory().getChestplate());
            zombie.getEquipment().setHelmet(player.getInventory().getHelmet());
            zombie.getEquipment().setItemInHand(player.getInventory().getItemInHand());
            zombie.damage(2000.0);
        }
    }

    public void heal() {
        this.health = this.maxHealth;
    }

    private void decrementRespawnTimer() {
        if (this.respawnTimer == 1) {
            this.respawn();
        } else if (this.respawnTimer > 0) {
            this.minuteStats.addTotalRespawnTime();
            --this.respawnTimer;
            if (this.respawnTimer <= 11 && this.entity instanceof Player) {
                PacketUtils.sendTitle((Player)this.entity, "", this.team.teamColor() + "Respawning in... " + ChatColor.YELLOW + this.respawnTimer, 0, 40, 0);
            }
        }
    }

    public void respawn() {
        ArrayList<Location> candidates = new ArrayList<Location>();
        double priority = Double.NEGATIVE_INFINITY;
        for (SpawnLocationMarker marker : this.getGame().getMarkers(SpawnLocationMarker.class)) {
            if (candidates.isEmpty()) {
                candidates.add(marker.getLocation());
                priority = marker.getPriority(this);
                continue;
            }
            double newPriority = marker.getPriority(this);
            if (!(newPriority >= priority)) continue;
            if (newPriority > priority) {
                candidates.clear();
                priority = newPriority;
            }
            candidates.add(marker.getLocation());
        }
        Location respawnPoint = !candidates.isEmpty() ? (Location)candidates.get((int)(Math.random() * (double)candidates.size())) : (this.deathLocation != null ? this.deathLocation : this.getLocation());
        WarlordsRespawnEvent event = new WarlordsRespawnEvent(this, respawnPoint);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.entity instanceof Player) {
            PacketUtils.sendTitle((Player)this.entity, "", "", 0, 0, 0);
        }
        this.setRespawnTimer(-1);
        this.setEnergy(this.getMaxEnergy() / 2.0f);
        this.dead = false;
        this.teleport(respawnPoint);
        this.health = this.maxHealth;
        if (this.entity instanceof Player) {
            this.updatePlayer((Player)this.entity);
        } else {
            this.entity = this.spawnJimmy(respawnPoint, this.entity.getEquipment());
        }
    }

    public int getRegenTimer() {
        return this.regenTimer;
    }

    public void setRegenTimer(int regenTimer) {
        this.regenTimer = regenTimer;
    }

    public int getRespawnTimer() {
        return this.respawnTimer;
    }

    public void setRespawnTimer(int respawnTimer) {
        this.respawnTimer = respawnTimer;
    }

    public float getEnergy() {
        return this.energy;
    }

    public void setEnergy(float energy) {
        this.energy = energy;
    }

    public float addEnergy(WarlordsPlayer giver, String ability, float amount) {
        float energyGiven = 0.0f;
        if (this.energy + amount > this.maxEnergy) {
            energyGiven = this.maxEnergy - this.energy;
            this.energy = this.maxEnergy;
        } else if (this.energy + amount > 0.0f) {
            energyGiven = amount;
            this.energy += amount;
        } else {
            this.energy = 1.0f;
        }
        if ((int)amount != 0) {
            if (this == giver) {
                this.sendMessage(GIVE_ARROW_GREEN + ChatColor.GRAY + " Your " + ability + " gave you " + ChatColor.YELLOW + (int)amount + " " + ChatColor.GRAY + "energy.");
            } else {
                this.sendMessage(RECEIVE_ARROW_GREEN + ChatColor.GRAY + " " + giver.getName() + "'s " + ability + " gave you " + ChatColor.YELLOW + (int)amount + " " + ChatColor.GRAY + "energy.");
                giver.sendMessage(GIVE_ARROW_GREEN + ChatColor.GRAY + " Your " + ability + " gave " + this.name + " " + ChatColor.YELLOW + (int)amount + " " + ChatColor.GRAY + "energy.");
            }
        }
        return energyGiven;
    }

    public float subtractEnergy(int amount) {
        float amountSubtracted = 0.0f;
        if (!this.noEnergyConsumption) {
            if (this.energy - (float)(amount = (int)((double)amount * this.energyModifier)) > this.maxEnergy) {
                amountSubtracted = this.maxEnergy - this.energy;
                this.energy = this.maxEnergy;
            } else if (this.energy - (float)amount < 0.0f) {
                amountSubtracted = this.energy;
                this.energy = 0.0f;
            } else {
                amountSubtracted = amount;
                this.energy -= (float)amount;
            }
        }
        return amountSubtracted;
    }

    public void sendMessage(String message) {
        if (this.entity instanceof Player) {
            this.entity.sendMessage(message);
        }
    }

    public void playSound(Location location, Sound sound, float volume, float pitch) {
        if (this.entity instanceof Player) {
            ((Player)this.entity).playSound(location, sound, volume, pitch);
        }
    }

    public void playSound(Location location, String soundString, float volume, float pitch) {
        if (this.entity instanceof Player) {
            ((Player)this.entity).playSound(location, soundString, volume, pitch);
        }
    }

    public boolean onHorse() {
        return this.entity.isInsideVehicle();
    }

    public float getMaxEnergy() {
        return this.maxEnergy;
    }

    public void setMaxEnergy(int maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    public CustomHorse getHorse() {
        return this.horse;
    }

    public void setHorse(CustomHorse horse) {
        this.horse = horse;
    }

    public float getHorseCooldown() {
        return this.horseCooldown;
    }

    public void setHorseCooldown(float horseCooldown) {
        this.horseCooldown = horseCooldown;
    }

    public int getFlagDropCooldown() {
        return this.flagDropCooldown;
    }

    public void setFlagDropCooldown(int flagDropCooldown) {
        this.flagDropCooldown = flagDropCooldown;
    }

    public int getFlagPickCooldown() {
        return this.flagPickCooldown;
    }

    public void setFlagPickCooldown(int flagPickCooldown) {
        this.flagPickCooldown = flagPickCooldown;
    }

    public int getHitCooldown() {
        return this.hitCooldown;
    }

    public void setHitCooldown(int hitCooldown) {
        this.hitCooldown = hitCooldown;
    }

    public void addKill() {
        this.minuteStats.addKill();
    }

    public void addAssist() {
        this.minuteStats.addAssist();
    }

    public LinkedHashMap<WarlordsPlayer, Integer> getHitBy() {
        return this.hitBy;
    }

    public LinkedHashMap<WarlordsPlayer, Integer> getHealedBy() {
        return this.healedBy;
    }

    public void addDeath() {
        this.minuteStats.addDeath();
    }

    public void addDamage(float amount, boolean onCarrier) {
        this.minuteStats.addDamage((long)amount);
        if (onCarrier) {
            this.minuteStats.addDamageOnCarrier((long)amount);
        }
    }

    public void addHealing(float amount, boolean onCarrier) {
        this.minuteStats.addHealing((long)amount);
        if (onCarrier) {
            this.minuteStats.addHealingOnCarrier((long)amount);
        }
    }

    public void addAbsorbed(float amount) {
        this.minuteStats.addAbsorbed((long)amount);
    }

    public String getStatString(String name) {
        StringBuilder stringBuilder = new StringBuilder(ChatColor.AQUA + "Stat Breakdown (" + name + "):");
        List<PlayerStatisticsMinute.Entry> entries = this.minuteStats.getEntries();
        int length = entries.size();
        block16: for (int i = 0; i < length; ++i) {
            PlayerStatisticsMinute.Entry entry = entries.get(length - i - 1);
            stringBuilder.append("\n");
            stringBuilder.append(ChatColor.WHITE + "Minute ").append(i + 1).append(": ").append(ChatColor.GOLD);
            switch (name) {
                case "Kills": {
                    stringBuilder.append(NumberFormat.addCommaAndRound(entry.getKills()));
                    continue block16;
                }
                case "Assists": {
                    stringBuilder.append(NumberFormat.addCommaAndRound(entry.getAssists()));
                    continue block16;
                }
                case "Deaths": {
                    stringBuilder.append(NumberFormat.addCommaAndRound(entry.getDeaths()));
                    continue block16;
                }
                case "Damage": {
                    stringBuilder.append(NumberFormat.addCommaAndRound(entry.getDamage()));
                    continue block16;
                }
                case "Healing": {
                    stringBuilder.append(NumberFormat.addCommaAndRound(entry.getHealing()));
                    continue block16;
                }
                case "Absorbed": {
                    stringBuilder.append(NumberFormat.addCommaAndRound(entry.getAbsorbed()));
                }
            }
        }
        return stringBuilder.toString();
    }

    public void toggleTeamFlagCompass() {
        List<CompassTargetMarker> targets = this.getGame().getMarkers(CompassTargetMarker.class);
        boolean shouldPick = false;
        CompassTargetMarker first = null;
        for (CompassTargetMarker ctm : targets) {
            if (ctm == this.compassTarget) {
                shouldPick = true;
                if (first != null) continue;
                first = ctm;
                continue;
            }
            if (!ctm.isEnabled()) continue;
            if (first == null) {
                first = ctm;
            }
            if (!shouldPick) continue;
            this.compassTarget = ctm;
            return;
        }
        this.compassTarget = first;
    }

    public CalculateSpeed getSpeed() {
        return this.speed;
    }

    public Location getDeathLocation() {
        return this.deathLocation;
    }

    public int getFlagsCaptured() {
        return this.minuteStats.total().getFlagsCaptured();
    }

    public void addFlagCap() {
        this.minuteStats.addFlagCapture();
    }

    public int getFlagsReturned() {
        return this.minuteStats.total().getFlagsReturned();
    }

    public void addFlagReturn() {
        this.minuteStats.addFlagReturned();
    }

    public int getTotalCapsAndReturnsWeighted() {
        PlayerStatisticsMinute.Entry total = this.minuteStats.total();
        return total.getFlagsCaptured() * 5 + total.getFlagsReturned();
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public boolean isAlive() {
        return !this.isDead();
    }

    public void updatePlayerReference(@Nullable Player player) {
        if (player == this.entity) {
            return;
        }
        Location loc = this.getLocation();
        if (player == null) {
            if (this.entity instanceof Player) {
                ((Player)this.entity).getInventory().setHeldItemSlot(0);
                this.entity = this.spawnJimmy(loc, ((Player)this.entity).getEquipment());
            }
        } else {
            if (this.entity instanceof Zombie) {
                this.entity.remove();
            }
            player.teleport(loc);
            this.entity = player;
            this.updatePlayer(player);
        }
    }

    public void updatePlayer(@Nonnull Player player) {
        player.removeMetadata("WARLORDS_PLAYER", (Plugin)Warlords.getInstance());
        player.setMetadata("WARLORDS_PLAYER", (MetadataValue)new FixedMetadataValue((Plugin)Warlords.getInstance(), (Object)this));
        player.setWalkSpeed(this.walkspeed);
        player.setMaxHealth(40.0);
        player.setLevel((int)this.getMaxEnergy());
        player.getInventory().clear();
        this.spec.getWeapon().updateDescription(player);
        this.spec.getRed().updateDescription(player);
        this.spec.getPurple().updateDescription(player);
        this.spec.getBlue().updateDescription(player);
        this.spec.getOrange().updateDescription(player);
        this.applySkillBoost(player);
        player.closeInventory();
        this.assignItemLore(player);
        this.updateArmor();
        this.resetPlayerAddons();
        if (this.isDead()) {
            player.setGameMode(GameMode.SPECTATOR);
        } else {
            player.setGameMode(GameMode.ADVENTURE);
        }
    }

    private void resetPlayerAddons() {
        if (this.getEntity() instanceof Player) {
            Player player = (Player)this.getEntity();
            if (this.getCooldownManager().hasCooldown(Soulbinding.class)) {
                ItemMeta itemMeta = player.getInventory().getItem(0).getItemMeta();
                itemMeta.addEnchant(Enchantment.OXYGEN, 1, true);
                player.getInventory().getItem(0).setItemMeta(itemMeta);
            } else {
                player.getInventory().getItem(0).removeEnchantment(Enchantment.OXYGEN);
            }
            if (this.getCooldownManager().checkUndyingArmy(true)) {
                player.getInventory().setItem(5, UndyingArmy.BONE);
            } else {
                player.getInventory().remove(UndyingArmy.BONE);
            }
            List arcaneShields = new CooldownFilter<RegularCooldown>(this, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(ArcaneShield.class).collect(Collectors.toList());
            if (!arcaneShields.isEmpty()) {
                ArcaneShield arcaneShield = (ArcaneShield)arcaneShields.get(0);
                ((CraftPlayer)player).getHandle().setAbsorptionHearts((float)((double)arcaneShield.getShieldHealth() / ((double)this.getMaxHealth() * 0.5) * 20.0));
            } else {
                ((CraftPlayer)player).getHandle().setAbsorptionHearts(0.0f);
            }
        }
    }

    public Specializations getSpecClass() {
        return this.specClass;
    }

    public Weapons getWeapon() {
        return this.weapon;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Game getGame() {
        return this.game;
    }

    @Nonnull
    public LivingEntity getEntity() {
        return this.entity;
    }

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
    }

    @Nonnull
    public Location getLocation() {
        return this.entity.getLocation();
    }

    @Nonnull
    public Location getLocation(@Nonnull Location copyInto) {
        return this.entity.getLocation(copyInto);
    }

    public boolean isSneaking() {
        return this.entity instanceof Player && ((Player)this.entity).isSneaking();
    }

    public boolean isWasSneaking() {
        return this.wasSneaking;
    }

    public void setWasSneaking(boolean wasSneaking) {
        this.wasSneaking = wasSneaking;
    }

    public boolean isEnemyAlive(@Nullable Entity other) {
        return this.isEnemyAlive(Warlords.getPlayer(other));
    }

    public boolean isEnemyAlive(@Nullable WarlordsPlayer p) {
        return p != null && p.getGame() == this.getGame() && !p.isDead() && p.getTeam() != this.getTeam();
    }

    public boolean isEnemy(@Nullable WarlordsPlayer p) {
        return p != null && p.getGame() == this.getGame() && p.getTeam() != this.getTeam();
    }

    public boolean isTeammateAlive(@Nullable Entity other) {
        return this.isEnemyAlive(Warlords.getPlayer(other));
    }

    public boolean isTeammateAlive(@Nullable WarlordsPlayer p) {
        return p != null && p.getGame() == this.getGame() && !p.isDead() && p.getTeam() == this.getTeam();
    }

    public boolean isTeammate(@Nullable WarlordsPlayer p) {
        return p != null && p.getGame() == this.getGame() && p.getTeam() == this.getTeam();
    }

    public void teleport(Location location) {
        this.entity.teleport(location);
    }

    public void teleportLocationOnly(Location location) {
        if (this.entity instanceof Player) {
            TeleportUtils.teleport((Player)this.entity, location);
        } else {
            Location location1 = this.getLocation();
            location1.setX(location.getX());
            location1.setY(location.getY());
            location1.setZ(location.getZ());
        }
    }

    public PlayingState getGameState() {
        return this.gameState;
    }

    public double getFlagDamageMultiplier() {
        return this.carriedFlag != null && this.carriedFlag.getFlag() instanceof PlayerFlagLocation && ((PlayerFlagLocation)this.carriedFlag.getFlag()).getPlayer() == this ? ((PlayerFlagLocation)this.carriedFlag.getFlag()).getComputedMultiplier() : 1.0;
    }

    public boolean hasFlag() {
        return FlagHolder.isPlayerHolderFlag(this);
    }

    public String getColoredName() {
        return this.getTeam().teamColor() + this.getName();
    }

    public String getColoredNameBold() {
        return this.getTeam().teamColor().toString() + ChatColor.BOLD + this.getName();
    }

    public void setVelocity(Vector v, boolean ignoreModifications) {
        this.setVelocity(v, true, ignoreModifications);
    }

    public void setVelocity(Vector v, boolean kbAfterHorse, boolean ignoreModifications) {
        if (kbAfterHorse || this.entity.getVehicle() == null) {
            if (!ignoreModifications) {
                if (this.cooldownManager.hasCooldownFromName("KB Resistance")) {
                    v.multiply(0.75);
                }
                if (this.cooldownManager.hasCooldownFromName("Vindicate Debuff Immunity")) {
                    v.multiply(0.5);
                }
                if (this.cooldownManager.hasCooldownFromName("KB Increase")) {
                    v.multiply(1.5);
                }
            }
            this.entity.setVelocity(v);
        }
    }

    public void addPotionEffect(PotionEffect potionEffect) {
        if (this.getCooldownManager().hasCooldownFromName("Vindicate Debuff Immunity") && (PotionEffectType.BLINDNESS.equals((Object)potionEffect.getType()) || PotionEffectType.CONFUSION.equals((Object)potionEffect.getType()))) {
            return;
        }
        this.getEntity().addPotionEffect(potionEffect, true);
    }

    public World getWorld() {
        return this.entity.getWorld();
    }

    public boolean isNoEnergyConsumption() {
        return this.noEnergyConsumption;
    }

    public void setNoEnergyConsumption(boolean noEnergyConsumption) {
        this.noEnergyConsumption = noEnergyConsumption;
    }

    public boolean isDisableCooldowns() {
        return this.disableCooldowns;
    }

    public void setDisableCooldowns(boolean disableCooldowns) {
        this.disableCooldowns = disableCooldowns;
    }

    public double getEnergyModifier() {
        return this.energyModifier;
    }

    public void setEnergyModifier(double energyModifier) {
        this.energyModifier = energyModifier;
    }

    public double getCooldownModifier() {
        return this.cooldownModifier;
    }

    public void setCooldownModifier(double cooldownModifier) {
        this.cooldownModifier = cooldownModifier;
    }

    public boolean isTakeDamage() {
        return this.takeDamage;
    }

    public void setTakeDamage(boolean takeDamage) {
        this.takeDamage = takeDamage;
    }

    public boolean isCanCrit() {
        return this.canCrit;
    }

    public void setCanCrit(boolean canCrit) {
        this.canCrit = canCrit;
    }

    public int getBlocksTravelledCM() {
        return this.blocksTravelledCM;
    }

    public void setBlocksTravelledCM(int blocksTravelledCM) {
        this.blocksTravelledCM = blocksTravelledCM;
    }

    public float getWalkspeed() {
        return this.walkspeed;
    }

    public List<Float> getRecordDamage() {
        return this.recordDamage;
    }

    public float getCurrentHealthModifier() {
        return this.currentHealthModifier;
    }

    public void setCurrentHealthModifier(float currentHealthModifier) {
        this.currentHealthModifier = currentHealthModifier;
    }

    @Nullable
    public FlagInfo getCarriedFlag() {
        return this.carriedFlag;
    }

    public void setCarriedFlag(@Nullable FlagInfo carriedFlag) {
        this.carriedFlag = carriedFlag;
    }

    @Nonnull
    public PlayerStatisticsMinute getMinuteStats() {
        return this.minuteStats;
    }

    public PlayerStatisticsSecond getSecondStats() {
        return this.secondStats;
    }

    public List<Achievement.AbstractAchievementRecord<?>> getAchievementsUnlocked() {
        return this.achievementsUnlocked;
    }

    public boolean hasAchievement(ChallengeAchievements achievements) {
        return this.achievementsUnlocked.stream().filter(ChallengeAchievements.ChallengeAchievementRecord.class::isInstance).map(ChallengeAchievements.ChallengeAchievementRecord.class::cast).map(Achievement.AbstractAchievementRecord::getAchievement).anyMatch(achievement -> achievement == achievements);
    }

    public void unlockAchievement(ChallengeAchievements achievement) {
        DatabasePlayer databasePlayer;
        this.achievementsUnlocked.add(new ChallengeAchievements.ChallengeAchievementRecord(achievement));
        if (this.entity instanceof Player && !(databasePlayer = DatabaseManager.playerService.findByUUID(this.uuid)).hasAchievement(achievement)) {
            achievement.sendAchievementUnlockMessage((Player)this.entity);
            achievement.sendAchievementUnlockMessageToOthers(this);
        }
        System.out.println(this.name + " unlocked achievement: " + achievement.name);
    }

    public boolean isOnline() {
        return this.entity instanceof Player;
    }

    @Nullable
    public CompassTargetMarker getCompassTarget() {
        return this.compassTarget;
    }

    public void runEverySecond() {
        this.spec.runEverySecond();
        this.decrementRespawnTimer();
    }
}

