/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player;

import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.classes.mage.specs.Aquamancer;
import com.ebicep.warlords.classes.mage.specs.Cryomancer;
import com.ebicep.warlords.classes.mage.specs.Pyromancer;
import com.ebicep.warlords.classes.paladin.specs.Avenger;
import com.ebicep.warlords.classes.paladin.specs.Crusader;
import com.ebicep.warlords.classes.paladin.specs.Protector;
import com.ebicep.warlords.classes.rogue.specs.Apothecary;
import com.ebicep.warlords.classes.rogue.specs.Assassin;
import com.ebicep.warlords.classes.rogue.specs.Vindicator;
import com.ebicep.warlords.classes.shaman.specs.Earthwarden;
import com.ebicep.warlords.classes.shaman.specs.Spiritguard;
import com.ebicep.warlords.classes.shaman.specs.Thunderlord;
import com.ebicep.warlords.classes.warrior.specs.Berserker;
import com.ebicep.warlords.classes.warrior.specs.Defender;
import com.ebicep.warlords.classes.warrior.specs.Revenant;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.SkillBoosts;
import com.ebicep.warlords.player.SpecType;
import com.ebicep.warlords.util.bukkit.WordWrap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public enum Specializations {
    PYROMANCER("Pyromancer", Pyromancer::new, WordWrap.wrapWithNewline("\u00a77A damage-oriented Mage specialization that uses the destructive Fire spells to obliterate enemies.", 200), SpecType.DAMAGE, SkillBoosts.FIREBALL, SkillBoosts.FLAME_BURST, SkillBoosts.TIME_WARP_PYROMANCER, SkillBoosts.ARCANE_SHIELD_PYROMANCER, SkillBoosts.INFERNO),
    CRYOMANCER("Cryomancer", Cryomancer::new, WordWrap.wrapWithNewline("\u00a77A defense-oriented Mage specialization that uses Ice spells to slow down enemies and to creative defensive barriers.", 200), SpecType.TANK, SkillBoosts.FROST_BOLT, SkillBoosts.FREEZING_BREATH, SkillBoosts.TIME_WARP_CRYOMANCER, SkillBoosts.ARCANE_SHIELD_CRYOMANCER, SkillBoosts.ICE_BARRIER),
    AQUAMANCER("Aquamancer", Aquamancer::new, WordWrap.wrapWithNewline("\u00a77A healing-oriented Mage specialization that uses Water spells to heal allies and to deal minor damage to enemies. This specialization has access to the 'Overheal' ability.", 200), SpecType.HEALER, SkillBoosts.WATER_BOLT, SkillBoosts.WATER_BREATH, SkillBoosts.TIME_WARP_AQUAMANCER, SkillBoosts.ARCANE_SHIELD_AQUAMANCER, SkillBoosts.HEALING_RAIN),
    BERSERKER("Berserker", Berserker::new, WordWrap.wrapWithNewline("\u00a77A damage-oriented Warrior specialization with a lust for blood and anger issues.", 200), SpecType.DAMAGE, SkillBoosts.WOUNDING_STRIKE_BERSERKER, SkillBoosts.SEISMIC_WAVE_BERSERKER, SkillBoosts.GROUND_SLAM_BERSERKER, SkillBoosts.BLOOD_LUST, SkillBoosts.BERSERK),
    DEFENDER("Defender", Defender::new, WordWrap.wrapWithNewline("\u00a77A defense-oriented Warrior specialization that can protect teammates by mitigating damage and intercepting enemy hits.", 200), SpecType.TANK, SkillBoosts.WOUNDING_STRIKE_DEFENDER, SkillBoosts.SEISMIC_WAVE_DEFENDER, SkillBoosts.GROUND_SLAM_DEFENDER, SkillBoosts.INTERVENE, SkillBoosts.LAST_STAND),
    REVENANT("Revenant", Revenant::new, WordWrap.wrapWithNewline("\u00a77A support-oriented Warrior specialization that can give allies a second chance of life.", 200), SpecType.HEALER, SkillBoosts.CRIPPLING_STRIKE, SkillBoosts.RECKLESS_CHARGE, SkillBoosts.GROUND_SLAM_REVENANT, SkillBoosts.ORBS_OF_LIFE, SkillBoosts.UNDYING_ARMY),
    AVENGER("Avenger", Avenger::new, WordWrap.wrapWithNewline("\u00a77A damage-oriented Paladin specialization that focuses on draining energy from enemies and has access to minor healing.", 200), SpecType.DAMAGE, SkillBoosts.AVENGER_STRIKE, SkillBoosts.CONSECRATE_AVENGER, SkillBoosts.LIGHT_INFUSION_AVENGER, SkillBoosts.HOLY_RADIANCE_AVENGER, SkillBoosts.AVENGERS_WRATH),
    CRUSADER("Crusader", Crusader::new, WordWrap.wrapWithNewline("\u00a77A defense-oriented Paladin specialization that inspires allies by granting them more energy in battle and has access to minor healing.", 200), SpecType.TANK, SkillBoosts.CRUSADER_STRIKE, SkillBoosts.CONSECRATE_CRUSADER, SkillBoosts.LIGHT_INFUSION_CRUSADER, SkillBoosts.HOLY_RADIANCE_CRUSADER, SkillBoosts.INSPIRING_PRESENCE),
    PROTECTOR("Protector", Protector::new, WordWrap.wrapWithNewline("\u00a77A healing-oriented Paladin specialization that converts damage into healing for his allies and has access to greater healing abilities.", 200), SpecType.HEALER, SkillBoosts.PROTECTOR_STRIKE, SkillBoosts.CONSECRATE_PROTECTOR, SkillBoosts.LIGHT_INFUSION_PROTECTOR, SkillBoosts.HOLY_RADIANCE_PROTECTOR, SkillBoosts.HAMMER_OF_LIGHT),
    THUNDERLORD("Thunderlord", Thunderlord::new, WordWrap.wrapWithNewline("\u00a77A damage-oriented Shaman specialization that calls upon the power of Lightning to electrocute enemies.", 200), SpecType.DAMAGE, SkillBoosts.LIGHTNING_BOLT, SkillBoosts.CHAIN_LIGHTNING, SkillBoosts.WINDFURY_WEAPON, SkillBoosts.LIGHTNING_ROD, SkillBoosts.CAPACITOR_TOTEM),
    SPIRITGUARD("Spiritguard", Spiritguard::new, WordWrap.wrapWithNewline("\u00a77A defense-oriented Shaman specialization that calls upon the aid of spirits old and new to mitigate damage and avoid death.", 200), SpecType.TANK, SkillBoosts.FALLEN_SOULS, SkillBoosts.SPIRIT_LINK, SkillBoosts.SOULBINDING_WEAPON, SkillBoosts.REPENTANCE, SkillBoosts.DEATHS_DEBT),
    EARTHWARDEN("Earthwarden", Earthwarden::new, WordWrap.wrapWithNewline("\u00a77A healing-oriented Shaman specialization that calls upon the power of Earth to crush enemies and to aid allies.", 200), SpecType.HEALER, SkillBoosts.EARTHEN_SPIKE, SkillBoosts.BOULDER, SkillBoosts.EARTHLIVING_WEAPON, SkillBoosts.CHAIN_HEAL, SkillBoosts.HEALING_TOTEM),
    ASSASSIN("Assassin", Assassin::new, WordWrap.wrapWithNewline("\u00a77A damage-oriented Rogue specialization that is a master of stealth, rapidly taking out any enemies who cross them.", 200), SpecType.DAMAGE, SkillBoosts.JUDGEMENT_STRIKE, SkillBoosts.INCENDIARY_CURSE, SkillBoosts.BLINDING_ASSAULT, SkillBoosts.SOUL_SWITCH, SkillBoosts.ORDER_OF_EVISCERATE),
    VINDICATOR("Vindicator", Vindicator::new, WordWrap.wrapWithNewline("\u00a77A defense-oriented Rogue specialization that deceives enemies by disabling their powers and use bulk power to protect allies.", 200), SpecType.TANK, SkillBoosts.RIGHTEOUS_STRIKE, SkillBoosts.SOUL_SHACKLE, SkillBoosts.HEART_TO_HEART, SkillBoosts.PRISM_GUARD, SkillBoosts.VINDICATE),
    APOTHECARY("Apothecary", Apothecary::new, WordWrap.wrapWithNewline("\u00a77A healing-oriented Rogue specialization that uses special brews and alchemical powers to weaken their foes and aid allies.", 200), SpecType.HEALER, SkillBoosts.IMPALING_STRIKE, SkillBoosts.SOOTHING_PUDDLE, SkillBoosts.VITALITY_LIQUOR, SkillBoosts.REMEDIC_CHAINS, SkillBoosts.DRAINING_MIASMA);

    public final String name;
    public final Supplier<AbstractPlayerClass> create;
    public final String description;
    public final SpecType specType;
    public final List<SkillBoosts> skillBoosts;

    private Specializations(String name, Supplier<AbstractPlayerClass> create, String description, SpecType specType, SkillBoosts ... skillBoosts) {
        this.name = name;
        this.create = create;
        this.description = description;
        this.specType = specType;
        this.skillBoosts = Arrays.asList(skillBoosts);
    }

    public static Specializations getSpecFromName(String name) {
        if (name == null) {
            return PYROMANCER;
        }
        for (Specializations value : Specializations.values()) {
            if (!value.name.equalsIgnoreCase(name)) continue;
            return value;
        }
        return PYROMANCER;
    }

    public static Classes getClass(Specializations selected) {
        return (Classes)((Object)Arrays.stream(Classes.values()).filter(o -> o.subclasses.contains((Object)selected)).collect(Collectors.toList()).get(0));
    }

    public static Classes getClass(String specName) {
        return (Classes)((Object)Arrays.stream(Classes.values()).filter(o -> o.subclasses.stream().anyMatch(subClass -> subClass.name.equalsIgnoreCase(specName))).collect(Collectors.toList()).get(0));
    }
}

