/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class Settings {
    public static final String powerupsName = ChatColor.GOLD + "Energy Powerups";
    public static final String powerupsDescription = ChatColor.GRAY + "Replaces energy powerups with damage\n" + ChatColor.GRAY + "boosting powerups";
    public static final String hotkeyModeName = ChatColor.GREEN + "Hotkey Mode";

    public static enum ParticleQuality {
        LOW(new ItemBuilder(Material.STAINED_GLASS_PANE, 1, 1).name(ChatColor.GOLD + "Low Quality").get(), ChatColor.GRAY + "Heavily reduces the amount of\n" + ChatColor.GRAY + "particles you will see.", 2),
        MEDIUM(new ItemBuilder(Material.STAINED_GLASS_PANE, 1, 4).name(ChatColor.YELLOW + "Medium Quality").get(), ChatColor.GRAY + "Reduces the amount of particles\n" + ChatColor.GRAY + "seem.", 4),
        HIGH(new ItemBuilder(Material.STAINED_GLASS_PANE, 1, 5).name(ChatColor.GREEN + "High Quality").get(), ChatColor.GRAY + "Shows all particles for the best\n" + ChatColor.GRAY + "experience.", 100000);

        public ItemStack item;
        public String description;
        public int particleReduction;

        private ParticleQuality(ItemStack item, String description, int particleReduction) {
            this.item = item;
            this.description = description;
            this.particleReduction = particleReduction;
        }

        public static ParticleQuality getParticleQuality(String name) {
            for (ParticleQuality value : ParticleQuality.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            return HIGH;
        }

        public static ParticleQuality getSelected(Player player) {
            return player.getMetadata("selected-particle-quality").stream().map(v -> v.value() instanceof ParticleQuality ? (ParticleQuality)((Object)((Object)v.value())) : null).filter(Objects::nonNull).findAny().orElse(MEDIUM);
        }

        public static void setSelected(Player player, ParticleQuality selectedParticleQuality) {
            player.removeMetadata("selected-particle-quality", (Plugin)Warlords.getInstance());
            player.setMetadata("selected-particle-quality", (MetadataValue)new FixedMetadataValue((Plugin)Warlords.getInstance(), (Object)selectedParticleQuality));
            Warlords.getPlayerSettings(player.getUniqueId()).setParticleQuality(selectedParticleQuality);
        }
    }

    public static enum HotkeyMode {
        NEW_MODE(new ItemBuilder(Material.REDSTONE).name(hotkeyModeName).lore(ChatColor.AQUA + "Currently selected " + ChatColor.YELLOW + "NEW", "", ChatColor.YELLOW + "Click here to enable Classic mode.").get()),
        CLASSIC_MODE(new ItemBuilder(Material.SNOW_BALL).name(hotkeyModeName).lore(ChatColor.YELLOW + "Currently selected " + ChatColor.AQUA + "Classic", "", ChatColor.YELLOW + "Click here to enable NEW mode.").get());

        public ItemStack item;

        private HotkeyMode(ItemStack item) {
            this.item = item;
        }

        public static HotkeyMode getHotkeyMode(String name) {
            for (HotkeyMode value : HotkeyMode.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            return NEW_MODE;
        }

        public static HotkeyMode getSelected(Player player) {
            return player.getMetadata("selected-hotkeymode").stream().map(v -> v.value() instanceof HotkeyMode ? (HotkeyMode)((Object)((Object)v.value())) : null).filter(Objects::nonNull).findAny().orElse(NEW_MODE);
        }

        public static void setSelected(Player player, HotkeyMode selectedHotkeyMode) {
            player.removeMetadata("selected-hotkeymode", (Plugin)Warlords.getInstance());
            player.setMetadata("selected-hotkeymode", (MetadataValue)new FixedMetadataValue((Plugin)Warlords.getInstance(), (Object)selectedHotkeyMode));
            Warlords.getPlayerSettings(player.getUniqueId()).setHotKeyMode(selectedHotkeyMode == NEW_MODE);
        }
    }

    public static enum Powerup {
        DAMAGE(new ItemStack(Material.WOOL, 1, 14)),
        ENERGY(new ItemStack(Material.WOOL, 1, 1));

        public ItemStack item;

        private Powerup(ItemStack item) {
            this.item = item;
        }

        public static Powerup getPowerup(String name) {
            for (Powerup value : Powerup.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            return DAMAGE;
        }

        public static Powerup getSelected(Player player) {
            return player.getMetadata("selected-powerup").stream().map(v -> v.value() instanceof Powerup ? (Powerup)((Object)((Object)v.value())) : null).filter(Objects::nonNull).findAny().orElse(DAMAGE);
        }

        public static void setSelected(Player player, Powerup selectedPowerup) {
            player.removeMetadata("selected-powerup", (Plugin)Warlords.getInstance());
            player.setMetadata("selected-powerup", (MetadataValue)new FixedMetadataValue((Plugin)Warlords.getInstance(), (Object)selectedPowerup));
        }
    }
}

