/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player;

import com.ebicep.warlords.events.WarlordsDamageHealingFinalEvent;
import com.ebicep.warlords.game.state.PlayingState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PlayerStatisticsSecond
implements Iterable<Entry> {
    private final PlayingState playingState;
    private final List<Entry> entries = new ArrayList<Entry>();
    private Entry current = new Entry();

    public PlayerStatisticsSecond(PlayingState playingState) {
        this.playingState = playingState;
        this.entries.add(this.current);
    }

    public void advanceSecond() {
        this.current = new Entry();
        this.entries.add(this.current);
    }

    public void addDamageHealingEventAsSelf(WarlordsDamageHealingFinalEvent event) {
        this.current.eventsAsSelf.add(event);
    }

    public void addDamageHealingEventAsAttacker(WarlordsDamageHealingFinalEvent event) {
        this.current.eventsAsAttacker.add(event);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public List<WarlordsDamageHealingFinalEvent> getAllEventsAsSelf() {
        ArrayList<WarlordsDamageHealingFinalEvent> events = new ArrayList<WarlordsDamageHealingFinalEvent>();
        this.entries.forEach(entry -> events.addAll(entry.getEventsAsSelf()));
        return events;
    }

    public List<WarlordsDamageHealingFinalEvent> getAllEventsAsAttacker() {
        ArrayList<WarlordsDamageHealingFinalEvent> events = new ArrayList<WarlordsDamageHealingFinalEvent>();
        this.entries.forEach(entry -> events.addAll(entry.getEventsAsAttacker()));
        return events;
    }

    public List<WarlordsDamageHealingFinalEvent> getEventsAsSelfFromLastSecond(int seconds) {
        int timeLimit = this.playingState.getTicksElapsed() - seconds * 20;
        return this.getAllEventsAsSelf().stream().filter(event -> timeLimit <= event.getInGameTick()).collect(Collectors.toList());
    }

    public List<WarlordsDamageHealingFinalEvent> getEventsAsAttackerFromLastSecond(int seconds) {
        int timeLimit = this.playingState.getTicksElapsed() - seconds * 20;
        return this.getAllEventsAsAttacker().stream().filter(event -> timeLimit <= event.getInGameTick()).collect(Collectors.toList());
    }

    public List<WarlordsDamageHealingFinalEvent> getLastEventsAsSelf(int amount, int timeLimitSeconds) {
        List<WarlordsDamageHealingFinalEvent> events = this.getEventsAsSelfFromLastSecond(timeLimitSeconds);
        return events.subList(Math.max(0, events.size() - amount), events.size());
    }

    public List<WarlordsDamageHealingFinalEvent> getLastEventsAsSelf(int amount) {
        return this.getLastEventsAsSelf(amount, 60);
    }

    public List<WarlordsDamageHealingFinalEvent> getLastEventsAsAttacker(int amount, int timeLimitSeconds) {
        List<WarlordsDamageHealingFinalEvent> events = this.getEventsAsAttackerFromLastSecond(timeLimitSeconds);
        return events.subList(Math.max(0, events.size() - amount), events.size());
    }

    public List<WarlordsDamageHealingFinalEvent> getLastEventsAsAttacker(int amount) {
        return this.getLastEventsAsAttacker(amount, 60);
    }

    public WarlordsDamageHealingFinalEvent getLastEventAsSelf() {
        return this.getLastEventsAsSelf(1, 1).get(0);
    }

    public WarlordsDamageHealingFinalEvent getLastEventAsAttacker() {
        return this.getLastEventsAsAttacker(1, 1).get(0);
    }

    @Override
    @NotNull
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public static class Entry {
        List<WarlordsDamageHealingFinalEvent> eventsAsSelf = new ArrayList<WarlordsDamageHealingFinalEvent>();
        List<WarlordsDamageHealingFinalEvent> eventsAsAttacker = new ArrayList<WarlordsDamageHealingFinalEvent>();

        public List<WarlordsDamageHealingFinalEvent> getEventsAsSelf() {
            return this.eventsAsSelf;
        }

        public List<WarlordsDamageHealingFinalEvent> getEventsAsAttacker() {
            return this.eventsAsAttacker;
        }
    }
}

