/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class PlayerStatisticsMinute
implements Iterable<Entry> {
    @Nonnull
    private final List<Entry> entries;
    @Nonnull
    private Entry current = new Entry();
    @CheckForNull
    private transient Entry total = null;

    public PlayerStatisticsMinute() {
        this(16);
    }

    public PlayerStatisticsMinute(int expectedGameDurationInMinutes) {
        this.entries = new ArrayList<Entry>(expectedGameDurationInMinutes);
        this.entries.add(this.current);
    }

    public void advanceMinute() {
        this.current = new Entry();
        this.entries.add(this.current);
    }

    public void addKill() {
        this.current.kills++;
        if (this.total != null) {
            this.total.kills++;
        }
    }

    public void addAssist() {
        this.current.assists++;
        if (this.total != null) {
            this.total.assists++;
        }
    }

    public void addDeath() {
        this.current.deaths++;
        if (this.total != null) {
            this.total.deaths++;
        }
    }

    public void addDamage(long damage) {
        Entry entry = this.current;
        entry.damage = entry.damage + damage;
        if (this.total != null) {
            entry = this.total;
            entry.damage = entry.damage + damage;
        }
    }

    public void addHealing(long healing) {
        Entry entry = this.current;
        entry.healing = entry.healing + healing;
        if (this.total != null) {
            entry = this.total;
            entry.healing = entry.healing + healing;
        }
    }

    public void addAbsorbed(long absorbed) {
        Entry entry = this.current;
        entry.absorbed = entry.absorbed + absorbed;
        if (this.total != null) {
            entry = this.total;
            entry.absorbed = entry.absorbed + absorbed;
        }
    }

    public void addDamageOnCarrier(long damageOnCarrier) {
        Entry entry = this.current;
        entry.damageOnCarrier = entry.damageOnCarrier + damageOnCarrier;
        if (this.total != null) {
            entry = this.total;
            entry.damageOnCarrier = entry.damageOnCarrier + damageOnCarrier;
        }
    }

    public void addHealingOnCarrier(long healingOnCarrier) {
        Entry entry = this.current;
        entry.healingOnCarrier = entry.healingOnCarrier + healingOnCarrier;
        if (this.total != null) {
            entry = this.total;
            entry.healingOnCarrier = entry.healingOnCarrier + healingOnCarrier;
        }
    }

    public void addFlagCapture() {
        this.current.flagsCaptured++;
        if (this.total != null) {
            this.total.flagsCaptured++;
        }
    }

    public void addFlagReturned() {
        this.current.flagsReturned++;
        if (this.total != null) {
            this.total.flagsReturned++;
        }
    }

    public void addTimeInCombat() {
        this.current.timeInCombat++;
        if (this.total != null) {
            this.total.timeInCombat++;
        }
    }

    public void addTotalRespawnTime() {
        this.current.respawnTimeSpent++;
        if (this.total != null) {
            this.total.respawnTimeSpent++;
        }
    }

    public Entry recomputeTotal() {
        return this.entries.stream().reduce(new Entry(), Entry::merge);
    }

    @Nonnull
    public Entry total() {
        if (this.total == null) {
            this.total = this.recomputeTotal();
        }
        return this.total;
    }

    @Nonnull
    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public void forEach(Consumer<? super Entry> action) {
        this.entries.forEach(action);
    }

    @Override
    public Spliterator<Entry> spliterator() {
        return this.entries.spliterator();
    }

    public Stream<Entry> stream() {
        return this.entries.stream();
    }

    public static class Entry {
        @Nonnegative
        private int kills;
        @Nonnegative
        private int assists;
        @Nonnegative
        private int deaths;
        @Nonnegative
        private long damage;
        @Nonnegative
        private long healing;
        @Nonnegative
        private long absorbed;
        @Nonnegative
        private long damageOnCarrier;
        @Nonnegative
        private long healingOnCarrier;
        @Nonnegative
        private int flagsCaptured;
        @Nonnegative
        private int flagsReturned;
        @Nonnegative
        private int timeInCombat;
        @Nonnegative
        private int respawnTimeSpent;

        public Entry merge(Entry other) {
            this.kills += other.kills;
            this.assists += other.assists;
            this.deaths += other.deaths;
            this.damage += other.damage;
            this.healing += other.healing;
            this.absorbed += other.absorbed;
            this.damageOnCarrier += other.damageOnCarrier;
            this.healingOnCarrier += other.healingOnCarrier;
            this.flagsCaptured += other.flagsCaptured;
            this.flagsReturned += other.flagsReturned;
            this.timeInCombat += other.timeInCombat;
            this.respawnTimeSpent += other.respawnTimeSpent;
            return this;
        }

        @Nonnegative
        public int getKills() {
            return this.kills;
        }

        @Nonnegative
        public int getAssists() {
            return this.assists;
        }

        @Nonnegative
        public int getDeaths() {
            return this.deaths;
        }

        @Nonnegative
        public long getDamage() {
            return this.damage;
        }

        @Nonnegative
        public long getHealing() {
            return this.healing;
        }

        @Nonnegative
        public long getAbsorbed() {
            return this.absorbed;
        }

        @Nonnegative
        public long getDamageOnCarrier() {
            return this.damageOnCarrier;
        }

        @Nonnegative
        public long getHealingOnCarrier() {
            return this.healingOnCarrier;
        }

        @Nonnegative
        public int getFlagsCaptured() {
            return this.flagsCaptured;
        }

        @Nonnegative
        public int getFlagsReturned() {
            return this.flagsReturned;
        }

        @Nonnegative
        public int getTimeInCombat() {
            return this.timeInCombat;
        }

        @Nonnegative
        public float getRespawnTimeSpent() {
            return this.respawnTimeSpent;
        }

        public String toString() {
            return "{kills=" + this.kills + ", assists=" + this.assists + ", deaths=" + this.deaths + ", damage=" + this.damage + ", healing=" + this.healing + ", absorbed=" + this.absorbed + ", damageOnCarrier=" + this.damageOnCarrier + ", healingOnCarrier=" + this.healingOnCarrier + ", flagsCaptured=" + this.flagsCaptured + ", flagsReturned=" + this.flagsReturned + ", timeInCombat=" + this.timeInCombat + ", respawnTimeSpent=" + this.respawnTimeSpent + '}';
        }

        public int hashCode() {
            int hash = 7;
            hash = 13 * hash + this.kills;
            hash = 13 * hash + this.assists;
            hash = 13 * hash + this.deaths;
            hash = 13 * hash + (int)(this.damage ^ this.damage >>> 32);
            hash = 13 * hash + (int)(this.healing ^ this.healing >>> 32);
            hash = 13 * hash + (int)(this.absorbed ^ this.absorbed >>> 32);
            hash = 13 * hash + (int)(this.damageOnCarrier ^ this.damageOnCarrier >>> 32);
            hash = 13 * hash + (int)(this.healingOnCarrier ^ this.healingOnCarrier >>> 32);
            hash = 13 * hash + this.flagsCaptured;
            hash = 13 * hash + this.flagsReturned;
            hash = 13 * hash + this.timeInCombat;
            hash = 13 * hash + this.respawnTimeSpent;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.kills == other.kills && this.assists == other.assists && this.deaths == other.deaths && this.damage == other.damage && this.healing == other.healing && this.absorbed == other.absorbed && this.damageOnCarrier == other.damageOnCarrier && this.healingOnCarrier == other.healingOnCarrier && this.flagsCaptured == other.flagsCaptured && this.flagsReturned == other.flagsReturned && this.timeInCombat == other.timeInCombat && this.respawnTimeSpent == other.respawnTimeSpent;
        }
    }
}

