/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player;

import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.FutureMessageManager;
import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.SpecType;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.ebicep.warlords.util.java.NumberFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.Document;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class ExperienceManager {
    public static final Map<Integer, Long> levelExperience;
    public static final Map<Long, Integer> experienceLevel;
    public static final DecimalFormat currentExperienceDecimalFormat;
    public static final HashMap<UUID, LinkedHashMap<String, Long>> cachedPlayerExpSummary;
    private static final Map<String, int[]> awardOrder;

    public static void awardWeeklyExperience(Document weeklyDocument) {
        if (DatabaseManager.playerService == null) {
            System.out.println("WARNING - Could not give weekly experience bonus - playerService is null");
            return;
        }
        HashMap<String, Document> futureMessageDocuments = new HashMap<String, Document>();
        BulkOperations operations = DatabaseManager.playerService.bulkOps();
        awardOrder.forEach((key, rewards) -> {
            String name = (String)((Object)weeklyDocument.getEmbedded((List<?>)Arrays.asList(key, "name"), String.class));
            List top = weeklyDocument.getEmbedded(Arrays.asList(key, "top"), new ArrayList());
            for (int i = 0; i < top.size(); ++i) {
                Document topDocument = (Document)top.get(i);
                String[] names = topDocument.getString("names").split(",");
                String[] uuids = topDocument.getString("uuids").split(",");
                for (int j = 0; j < uuids.length; ++j) {
                    int experienceGain = rewards[i];
                    if (!futureMessageDocuments.containsKey(uuids[j])) {
                        futureMessageDocuments.put(uuids[j], new Document("uuid", uuids[j]).append("name", names[j]).append("centered", true).append("messages", new ArrayList<String>(Arrays.asList(ChatColor.BLUE + "---------------------------------------------------", ChatColor.GREEN + "Weekly Experience Bonus\n "))).append("total_experience_gain", 0L));
                    }
                    Document previousDocument = (Document)futureMessageDocuments.get(uuids[j]);
                    previousDocument.getList("messages", String.class).add(ChatColor.YELLOW + "#" + (i + 1) + ". " + ChatColor.AQUA + name + ChatColor.WHITE + ": " + ChatColor.DARK_GRAY + "+" + ChatColor.DARK_AQUA + experienceGain + ChatColor.GOLD + " Universal Experience");
                    previousDocument.put("total_experience_gain", (Object)(previousDocument.getLong("total_experience_gain") + (long)experienceGain));
                }
            }
        });
        futureMessageDocuments.forEach((s2, document) -> {
            long expGain = document.getLong("total_experience_gain");
            Query query = new Query().addCriteria(Criteria.where("uuid").is(document.getString("uuid")));
            Update update = new Update().inc("experience", expGain);
            operations.updateOne(query, update);
            document.getList("messages", String.class).add(ChatColor.GOLD + "Total Experience Gain" + ChatColor.WHITE + ": " + ChatColor.DARK_GRAY + "+" + ChatColor.DARK_AQUA + expGain);
            document.getList("messages", String.class).addAll(Collections.singletonList(ChatColor.BLUE + "---------------------------------------------------"));
        });
        FutureMessageManager.addNewFutureMessageDocuments(new ArrayList<Document>(futureMessageDocuments.values()));
        System.out.println(operations.execute().getModifiedCount() + " players were given weekly experience bonuses");
    }

    public static LinkedHashMap<String, Long> getExpFromGameStats(WarlordsPlayer warlordsPlayer, boolean recalculate) {
        double absorbedMultiplier;
        double healingMultiplier;
        double damageMultiplier;
        if (!recalculate && cachedPlayerExpSummary.containsKey(warlordsPlayer.getUuid()) && cachedPlayerExpSummary.get(warlordsPlayer.getUuid()) != null) {
            return cachedPlayerExpSummary.get(warlordsPlayer.getUuid());
        }
        boolean isCompGame = warlordsPlayer.getGame().getAddons().contains((Object)GameAddon.PRIVATE_GAME);
        float multiplier = 1.0f;
        if (!isCompGame) {
            multiplier = (float)((double)multiplier * 0.1);
        }
        if (warlordsPlayer.getGame().getGameMode() == GameMode.DUEL) {
            multiplier = (float)((double)multiplier * 0.1);
        }
        boolean won = warlordsPlayer.getGame().getPoints(warlordsPlayer.getTeam()) > warlordsPlayer.getGame().getPoints(warlordsPlayer.getTeam().enemy());
        long winLossExp = won ? 500L : 250L;
        long kaExp = 5L * (long)(warlordsPlayer.getMinuteStats().total().getKills() + warlordsPlayer.getMinuteStats().total().getAssists());
        Specializations specializations = warlordsPlayer.getSpecClass();
        if (specializations.specType == SpecType.DAMAGE) {
            damageMultiplier = 0.8;
            healingMultiplier = 0.1;
            absorbedMultiplier = 0.1;
        } else if (specializations.specType == SpecType.HEALER) {
            damageMultiplier = 0.275;
            healingMultiplier = 0.65;
            absorbedMultiplier = 0.75;
        } else {
            damageMultiplier = 0.575;
            healingMultiplier = 0.1;
            absorbedMultiplier = 0.325;
        }
        double calculatedDHP = (double)warlordsPlayer.getMinuteStats().total().getDamage() * damageMultiplier + (double)warlordsPlayer.getMinuteStats().total().getHealing() * healingMultiplier + (double)warlordsPlayer.getMinuteStats().total().getAbsorbed() * absorbedMultiplier;
        long dhpExp = (long)(calculatedDHP / 500.0);
        long flagCapExp = (long)warlordsPlayer.getFlagsCaptured() * 150L;
        long flagRetExp = (long)warlordsPlayer.getFlagsReturned() * 50L;
        LinkedHashMap<String, Long> expGain = new LinkedHashMap<String, Long>();
        expGain.put(won ? "Win" : "Loss", (long)((float)winLossExp * multiplier));
        if (kaExp != 0L) {
            expGain.put("Kills/Assists", (long)((float)kaExp * multiplier));
        }
        if (dhpExp != 0L) {
            expGain.put("DHP", (long)((float)dhpExp * multiplier));
        }
        if (flagCapExp != 0L) {
            expGain.put("Flags Captured", (long)((float)flagCapExp * multiplier));
        }
        if (flagRetExp != 0L) {
            expGain.put("Flags Returned", (long)((float)flagRetExp * multiplier));
        }
        try {
            DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(warlordsPlayer.getUuid(), PlayersCollections.DAILY);
            if (isCompGame) {
                switch (databasePlayer.getCompStats().getPlays()) {
                    case 0: {
                        expGain.put("First Game of the Day", 500L);
                        break;
                    }
                    case 1: {
                        expGain.put("Second Game of the Day", 250L);
                        break;
                    }
                    case 2: {
                        expGain.put("Third Game of the Day", 100L);
                    }
                }
            } else {
                switch (databasePlayer.getPubStats().getPlays()) {
                    case 0: {
                        expGain.put("First Game of the Day", 50L);
                        break;
                    }
                    case 1: {
                        expGain.put("Second Game of the Day", 25L);
                        break;
                    }
                    case 2: {
                        expGain.put("Third Game of the Day", 10L);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cachedPlayerExpSummary.put(warlordsPlayer.getUuid(), expGain);
        return expGain;
    }

    public static long getSpecExpFromSummary(LinkedHashMap<String, Long> expSummary) {
        return expSummary.values().stream().mapToLong(Long::longValue).sum() - expSummary.getOrDefault("First Game of the Day", 0L) - expSummary.getOrDefault("Second Game of the Day", 0L) - expSummary.getOrDefault("Third Game of the Day", 0L);
    }

    public static long getExperienceForClass(UUID uuid, Classes classes) {
        if (DatabaseManager.playerService == null) {
            return 0L;
        }
        DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(uuid);
        return databasePlayer == null ? 0L : databasePlayer.getClass(classes).getExperience();
    }

    public static int getLevelForClass(UUID uuid, Classes classes) {
        return (int)ExperienceManager.calculateLevelFromExp(ExperienceManager.getExperienceForClass(uuid, classes));
    }

    public static long getExperienceForSpec(UUID uuid, Specializations spec) {
        return ExperienceManager.getExperienceFromSpec(uuid, spec);
    }

    public static int getLevelForSpec(UUID uuid, Specializations spec) {
        return (int)ExperienceManager.calculateLevelFromExp(ExperienceManager.getExperienceFromSpec(uuid, spec));
    }

    public static long getUniversalLevel(UUID uuid) {
        if (DatabaseManager.playerService == null) {
            return 0L;
        }
        DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(uuid);
        return databasePlayer == null ? 0L : databasePlayer.getExperience();
    }

    private static long getExperienceFromSpec(UUID uuid, Specializations specializations) {
        if (DatabaseManager.playerService == null) {
            return 0L;
        }
        DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(uuid);
        return databasePlayer == null ? 0L : databasePlayer.getSpec(specializations).getExperience();
    }

    public static String getLevelString(int level) {
        return level < 10 ? "0" + level : String.valueOf(level);
    }

    public static String getProgressString(long currentExperience, int nextLevel) {
        int i;
        String progress = ChatColor.GRAY + "Progress to Level " + nextLevel + ": " + ChatColor.YELLOW;
        long experience = currentExperience - levelExperience.get(nextLevel - 1);
        long experienceNeeded = levelExperience.get(nextLevel) - levelExperience.get(nextLevel - 1);
        double progressPercentage = (double)experience / (double)experienceNeeded * 100.0;
        progress = progress + NumberFormat.formatOptionalTenths(progressPercentage) + "%\n" + ChatColor.GREEN;
        int greenBars = (int)Math.round(progressPercentage * 20.0 / 100.0);
        for (i = 0; i < greenBars; ++i) {
            progress = progress + "-";
        }
        progress = progress + ChatColor.WHITE;
        for (i = greenBars; i < 20; ++i) {
            progress = progress + "-";
        }
        progress = progress + " " + ChatColor.YELLOW + currentExperienceDecimalFormat.format(experience) + ChatColor.GOLD + "/" + ChatColor.YELLOW + NumberFormat.getSimplifiedNumber(experienceNeeded);
        return progress;
    }

    public static double calculateLevelFromExp(long exp) {
        return Math.sqrt((double)exp / 25.0);
    }

    public static double calculateExpFromLevel(int level) {
        return Math.pow(level, 2.0) * 25.0;
    }

    public static void giveExperienceBar(Player player) {
        long experience = ExperienceManager.getUniversalLevel(player.getUniqueId());
        int level = (int)ExperienceManager.calculateLevelFromExp(experience);
        player.setLevel(level);
        player.setExp((float)(experience - levelExperience.get(level)) / (float)(levelExperience.get(level + 1) - levelExperience.get(level)));
    }

    public static void giveLevelUpMessage(Player player, long expBefore, long expAfter) {
        int levelAfter;
        int levelBefore = (int)ExperienceManager.calculateLevelFromExp(expBefore);
        if (levelBefore != (levelAfter = (int)ExperienceManager.calculateLevelFromExp(expAfter))) {
            ChatUtils.sendMessage(player, true, ChatColor.GREEN.toString() + ChatColor.BOLD + ChatColor.MAGIC + "   " + ChatColor.AQUA + ChatColor.BOLD + " LEVEL UP! " + ChatColor.DARK_GRAY + ChatColor.BOLD + "[" + ChatColor.GRAY + ChatColor.BOLD + levelBefore + ChatColor.DARK_GRAY + ChatColor.BOLD + "]" + ChatColor.GREEN + ChatColor.BOLD + " > " + ChatColor.DARK_GRAY + ChatColor.BOLD + "[" + ChatColor.GRAY + ChatColor.BOLD + levelAfter + ChatColor.DARK_GRAY + ChatColor.BOLD + "] " + ChatColor.GREEN + ChatColor.MAGIC + ChatColor.BOLD + "   ");
        }
    }

    static {
        currentExperienceDecimalFormat = new DecimalFormat("#,###.#");
        cachedPlayerExpSummary = new HashMap();
        HashMap<Integer, Long> levelExperienceNew = new HashMap<Integer, Long>();
        HashMap<Long, Integer> experienceLevelNew = new HashMap<Long, Integer>();
        for (int i = 0; i < 201; ++i) {
            long exp = (long)ExperienceManager.calculateExpFromLevel(i);
            levelExperienceNew.put(i, exp);
            experienceLevelNew.put(exp, i);
        }
        levelExperience = Collections.unmodifiableMap(levelExperienceNew);
        experienceLevel = Collections.unmodifiableMap(experienceLevelNew);
        currentExperienceDecimalFormat.setDecimalSeparatorAlwaysShown(false);
        awardOrder = new LinkedHashMap<String, int[]>(){
            {
                this.put("wins", new int[]{1000, 750, 500});
                this.put("losses", new int[]{200, 150, 100});
                this.put("kills", new int[]{850, 600, 350});
                this.put("assists", new int[]{850, 600, 350});
                this.put("deaths", new int[]{200, 150, 100});
                this.put("dhp", new int[]{1000, 750, 500});
                this.put("dhp_per_game", new int[]{1000, 750, 500});
                this.put("damage", new int[]{850, 600, 350});
                this.put("healing", new int[]{850, 600, 350});
                this.put("absorbed", new int[]{850, 600, 350});
                this.put("flags_captured", new int[]{600, 400, 200});
                this.put("flags_returned", new int[]{600, 400, 200});
            }
        };
    }
}

