/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.leaderboards.Leaderboard;
import com.ebicep.warlords.database.leaderboards.LeaderboardManager;
import com.ebicep.warlords.database.leaderboards.sections.LeaderboardCategory;
import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.util.java.NumberFormat;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class CustomScoreboard {
    private static final String[] teamEntries = new String[]{"\ud83c\udf82", "\ud83c\udf89", "\ud83c\udf81", "\ud83d\udc79", "\ud83c\udfc0", "\u26bd", "\ud83c\udf6d", "\ud83c\udf20", "\ud83d\udc7e", "\ud83d\udc0d", "\ud83d\udd2e", "\ud83d\udc7d", "\ud83d\udca3", "\ud83c\udf6b", "\ud83d\udd2b", "\ud83e\udded", "\ud83e\uddf1", "\ud83d\udc88", "\ud83e\uddbd", "\ud83e\uddbc"};
    private final Player player;
    private final Scoreboard scoreboard;
    private Objective sideBar;
    private Objective health;

    public CustomScoreboard(Player player) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        this.scoreboard = manager.getNewScoreboard();
        this.sideBar = this.scoreboard.registerNewObjective("WARLORDS", "dummy");
        this.sideBar.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.sideBar.setDisplayName("\u00a7e\u00a7lWARLORDS 2.0");
        this.player = player;
        this.player.setScoreboard(this.scoreboard);
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public Objective getHealth() {
        return this.health;
    }

    public void setHealth(Objective health) {
        this.health = health;
    }

    public void setSideBarTeamPrefixAndSuffix(int team, String prefix, String suffix) {
        if (prefix.length() > 16) {
            prefix = "Error";
        }
        if (suffix.length() > 16) {
            suffix = "Error";
        }
        this.scoreboard.getTeam("team_" + team).setPrefix(prefix);
        this.scoreboard.getTeam("team_" + team).setSuffix(suffix);
    }

    public void setSideBarTeam(int team, String entry) {
        if (entry.length() > 16) {
            if (entry.charAt(15) == '\u00a7') {
                this.scoreboard.getTeam("team_" + team).setPrefix(entry.substring(0, 15));
                if (entry.length() > 31) {
                    this.scoreboard.getTeam("team_" + team).setSuffix(entry.substring(15, 31));
                } else {
                    this.scoreboard.getTeam("team_" + team).setSuffix(entry.substring(15));
                }
            } else {
                this.scoreboard.getTeam("team_" + team).setPrefix(entry.substring(0, 16));
                if (entry.length() > 32) {
                    this.scoreboard.getTeam("team_" + team).setSuffix(entry.substring(16, 32));
                } else {
                    this.scoreboard.getTeam("team_" + team).setSuffix(entry.substring(16));
                }
            }
        } else {
            this.scoreboard.getTeam("team_" + team).setPrefix(entry);
            this.scoreboard.getTeam("team_" + team).setSuffix("");
        }
    }

    public void giveNewSideBar(boolean forceClear, List<String> entries) {
        this.giveNewSideBar(forceClear, entries.toArray(new String[0]));
    }

    public void giveNewSideBar(boolean forceClear, String ... entries) {
        int i;
        int sideBarTeams = (int)this.scoreboard.getTeams().stream().filter(team -> team.getName().contains("team")).count();
        if (forceClear || entries.length != sideBarTeams) {
            this.scoreboard.getTeams().forEach(Team::unregister);
            this.clearSideBar();
            for (i = 0; i < entries.length; ++i) {
                Team tempTeam = this.scoreboard.registerNewTeam("team_" + (i + 1));
                tempTeam.addEntry(teamEntries[i]);
                this.sideBar.getScore(teamEntries[i]).setScore(i + 1);
            }
        }
        for (i = entries.length; i > 0; --i) {
            String entry = entries[entries.length - i];
            this.setSideBarTeam(i, entry == null ? "" : entry);
        }
    }

    private void clearSideBar() {
        this.sideBar.unregister();
        this.sideBar = this.scoreboard.registerNewObjective("WARLORDS", "dummy");
        this.sideBar.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.sideBar.setDisplayName("\u00a7e\u00a7lWARLORDS 2.0");
    }

    public void giveMainLobbyScoreboard() {
        if (this.scoreboard.getObjective("health") != null) {
            this.scoreboard.getObjective("health").unregister();
            this.health = null;
        }
        block8: for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            for (Team team : this.scoreboard.getTeams()) {
                if (!team.getName().equals(onlinePlayer.getName())) continue;
                team.unregister();
                continue block8;
            }
        }
        if (LeaderboardManager.loaded) {
            List<DatabasePlayer> databasePlayerList;
            LeaderboardCategory<?> leaderboardCategory = LeaderboardManager.getLeaderboardCategoryFromPlayer(this.player);
            if (leaderboardCategory == null) {
                return;
            }
            Leaderboard leaderboard = leaderboardCategory.leaderboards.get(0);
            switch (LeaderboardManager.playerLeaderboardTime.getOrDefault(this.player.getUniqueId(), PlayersCollections.LIFETIME)) {
                case LIFETIME: {
                    databasePlayerList = leaderboard.getSortedAllTime();
                    break;
                }
                case SEASON_6: {
                    databasePlayerList = leaderboard.getSortedSeason6();
                    break;
                }
                case SEASON_5: {
                    databasePlayerList = leaderboard.getSortedSeason5();
                    break;
                }
                case SEASON_4: {
                    databasePlayerList = leaderboard.getSortedSeason4();
                    break;
                }
                case WEEKLY: {
                    databasePlayerList = leaderboard.getSortedWeekly();
                    break;
                }
                case DAILY: {
                    databasePlayerList = leaderboard.getSortedDaily();
                    break;
                }
                default: {
                    databasePlayerList = leaderboard.getSortedAllTime();
                }
            }
            LeaderboardManager.GameType selectedType = LeaderboardManager.playerLeaderboardGameType.get(this.player.getUniqueId());
            LeaderboardManager.Category selectedCategory = LeaderboardManager.playerLeaderboardCategory.get(this.player.getUniqueId());
            PlayersCollections selectedCollection = LeaderboardManager.playerLeaderboardTime.get(this.player.getUniqueId());
            if (selectedType == null) {
                selectedType = LeaderboardManager.GameType.ALL;
            }
            if (selectedCollection == null) {
                selectedCategory = LeaderboardManager.Category.ALL;
            }
            if (selectedCollection == null) {
                selectedCollection = PlayersCollections.LIFETIME;
            }
            String scoreboardSelection = "";
            if (!selectedType.shortName.isEmpty()) {
                scoreboardSelection = scoreboardSelection + selectedType.shortName + "/";
            }
            if (!selectedCategory.shortName.isEmpty()) {
                scoreboardSelection = scoreboardSelection + selectedCategory.shortName + "/";
            }
            scoreboardSelection = scoreboardSelection + selectedCollection.name;
            Optional<DatabasePlayer> optionalDatabasePlayer = databasePlayerList.stream().filter(databasePlayer -> databasePlayer.getUuid().equalsIgnoreCase(this.player.getUniqueId().toString())).findAny();
            if (optionalDatabasePlayer.isPresent()) {
                DatabasePlayer databasePlayer2 = optionalDatabasePlayer.get();
                AbstractDatabaseStatInformation playerInformation = (AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply(databasePlayer2);
                this.giveNewSideBar(true, ChatColor.GRAY + scoreboardSelection, "", "Kills: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(playerInformation.getKills()), "Assists: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(playerInformation.getAssists()), "Deaths: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(playerInformation.getDeaths()), " ", "Wins: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(playerInformation.getWins()), "Losses: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(playerInformation.getLosses()), "  ", "Damage: " + ChatColor.RED + NumberFormat.addCommaAndRound(playerInformation.getDamage()), "Healing: " + ChatColor.DARK_GREEN + NumberFormat.addCommaAndRound(playerInformation.getHealing()), "Absorbed: " + ChatColor.GOLD + NumberFormat.addCommaAndRound(playerInformation.getAbsorbed()), "    ", "            " + ChatColor.YELLOW + ChatColor.BOLD + "Update", "     " + ChatColor.GOLD + ChatColor.BOLD + Warlords.VERSION);
            } else {
                this.giveNASidebar(scoreboardSelection);
            }
            return;
        }
        if (DatabaseManager.playerService == null) {
            this.giveNASidebar("Lifetime");
            return;
        }
        DatabasePlayer databasePlayer3 = DatabaseManager.playerService.findByUUID(this.player.getUniqueId());
        this.giveNewSideBar(true, ChatColor.GRAY + "Lifetime", " ", "Kills: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(databasePlayer3.getKills()), "Assists: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(databasePlayer3.getAssists()), "Deaths: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(databasePlayer3.getDeaths()), " ", "Wins: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(databasePlayer3.getWins()), "Losses: " + ChatColor.GREEN + NumberFormat.addCommaAndRound(databasePlayer3.getLosses()), "  ", "Damage: " + ChatColor.RED + NumberFormat.addCommaAndRound(databasePlayer3.getDamage()), "Healing: " + ChatColor.DARK_GREEN + NumberFormat.addCommaAndRound(databasePlayer3.getHealing()), "Absorbed: " + ChatColor.GOLD + NumberFormat.addCommaAndRound(databasePlayer3.getAbsorbed()), "    ", "            " + ChatColor.YELLOW + ChatColor.BOLD + "Update", "     " + ChatColor.GOLD + ChatColor.BOLD + Warlords.VERSION);
    }

    private void giveNASidebar(String title) {
        this.giveNewSideBar(true, ChatColor.GRAY + title, " ", "Kills: " + ChatColor.GREEN + "N/A", "Assists: " + ChatColor.GREEN + "N/A", "Deaths: " + ChatColor.GREEN + "N/A", " ", "Wins: " + ChatColor.GREEN + "N/A", "Losses: " + ChatColor.GREEN + "N/A", "  ", "Damage: " + ChatColor.RED + "N/A", "Healing: " + ChatColor.DARK_GREEN + "N/A", "Absorbed: " + ChatColor.GOLD + "N/A", "    ", "            " + ChatColor.YELLOW + ChatColor.BOLD + "Update", "     " + ChatColor.GOLD + ChatColor.BOLD + Warlords.VERSION);
    }
}

