/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.player;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;

public class CalculateSpeed {
    private final float BASE_SPEED = 7.02f;
    private final float BASE_SPEED_TO_WALKING_SPEED = 0.035612535f;
    private final float minspeed;
    private final float maxspeed;
    private final List<Modifier> modifiers = new LinkedList<Modifier>();
    private final Consumer<Float> updateWalkingSpeed;
    private float lastSpeed = 0.0f;
    private boolean changed = true;
    private boolean hasPendingTimers = false;
    private boolean hasEffectAlteringEffects = false;

    public CalculateSpeed(Consumer<Float> updateWalkingSpeed, int baseModifier) {
        this.minspeed = 7.02f * (1.0f + (float)baseModifier / 100.0f) * 0.65f;
        this.maxspeed = 9.828f;
        this.updateWalkingSpeed = updateWalkingSpeed;
        this.modifiers.add(new Modifier("BASE", baseModifier, 0, Collections.emptyList(), false));
    }

    public void updateSpeed() {
        if (this.changed || this.hasPendingTimers) {
            boolean hasPendingTimers = false;
            boolean hasEffectAlteringEffects = false;
            Iterator<Modifier> iterator = this.modifiers.iterator();
            while (iterator.hasNext()) {
                Modifier next = iterator.next();
                if (next.duration == 0) continue;
                --next.duration;
                if (next.duration == 0) {
                    iterator.remove();
                    this.changed = true;
                    continue;
                }
                hasPendingTimers = true;
                if (next.toDisable.isEmpty()) continue;
                hasEffectAlteringEffects = true;
            }
            this.hasEffectAlteringEffects = hasEffectAlteringEffects;
            this.hasPendingTimers = hasPendingTimers;
        }
        if (this.changed) {
            Modifier mod;
            this.changed = false;
            float speed = 7.02f;
            HashMap<String, Modifier> appliedEffects = new HashMap<String, Modifier>();
            for (Modifier next : this.modifiers) {
                if (next.afterLimit) continue;
                if (this.hasEffectAlteringEffects) {
                    for (String toDisable : next.toDisable) {
                        mod = appliedEffects.put(toDisable, null);
                        if (mod == null) continue;
                        speed /= mod.calculatedModifier;
                    }
                    if (appliedEffects.containsKey(next.name)) continue;
                }
                speed *= next.calculatedModifier;
                appliedEffects.put(next.name, next);
            }
            if (speed < this.minspeed) {
                speed = this.minspeed;
            }
            if (speed > this.maxspeed) {
                speed = this.maxspeed;
            }
            for (Modifier next : this.modifiers) {
                if (!next.afterLimit) continue;
                if (this.hasEffectAlteringEffects) {
                    for (String toDisable : next.toDisable) {
                        mod = appliedEffects.put(toDisable, null);
                        if (mod == null) continue;
                        speed /= mod.calculatedModifier;
                    }
                    if (appliedEffects.containsKey(next.name)) continue;
                }
                speed *= next.calculatedModifier;
                appliedEffects.put(next.name, next);
            }
            if (speed != this.lastSpeed) {
                float walkSpeed = speed * 0.035612535f;
                for (Object object : appliedEffects.values()) {
                }
                this.lastSpeed = speed;
                this.updateWalkingSpeed.accept(Float.valueOf(walkSpeed));
            }
        }
    }

    public Runnable addSpeedModifier(String name, int modifier, int duration, String ... toDisable) {
        return this.addSpeedModifier(name, modifier, duration, Arrays.asList(toDisable));
    }

    public Runnable addSpeedModifier(String name, int modifier, int duration, Collection<String> toDisable) {
        return this.addSpeedModifier(name, modifier, duration, false, toDisable);
    }

    public Runnable addSpeedModifier(String name, int modifier, int duration, boolean afterLimit, String ... toDisable) {
        return this.addSpeedModifier(name, modifier, duration, afterLimit, Arrays.asList(toDisable));
    }

    public Runnable addSpeedModifier(String name, int modifier, int duration, boolean afterLimit, Collection<String> toDisable) {
        Modifier mod = new Modifier(name, modifier, duration == 0 ? 0 : duration + 1, toDisable, afterLimit);
        ListIterator<Modifier> iterator = this.modifiers.listIterator();
        while (iterator.hasNext()) {
            Modifier next = iterator.next();
            if (!Objects.equals(next.name, name)) continue;
            iterator.set(mod);
            return () -> this.modifiers.remove(mod);
        }
        this.modifiers.add(mod);
        this.changed = true;
        return () -> {
            this.modifiers.remove(mod);
            this.changed = true;
        };
    }

    public void removeSlownessModifiers() {
        boolean isChanged = this.modifiers.removeIf(modifier -> modifier.duration > 0 && modifier.calculatedModifier < 1.0f);
        this.changed = this.changed || isChanged;
    }

    private static class Modifier {
        public final String name;
        public final int modifier;
        public final float calculatedModifier;
        public int duration;
        public final boolean afterLimit;
        public final Collection<String> toDisable;

        public Modifier(String name, int modifier, int duration, Collection<String> toDisable, boolean afterLimit) {
            this.name = name;
            this.modifier = modifier;
            this.calculatedModifier = 1.0f + (float)modifier / 100.0f;
            this.duration = duration;
            this.afterLimit = afterLimit;
            this.toDisable = toDisable;
        }

        public String toString() {
            return "Modifier{name=" + this.name + ", modifier=" + this.modifier + " (" + this.calculatedModifier + "), duration=" + this.duration + ", toDisable=" + this.toDisable + '}';
        }
    }
}

