/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.party;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.menu.Menu;
import com.ebicep.warlords.party.Party;
import com.ebicep.warlords.permissions.PermissionHandler;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.SpecType;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RegularGamesMenu {
    private final Party party;
    private final List<RegularGamePlayer> regularGamePlayers = new ArrayList<RegularGamePlayer>();
    private final HashMap<Team, List<UUID>> selectedPlayersToSwap = new HashMap<Team, List<UUID>>(){
        {
            this.put(Team.BLUE, new ArrayList());
            this.put(Team.RED, new ArrayList());
        }
    };
    private HashMap<Team, Boolean> checkPlayers = new HashMap<Team, Boolean>(){
        {
            this.put(Team.BLUE, true);
            this.put(Team.RED, true);
        }
    };

    public RegularGamesMenu(Party party) {
        this.party = party;
    }

    public void openMenuForPlayer(Player player) {
        int i;
        Optional<RegularGamePlayer> gamePlayerOptional = this.regularGamePlayers.stream().filter(p -> p.getUuid().equals(player.getUniqueId())).findFirst();
        if (!gamePlayerOptional.isPresent()) {
            return;
        }
        RegularGamePlayer regularGamePlayer = gamePlayerOptional.get();
        Menu menu = new Menu("Team Builder", 54);
        Team team = regularGamePlayer.getTeam();
        for (i = 0; i < 6; ++i) {
            menu.setItem(0, i, new ItemBuilder(team.getItem()).name(team.coloredPrefix()).get(), (m4, e) -> {});
            menu.setItem(8, i, new ItemBuilder(team.getItem()).name(team.coloredPrefix()).get(), (m4, e) -> {});
        }
        for (i = 1; i < 8; ++i) {
            menu.setItem(i, 0, new ItemBuilder(team.getItem()).name(team.coloredPrefix()).get(), (m4, e) -> {});
            if (i != 2) continue;
            i = 5;
        }
        for (i = 0; i < Classes.values().length; ++i) {
            Classes classes2 = Classes.values()[i];
            menu.setItem(2, i + 1, new ItemBuilder(classes2.item).name(ChatColor.GREEN + classes2.name).get(), (m4, e) -> {});
            menu.setItem(6, i + 1, new ItemBuilder(classes2.item).name(ChatColor.GREEN + classes2.name).get(), (m4, e) -> {});
        }
        for (i = 0; i < SpecType.values().length; ++i) {
            SpecType specType = SpecType.values()[i];
            menu.setItem(i + 3, 0, new ItemBuilder(specType.itemStack).name(specType.chatColor + specType.name).get(), (m4, e) -> {});
        }
        List teamPlayers = this.regularGamePlayers.stream().filter(p -> p.getTeam() == team).collect(Collectors.toList());
        ArrayList<UUID> uuidsWithPerms = new ArrayList<UUID>();
        for (Object p2 : teamPlayers) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)((RegularGamePlayer)p2).getUuid());
            if (offlinePlayer.getPlayer() == null || !PermissionHandler.isGameStarter(offlinePlayer.getPlayer()) && !offlinePlayer.getPlayer().isOp()) continue;
            uuidsWithPerms.add(((RegularGamePlayer)p2).getUuid());
        }
        ArrayList<String> editors = new ArrayList<String>();
        for (UUID uUID : uuidsWithPerms) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
            if (offlinePlayer == null) continue;
            editors.add(ChatColor.GRAY + offlinePlayer.getName());
        }
        menu.setItem(2, 5, new ItemBuilder(Material.BOOK_AND_QUILL).name(ChatColor.GREEN + "Editors").lore(editors).get(), (m4, e) -> {});
        menu.setItem(3, 5, new ItemBuilder(Material.WOOL, 1, 5).name(ChatColor.GREEN + "Confirm Team").get(), (m4, e) -> {
            if (!uuidsWithPerms.contains(player.getUniqueId())) {
                return;
            }
            for (RegularGamePlayer teamPlayer : teamPlayers) {
                UUID uuid = teamPlayer.getUuid();
                Specializations spec = teamPlayer.getSelectedSpec();
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                Warlords.getPlayerSettings(uuid).setSelectedSpec(spec);
                DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(uuid);
                databasePlayer.setLastSpec(spec);
                DatabaseManager.updatePlayerAsync(databasePlayer);
                if (offlinePlayer.getPlayer() == null) continue;
                offlinePlayer.getPlayer().sendMessage(ChatColor.DARK_BLUE + "---------------------------------------");
                offlinePlayer.getPlayer().sendMessage(ChatColor.GREEN + "Your spec was automatically changed to " + ChatColor.YELLOW + spec.name + ChatColor.GREEN + "!");
                offlinePlayer.getPlayer().sendMessage(ChatColor.DARK_BLUE + "---------------------------------------");
            }
            this.regularGamePlayers.forEach(p -> {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)p.getUuid());
                if (offlinePlayer.getPlayer() != null) {
                    offlinePlayer.getPlayer().sendMessage(ChatColor.GREEN + "The " + team.coloredPrefix() + ChatColor.GREEN + " team is ready!");
                }
            });
        });
        menu.setItem(4, 5, Menu.MENU_CLOSE, Menu.ACTION_CLOSE_MENU);
        ArrayList<String> playerOnSpecs = new ArrayList<String>();
        for (Specializations value : Specializations.values()) {
            Optional<RegularGamePlayer> optional = teamPlayers.stream().filter(p -> p.getSelectedSpec() == value).findFirst();
            if (optional.isPresent()) {
                playerOnSpecs.add(ChatColor.GOLD + value.name + ChatColor.GRAY + " - " + ChatColor.AQUA + Bukkit.getOfflinePlayer((UUID)optional.get().getUuid()).getName());
                continue;
            }
            playerOnSpecs.add(ChatColor.GOLD + value.name + ChatColor.GRAY + " - " + ChatColor.AQUA);
        }
        menu.setItem(5, 5, new ItemBuilder(Material.SIGN).name(ChatColor.GREEN + "General Information").lore(playerOnSpecs).get(), (m4, e) -> {});
        if (this.checkPlayers.get((Object)team).booleanValue()) {
            this.checkPlayers.put(team, false);
            ArrayList<Specializations> arrayList = new ArrayList<Specializations>();
            ArrayList<RegularGamePlayer> playersToReassign = new ArrayList<RegularGamePlayer>();
            for (RegularGamePlayer p3 : teamPlayers) {
                Specializations specializations = p3.getSelectedSpec();
                if (arrayList.contains((Object)specializations)) {
                    playersToReassign.add(p3);
                    continue;
                }
                arrayList.add(specializations);
            }
            block8: for (RegularGamePlayer p2 : playersToReassign) {
                for (Specializations value : Specializations.values()) {
                    if (arrayList.contains((Object)value)) continue;
                    p2.setSelectedSpec(value);
                    arrayList.add(value);
                    continue block8;
                }
            }
        }
        ArrayList<Specializations> arrayList = new ArrayList<Specializations>();
        for (RegularGamePlayer p4 : teamPlayers) {
            int y;
            int x;
            UUID uuid = p4.getUuid();
            Specializations specializations = p4.getSelectedSpec();
            Classes classes3 = Specializations.getClass(specializations);
            int n = specializations.specType == SpecType.DAMAGE ? 3 : (specializations.specType == SpecType.TANK ? 4 : (x = specializations.specType == SpecType.HEALER ? 5 : -1));
            int n2 = classes3 == Classes.MAGE ? 1 : (classes3 == Classes.WARRIOR ? 2 : (classes3 == Classes.PALADIN ? 3 : (y = classes3 == Classes.SHAMAN ? 4 : -1)));
            if (x == -1 || y == -1) {
                System.out.println("ERROR trying to get players spec position for regular game menu");
                continue;
            }
            arrayList.add(specializations);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            String name = offlinePlayer != null ? offlinePlayer.getName() : "UNKNOWN";
            ItemBuilder itemBuilder = this.selectedPlayersToSwap.get((Object)team).contains(uuid) ? new ItemBuilder(new ItemStack(Material.SKULL_ITEM, 1, (short)SkullType.CREEPER.ordinal())).name(ChatColor.AQUA + name + ChatColor.GREEN + " SELECTED").lore(ChatColor.GOLD + p4.getSelectedSpec().name) : new ItemBuilder(Warlords.getHead(uuid)).name(ChatColor.AQUA + name).lore(ChatColor.GOLD + p4.getSelectedSpec().name);
            menu.setItem(x, y, itemBuilder.get(), (m4, e) -> {
                if (!uuidsWithPerms.contains(player.getUniqueId())) {
                    return;
                }
                List<UUID> uuids = this.selectedPlayersToSwap.get((Object)team);
                if (uuids.contains(uuid)) {
                    uuids.remove(uuid);
                } else {
                    uuids.add(uuid);
                    if (uuids.size() == 2) {
                        this.swapPlayers(team);
                    }
                }
                menu.openForPlayer(player);
            });
        }
        Arrays.stream(Specializations.values()).filter(classes -> !assignedClasses.contains(classes)).collect(Collectors.toList()).forEach(selectedSpec -> {
            int x;
            Classes classes = Specializations.getClass(selectedSpec);
            int n = selectedSpec.specType == SpecType.DAMAGE ? 3 : (selectedSpec.specType == SpecType.TANK ? 4 : (x = selectedSpec.specType == SpecType.HEALER ? 5 : -1));
            int y = classes == Classes.MAGE ? 1 : (classes == Classes.WARRIOR ? 2 : (classes == Classes.PALADIN ? 3 : (classes == Classes.SHAMAN ? 4 : -1)));
            menu.setItem(x, y, new ItemBuilder(Material.STAINED_GLASS_PANE, 1, 7).name(ChatColor.GRAY + "Available Spec").get(), (m4, e) -> {
                if (!uuidsWithPerms.contains(player.getUniqueId())) {
                    return;
                }
                List<UUID> uuids = this.selectedPlayersToSwap.get((Object)team);
                if (uuids.size() == 1) {
                    this.regularGamePlayers.stream().filter(p -> p.getUuid().equals(this.selectedPlayersToSwap.get((Object)team).get(0))).findFirst().ifPresent(p -> {
                        p.setSelectedSpec((Specializations)((Object)((Object)selectedSpec)));
                        this.selectedPlayersToSwap.get((Object)team).clear();
                    });
                }
                menu.openForPlayer(player);
            });
        });
        menu.openForPlayer(player);
    }

    private void swapPlayers(Team team) {
        Optional<RegularGamePlayer> regularGamePlayer1 = this.regularGamePlayers.stream().filter(regularGamePlayer -> regularGamePlayer.getUuid().equals(this.selectedPlayersToSwap.get((Object)team).get(0))).findFirst();
        Optional<RegularGamePlayer> regularGamePlayer2 = this.regularGamePlayers.stream().filter(regularGamePlayer -> regularGamePlayer.getUuid().equals(this.selectedPlayersToSwap.get((Object)team).get(1))).findFirst();
        if (!regularGamePlayer1.isPresent() || !regularGamePlayer2.isPresent()) {
            return;
        }
        Specializations classToSwap = regularGamePlayer1.get().getSelectedSpec();
        regularGamePlayer1.get().setSelectedSpec(regularGamePlayer2.get().getSelectedSpec());
        regularGamePlayer2.get().setSelectedSpec(classToSwap);
        this.selectedPlayersToSwap.get((Object)team).clear();
    }

    public void reset() {
        this.checkPlayers.put(Team.BLUE, true);
        this.checkPlayers.put(Team.RED, true);
        this.regularGamePlayers.clear();
    }

    public List<RegularGamePlayer> getRegularGamePlayers() {
        return this.regularGamePlayers;
    }

    public static class RegularGamePlayer {
        private final UUID uuid;
        private final Team team;
        private Specializations selectedSpec;

        public RegularGamePlayer(UUID uuid, Team team, Specializations selectedSpec) {
            this.uuid = uuid;
            this.team = team;
            this.selectedSpec = selectedSpec;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public Team getTeam() {
            return this.team;
        }

        public Specializations getSelectedSpec() {
            return this.selectedSpec;
        }

        public void setSelectedSpec(Specializations selectedSpec) {
            this.selectedSpec = selectedSpec;
        }
    }
}

