/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.menu.generalmenu;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.marker.LobbyLocationMarker;
import com.ebicep.warlords.game.option.marker.MapSymmetryMarker;
import com.ebicep.warlords.menu.Menu;
import com.ebicep.warlords.player.ArmorManager;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.ExperienceManager;
import com.ebicep.warlords.player.PlayerSettings;
import com.ebicep.warlords.player.Settings;
import com.ebicep.warlords.player.SkillBoosts;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.player.Weapons;
import com.ebicep.warlords.player.WeaponsRarity;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import com.ebicep.warlords.util.java.NumberFormat;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class WarlordsShopMenu {
    private static final ItemStack MENU_BACK_PREGAME = new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Back").lore(ChatColor.GRAY + "To Pre-game Menu").get();
    private static final ItemStack MENU_SKINS = new ItemBuilder(Material.PAINTING).name(ChatColor.GREEN + "Weapon Skin Selector").lore("\u00a77Change the cosmetic appearance\n\u00a77of your weapon to better suit\n\u00a77your tastes.", "", "\u00a7eClick to change weapon skin!").get();
    private static final ItemStack MENU_ARMOR_SETS = new ItemBuilder(Material.DIAMOND_HELMET).name(ChatColor.AQUA + "Armor Sets " + ChatColor.GRAY + "& " + ChatColor.AQUA + "Helmets " + ChatColor.GOLD + "(Cosmetic)").lore("\u00a77Equip your favorite armor\n\u00a77sets or class helmets").get();
    private static final ItemStack MENU_BOOSTS = new ItemBuilder(Material.BOOKSHELF).name(ChatColor.AQUA + "Weapon Skill Boost").lore("\u00a77Choose which of your skills you\n\u00a77want your equipped weapon to boost.", "", "\u00a7eClick to change skill boost!").get();
    private static final ItemStack MENU_SETTINGS = new ItemBuilder(Material.NETHER_STAR).name(ChatColor.AQUA + "Settings").lore("\u00a77Allows you to toggle different settings\n\u00a77options.", "", "\u00a7eClick to edit your settings.").get();
    private static final ItemStack MENU_SETTINGS_PARTICLE_QUALITY = new ItemBuilder(Material.NETHER_STAR).name(ChatColor.GREEN + "Particle Quality").lore("\u00a77Allows you to control, or\n\u00a77disable, particles and the\n\u00a77amount of them.").get();
    private static final ItemStack MENU_ABILITY_DESCRIPTION = new ItemBuilder(Material.BOOK).name(ChatColor.GREEN + "Class Information").lore("\u00a77Preview of your ability \ndescriptions and specialization \nstats.").get();
    private static final ItemStack MENU_ARCADE = new ItemBuilder(Material.GOLD_BLOCK).name(ChatColor.GREEN + "Mini Games").lore("\u00a77Try your luck in rerolling or\nopening skin shards here!\n").get();
    private static final String[] legendaryNames = new String[]{"Warlord", "Vanquisher", "Champion"};
    private static final String[] mythicNames = new String[]{"Mythical", "Ascendant", "Brilliant"};
    private static final Map<WeaponsRarity, List<Weapons>> weaponByRarity = Stream.of(Weapons.values()).collect(Collectors.groupingBy(Weapons::getRarity));
    private static final Random random = new Random();
    private static final Map<UUID, Long> openWeaponCooldown = new HashMap<UUID, Long>();

    public static void openMainMenu(Player player) {
        Specializations selectedSpec = Warlords.getPlayerSettings(player.getUniqueId()).getSelectedSpec();
        Menu menu = new Menu("Warlords Shop", 54);
        Classes[] values = Classes.values();
        for (int i = 0; i < values.length; ++i) {
            Classes group = values[i];
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(group.description);
            lore.add("");
            lore.add(ChatColor.GOLD + "Specializations:");
            for (Specializations subClass : group.subclasses) {
                lore.add((subClass == selectedSpec ? ChatColor.GREEN : ChatColor.GRAY) + subClass.name);
            }
            lore.add("");
            long experience = ExperienceManager.getExperienceForClass(player.getUniqueId(), group);
            int level = (int)ExperienceManager.calculateLevelFromExp(experience);
            lore.add(ExperienceManager.getProgressString(experience, level + 1));
            lore.add("");
            lore.add(ChatColor.YELLOW + "Click here to select a " + group.name + "\n" + ChatColor.YELLOW + "specialization");
            ItemStack item = new ItemBuilder(group.item).name(ChatColor.GOLD + group.name + ChatColor.DARK_GRAY + " [" + ChatColor.GRAY + "Lv" + ExperienceManager.getLevelString(level) + ChatColor.DARK_GRAY + "]").lore(lore).get();
            menu.setItem(4 - values.length / 2 + i * 2 - 2, 1, item, (m4, e) -> WarlordsShopMenu.openClassMenu(player, group));
        }
        menu.setItem(1, 3, MENU_SKINS, (m4, e) -> WarlordsShopMenu.openWeaponMenu(player, 1));
        menu.setItem(3, 3, MENU_ARMOR_SETS, (m4, e) -> WarlordsShopMenu.openArmorMenu(player, 1));
        menu.setItem(5, 3, MENU_BOOSTS, (m4, e) -> WarlordsShopMenu.openSkillBoostMenu(player, selectedSpec));
        menu.setItem(7, 3, MENU_SETTINGS, (m4, e) -> WarlordsShopMenu.openSettingsMenu(player));
        menu.setItem(4, 5, Menu.MENU_CLOSE, Menu.ACTION_CLOSE_MENU);
        menu.setItem(4, 2, MENU_ABILITY_DESCRIPTION, (m4, e) -> WarlordsShopMenu.openLobbyAbilityMenu(player));
        menu.setItem(4, 4, MENU_ARCADE, (m4, e) -> WarlordsShopMenu.openArcadeMenu(player));
        menu.openForPlayer(player);
    }

    public static void openClassMenu(Player player, Classes selectedGroup) {
        Specializations selectedSpec = Warlords.getPlayerSettings(player.getUniqueId()).getSelectedSpec();
        Menu menu = new Menu(selectedGroup.name, 36);
        List<Specializations> values = selectedGroup.subclasses;
        for (int i = 0; i < values.size(); ++i) {
            Specializations subClass = values.get(i);
            ItemBuilder builder = new ItemBuilder(subClass.specType.itemStack).name(ChatColor.GREEN + "Specialization: " + subClass.name + " " + ChatColor.DARK_GRAY + "[" + ChatColor.GRAY + "Lv" + ExperienceManager.getLevelString(ExperienceManager.getLevelForSpec(player.getUniqueId(), subClass)) + ChatColor.DARK_GRAY + "]").flags(ItemFlag.HIDE_ENCHANTS);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(subClass.description);
            lore.add("");
            long experience = ExperienceManager.getExperienceForSpec(player.getUniqueId(), subClass);
            int level = (int)ExperienceManager.calculateLevelFromExp(experience);
            lore.add(ExperienceManager.getProgressString(experience, level + 1));
            lore.add("");
            if (subClass == selectedSpec) {
                lore.add(ChatColor.GREEN + ">>> ACTIVE <<<");
                builder.enchant(Enchantment.OXYGEN, 1);
            } else {
                lore.add(ChatColor.YELLOW + "> Click to activate <");
            }
            builder.lore(lore);
            menu.setItem(4 - values.size() / 2 + i * 2 - 1, 1, builder.get(), (m4, e) -> {
                player.sendMessage(ChatColor.WHITE + "Spec: \u00a76" + (Object)((Object)subClass));
                player.playSound(player.getLocation(), Sound.NOTE_PLING, 1.0f, 2.0f);
                ArmorManager.resetArmor(player, subClass, Warlords.getPlayerSettings(player.getUniqueId()).getWantedTeam());
                PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
                playerSettings.setSelectedSpec(subClass);
                AbstractPlayerClass apc = subClass.create.get();
                player.getInventory().setItem(1, new ItemBuilder(apc.getWeapon().getItem(playerSettings.getWeaponSkins().getOrDefault((Object)((Object)((Object)subClass)), (Weapons)Weapons.FELFLAME_BLADE).item)).name("\u00a7aWeapon Skin Preview").lore("").get());
                WarlordsShopMenu.openClassMenu(player, selectedGroup);
                if (DatabaseManager.playerService == null) {
                    return;
                }
                DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(player.getUniqueId());
                databasePlayer.setLastSpec(subClass);
                DatabaseManager.updatePlayerAsync(databasePlayer);
            });
        }
        menu.setItem(4, 3, MENU_BACK_PREGAME, (m4, e) -> WarlordsShopMenu.openMainMenu(player));
        menu.openForPlayer(player);
    }

    public static void openSkillBoostMenu(Player player, Specializations selectedSpec) {
        SkillBoosts selectedBoost = Warlords.getPlayerSettings(player.getUniqueId()).getSkillBoostForClass();
        Menu menu = new Menu("Skill Boost", 54);
        List<SkillBoosts> values = selectedSpec.skillBoosts;
        for (int i = 0; i < values.size(); ++i) {
            SkillBoosts skillBoost = values.get(i);
            ItemBuilder builder = new ItemBuilder(selectedSpec.specType.itemStack).name(skillBoost == selectedBoost ? ChatColor.GREEN + skillBoost.name + " (" + selectedSpec.name + ")" : ChatColor.RED + skillBoost.name + " (" + selectedSpec.name + ")").flags(ItemFlag.HIDE_ENCHANTS);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(skillBoost == selectedBoost ? skillBoost.selectedDescription : skillBoost.description);
            lore.add("");
            if (skillBoost == selectedBoost) {
                lore.add(ChatColor.GREEN + "Currently selected!");
                builder.enchant(Enchantment.OXYGEN, 1);
            } else {
                lore.add(ChatColor.YELLOW + "Click to select!");
            }
            builder.lore(lore);
            menu.setItem(i + 2, 3, builder.get(), (m4, e) -> {
                player.sendMessage(ChatColor.GREEN + "You have changed your weapon boost to: \u00a7b" + skillBoost.name + "!");
                Warlords.getPlayerSettings(player.getUniqueId()).setSkillBoostForSelectedSpec(skillBoost);
                WarlordsShopMenu.openSkillBoostMenu(player, selectedSpec);
                if (DatabaseManager.playerService == null) {
                    return;
                }
                DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(player.getUniqueId());
                databasePlayer.getSpec(selectedSpec).setSkillBoost(skillBoost);
                DatabaseManager.updatePlayerAsync(databasePlayer);
            });
        }
        PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
        AbstractPlayerClass apc = selectedSpec.create.get();
        AbstractPlayerClass apc2 = selectedSpec.create.get();
        if (apc2.getWeapon().getClass() == selectedBoost.ability) {
            apc2.getWeapon().boostSkill(selectedBoost, apc2);
            apc.getWeapon().updateDescription(player);
            apc2.getWeapon().updateDescription(player);
            menu.setItem(3, 1, apc.getWeapon().getItem(playerSettings.getWeaponSkins().getOrDefault((Object)((Object)selectedSpec), (Weapons)Weapons.FELFLAME_BLADE).item), Menu.ACTION_DO_NOTHING);
            menu.setItem(5, 1, apc2.getWeapon().getItem(playerSettings.getWeaponSkins().getOrDefault((Object)((Object)selectedSpec), (Weapons)Weapons.FELFLAME_BLADE).item), Menu.ACTION_DO_NOTHING);
        } else if (apc2.getRed().getClass() == selectedBoost.ability) {
            apc2.getRed().boostSkill(selectedBoost, apc2);
            apc.getRed().updateDescription(player);
            apc2.getRed().updateDescription(player);
            menu.setItem(3, 1, apc.getRed().getItem(new ItemStack(Material.INK_SACK, 1, 1)), Menu.ACTION_DO_NOTHING);
            menu.setItem(5, 1, apc2.getRed().getItem(new ItemStack(Material.INK_SACK, 1, 1)), Menu.ACTION_DO_NOTHING);
        } else if (apc2.getPurple().getClass() == selectedBoost.ability) {
            apc2.getPurple().boostSkill(selectedBoost, apc2);
            apc.getPurple().updateDescription(player);
            apc2.getPurple().updateDescription(player);
            menu.setItem(3, 1, apc.getPurple().getItem(new ItemStack(Material.GLOWSTONE_DUST)), Menu.ACTION_DO_NOTHING);
            menu.setItem(5, 1, apc2.getPurple().getItem(new ItemStack(Material.GLOWSTONE_DUST)), Menu.ACTION_DO_NOTHING);
        } else if (apc2.getBlue().getClass() == selectedBoost.ability) {
            apc2.getBlue().boostSkill(selectedBoost, apc2);
            apc.getBlue().updateDescription(player);
            apc2.getBlue().updateDescription(player);
            menu.setItem(3, 1, apc.getBlue().getItem(new ItemStack(Material.INK_SACK, 1, 10)), Menu.ACTION_DO_NOTHING);
            menu.setItem(5, 1, apc2.getBlue().getItem(new ItemStack(Material.INK_SACK, 1, 10)), Menu.ACTION_DO_NOTHING);
        } else if (apc2.getOrange().getClass() == selectedBoost.ability) {
            apc2.getOrange().boostSkill(selectedBoost, apc2);
            apc.getOrange().updateDescription(player);
            apc2.getOrange().updateDescription(player);
            menu.setItem(3, 1, apc.getOrange().getItem(new ItemStack(Material.INK_SACK, 1, 14)), Menu.ACTION_DO_NOTHING);
            menu.setItem(5, 1, apc2.getOrange().getItem(new ItemStack(Material.INK_SACK, 1, 14)), Menu.ACTION_DO_NOTHING);
        }
        menu.setItem(4, 5, MENU_BACK_PREGAME, (m4, e) -> WarlordsShopMenu.openMainMenu(player));
        menu.openForPlayer(player);
    }

    public static void openWeaponMenu(Player player, int pageNumber) {
        Specializations selectedSpec = Warlords.getPlayerSettings(player.getUniqueId()).getSelectedSpec();
        Weapons selectedWeapon = Weapons.getSelected((OfflinePlayer)player, selectedSpec);
        Menu menu = new Menu("Weapon Skin Selector", 54);
        ArrayList<Weapons> values = new ArrayList<Weapons>(Arrays.asList(Weapons.values()));
        for (int i = (pageNumber - 1) * 21; i < pageNumber * 21 && i < values.size(); ++i) {
            ItemBuilder builder;
            Weapons weapon = (Weapons)((Object)values.get(i));
            if (weapon.isUnlocked) {
                builder = new ItemBuilder(weapon.item).name(ChatColor.GREEN + weapon.name).flags(ItemFlag.HIDE_ENCHANTS);
                ArrayList<String> lore = new ArrayList<String>();
                if (weapon == selectedWeapon) {
                    lore.add(ChatColor.GREEN + "Currently selected!");
                    builder.enchant(Enchantment.OXYGEN, 1);
                } else {
                    lore.add(ChatColor.YELLOW + "Click to select!");
                }
                builder.lore(lore);
            } else {
                builder = new ItemBuilder(Material.BARRIER).name(ChatColor.RED + "Locked Weapon Skin");
            }
            menu.setItem((i - (pageNumber - 1) * 21) % 7 + 1, (i - (pageNumber - 1) * 21) / 7 + 1, builder.get(), (m4, e) -> {
                if (weapon.isUnlocked) {
                    player.sendMessage(ChatColor.GREEN + "You have changed your " + ChatColor.AQUA + selectedSpec.name + ChatColor.GREEN + "'s weapon skin to: \u00a7b" + weapon.name + "!");
                    Weapons.setSelected((OfflinePlayer)player, selectedSpec, weapon);
                    WarlordsShopMenu.openWeaponMenu(player, pageNumber);
                    PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
                    AbstractPlayerClass apc = selectedSpec.create.get();
                    player.getInventory().setItem(1, new ItemBuilder(apc.getWeapon().getItem(playerSettings.getWeaponSkins().getOrDefault((Object)((Object)((Object)selectedSpec)), (Weapons)Weapons.FELFLAME_BLADE).item)).name("\u00a7aWeapon Skin Preview").lore("").get());
                    if (DatabaseManager.playerService == null) {
                        return;
                    }
                    DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(player.getUniqueId());
                    databasePlayer.getSpec(selectedSpec).setWeapon(weapon);
                    DatabaseManager.updatePlayerAsync(databasePlayer);
                } else {
                    player.sendMessage(ChatColor.RED + "This weapon skin has not been unlocked yet!");
                }
            });
        }
        if (pageNumber == 1) {
            menu.setItem(8, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Next Page").lore(ChatColor.YELLOW + "Page " + (pageNumber + 1)).get(), (m4, e) -> WarlordsShopMenu.openWeaponMenu(player, pageNumber + 1));
        } else if (pageNumber == 2) {
            menu.setItem(0, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Previous Page").lore(ChatColor.YELLOW + "Page " + (pageNumber - 1)).get(), (m4, e) -> WarlordsShopMenu.openWeaponMenu(player, pageNumber - 1));
            menu.setItem(8, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Next Page").lore(ChatColor.YELLOW + "Page " + (pageNumber + 1)).get(), (m4, e) -> WarlordsShopMenu.openWeaponMenu(player, pageNumber + 1));
        } else if (pageNumber == 3) {
            menu.setItem(0, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Previous Page").lore(ChatColor.YELLOW + "Page " + (pageNumber - 1)).get(), (m4, e) -> WarlordsShopMenu.openWeaponMenu(player, pageNumber - 1));
            menu.setItem(8, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Next Page").lore(ChatColor.YELLOW + "Page " + (pageNumber + 1)).get(), (m4, e) -> WarlordsShopMenu.openWeaponMenu(player, pageNumber + 1));
        } else if (pageNumber == 4) {
            menu.setItem(0, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Previous Page").lore(ChatColor.YELLOW + "Page " + (pageNumber - 1)).get(), (m4, e) -> WarlordsShopMenu.openWeaponMenu(player, pageNumber - 1));
        }
        menu.setItem(4, 5, MENU_BACK_PREGAME, (m4, e) -> WarlordsShopMenu.openMainMenu(player));
        menu.openForPlayer(player);
    }

    public static void openArmorMenu(Player player, int pageNumber) {
        boolean onBlueTeam = Warlords.getGameManager().getPlayerGame(player.getUniqueId()).map(g2 -> g2.getPlayerTeam(player.getUniqueId())).orElse(Team.BLUE) == Team.BLUE;
        List<ArmorManager.Helmets> selectedHelmet = ArmorManager.Helmets.getSelected(player);
        List<ArmorManager.ArmorSets> selectedArmorSet = ArmorManager.ArmorSets.getSelected(player);
        Menu menu = new Menu("Armor Sets & Helmets", 54);
        List<ArmorManager.Helmets> helmets = Arrays.asList(ArmorManager.Helmets.values());
        for (int i = (pageNumber - 1) * 8; i < pageNumber * 8 && i < helmets.size(); ++i) {
            ArmorManager.Helmets helmet = helmets.get(i);
            ItemBuilder builder = new ItemBuilder(onBlueTeam ? helmet.itemBlue : helmet.itemRed).name(onBlueTeam ? ChatColor.BLUE + helmet.name : ChatColor.RED + helmet.name).flags(ItemFlag.HIDE_ENCHANTS);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77A cosmetic item for your head.\n\u00a77Each class has a different piece of headgear.");
            lore.add("");
            if (selectedHelmet.contains((Object)helmet)) {
                lore.add(ChatColor.GREEN + ">>> ACTIVE <<<");
                builder.enchant(Enchantment.OXYGEN, 1);
            } else {
                lore.add(ChatColor.YELLOW + "> Click to activate! <");
            }
            builder.lore(lore);
            menu.setItem(i - (pageNumber - 1) * 8 + 1, 2, builder.get(), (m4, e) -> {
                player.sendMessage(ChatColor.YELLOW + "Selected: " + ChatColor.GREEN + helmet.name);
                if (helmet == ArmorManager.Helmets.SIMPLE_MAGE_HELMET || helmet == ArmorManager.Helmets.GREATER_MAGE_HELMET || helmet == ArmorManager.Helmets.MASTERWORK_MAGE_HELMET || helmet == ArmorManager.Helmets.LEGENDARY_MAGE_HELMET) {
                    ArmorManager.Helmets.setSelectedMage(player, helmet);
                } else if (helmet == ArmorManager.Helmets.SIMPLE_WARRIOR_HELMET || helmet == ArmorManager.Helmets.GREATER_WARRIOR_HELMET || helmet == ArmorManager.Helmets.MASTERWORK_WARRIOR_HELMET || helmet == ArmorManager.Helmets.LEGENDARY_WARRIOR_HELMET) {
                    ArmorManager.Helmets.setSelectedWarrior(player, helmet);
                } else if (helmet == ArmorManager.Helmets.SIMPLE_PALADIN_HELMET || helmet == ArmorManager.Helmets.GREATER_PALADIN_HELMET || helmet == ArmorManager.Helmets.MASTERWORK_PALADIN_HELMET || helmet == ArmorManager.Helmets.LEGENDARY_PALADIN_HELMET) {
                    ArmorManager.Helmets.setSelectedPaladin(player, helmet);
                } else if (helmet == ArmorManager.Helmets.SIMPLE_SHAMAN_HELMET || helmet == ArmorManager.Helmets.GREATER_SHAMAN_HELMET || helmet == ArmorManager.Helmets.MASTERWORK_SHAMAN_HELMET || helmet == ArmorManager.Helmets.LEGENDARY_SHAMAN_HELMET) {
                    ArmorManager.Helmets.setSelectedShaman(player, helmet);
                } else if (helmet == ArmorManager.Helmets.SIMPLE_ROGUE_HELMET || helmet == ArmorManager.Helmets.GREATER_ROGUE_HELMET || helmet == ArmorManager.Helmets.MASTERWORK_ROGUE_HELMET || helmet == ArmorManager.Helmets.LEGENDARY_ROGUE_HELMET) {
                    ArmorManager.Helmets.setSelectedRogue(player, helmet);
                }
                ArmorManager.resetArmor(player, Warlords.getPlayerSettings(player.getUniqueId()).getSelectedSpec(), Warlords.getPlayerSettings(player.getUniqueId()).getWantedTeam());
                WarlordsShopMenu.openArmorMenu(player, pageNumber);
                if (DatabaseManager.playerService == null) {
                    return;
                }
                List<ArmorManager.Helmets> selectedHelmets = ArmorManager.Helmets.getSelected(player);
                DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(player.getUniqueId());
                databasePlayer.getMage().setHelmet(selectedHelmets.get(0));
                databasePlayer.getWarrior().setHelmet(selectedHelmets.get(1));
                databasePlayer.getPaladin().setHelmet(selectedHelmets.get(2));
                databasePlayer.getShaman().setHelmet(selectedHelmets.get(3));
                databasePlayer.getRogue().setHelmet(selectedHelmets.get(4));
                DatabaseManager.updatePlayerAsync(databasePlayer);
            });
        }
        List<ArmorManager.ArmorSets> armorSets = Arrays.asList(ArmorManager.ArmorSets.values());
        int xPosition = 1;
        for (int i = (pageNumber - 1) * 6; i < pageNumber * 6 && (pageNumber != 3 || i != 15); ++i) {
            ArmorManager.ArmorSets armorSet = armorSets.get(i);
            ItemBuilder builder = new ItemBuilder(i % 3 == 0 ? ArmorManager.ArmorSets.applyColor(armorSet.itemBlue, onBlueTeam) : armorSet.itemBlue).name(onBlueTeam ? ChatColor.BLUE + armorSet.name : ChatColor.RED + armorSet.name).flags(ItemFlag.HIDE_ENCHANTS);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Cosmetic armor to complement your hat.\n\u00a77The armor pieces are the same for each class.");
            lore.add("");
            if (selectedArmorSet.contains((Object)armorSet)) {
                lore.add(ChatColor.GREEN + ">>> ACTIVE <<<");
                builder.enchant(Enchantment.OXYGEN, 1);
            } else {
                lore.add(ChatColor.YELLOW + "> Click to activate! <");
            }
            builder.lore(lore);
            menu.setItem(xPosition, 3, builder.get(), (m4, e) -> {
                player.sendMessage(ChatColor.YELLOW + "Selected: " + ChatColor.GREEN + armorSet.name);
                if (armorSet == ArmorManager.ArmorSets.SIMPLE_CHESTPLATE_MAGE || armorSet == ArmorManager.ArmorSets.GREATER_CHESTPLATE_MAGE || armorSet == ArmorManager.ArmorSets.MASTERWORK_CHESTPLATE_MAGE) {
                    ArmorManager.ArmorSets.setSelectedMage(player, armorSet);
                } else if (armorSet == ArmorManager.ArmorSets.SIMPLE_CHESTPLATE_WARRIOR || armorSet == ArmorManager.ArmorSets.GREATER_CHESTPLATE_WARRIOR || armorSet == ArmorManager.ArmorSets.MASTERWORK_CHESTPLATE_WARRIOR) {
                    ArmorManager.ArmorSets.setSelectedWarrior(player, armorSet);
                } else if (armorSet == ArmorManager.ArmorSets.SIMPLE_CHESTPLATE_PALADIN || armorSet == ArmorManager.ArmorSets.GREATER_CHESTPLATE_PALADIN || armorSet == ArmorManager.ArmorSets.MASTERWORK_CHESTPLATE_PALADIN) {
                    ArmorManager.ArmorSets.setSelectedPaladin(player, armorSet);
                } else if (armorSet == ArmorManager.ArmorSets.SIMPLE_CHESTPLATE_SHAMAN || armorSet == ArmorManager.ArmorSets.GREATER_CHESTPLATE_SHAMAN || armorSet == ArmorManager.ArmorSets.MASTERWORK_CHESTPLATE_SHAMAN) {
                    ArmorManager.ArmorSets.setSelectedShaman(player, armorSet);
                } else if (armorSet == ArmorManager.ArmorSets.SIMPLE_CHESTPLATE_ROGUE || armorSet == ArmorManager.ArmorSets.GREATER_CHESTPLATE_ROGUE || armorSet == ArmorManager.ArmorSets.MASTERWORK_CHESTPLATE_ROGUE) {
                    ArmorManager.ArmorSets.setSelectedRogue(player, armorSet);
                }
                WarlordsShopMenu.openArmorMenu(player, pageNumber);
                if (DatabaseManager.playerService == null) {
                    return;
                }
                List<ArmorManager.ArmorSets> armorSetsList = ArmorManager.ArmorSets.getSelected(player);
                DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(player.getUniqueId());
                databasePlayer.getMage().setArmor(armorSetsList.get(0));
                databasePlayer.getWarrior().setArmor(armorSetsList.get(1));
                databasePlayer.getPaladin().setArmor(armorSetsList.get(2));
                databasePlayer.getShaman().setArmor(armorSetsList.get(3));
                databasePlayer.getRogue().setArmor(armorSetsList.get(4));
                DatabaseManager.updatePlayerAsync(databasePlayer);
            });
            if (xPosition == 3) {
                xPosition += 2;
                continue;
            }
            ++xPosition;
        }
        if (pageNumber == 1) {
            menu.setItem(8, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Next Page").lore(ChatColor.YELLOW + "Page " + (pageNumber + 1)).get(), (m4, e) -> WarlordsShopMenu.openArmorMenu(player, pageNumber + 1));
        } else if (pageNumber == 2) {
            menu.setItem(8, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Next Page").lore(ChatColor.YELLOW + "Page " + (pageNumber + 1)).get(), (m4, e) -> WarlordsShopMenu.openArmorMenu(player, pageNumber + 1));
            menu.setItem(0, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Previous Page").lore(ChatColor.YELLOW + "Page " + (pageNumber - 1)).get(), (m4, e) -> WarlordsShopMenu.openArmorMenu(player, pageNumber - 1));
        } else if (pageNumber == 3) {
            menu.setItem(0, 5, new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Previous Page").lore(ChatColor.YELLOW + "Page " + (pageNumber - 1)).get(), (m4, e) -> WarlordsShopMenu.openArmorMenu(player, pageNumber - 1));
        }
        menu.setItem(4, 5, MENU_BACK_PREGAME, (m4, e) -> WarlordsShopMenu.openMainMenu(player));
        menu.openForPlayer(player);
    }

    public static void openSettingsMenu(Player player) {
        Settings.Powerup selectedPowerup = Settings.Powerup.getSelected(player);
        Settings.HotkeyMode selectedHotkeyMode = Settings.HotkeyMode.getSelected(player);
        Menu menu = new Menu("Settings", 36);
        menu.setItem(3, 1, selectedHotkeyMode.item, (m4, e) -> {
            player.sendMessage(selectedHotkeyMode == Settings.HotkeyMode.NEW_MODE ? ChatColor.GREEN + "Hotkey Mode " + ChatColor.AQUA + "Classic " + ChatColor.GREEN + "enabled." : ChatColor.GREEN + "Hotkey Mode " + ChatColor.YELLOW + "NEW " + ChatColor.GREEN + "enabled.");
            Settings.HotkeyMode.setSelected(player, selectedHotkeyMode == Settings.HotkeyMode.NEW_MODE ? Settings.HotkeyMode.CLASSIC_MODE : Settings.HotkeyMode.NEW_MODE);
            WarlordsShopMenu.openSettingsMenu(player);
        });
        menu.setItem(1, 1, MENU_SETTINGS_PARTICLE_QUALITY, (m4, e) -> WarlordsShopMenu.openParticleQualityMenu(player));
        menu.setItem(4, 3, MENU_BACK_PREGAME, (m4, e) -> WarlordsShopMenu.openMainMenu(player));
        menu.openForPlayer(player);
    }

    public static void openParticleQualityMenu(Player player) {
        Settings.ParticleQuality selectedParticleQuality = Settings.ParticleQuality.getSelected(player);
        Menu menu = new Menu("Particle Quality", 36);
        Settings.ParticleQuality[] particleQualities = Settings.ParticleQuality.values();
        for (int i = 0; i < particleQualities.length; ++i) {
            Settings.ParticleQuality particleQuality = particleQualities[i];
            menu.setItem(i + 3, 1, new ItemBuilder(particleQuality.item).lore(particleQuality.description, "", selectedParticleQuality == particleQuality ? ChatColor.GREEN + "SELECTED" : ChatColor.YELLOW + "Click to select!").flags(ItemFlag.HIDE_ENCHANTS).get(), (m4, e) -> {
                Bukkit.getServer().dispatchCommand((CommandSender)player, "pq " + particleQuality.name());
                WarlordsShopMenu.openParticleQualityMenu(player);
            });
        }
        menu.setItem(4, 3, MENU_BACK_PREGAME, (m4, e) -> WarlordsShopMenu.openMainMenu(player));
        menu.openForPlayer(player);
    }

    public static void openTeamMenu(Player player) {
        Team selectedTeam = Warlords.getPlayerSettings(player.getUniqueId()).getWantedTeam();
        Menu menu = new Menu("Team Selector", 36);
        ArrayList<Team> values = new ArrayList<Team>(Arrays.asList(Team.values()));
        for (int i = 0; i < values.size(); ++i) {
            Team team = (Team)((Object)values.get(i));
            ItemBuilder builder = new ItemBuilder(team.getItem()).name(team.teamColor() + team.getName()).flags(ItemFlag.HIDE_ENCHANTS);
            ArrayList<String> lore = new ArrayList<String>();
            if (team == selectedTeam) {
                lore.add(ChatColor.GREEN + "Currently selected!");
                builder.enchant(Enchantment.OXYGEN, 1);
            } else {
                lore.add(ChatColor.YELLOW + "Click to select!");
            }
            builder.lore(lore);
            menu.setItem(4 - values.size() % 2 + i * 2 - 1, 1, builder.get(), (m4, e) -> {
                if (selectedTeam != team) {
                    player.sendMessage(ChatColor.GREEN + "You have joined the " + team.teamColor() + team.getName() + ChatColor.GREEN + " team!");
                    Optional<Game> playerGame = Warlords.getGameManager().getPlayerGame(player.getUniqueId());
                    if (playerGame.isPresent()) {
                        Game game = playerGame.get();
                        Team oldTeam = game.getPlayerTeam(player.getUniqueId());
                        game.setPlayerTeam((OfflinePlayer)player, team);
                        LobbyLocationMarker randomLobbyLocation = LobbyLocationMarker.getRandomLobbyLocation(game, team);
                        if (randomLobbyLocation != null) {
                            Location teleportDestination = MapSymmetryMarker.getSymmetry(game).getOppositeLocation(game, oldTeam, team, player.getLocation(), randomLobbyLocation.getLocation());
                            player.teleport(teleportDestination);
                            Warlords.setRejoinPoint(player.getUniqueId(), teleportDestination);
                        }
                    }
                    ArmorManager.resetArmor(player, Warlords.getPlayerSettings(player.getUniqueId()).getSelectedSpec(), team);
                    Warlords.getPlayerSettings(player.getUniqueId()).setWantedTeam(team);
                }
                WarlordsShopMenu.openTeamMenu(player);
            });
        }
        menu.setItem(4, 3, Menu.MENU_CLOSE, Menu.ACTION_CLOSE_MENU);
        menu.openForPlayer(player);
    }

    public static void openLobbyAbilityMenu(Player player) {
        Menu menu = new Menu("Class Information", 9);
        PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
        Specializations selectedSpec = playerSettings.getSelectedSpec();
        AbstractPlayerClass apc = selectedSpec.create.get();
        ItemBuilder icon = new ItemBuilder(selectedSpec.specType.itemStack);
        icon.name(ChatColor.GREEN + selectedSpec.name);
        icon.lore(selectedSpec.description, "", "\u00a76Specialization Stats:", "", "\u00a77Health: \u00a7a" + apc.getMaxHealth(), "\u00a77Energy: \u00a7a" + apc.getMaxEnergy() + " \u00a77/ \u00a7a+" + apc.getEnergyPerSec() + " \u00a77per sec \u00a77/ \u00a7a+" + apc.getEnergyOnHit() + " \u00a77per hit", "", selectedSpec == Specializations.APOTHECARY ? "\u00a77Speed: \u00a7e10%" : null, apc.getDamageResistance() == 0 ? "\u00a77Damage Reduction: \u00a7cNone" : "\u00a77Damage Reduction: \u00a7e" + apc.getDamageResistance() + "%");
        SkillBoosts selectedBoost = playerSettings.getSkillBoostForClass();
        if (selectedBoost != null) {
            if (apc.getWeapon().getClass() == selectedBoost.ability) {
                apc.getWeapon().boostSkill(selectedBoost, apc);
            } else if (apc.getRed().getClass() == selectedBoost.ability) {
                apc.getRed().boostSkill(selectedBoost, apc);
            } else if (apc.getPurple().getClass() == selectedBoost.ability) {
                apc.getPurple().boostSkill(selectedBoost, apc);
            } else if (apc.getBlue().getClass() == selectedBoost.ability) {
                apc.getBlue().boostSkill(selectedBoost, apc);
            } else if (apc.getOrange().getClass() == selectedBoost.ability) {
                apc.getOrange().boostSkill(selectedBoost, apc);
            }
        }
        apc.getWeapon().updateDescription(player);
        apc.getRed().updateDescription(player);
        apc.getPurple().updateDescription(player);
        apc.getBlue().updateDescription(player);
        apc.getOrange().updateDescription(player);
        menu.setItem(0, icon.get(), Menu.ACTION_DO_NOTHING);
        menu.setItem(2, apc.getWeapon().getItem(playerSettings.getWeaponSkins().getOrDefault((Object)((Object)selectedSpec), (Weapons)Weapons.FELFLAME_BLADE).item), Menu.ACTION_DO_NOTHING);
        menu.setItem(3, apc.getRed().getItem(new ItemStack(Material.INK_SACK, 1, 1)), Menu.ACTION_DO_NOTHING);
        menu.setItem(4, apc.getPurple().getItem(new ItemStack(Material.GLOWSTONE_DUST)), Menu.ACTION_DO_NOTHING);
        menu.setItem(5, apc.getBlue().getItem(new ItemStack(Material.INK_SACK, 1, 10)), Menu.ACTION_DO_NOTHING);
        menu.setItem(6, apc.getOrange().getItem(new ItemStack(Material.INK_SACK, 1, 14)), Menu.ACTION_DO_NOTHING);
        menu.setItem(8, MENU_BACK_PREGAME, (m4, e) -> WarlordsShopMenu.openMainMenu(player));
        menu.openForPlayer(player);
    }

    private static double map(double value, double min2, double max) {
        return value * (max - min2) + min2;
    }

    public static void openArcadeMenu(Player player) {
        Menu menu = new Menu("Mini Games", 36);
        ItemBuilder icon = new ItemBuilder(Material.GOLD_INGOT);
        icon.name(ChatColor.GREEN + "Weapon Roller");
        icon.lore("\u00a77Is RNG with you today?");
        menu.setItem(3, 1, icon.get(), (m4, e) -> {
            double difficulty = 1.0;
            double base = random.nextDouble() * (1.0 - difficulty);
            double meleeDamageMin = random.nextDouble() * difficulty + base;
            double meleeDamageMax = random.nextDouble() * difficulty + base;
            double critChance = random.nextDouble() * difficulty + base;
            double critMultiplier = random.nextDouble() * difficulty + base;
            double skillBoost = random.nextDouble() * difficulty + base;
            double health = random.nextDouble() * difficulty + base;
            double energy = random.nextDouble() * difficulty + base;
            double cooldown = random.nextDouble() * difficulty + base;
            double speed = random.nextDouble() * difficulty + base;
            double score = (meleeDamageMin + meleeDamageMax + critChance + critMultiplier + skillBoost + health + energy + cooldown + speed) / 9.0;
            meleeDamageMin = WarlordsShopMenu.map(meleeDamageMin, 122.0, 132.0);
            meleeDamageMax = WarlordsShopMenu.map(meleeDamageMax, 166.0, 179.0);
            critChance = WarlordsShopMenu.map(critChance, 15.0, 25.0);
            critMultiplier = WarlordsShopMenu.map(critMultiplier, 180.0, 200.0);
            skillBoost = WarlordsShopMenu.map(skillBoost, 13.0, 20.0);
            health = WarlordsShopMenu.map(health, 500.0, 800.0);
            energy = WarlordsShopMenu.map(energy, 30.0, 35.0);
            cooldown = WarlordsShopMenu.map(cooldown, 7.0, 13.0);
            speed = WarlordsShopMenu.map(speed, 7.0, 13.0);
            if (meleeDamageMin > meleeDamageMax) {
                double temp = meleeDamageMin;
                meleeDamageMin = meleeDamageMax;
                meleeDamageMax = temp;
            }
            String displayScore = "\u00a77Your weapon score is \u00a7a" + NumberFormat.formatOptionalTenths(score * 100.0);
            PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
            Specializations selectedSpec = playerSettings.getSelectedSpec();
            AbstractPlayerClass apc = selectedSpec.create.get();
            ItemStack weapon = new ItemStack(Weapons.FELFLAME_BLADE.item);
            ItemMeta weaponMeta = weapon.getItemMeta();
            weaponMeta.setDisplayName("\u00a76Warlord's Felflame of the " + apc.getWeapon().getName());
            ArrayList<String> weaponLore = new ArrayList<String>();
            weaponLore.add("\u00a77Damage: \u00a7c" + Math.round(meleeDamageMin) + "\u00a77-\u00a7c" + Math.round(meleeDamageMax));
            weaponLore.add("\u00a77Crit Chance: \u00a7c" + Math.round(critChance) + "%");
            weaponLore.add("\u00a77Crit Multiplier: \u00a7c" + Math.round(critMultiplier) + "%");
            weaponLore.add("");
            String classNamePath = apc.getClass().getGenericSuperclass().getTypeName();
            weaponLore.add("\u00a7a" + classNamePath.substring(classNamePath.indexOf("Abstract") + 8) + " (" + apc.getClass().getSimpleName() + "):");
            weaponLore.add("\u00a7aIncreases the damage you");
            weaponLore.add("\u00a7adeal with " + apc.getWeapon().getName() + " by \u00a7c" + Math.round(skillBoost) + "%");
            weaponLore.add("");
            weaponLore.add("\u00a77Health: \u00a7a+" + Math.round(health));
            weaponLore.add("\u00a77Max Energy: \u00a7a+" + Math.round(energy));
            weaponLore.add("\u00a77Cooldown Reduction: \u00a7a+" + Math.round(cooldown) + "%");
            weaponLore.add("\u00a77Speed: \u00a7a+" + Math.round(speed) + "%");
            weaponLore.add("");
            weaponLore.add("\u00a73CRAFTED");
            weaponLore.add("");
            weaponLore.add(displayScore);
            weaponLore.add("");
            weaponLore.add("\u00a77Left-click to roll again!");
            weaponMeta.setLore(weaponLore);
            weapon.setItemMeta(weaponMeta);
            m4.getInventory().setItem(e.getRawSlot(), weapon);
            if (score > 0.85) {
                Bukkit.broadcastMessage((String)("\u00a76" + player.getDisplayName() + " \u00a7frolled a weapon with a total score of \u00a76" + NumberFormat.formatOptionalTenths(score * 100.0) + "\u00a7f!"));
            }
            if (score < 0.15) {
                Bukkit.broadcastMessage((String)("\u00a76" + player.getDisplayName() + " \u00a7frolled a weapon with a total score of \u00a7c" + NumberFormat.formatOptionalTenths(score * 100.0) + "\u00a7f!"));
            }
        });
        ItemBuilder icon2 = new ItemBuilder(Material.SULPHUR);
        icon2.name(ChatColor.GREEN + "Skin Shard Roller");
        icon2.lore("\u00a77Is RNG with you to give everyone a new awesome skin?", "", "\u00a77Left-click to roll 10 skin shards!");
        menu.setItem(5, 1, icon2.get(), (m4, e) -> {
            Long weaponCooldown = openWeaponCooldown.get(player.getUniqueId());
            EnumMap<WeaponsRarity, Integer> foundWeaponCount = new EnumMap<WeaponsRarity, Integer>(WeaponsRarity.class);
            for (WeaponsRarity rarity : WeaponsRarity.values()) {
                foundWeaponCount.put(rarity, 0);
            }
            if (Bukkit.getOnlinePlayers().size() >= 16) {
                if (weaponCooldown == null || weaponCooldown < System.currentTimeMillis()) {
                    openWeaponCooldown.put(player.getUniqueId(), System.currentTimeMillis() + 480000L);
                    player.playSound(player.getLocation(), Sound.NOTE_PLING, 1.0f, 2.0f);
                    for (int i = 0; i < 10; ++i) {
                        String legendaryName = legendaryNames[random.nextInt(legendaryNames.length)];
                        String mythicName = mythicNames[random.nextInt(mythicNames.length)];
                        double chance = random.nextDouble() * 100.0;
                        PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
                        Specializations selectedSpec = playerSettings.getSelectedSpec();
                        WeaponsRarity rarity = chance < 96.3 ? WeaponsRarity.RARE : (chance < 99.3 ? WeaponsRarity.EPIC : (chance < 99.89999999999999 ? WeaponsRarity.LEGENDARY : WeaponsRarity.MYTHIC));
                        foundWeaponCount.compute(rarity, (key, value) -> value == null ? 1 : value + 1);
                        List<Weapons> weapons = weaponByRarity.get((Object)rarity);
                        Weapons weapon = weapons.get(random.nextInt(weapons.size()));
                        String message = rarity.getWeaponChatColor() + legendaryName + "'s " + weapon.getName() + " of the " + selectedSpec.name;
                        String mythicMessage = rarity.getWeaponChatColor() + "\u00a7l" + mythicName + " " + weapon.getName() + " of the " + selectedSpec.name;
                        if (rarity == WeaponsRarity.EPIC) {
                            Bukkit.broadcastMessage((String)(ChatColor.AQUA + player.getDisplayName() + " \u00a7fgot lucky and found " + message));
                        }
                        if (rarity == WeaponsRarity.LEGENDARY) {
                            Utils.playGlobalSound(player.getLocation(), "legendaryfind", 1.0f, 1.0f);
                            Bukkit.broadcastMessage((String)(ChatColor.AQUA + player.getDisplayName() + " \u00a7fgot lucky and found " + message));
                            player.getWorld().spigot().strikeLightningEffect(player.getLocation(), false);
                        }
                        if (rarity == WeaponsRarity.MYTHIC) {
                            Utils.playGlobalSound(player.getLocation(), "legendaryfind", 500.0f, 0.8f);
                            Utils.playGlobalSound(player.getLocation(), Sound.ENDERDRAGON_GROWL, 500.0f, 0.8f);
                            Bukkit.broadcastMessage((String)(ChatColor.AQUA + player.getDisplayName() + " \u00a7fgot lucky and found " + mythicMessage));
                            for (int j = 0; j < 10; ++j) {
                                player.getWorld().spigot().strikeLightningEffect(player.getLocation(), false);
                            }
                        }
                        if (!weapon.isUnlocked) {
                            weapon.isUnlocked = true;
                            Warlords.getInstance().saveWeaponConfig();
                            continue;
                        }
                        if (rarity != WeaponsRarity.MYTHIC) continue;
                    }
                    player.sendMessage("");
                    player.sendMessage("\u00a77You found:");
                    player.sendMessage("\u00a77Rare: \u00a79" + foundWeaponCount.get((Object)WeaponsRarity.RARE));
                    player.sendMessage("\u00a77Epic: \u00a75" + foundWeaponCount.get((Object)WeaponsRarity.EPIC));
                    player.sendMessage("\u00a77Legendary: \u00a76" + foundWeaponCount.get((Object)WeaponsRarity.LEGENDARY));
                    player.sendMessage("\u00a77Mythic: \u00a7c" + foundWeaponCount.get((Object)WeaponsRarity.MYTHIC));
                } else {
                    long remainingTime = (weaponCooldown - System.currentTimeMillis()) / 1000L;
                    long remainingTimeinMinutes = remainingTime / 60L;
                    player.sendMessage(ChatColor.RED + "Please wait " + (remainingTime > 60L ? remainingTimeinMinutes + " minutes" : remainingTime + " seconds") + " before opening skin shards again!");
                }
            } else {
                player.sendMessage(ChatColor.RED + "There must be at least 16 players online to roll skin shards!");
            }
        });
        menu.setItem(4, 3, MENU_BACK_PREGAME, (m4, e) -> WarlordsShopMenu.openMainMenu(player));
        menu.openForPlayer(player);
    }
}

