/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.menu.debugmenu;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.menu.Menu;
import com.ebicep.warlords.menu.debugmenu.DebugMenuGameOptions;
import com.ebicep.warlords.menu.debugmenu.DebugMenuPlayerOptions;
import com.ebicep.warlords.menu.debugmenu.DebugMenuTeamOptions;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DebugMenu {
    public static void openDebugMenu(final Player player) {
        Menu menu = new Menu("Debug Options", 36);
        LinkedHashMap<ItemStack, BiConsumer<Menu, InventoryClickEvent>> items = new LinkedHashMap<ItemStack, BiConsumer<Menu, InventoryClickEvent>>();
        items.put(new ItemBuilder(Material.ENDER_PORTAL_FRAME).name(ChatColor.GREEN + "Game Options").get(), (m4, e) -> DebugMenuGameOptions.openGameMenu(player));
        WarlordsPlayer warlordsPlayer = Warlords.getPlayer(player);
        if (warlordsPlayer != null) {
            final Game game = warlordsPlayer.getGame();
            items.put(new ItemBuilder(Material.BOOK).name(ChatColor.GREEN + "Game - " + game.getGameId()).lore(ChatColor.DARK_GRAY + "Map - " + ChatColor.RED + game.getMap().getMapName(), ChatColor.DARK_GRAY + "GameMode - " + ChatColor.RED + (Object)((Object)game.getGameMode()), ChatColor.DARK_GRAY + "Addons - " + ChatColor.RED + game.getAddons(), ChatColor.DARK_GRAY + "Players - " + ChatColor.RED + game.playersCount()).enchant(Enchantment.OXYGEN, 1).flags(ItemFlag.HIDE_ENCHANTS).get(), (m4, e) -> DebugMenuGameOptions.GamesMenu.openGameEditorMenu(player, game));
            items.put(new ItemBuilder(Warlords.getHead(player)).name(ChatColor.GREEN + "Player Options").get(), (m4, e) -> DebugMenuPlayerOptions.openPlayerMenu(player, Warlords.getPlayer(player)));
            items.put(new ItemBuilder(Material.NOTE_BLOCK).name(ChatColor.GREEN + "Team Options").get(), (m4, e) -> {
                DebugMenuTeamOptions.openTeamMenu(player, game);
                new BukkitRunnable(){

                    public void run() {
                        if (player.getOpenInventory().getTopInventory().getName().equals("Team Options")) {
                            DebugMenuTeamOptions.openTeamMenu(player, game);
                        } else {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)Warlords.getInstance(), 20L, 20L);
            });
        }
        ArrayList itemsArray = new ArrayList(items.keySet());
        for (int i = 0; i < items.size(); ++i) {
            menu.setItem(i + 1, 1, (ItemStack)itemsArray.get(i), (BiConsumer)items.get(itemsArray.get(i)));
        }
        menu.setItem(4, 3, Menu.MENU_CLOSE, Menu.ACTION_CLOSE_MENU);
        menu.openForPlayer(player);
    }
}

