/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.menu;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.menu.AbstractMenuBase;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Menu
extends AbstractMenuBase {
    public static final BiConsumer<Menu, InventoryClickEvent> ACTION_CLOSE_MENU = (m4, e) -> new BukkitRunnable((InventoryClickEvent)e){
        final /* synthetic */ InventoryClickEvent val$e;
        {
            this.val$e = inventoryClickEvent;
        }

        public void run() {
            this.val$e.getWhoClicked().closeInventory();
        }
    }.runTaskLater((Plugin)Warlords.getInstance(), 1L);
    public static final BiConsumer<Menu, InventoryClickEvent> ACTION_DO_NOTHING = (m4, e) -> {};
    private final Inventory inventory;
    private final BiConsumer<Menu, InventoryClickEvent>[] onClick = new BiConsumer[54];
    private int nextItemIndex = 0;
    public static final ItemStack MENU_CLOSE = new ItemBuilder(Material.BARRIER).name(ChatColor.RED + "Close").get();
    public static final ItemStack MENU_BACK = new ItemBuilder(Material.ARROW).name(ChatColor.GREEN + "Back").get();

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    public Menu(String name, int size) {
        this.inventory = Bukkit.createInventory(null, (int)size, (String)name.substring(0, Math.min(name.length(), 32)));
    }

    public void setItem(int x, int y, ItemStack item, BiConsumer<Menu, InventoryClickEvent> clickHandler) {
        this.setItem(x + y * 9, item, clickHandler);
    }

    public void setItem(int index, ItemStack item, BiConsumer<Menu, InventoryClickEvent> clickHandler) {
        this.inventory.setItem(index, item);
        this.onClick[index] = clickHandler;
        if (++this.nextItemIndex >= this.inventory.getSize()) {
            this.nextItemIndex = 0;
        }
    }

    public void removeItem(int x, int y) {
        this.removeItem(x + y * 9);
    }

    public void removeItem(int index) {
        this.inventory.setItem(index, null);
        this.onClick[index] = null;
    }

    public void addItem(ItemStack item, BiConsumer<Menu, InventoryClickEvent> clickHandler) {
        this.setItem(this.nextItemIndex, item, clickHandler);
    }

    @Override
    public void doOnClickAction(InventoryClickEvent event) {
        if (event.getClickedInventory() != null && event.getClickedInventory().equals(this.inventory) && event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR && event.getRawSlot() < this.inventory.getSize()) {
            event.setCancelled(true);
            this.onClick[event.getRawSlot()].accept(this, event);
        }
    }
}

