/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.state;

import com.ebicep.jda.BotManager;
import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.PreGameItemOption;
import com.ebicep.warlords.game.option.marker.LobbyLocationMarker;
import com.ebicep.warlords.game.state.State;
import com.ebicep.warlords.game.state.SyncTimerState;
import com.ebicep.warlords.game.state.TimerDebugAble;
import com.ebicep.warlords.player.ArmorManager;
import com.ebicep.warlords.player.CustomScoreboard;
import com.ebicep.warlords.player.ExperienceManager;
import com.ebicep.warlords.player.PlayerSettings;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.sr.SRCalculator;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.ebicep.warlords.util.warlords.Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class PreLobbyState
implements State,
TimerDebugAble {
    public static final String WARLORDS_DATABASE_MESSAGEFEED = "warlords.database.messagefeed";
    private final Game game;
    private final Map<UUID, TeamPreference> teamPreferences = new HashMap<UUID, TeamPreference>();
    private int timer = 0;
    private int maxTimer = 0;
    private boolean timerHasBeenSkipped = false;
    private final PreGameItemOption[] items = new PreGameItemOption[9];

    public PreLobbyState(Game game) {
        this.game = game;
    }

    @Override
    public void begin() {
        this.maxTimer = this.game.getMap().getLobbyCountdown();
        this.resetTimer();
        this.game.setAcceptsPlayers(true);
        this.game.setAcceptsSpectators(false);
        for (Option option : this.game.getOptions()) {
            PreGameItemOption preGameItemOption;
            if (!(option instanceof PreGameItemOption)) continue;
            this.items[preGameItemOption.getSlot()] = preGameItemOption = (PreGameItemOption)option;
        }
    }

    public boolean hasEnoughPlayers() {
        int players = this.game.playersCount();
        return players >= this.game.getMinPlayers();
    }

    @Override
    public State run() {
        if (this.hasEnoughPlayers() || this.timerHasBeenSkipped) {
            this.timerHasBeenSkipped = false;
            if (this.timer % 20 == 0) {
                int time = this.timer / 20;
                this.game.forEachOnlinePlayerWithoutSpectators((player, team) -> {
                    this.giveLobbyScoreboard(false, (Player)player);
                    player.setAllowFlight(false);
                });
                if (time == 30) {
                    this.game.forEachOnlinePlayerWithoutSpectators((player, team) -> {
                        ChatUtils.sendMessage(player, false, ChatColor.YELLOW + "The game starts in " + ChatColor.GREEN + "30 " + ChatColor.YELLOW + "seconds!");
                        player.playSound(player.getLocation(), Sound.NOTE_STICKS, 1.0f, 1.0f);
                    });
                } else if (time == 20) {
                    this.game.forEachOnlinePlayerWithoutSpectators((player, team) -> {
                        ChatUtils.sendMessage(player, false, ChatColor.YELLOW + "The game starts in 20 seconds!");
                        player.playSound(player.getLocation(), Sound.NOTE_STICKS, 1.0f, 1.0f);
                    });
                } else if (time == 10) {
                    this.game.forEachOnlinePlayerWithoutSpectators((player, team) -> {
                        ChatUtils.sendMessage(player, false, ChatColor.YELLOW + "The game starts in " + ChatColor.GOLD + "10 " + ChatColor.YELLOW + "seconds!");
                        player.playSound(player.getLocation(), Sound.NOTE_STICKS, 1.0f, 1.0f);
                    });
                } else if (time <= 5 && time != 0) {
                    this.game.forEachOnlinePlayerWithoutSpectators((player, team) -> {
                        String s2 = time == 1 ? "!" : "s!";
                        ChatUtils.sendMessage(player, false, ChatColor.YELLOW + "The game starts in " + ChatColor.RED + time + ChatColor.YELLOW + " second" + s2);
                        player.playSound(player.getLocation(), Sound.NOTE_STICKS, 1.0f, 1.0f);
                    });
                } else if (time == 0) {
                    this.game.forEachOnlinePlayerWithoutSpectators((player, team) -> {
                        player.playSound(player.getLocation(), "gamestart", 1.0f, 1.0f);
                        player.setAllowFlight(false);
                    });
                }
            }
            if (this.timer <= 0) {
                if (!this.game.getAddons().contains((Object)GameAddon.PRIVATE_GAME)) {
                    HashMap<Specializations, List> playerSpecs;
                    HashMap<Player, Team> teams;
                    int redSR;
                    int sameTeamPartyLimit = 2;
                    HashMap<Team, List<Player>> partyMembers = new HashMap<Team, List<Player>>(){
                        {
                            this.put(Team.BLUE, new ArrayList());
                            this.put(Team.RED, new ArrayList());
                        }
                    };
                    this.game.onlinePlayersWithoutSpectators().filter(e -> e.getValue() != null).forEach(e -> {
                        Player player = (Player)e.getKey();
                        Team team = (Team)((Object)((Object)e.getValue()));
                        if (partyMembers.values().stream().anyMatch(list -> list.contains(player))) {
                            return;
                        }
                        Warlords.partyManager.getPartyFromAny(player.getUniqueId()).ifPresent(party -> {
                            List partyPlayersInGame = party.getAllPartyPeoplePlayerOnline().stream().filter(p -> this.game.getPlayers().containsKey(p.getUniqueId())).collect(Collectors.toList());
                            if (partyPlayersInGame.size() > sameTeamPartyLimit) {
                                return;
                            }
                            List bluePlayers = (List)partyMembers.get((Object)Team.BLUE);
                            List redPlayers = (List)partyMembers.get((Object)Team.RED);
                            ArrayList partyPlayers = new ArrayList(partyPlayersInGame);
                            Collections.shuffle(partyPlayers);
                            int teamSizeDiff = Math.abs(bluePlayers.size() - redPlayers.size());
                            if (teamSizeDiff > partyPlayers.size()) {
                                if (bluePlayers.size() > redPlayers.size()) {
                                    bluePlayers.addAll(partyPlayers);
                                } else {
                                    redPlayers.addAll(partyPlayers);
                                }
                            } else {
                                bluePlayers.addAll(partyPlayers);
                            }
                        });
                    });
                    HashMap playersSR = new HashMap();
                    SRCalculator.playersSR.forEach((key, value1) -> playersSR.put(key.getUuid(), value1 == null ? 500 : value1));
                    HashMap<Player, Team> bestTeam = new HashMap<Player, Team>();
                    int bestBlueSR = 0;
                    int bestRedSR = 0;
                    int bestTeamSRDifference = Integer.MAX_VALUE;
                    int maxSRDiff = 200;
                    for (int i = 0; i < 5000; ++i) {
                        int redPlayers;
                        HashMap<Player, Team> teams2 = new HashMap<Player, Team>();
                        HashMap<Specializations, List> playerSpecs2 = new HashMap<Specializations, List>();
                        this.game.onlinePlayersWithoutSpectators().filter(e -> e.getValue() != null).forEach(e -> {
                            Player player = (Player)e.getKey();
                            Team team = (Team)((Object)((Object)e.getValue()));
                            PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
                            playerSpecs2.computeIfAbsent(playerSettings.getSelectedSpec(), v -> new ArrayList()).add(player);
                        });
                        ArrayList playersLeft = new ArrayList();
                        playerSpecs2.forEach((classes, playerList) -> {
                            int amountOfTargetSpecsOnBlue = (int)teams2.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.BLUE && Warlords.getPlayerSettings(((Player)playerTeamEntry.getKey()).getUniqueId()).getSelectedSpec() == classes).count();
                            int amountOfTargetSpecsOnRed = (int)teams2.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.RED && Warlords.getPlayerSettings(((Player)playerTeamEntry.getKey()).getUniqueId()).getSelectedSpec() == classes).count();
                            for (Player player : playerList) {
                                if (amountOfTargetSpecsOnBlue > amountOfTargetSpecsOnRed) {
                                    teams2.put(player, Team.RED);
                                    ++amountOfTargetSpecsOnRed;
                                    continue;
                                }
                                if (amountOfTargetSpecsOnRed > amountOfTargetSpecsOnBlue) {
                                    teams2.put(player, Team.BLUE);
                                    ++amountOfTargetSpecsOnBlue;
                                    continue;
                                }
                                playersLeft.add(player);
                            }
                        });
                        int blueSR = teams2.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.BLUE).mapToInt(value -> playersSR.getOrDefault(((Player)value.getKey()).getUniqueId().toString(), 500)).sum();
                        redSR = teams2.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.RED).mapToInt(value -> playersSR.getOrDefault(((Player)value.getKey()).getUniqueId().toString(), 500)).sum();
                        for (Player player2 : playersLeft) {
                            if (redSR > blueSR) {
                                teams2.put(player2, Team.BLUE);
                                blueSR += playersSR.getOrDefault(player2.getUniqueId().toString(), 500).intValue();
                                continue;
                            }
                            teams2.put(player2, Team.RED);
                            redSR += playersSR.getOrDefault(player2.getUniqueId().toString(), 500).intValue();
                        }
                        int bluePlayers = (int)teams2.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.BLUE).count();
                        if ((bluePlayers + (redPlayers = (int)teams2.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.RED).count())) % 2 != 0) {
                            int srDiffRed = Math.abs(redSR - 3500 - blueSR);
                            int srDiffBlue = Math.abs(blueSR - 3500 - redSR);
                            if (bluePlayers > redPlayers && srDiffRed > maxSRDiff && srDiffRed > 0 || redPlayers > bluePlayers && srDiffBlue > maxSRDiff && srDiffBlue > 0) {
                                ++maxSRDiff;
                                continue;
                            }
                        } else if (Math.abs(redSR - blueSR) > maxSRDiff) {
                            ++maxSRDiff;
                            continue;
                        }
                        if (Math.abs(bluePlayers - redPlayers) > 1) {
                            ++maxSRDiff;
                            continue;
                        }
                        if (Math.abs(redSR - blueSR) >= bestTeamSRDifference) continue;
                        bestTeam = teams2;
                        bestBlueSR = blueSR;
                        bestRedSR = redSR;
                        bestTeamSRDifference = Math.abs(redSR - blueSR);
                    }
                    boolean failSafeActive = false;
                    boolean secondFailSafeActive = false;
                    if (bestTeam.isEmpty()) {
                        failSafeActive = true;
                        teams = new HashMap<Player, Team>();
                        playerSpecs = new HashMap<Specializations, List>();
                        this.game.onlinePlayersWithoutSpectators().filter(e -> e.getValue() != null).forEach(e -> {
                            Player player = (Player)e.getKey();
                            Team team = (Team)((Object)((Object)e.getValue()));
                            PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
                            playerSpecs.computeIfAbsent(playerSettings.getSelectedSpec(), v -> new ArrayList()).add(player);
                        });
                        ArrayList playersLeft = new ArrayList();
                        playerSpecs.forEach((classes, playerList) -> {
                            int amountOfTargetSpecsOnBlue = (int)teams.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.BLUE && Warlords.getPlayerSettings(((Player)playerTeamEntry.getKey()).getUniqueId()).getSelectedSpec() == classes).count();
                            int amountOfTargetSpecsOnRed = (int)teams.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.RED && Warlords.getPlayerSettings(((Player)playerTeamEntry.getKey()).getUniqueId()).getSelectedSpec() == classes).count();
                            for (Player player : playerList) {
                                if (amountOfTargetSpecsOnBlue > amountOfTargetSpecsOnRed) {
                                    teams.put(player, Team.RED);
                                    ++amountOfTargetSpecsOnRed;
                                    continue;
                                }
                                if (amountOfTargetSpecsOnRed > amountOfTargetSpecsOnBlue) {
                                    teams.put(player, Team.BLUE);
                                    ++amountOfTargetSpecsOnBlue;
                                    continue;
                                }
                                playersLeft.add(player);
                            }
                        });
                        int amountOnBlue = (int)teams.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.BLUE).count();
                        int amountOnRed = (int)teams.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.RED).count();
                        boolean[] toBlueTeam = new boolean[]{amountOnBlue <= amountOnRed};
                        playersLeft.stream().sorted(Comparator.comparing(o -> Warlords.getPlayerSettings((UUID)o.getUniqueId()).getSelectedSpec().specType)).forEachOrdered(player -> {
                            if (toBlueTeam[0]) {
                                teams.put((Player)player, Team.BLUE);
                            } else {
                                teams.put((Player)player, Team.RED);
                            }
                            toBlueTeam[0] = !toBlueTeam[0];
                        });
                        bestTeam = teams;
                        bestBlueSR = teams.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.BLUE).mapToInt(value -> playersSR.getOrDefault(((Player)value.getKey()).getUniqueId().toString(), 500)).sum();
                        bestRedSR = teams.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.RED).mapToInt(value -> playersSR.getOrDefault(((Player)value.getKey()).getUniqueId().toString(), 500)).sum();
                        bestTeamSRDifference = Math.abs(bestBlueSR - bestRedSR);
                    }
                    if (bestTeamSRDifference > 5000) {
                        secondFailSafeActive = true;
                        teams = new HashMap();
                        playerSpecs = new HashMap();
                        this.game.onlinePlayersWithoutSpectators().filter(e -> e.getValue() != null).forEach(e -> {
                            Player player = (Player)e.getKey();
                            Team team = (Team)((Object)((Object)e.getValue()));
                            PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
                            playerSpecs.computeIfAbsent(playerSettings.getSelectedSpec(), v -> new ArrayList()).add(player);
                        });
                        int blueSR = 0;
                        redSR = 0;
                        for (List value2 : playerSpecs.values()) {
                            for (Player player3 : value2) {
                                if (blueSR > redSR) {
                                    teams.put(player3, Team.RED);
                                    redSR += playersSR.getOrDefault(player3.getUniqueId().toString(), 500).intValue();
                                    continue;
                                }
                                teams.put(player3, Team.BLUE);
                                blueSR += playersSR.getOrDefault(player3.getUniqueId().toString(), 500).intValue();
                            }
                        }
                        bestTeam = teams;
                        bestBlueSR = blueSR;
                        bestRedSR = redSR;
                        bestTeamSRDifference = Math.abs(bestBlueSR - bestRedSR);
                    }
                    bestTeam.forEach((player, team) -> {
                        this.game.setPlayerTeam((OfflinePlayer)player, (Team)((Object)team));
                        ArmorManager.resetArmor(player, Warlords.getPlayerSettings(player.getUniqueId()).getSelectedSpec(), team);
                        LobbyLocationMarker location = LobbyLocationMarker.getFirstLobbyLocation(this.game, team);
                        if (location != null) {
                            player.teleport(location.getLocation());
                        }
                    });
                    int bluePlayers = (int)bestTeam.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.BLUE).count();
                    int redPlayers = (int)bestTeam.entrySet().stream().filter(playerTeamEntry -> playerTeamEntry.getValue() == Team.RED).count();
                    for (Map.Entry<UUID, Team> uuidTeamEntry : this.game.getPlayers().entrySet()) {
                        Player value3 = Bukkit.getPlayer((UUID)uuidTeamEntry.getKey());
                        if (value3 == null || !value3.hasPermission(WARLORDS_DATABASE_MESSAGEFEED)) continue;
                        value3.sendMessage(ChatColor.DARK_AQUA + "----- BALANCE INFORMATION -----");
                        value3.sendMessage(ChatColor.GREEN + "Max SR Diff: " + maxSRDiff);
                        value3.sendMessage(ChatColor.GREEN + "SR Diff: " + bestTeamSRDifference);
                        value3.sendMessage(ChatColor.BLUE + "Blue Players: " + ChatColor.GOLD + bluePlayers + ChatColor.GRAY + " - " + ChatColor.BLUE + "SR: " + ChatColor.GOLD + bestBlueSR);
                        value3.sendMessage(ChatColor.RED + "Red Players: " + ChatColor.GOLD + redPlayers + ChatColor.GRAY + " - " + ChatColor.RED + "SR: " + ChatColor.GOLD + bestRedSR);
                        value3.sendMessage(ChatColor.GREEN + "Fail Safe: " + ChatColor.GOLD + failSafeActive);
                        value3.sendMessage(ChatColor.GREEN + "Second Fail Safe: " + ChatColor.GOLD + secondFailSafeActive);
                        value3.sendMessage(ChatColor.DARK_AQUA + "-------------------------------");
                        bestTeam.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(playerTeamEntry -> {
                            Specializations specializations = Warlords.getPlayerSettings(((Player)playerTeamEntry.getKey()).getUniqueId()).getSelectedSpec();
                            value3.sendMessage(((Team)((Object)((Object)playerTeamEntry.getValue()))).teamColor() + ((Player)playerTeamEntry.getKey()).getName() + ChatColor.GRAY + " - " + specializations.specType.chatColor + specializations.name + ChatColor.GRAY + " - " + ChatColor.GOLD + playersSR.get(((Player)playerTeamEntry.getKey()).getUniqueId().toString()));
                        });
                        value3.sendMessage(ChatColor.DARK_AQUA + "-------------------------------");
                    }
                    System.out.println(ChatColor.DARK_AQUA + "----- BALANCE INFORMATION -----");
                    System.out.println(ChatColor.GREEN + "Max SR Diff: " + maxSRDiff);
                    System.out.println(ChatColor.GREEN + "SR Diff: " + bestTeamSRDifference);
                    System.out.println(ChatColor.BLUE + "Blue Players: " + ChatColor.GOLD + bluePlayers + ChatColor.GRAY + " - " + ChatColor.BLUE + "SR: " + ChatColor.GOLD + bestBlueSR);
                    System.out.println(ChatColor.RED + "Red Players: " + ChatColor.GOLD + redPlayers + ChatColor.GRAY + " - " + ChatColor.RED + "SR: " + ChatColor.GOLD + bestRedSR);
                    System.out.println(ChatColor.GREEN + "Fail Safe: " + ChatColor.GOLD + failSafeActive);
                    System.out.println(ChatColor.GREEN + "Second Fail Safe: " + ChatColor.GOLD + secondFailSafeActive);
                    System.out.println(ChatColor.DARK_AQUA + "-------------------------------");
                    bestTeam.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(playerTeamEntry -> {
                        Specializations specializations = Warlords.getPlayerSettings(((Player)playerTeamEntry.getKey()).getUniqueId()).getSelectedSpec();
                        System.out.println(((Team)((Object)((Object)playerTeamEntry.getValue()))).teamColor() + ((Player)playerTeamEntry.getKey()).getName() + ChatColor.GRAY + " - " + specializations.specType.chatColor + specializations.name + ChatColor.GRAY + " - " + ChatColor.GOLD + playersSR.get(((Player)playerTeamEntry.getKey()).getUniqueId().toString()));
                    });
                    System.out.println(ChatColor.DARK_AQUA + "-------------------------------");
                }
                if (this.game.getPlayers().size() >= 14) {
                    boolean isPrivate = this.game.getAddons().contains((Object)GameAddon.PRIVATE_GAME);
                    BotManager.sendMessageToNotificationChannel("[GAME] A " + (isPrivate ? "" : "Public ") + "**" + this.game.getMap().getMapName() + "** started with **" + this.game.getPlayers().size() + (this.game.getPlayers().size() == 1 ? "** player!" : "** players!"), isPrivate, !isPrivate);
                }
                return new SyncTimerState(this.game);
            }
            --this.timer;
        } else {
            this.resetTimer();
            this.game.forEachOnlinePlayerWithoutSpectators((player, team) -> this.giveLobbyScoreboard(false, (Player)player));
        }
        return null;
    }

    @Override
    public void end() {
    }

    public String getTimeLeftString() {
        int time = this.timer / 20;
        return (time < 10 ? "00:0" : "00:") + time;
    }

    public void giveLobbyScoreboard(boolean init, Player player) {
        String mapSuffix;
        CustomScoreboard customScoreboard = Warlords.playerScoreboards.get(player.getUniqueId());
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        String dateString = format.format(new Date());
        String mapPrefix = ChatColor.WHITE + "Map: " + ChatColor.GREEN;
        if (this.game.getMap().getMapName().length() >= 16) {
            mapPrefix = mapPrefix + this.game.getMap().getMapName().substring(0, 7);
            mapSuffix = this.game.getMap().getMapName().substring(7);
        } else {
            mapSuffix = this.game.getMap().getMapName();
        }
        Specializations specializations = Warlords.getPlayerSettings(player.getUniqueId()).getSelectedSpec();
        if (this.hasEnoughPlayers()) {
            customScoreboard.giveNewSideBar(init, ChatColor.GRAY + dateString, "  ", mapPrefix + mapSuffix, ChatColor.WHITE + "Players: " + ChatColor.GREEN + this.game.playersCount() + "/" + this.game.getMaxPlayers(), "   ", ChatColor.WHITE + "Starting in: " + ChatColor.GREEN + this.getTimeLeftString() + ChatColor.WHITE, "    ", ChatColor.GRAY + "Lv" + ExperienceManager.getLevelString(ExperienceManager.getLevelForSpec(player.getUniqueId(), specializations)) + " " + ChatColor.GOLD + Specializations.getClass((Specializations)specializations).name, ChatColor.WHITE + "Spec: " + ChatColor.GREEN + specializations.name, "     ", ChatColor.YELLOW + Warlords.VERSION);
        } else {
            customScoreboard.giveNewSideBar(init, ChatColor.GRAY + dateString, "  ", mapPrefix + mapSuffix, ChatColor.WHITE + "Players: " + ChatColor.GREEN + this.game.playersCount() + "/" + this.game.getMaxPlayers(), "   ", ChatColor.WHITE + "Starting if " + ChatColor.GREEN + (this.game.getMap().getMinPlayers() - this.game.playersCount()) + ChatColor.WHITE + " more", ChatColor.WHITE + "players join ", "    ", ChatColor.GRAY + "Lv" + ExperienceManager.getLevelString(ExperienceManager.getLevelForSpec(player.getUniqueId(), specializations)) + " " + ChatColor.GOLD + Specializations.getClass((Specializations)specializations).name, ChatColor.WHITE + "Spec: " + ChatColor.GREEN + specializations.name, "     ", ChatColor.YELLOW + Warlords.VERSION);
        }
    }

    private void updateTeamPreferences() {
        this.game.offlinePlayersWithoutSpectators().forEach(e -> {
            if (e.getValue() == null) {
                return;
            }
            Team selectedTeam = Warlords.getPlayerSettings(((OfflinePlayer)e.getKey()).getUniqueId()).getWantedTeam();
            if (selectedTeam == null) {
                Bukkit.broadcastMessage((String)(ChatColor.GOLD + ((OfflinePlayer)e.getKey()).getName() + " \u00a77did not choose a team!"));
            }
            TeamPreference newPref = new TeamPreference((Team)((Object)((Object)e.getValue())), selectedTeam == null ? (Team)((Object)((Object)e.getValue())) : selectedTeam, selectedTeam == null ? TeamPriority.NO_PREFERENCE : TeamPriority.PLAYER_PREFERENCE);
            this.teamPreferences.compute(((OfflinePlayer)e.getKey()).getUniqueId(), (k, oldPref) -> oldPref == null || oldPref.priority() < newPref.priority() ? newPref : oldPref);
        });
    }

    private boolean tryMovePeep(Map.Entry<UUID, TeamPreference> entry, Team target) {
        boolean canSwitchPeepTeam;
        if (entry.getValue().wantedTeam != target) {
            switch (entry.getValue().priority) {
                case FORCED_PREFERENCE: {
                    canSwitchPeepTeam = false;
                    break;
                }
                case PLAYER_PREFERENCE: {
                    canSwitchPeepTeam = false;
                    break;
                }
                default: {
                    canSwitchPeepTeam = true;
                    break;
                }
            }
        } else {
            canSwitchPeepTeam = true;
        }
        if (canSwitchPeepTeam) {
            this.game.setPlayerTeam(Bukkit.getOfflinePlayer((UUID)entry.getKey()), entry.getValue().wantedTeam);
            return true;
        }
        return false;
    }

    private void distributePeopleOverTeams() {
        List prefs = this.teamPreferences.entrySet().stream().collect(Collectors.toList());
        if (!prefs.isEmpty()) {
            int redIndex = 0;
            int blueIndex = prefs.size() - 1;
            boolean canPickRed = true;
            boolean canPickBlue = true;
            do {
                if (redIndex == blueIndex && canPickBlue && canPickRed) {
                    this.tryMovePeep((Map.Entry)prefs.get(redIndex), ((TeamPreference)((Map.Entry)prefs.get((int)redIndex)).getValue()).wantedTeam);
                    canPickBlue = false;
                    canPickRed = false;
                }
                if (canPickRed) {
                    canPickRed = this.tryMovePeep((Map.Entry)prefs.get(redIndex), Team.RED) ? ++redIndex < prefs.size() : false;
                }
                if (!canPickBlue || redIndex > blueIndex) continue;
                canPickBlue = this.tryMovePeep((Map.Entry)prefs.get(blueIndex), Team.BLUE) ? --blueIndex >= 0 : false;
            } while ((canPickRed || canPickBlue) && redIndex <= blueIndex);
        }
    }

    @Override
    public void skipTimer() {
        this.timer = 0;
        this.timerHasBeenSkipped = true;
    }

    @Override
    public void resetTimer() throws IllegalStateException {
        this.timer = this.maxTimer;
    }

    @Override
    public void onPlayerJoinGame(OfflinePlayer op, boolean asSpectator) {
        if (!asSpectator) {
            Team team = Warlords.getPlayerSettings(op.getUniqueId()).getWantedTeam();
            Team finalTeam = team == null ? Team.BLUE : team;
            this.game.setPlayerTeam(op, finalTeam);
            List<LobbyLocationMarker> lobbies = this.game.getMarkers(LobbyLocationMarker.class);
            LobbyLocationMarker location = (LobbyLocationMarker)lobbies.stream().filter(e -> e.matchesTeam(finalTeam)).collect(Utils.randomElement());
            if (location == null) {
                location = (LobbyLocationMarker)lobbies.stream().collect(Utils.randomElement());
            }
            if (location != null) {
                Warlords.setRejoinPoint(op.getUniqueId(), location.getLocation());
            }
        }
    }

    @Override
    public void onPlayerReJoinGame(Player player) {
        State.super.onPlayerReJoinGame(player);
        Team team = this.game.getPlayerTeam(player.getUniqueId());
        player.getActivePotionEffects().clear();
        if (team == null) {
            player.getInventory().clear();
            player.setAllowFlight(true);
            player.setGameMode(GameMode.SPECTATOR);
        } else {
            player.getInventory().clear();
            player.setAllowFlight(false);
            player.setGameMode(GameMode.ADVENTURE);
            for (PreGameItemOption item : this.items) {
                if (item == null) continue;
                player.getInventory().setItem(item.getSlot(), item.getItem(this.game, player));
            }
            ArmorManager.resetArmor(player, Warlords.getPlayerSettings(player.getUniqueId()).getSelectedSpec(), team);
        }
        LobbyLocationMarker location = LobbyLocationMarker.getRandomLobbyLocation(this.game, team);
        if (location != null) {
            player.teleport(location.getLocation());
            Warlords.setRejoinPoint(player.getUniqueId(), location.getLocation());
        } else {
            System.out.println("Unable to warp player to lobby!, no lobby marker found");
        }
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public int getMaxTimer() {
        return this.maxTimer;
    }

    public void setMaxTimer(int maxTimer) {
        this.maxTimer = maxTimer;
    }

    public void interactEvent(Player player, int heldItemSlot) {
        if (heldItemSlot >= 0 && heldItemSlot < 9 && this.items[heldItemSlot] != null) {
            this.items[heldItemSlot].runOnClick(this.game, player);
        }
    }

    private final class TeamPreference
    implements Comparable<TeamPreference> {
        final Team wantedTeam;
        final TeamPriority priority;
        final Team currentTeam;

        public TeamPreference(Team currentTeam, Team wantedTeam, TeamPriority priority) {
            this.currentTeam = currentTeam;
            this.wantedTeam = wantedTeam;
            this.priority = priority;
        }

        public int priority() {
            return this.priority.ordinal() * 2 + 1 + (this.wantedTeam == this.currentTeam ? 1 : 0);
        }

        public int toInt() {
            return (this.wantedTeam == Team.RED ? -1 : 1) * this.priority();
        }

        @Override
        public int compareTo(TeamPreference o) {
            return Integer.compare(this.toInt(), o.toInt());
        }
    }

    private static enum TeamPriority {
        FORCED_PREFERENCE,
        PLAYER_PREFERENCE,
        NO_PREFERENCE;

    }
}

