/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.state;

import com.ebicep.jda.BotManager;
import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.commands.debugcommands.misc.RecordGamesCommand;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.LobbyLocationMarker;
import com.ebicep.warlords.game.option.marker.LocationMarker;
import com.ebicep.warlords.game.option.marker.SpawnLocationMarker;
import com.ebicep.warlords.game.option.marker.TimerSkipAbleMarker;
import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import com.ebicep.warlords.game.state.EndState;
import com.ebicep.warlords.game.state.State;
import com.ebicep.warlords.game.state.TimerDebugAble;
import com.ebicep.warlords.player.CustomScoreboard;
import com.ebicep.warlords.player.ExperienceManager;
import com.ebicep.warlords.player.PlayerSettings;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.sr.SRCalculator;
import com.ebicep.warlords.util.bukkit.RemoveEntities;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class PlayingState
implements State,
TimerDebugAble {
    private final Game game;
    private WarlordsGameTriggerWinEvent winEvent;
    private int counter = 0;
    private int timer = 0;

    public PlayingState(@Nonnull Game game) {
        this.game = game;
    }

    @Nonnull
    public Game getGame() {
        return this.game;
    }

    @Override
    public void begin() {
        this.game.setAcceptsSpectators(true);
        this.game.setAcceptsPlayers(false);
        this.resetTimer();
        RemoveEntities.doRemove(this.game);
        for (Option option : this.game.getOptions()) {
            option.start(this.game);
        }
        this.game.forEachOfflinePlayer((player, team) -> {
            if (team != null) {
                PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
                Warlords.addPlayer(new WarlordsPlayer((OfflinePlayer)player, this, (Team)((Object)team), playerSettings));
            }
        });
        this.game.forEachOfflineWarlordsPlayer(wp -> {
            CustomScoreboard customScoreboard = Warlords.playerScoreboards.get(wp.getUuid());
            this.updateBasedOnGameState(customScoreboard, (WarlordsPlayer)wp);
            if (wp.getEntity() instanceof Player) {
                wp.applySkillBoost((Player)wp.getEntity());
            }
        });
        if (DatabaseManager.playerService != null) {
            Warlords.newChain().async(() -> this.game.forEachOfflinePlayer((player, team) -> {
                DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(player.getUniqueId());
                DatabaseManager.updatePlayerAsync(databasePlayer);
                DatabaseManager.loadPlayer(player.getUniqueId(), PlayersCollections.SEASON_6, () -> {});
                DatabaseManager.loadPlayer(player.getUniqueId(), PlayersCollections.WEEKLY, () -> {});
                DatabaseManager.loadPlayer(player.getUniqueId(), PlayersCollections.DAILY, () -> {});
            })).execute();
        } else {
            System.out.println("ATTENTION - playerService is null");
        }
        this.game.registerEvents(new Listener(){

            @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
            public void onWin(WarlordsGameTriggerWinEvent event) {
                PlayingState.this.game.setNextState(new EndState(PlayingState.this.game, event));
                PlayingState.this.winEvent = event;
            }
        });
        GameRunnable.create(this.game, this::updateScoreboard).runTaskTimer(0L, 10L);
        new GameRunnable(this.game){

            @Override
            public void run() {
                PlayingState.this.counter++;
                PlayingState.this.timer = PlayingState.this.timer + 20;
                if (PlayingState.this.counter >= 60) {
                    PlayingState.this.counter = PlayingState.this.counter - 60;
                    PlayerFilter.playingGame(PlayingState.this.game).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)wp -> wp.getMinuteStats().advanceMinute()));
                }
                PlayerFilter.playingGame(PlayingState.this.game).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)wp -> wp.getSecondStats().advanceSecond()));
            }
        }.runTaskTimer(0L, 20L);
        this.game.registerGameMarker(TimerSkipAbleMarker.class, delay -> {
            this.counter += delay / 20;
            this.timer += delay;
        });
        Warlords.getInstance().hideAndUnhidePeople();
    }

    @Override
    public State run() {
        this.game.players().forEach(uuidTeamEntry -> {
            WarlordsPlayer wp = Warlords.getPlayer((UUID)uuidTeamEntry.getKey());
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            if (wp != null) {
                byteArrayDataOutput.writeUTF(wp.getName());
                byteArrayDataOutput.writeInt((int)wp.getEnergy());
                byteArrayDataOutput.writeInt((int)wp.getMaxEnergy());
                AbstractPlayerClass spec = wp.getSpec();
                byteArrayDataOutput.writeInt(spec.getRed().getCurrentCooldown() == 0.0f ? 0 : (int)Math.round((double)spec.getRed().getCurrentCooldown() + 0.5));
                byteArrayDataOutput.writeInt(spec.getPurple().getCurrentCooldown() == 0.0f ? 0 : (int)Math.round((double)spec.getPurple().getCurrentCooldown() + 0.5));
                byteArrayDataOutput.writeInt(spec.getBlue().getCurrentCooldown() == 0.0f ? 0 : (int)Math.round((double)spec.getBlue().getCurrentCooldown() + 0.5));
                byteArrayDataOutput.writeInt(spec.getOrange().getCurrentCooldown() == 0.0f ? 0 : (int)Math.round((double)spec.getOrange().getCurrentCooldown() + 0.5));
                this.game.spectators().forEach(uuid -> {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player != null && player.getName().equals("sumSmash")) {
                        player.sendPluginMessage((Plugin)Warlords.getInstance(), "Warlords", byteArrayDataOutput.toByteArray());
                    }
                });
            }
        });
        return null;
    }

    @Override
    public void end() {
        System.out.println(" ----- GAME END ----- ");
        System.out.println("RecordGames = " + RecordGamesCommand.recordGames);
        System.out.println("Force End = " + (this.winEvent == null));
        System.out.println("Player Count = " + this.game.playersCount());
        System.out.println("Players = " + this.game.getPlayers().keySet());
        System.out.println("Timer = " + this.timer);
        System.out.println("Private = " + this.game.getAddons().contains((Object)GameAddon.PRIVATE_GAME));
        System.out.println("GameMode = " + (Object)((Object)this.game.getGameMode()));
        System.out.println("Game Addons = " + this.game.getAddons());
        System.out.println(" ----- GAME END ----- ");
        List<WarlordsPlayer> players = PlayerFilter.playingGame(this.game).toList();
        if (players.isEmpty()) {
            return;
        }
        if (!this.game.getAddons().contains((Object)GameAddon.PRIVATE_GAME) && !this.game.getAddons().contains((Object)GameAddon.IMPOSTER_MODE) && this.winEvent != null && this.game.playersCount() >= 12) {
            String gameEnd = "[GAME] A Public game ended with ";
            if (this.winEvent != null && this.winEvent.getDeclaredWinner() == Team.BLUE) {
                BotManager.sendMessageToNotificationChannel(gameEnd + "**BLUE** winning " + this.game.getPoints(Team.BLUE) + " to " + this.game.getPoints(Team.RED), false, true);
            } else if (this.winEvent != null && this.winEvent.getDeclaredWinner() == Team.RED) {
                BotManager.sendMessageToNotificationChannel(gameEnd + "**RED** winning " + this.game.getPoints(Team.RED) + " to " + this.game.getPoints(Team.BLUE), false, true);
            } else {
                BotManager.sendMessageToNotificationChannel(gameEnd + "a **DRAW**", false, true);
            }
            DatabaseGameBase.addGame(this.game, this.winEvent, true);
            if (DatabaseManager.playerService == null) {
                return;
            }
            Warlords.newChain().asyncFirst(() -> DatabaseManager.playerService.findAll(PlayersCollections.SEASON_5)).syncLast(databasePlayers -> {
                SRCalculator.databasePlayerCache = databasePlayers;
                SRCalculator.recalculateSR();
            }).execute();
        } else if (!this.game.getAddons().contains((Object)GameAddon.IMPOSTER_MODE) && this.winEvent != null && this.game.playersCount() >= 16 && this.timer >= 6000) {
            String gameEnd = "[GAME] A game ended with ";
            if (this.winEvent != null && this.winEvent.getDeclaredWinner() == Team.BLUE) {
                BotManager.sendMessageToNotificationChannel(gameEnd + "**BLUE** winning " + this.game.getPoints(Team.BLUE) + " to " + this.game.getPoints(Team.RED), true, false);
            } else if (this.winEvent != null && this.winEvent.getDeclaredWinner() == Team.RED) {
                BotManager.sendMessageToNotificationChannel(gameEnd + "**RED** winning " + this.game.getPoints(Team.RED) + " to " + this.game.getPoints(Team.BLUE), true, false);
            } else {
                BotManager.sendMessageToNotificationChannel(gameEnd + "a **DRAW**", true, false);
            }
            DatabaseGameBase.addGame(this.game, this.winEvent, RecordGamesCommand.recordGames);
        } else if (this.game.getAddons().contains((Object)GameAddon.PRIVATE_GAME) && this.game.playersCount() >= 6 && this.timer >= 6000) {
            DatabaseGameBase.addGame(this.game, this.winEvent, false);
        } else {
            System.out.println(ChatColor.GREEN + "[Warlords] This PUB/COMP game was not added to the database and player information remained the same");
        }
    }

    @Override
    public void skipTimer() {
        int maxSkip = Integer.MAX_VALUE;
        for (TimerSkipAbleMarker marker : this.game.getMarkers(TimerSkipAbleMarker.class)) {
            if (marker.getDelay() <= 0) continue;
            maxSkip = Math.min(marker.getDelay(), maxSkip);
        }
        for (TimerSkipAbleMarker marker : this.game.getMarkers(TimerSkipAbleMarker.class)) {
            marker.skipTimer(maxSkip);
        }
    }

    @Override
    public void resetTimer() throws IllegalStateException {
    }

    private void updateScoreboard() {
        this.game.forEachOnlinePlayer((player, team) -> this.updateBasedOnGameState(Warlords.playerScoreboards.get(player.getUniqueId()), Warlords.getPlayer(player)));
    }

    private void updateHealth(@Nonnull CustomScoreboard customScoreboard) {
        Scoreboard scoreboard = customScoreboard.getScoreboard();
        Objective health = customScoreboard.getHealth();
        if (health == null || scoreboard.getObjective("health") == null) {
            health = scoreboard.registerNewObjective("health", "dummy");
            health.setDisplaySlot(DisplaySlot.BELOW_NAME);
            health.setDisplayName(ChatColor.RED + "\u2764");
            customScoreboard.setHealth(health);
        }
        Objective finalHealth = health;
        this.getGame().forEachOfflinePlayer((player, team) -> {
            WarlordsPlayer warlordsPlayer = Warlords.getPlayer(player);
            if (warlordsPlayer != null) {
                finalHealth.getScore(warlordsPlayer.getName()).setScore(warlordsPlayer.getHealth());
            }
        });
    }

    private void updateNames(@Nonnull CustomScoreboard customScoreboard) {
        Scoreboard scoreboard = customScoreboard.getScoreboard();
        this.getGame().forEachOfflinePlayer((player, team) -> {
            WarlordsPlayer warlordsPlayer = Warlords.getPlayer(player);
            if (warlordsPlayer != null) {
                if (scoreboard.getTeam(warlordsPlayer.getName()) == null) {
                    org.bukkit.scoreboard.Team temp = scoreboard.registerNewTeam(warlordsPlayer.getName());
                    temp.setPrefix(ChatColor.DARK_GRAY + "[" + ChatColor.GOLD + warlordsPlayer.getSpec().getClassNameShort() + ChatColor.DARK_GRAY + "] " + team.teamColor());
                    temp.addEntry(warlordsPlayer.getName());
                    temp.setSuffix(ChatColor.DARK_GRAY + " [" + ChatColor.GOLD + "Lv" + ExperienceManager.getLevelString(ExperienceManager.getLevelForSpec(warlordsPlayer.getUuid(), warlordsPlayer.getSpecClass())) + ChatColor.DARK_GRAY + "]");
                } else {
                    scoreboard.getTeam(warlordsPlayer.getName()).setPrefix(ChatColor.DARK_GRAY + "[" + ChatColor.GOLD + warlordsPlayer.getSpec().getClassNameShort() + ChatColor.DARK_GRAY + "] " + team.teamColor());
                    if (warlordsPlayer.getCarriedFlag() != null) {
                        scoreboard.getTeam(warlordsPlayer.getName()).setSuffix(ChatColor.DARK_GRAY + "[" + ChatColor.GRAY + "Lv" + ExperienceManager.getLevelString(ExperienceManager.getLevelForSpec(warlordsPlayer.getUuid(), warlordsPlayer.getSpecClass())) + ChatColor.DARK_GRAY + "]" + ChatColor.WHITE + "\u2691");
                    } else {
                        scoreboard.getTeam(warlordsPlayer.getName()).setSuffix(ChatColor.DARK_GRAY + " [" + ChatColor.GRAY + "Lv" + ExperienceManager.getLevelString(ExperienceManager.getLevelForSpec(warlordsPlayer.getUuid(), warlordsPlayer.getSpecClass())) + ChatColor.DARK_GRAY + "]");
                    }
                }
            }
        });
    }

    public void updatePlayerName(@Nonnull WarlordsPlayer warlordsPlayer) {
        this.getGame().forEachOfflinePlayer((player, team) -> {
            Scoreboard scoreboard = Warlords.playerScoreboards.get(player.getUniqueId()).getScoreboard();
            int level = ExperienceManager.getLevelForSpec(warlordsPlayer.getUuid(), warlordsPlayer.getSpecClass());
            scoreboard.getTeam(warlordsPlayer.getName()).setPrefix(ChatColor.DARK_GRAY + "[" + ChatColor.GOLD + warlordsPlayer.getSpec().getClassNameShort() + ChatColor.DARK_GRAY + "] " + warlordsPlayer.getTeam().teamColor());
            scoreboard.getTeam(warlordsPlayer.getName()).setSuffix(ChatColor.DARK_GRAY + " [" + ChatColor.GRAY + "Lv" + (level < 10 ? "0" : "") + level + ChatColor.DARK_GRAY + "]");
        });
    }

    private void updateBasedOnGameScoreboards(@Nonnull CustomScoreboard customScoreboard, @Nullable WarlordsPlayer warlordsPlayer) {
        ArrayList<String> scoreboard = new ArrayList<String>();
        String lastGroup = null;
        boolean lastWasEmpty = true;
        for (ScoreboardHandler handler : Utils.iterable(this.game.getScoreboardHandlers().stream().sorted(Comparator.comparing(sh -> sh.getPriority(warlordsPlayer))))) {
            String group = handler.getGroup();
            if (!(lastGroup != null && lastGroup.equals(group) || lastWasEmpty)) {
                scoreboard.add("");
                lastWasEmpty = true;
            }
            lastGroup = group;
            List<String> handlerContents = handler.computeLines(warlordsPlayer);
            if (handlerContents.isEmpty()) continue;
            lastWasEmpty = false;
            scoreboard.addAll(handlerContents);
        }
        customScoreboard.giveNewSideBar(false, scoreboard);
    }

    private void updateBasedOnGameState(@Nonnull CustomScoreboard customScoreboard, @Nullable WarlordsPlayer warlordsPlayer) {
        this.updateHealth(customScoreboard);
        this.updateNames(customScoreboard);
        this.updateBasedOnGameScoreboards(customScoreboard, warlordsPlayer);
    }

    @Override
    public void onPlayerReJoinGame(@Nonnull Player player) {
        WarlordsPlayer wp = Warlords.getPlayer(player);
        if (wp == null) {
            player.setGameMode(GameMode.SPECTATOR);
            Location spawn = (Location)Stream.concat(this.getGame().getMarkers(SpawnLocationMarker.class).stream(), this.getGame().getMarkers(LobbyLocationMarker.class).stream()).map(LocationMarker::getLocation).collect(Utils.randomElement());
            player.teleport(spawn);
        }
        CustomScoreboard sb = Warlords.playerScoreboards.get(player.getUniqueId());
        this.updateBasedOnGameState(sb, wp);
    }

    public int getTicksElapsed() {
        return this.timer;
    }
}

