/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.state;

import com.ebicep.warlords.commands.debugcommands.misc.GetPlayerLastAbilityStatsCommand;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.state.ClosedState;
import com.ebicep.warlords.game.state.State;
import com.ebicep.warlords.game.state.TimerDebugAble;
import com.ebicep.warlords.player.ExperienceManager;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.bukkit.TextComponentBuilder;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.ebicep.warlords.util.java.NumberFormat;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class EndState
implements State,
TimerDebugAble {
    @Nonnull
    private final Game game;
    private final WarlordsGameTriggerWinEvent winEvent;
    private int timer;

    public EndState(@Nonnull Game game, @Nullable WarlordsGameTriggerWinEvent event) {
        this.game = game;
        this.winEvent = event;
    }

    @Override
    public void begin() {
        Player player;
        for (Option option : this.game.getOptions()) {
            option.onGameEnding(this.game);
        }
        this.resetTimer();
        boolean teamBlueWins = this.winEvent != null && this.winEvent.getDeclaredWinner() == Team.BLUE;
        boolean teamRedWins = this.winEvent != null && this.winEvent.getDeclaredWinner() == Team.RED;
        List players = this.game.warlordsPlayers().collect(Collectors.toList());
        if (players.isEmpty()) {
            return;
        }
        this.sendMessageToAllGamePlayer(this.game, "" + ChatColor.GREEN + ChatColor.BOLD + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac", true);
        this.sendMessageToAllGamePlayer(this.game, "" + ChatColor.WHITE + ChatColor.BOLD + "  Warlords", true);
        this.sendMessageToAllGamePlayer(this.game, "", false);
        if (teamBlueWins) {
            this.sendMessageToAllGamePlayer(this.game, ChatColor.YELLOW + "Winner" + ChatColor.GRAY + " - " + ChatColor.BLUE + "BLU", true);
        } else if (teamRedWins) {
            this.sendMessageToAllGamePlayer(this.game, ChatColor.YELLOW + "Winner" + ChatColor.GRAY + " - " + ChatColor.RED + "RED", true);
        } else if (this.game.getAddons().contains((Object)GameAddon.IMPOSTER_MODE)) {
            this.sendMessageToAllGamePlayer(this.game, ChatColor.YELLOW + "Winner" + ChatColor.GRAY + " - " + ChatColor.LIGHT_PURPLE + "GAME END", true);
        } else {
            this.sendMessageToAllGamePlayer(this.game, ChatColor.YELLOW + "Winner" + ChatColor.GRAY + " - " + ChatColor.LIGHT_PURPLE + "DRAW", true);
        }
        this.sendMessageToAllGamePlayer(this.game, "", false);
        this.sendCenteredHoverableMessageToAllGamePlayer(this.game, Collections.singletonList(new TextComponentBuilder(ChatColor.LIGHT_PURPLE.toString() + ChatColor.BOLD + "\u271a MVP \u271a").setHoverText(ChatColor.LIGHT_PURPLE + "Total Flag Captures (everyone): " + ChatColor.GOLD + NumberFormat.addCommaAndRound(players.stream().mapToInt(WarlordsPlayer::getFlagsCaptured).sum()) + "\n" + ChatColor.LIGHT_PURPLE + "Total Flag Returns (everyone): " + ChatColor.GOLD + NumberFormat.addCommaAndRound(players.stream().mapToInt(WarlordsPlayer::getFlagsCaptured).sum())).getTextComponent()));
        players = players.stream().sorted(Comparator.comparing(WarlordsPlayer::getTotalCapsAndReturnsWeighted).reversed()).collect(Collectors.toList());
        this.sendCenteredHoverableMessageToAllGamePlayer(this.game, Collections.singletonList(new TextComponentBuilder(ChatColor.AQUA + ((WarlordsPlayer)players.get(0)).getName()).setHoverText(ChatColor.LIGHT_PURPLE + "Flag Captures: " + ChatColor.GOLD + ((WarlordsPlayer)players.get(0)).getFlagsCaptured() + "\n" + ChatColor.LIGHT_PURPLE + "Flag Returns: " + ChatColor.GOLD + ((WarlordsPlayer)players.get(0)).getFlagsReturned()).getTextComponent()));
        this.sendMessageToAllGamePlayer(this.game, "", false);
        this.sendCenteredHoverableMessageToAllGamePlayer(this.game, Collections.singletonList(new TextComponentBuilder(ChatColor.RED.toString() + ChatColor.BOLD + "\u271a TOP DAMAGE \u271a").setHoverText(ChatColor.RED + "Total Damage (everyone)" + ChatColor.GRAY + ": " + ChatColor.GOLD + NumberFormat.addCommaAndRound(players.stream().mapToLong(wp -> wp.getMinuteStats().total().getDamage()).sum())).getTextComponent()));
        players = players.stream().sorted(Comparator.comparing(wp -> wp.getMinuteStats().total().getDamage()).reversed()).collect(Collectors.toList());
        ArrayList<TextComponent> leaderboardPlayersDamage = new ArrayList<TextComponent>();
        for (int i = 0; i < players.size() && i < 3; ++i) {
            WarlordsPlayer warlordsPlayer = (WarlordsPlayer)players.get(i);
            leaderboardPlayersDamage.add(new TextComponentBuilder(ChatColor.AQUA + warlordsPlayer.getName() + ChatColor.GRAY + ": " + ChatColor.GOLD + NumberFormat.getSimplifiedNumber(warlordsPlayer.getMinuteStats().total().getDamage())).setHoverText(ChatColor.DARK_GRAY + "Lv" + ChatColor.GRAY + ExperienceManager.getLevelForSpec(warlordsPlayer.getUuid(), warlordsPlayer.getSpecClass()) + " " + ChatColor.GOLD + warlordsPlayer.getSpec().getClassName() + ChatColor.GREEN + " (" + warlordsPlayer.getSpec().getClass().getSimpleName() + ")").getTextComponent());
            if (i == players.size() - 1 || i == 2) continue;
            leaderboardPlayersDamage.add(ChatUtils.SPACER);
        }
        this.sendCenteredHoverableMessageToAllGamePlayer(this.game, leaderboardPlayersDamage);
        this.sendMessageToAllGamePlayer(this.game, "", false);
        this.sendCenteredHoverableMessageToAllGamePlayer(this.game, Collections.singletonList(new TextComponentBuilder(ChatColor.GREEN.toString() + ChatColor.BOLD + "\u271a TOP HEALING \u271a").setHoverText(ChatColor.GREEN + "Total Healing (everyone)" + ChatColor.GRAY + ": " + ChatColor.GOLD + NumberFormat.addCommaAndRound(players.stream().mapToLong(wp -> wp.getMinuteStats().total().getHealing()).sum())).getTextComponent()));
        players = players.stream().sorted(Comparator.comparing(wp -> wp.getMinuteStats().total().getHealing()).reversed()).collect(Collectors.toList());
        ArrayList<TextComponent> leaderboardPlayersHealing = new ArrayList<TextComponent>();
        for (int i = 0; i < players.size() && i < 3; ++i) {
            WarlordsPlayer warlordsPlayer = (WarlordsPlayer)players.get(i);
            leaderboardPlayersHealing.add(new TextComponentBuilder(ChatColor.AQUA + warlordsPlayer.getName() + ChatColor.GRAY + ": " + ChatColor.GOLD + NumberFormat.getSimplifiedNumber(warlordsPlayer.getMinuteStats().total().getHealing())).setHoverText(ChatColor.DARK_GRAY + "Lv" + ChatColor.GRAY + ExperienceManager.getLevelForSpec(warlordsPlayer.getUuid(), warlordsPlayer.getSpecClass()) + " " + ChatColor.GOLD + warlordsPlayer.getSpec().getClassName() + ChatColor.GREEN + " (" + warlordsPlayer.getSpec().getClass().getSimpleName() + ")").getTextComponent());
            if (i == players.size() - 1 || i == 2) continue;
            leaderboardPlayersHealing.add(ChatUtils.SPACER);
        }
        this.sendCenteredHoverableMessageToAllGamePlayer(this.game, leaderboardPlayersHealing);
        this.sendMessageToAllGamePlayer(this.game, "", false);
        this.sendCenteredHoverableMessageToAllGamePlayer(this.game, Collections.singletonList(new TextComponentBuilder(ChatColor.GOLD.toString() + ChatColor.BOLD + "\u271a YOUR STATISTICS \u271a").setHoverText(ChatColor.WHITE + "Total Kills (everyone): " + ChatColor.GREEN + NumberFormat.addCommaAndRound(players.stream().mapToInt(wp -> wp.getMinuteStats().total().getKills()).sum()) + "\n" + ChatColor.WHITE + "Total Assists (everyone): " + ChatColor.GREEN + NumberFormat.addCommaAndRound(players.stream().mapToInt(wp -> wp.getMinuteStats().total().getAssists()).sum()) + "\n" + ChatColor.WHITE + "Total Deaths (everyone): " + ChatColor.GREEN + NumberFormat.addCommaAndRound(players.stream().mapToInt(wp -> wp.getMinuteStats().total().getDeaths()).sum())).getTextComponent()));
        for (WarlordsPlayer wp2 : PlayerFilter.playingGame(this.game)) {
            player = Bukkit.getPlayer((UUID)wp2.getUuid());
            if (player == null) continue;
            ChatUtils.sendCenteredMessageWithEvents(player, Arrays.asList(new TextComponentBuilder(ChatColor.WHITE + "Kills: " + ChatColor.GOLD + NumberFormat.addCommaAndRound(wp2.getMinuteStats().total().getKills())).setHoverText(wp2.getStatString("Kills")).getTextComponent(), ChatUtils.SPACER, new TextComponentBuilder(ChatColor.WHITE + "Assists: " + ChatColor.GOLD + NumberFormat.addCommaAndRound(wp2.getMinuteStats().total().getAssists())).setHoverText(wp2.getStatString("Assists")).getTextComponent(), ChatUtils.SPACER, new TextComponentBuilder(ChatColor.WHITE + "Deaths: " + ChatColor.GOLD + NumberFormat.addCommaAndRound(wp2.getMinuteStats().total().getDeaths())).setHoverText(wp2.getStatString("Deaths")).getTextComponent()));
            ChatUtils.sendCenteredMessageWithEvents(player, Arrays.asList(new TextComponentBuilder(ChatColor.WHITE + "Damage: " + ChatColor.GOLD + NumberFormat.addCommaAndRound(wp2.getMinuteStats().total().getDamage())).setHoverText(wp2.getStatString("Damage")).getTextComponent(), ChatUtils.SPACER, new TextComponentBuilder(ChatColor.WHITE + "Healing: " + ChatColor.GOLD + NumberFormat.addCommaAndRound(wp2.getMinuteStats().total().getHealing())).setHoverText(wp2.getStatString("Healing")).getTextComponent(), ChatUtils.SPACER, new TextComponentBuilder(ChatColor.WHITE + "Absorbed: " + ChatColor.GOLD + NumberFormat.addCommaAndRound(wp2.getMinuteStats().total().getAbsorbed())).setHoverText(wp2.getStatString("Absorbed")).getTextComponent()));
            ChatUtils.sendMessage(player, false, "");
            List<TextComponent> formattedData = wp2.getSpec().getFormattedData();
            ChatUtils.sendCenteredMessageWithEvents(player, Arrays.asList(formattedData.get(0), ChatUtils.SPACER, formattedData.get(1), ChatUtils.SPACER, formattedData.get(2)));
            ChatUtils.sendCenteredMessageWithEvents(player, Arrays.asList(formattedData.get(3), ChatUtils.SPACER, formattedData.get(4)));
            GetPlayerLastAbilityStatsCommand.playerLastAbilityStats.put(player.getUniqueId(), formattedData);
            player.setGameMode(GameMode.ADVENTURE);
            player.setAllowFlight(true);
            if (this.game.getAddons().contains((Object)GameAddon.IMPOSTER_MODE)) continue;
            if (this.winEvent == null || this.winEvent.getDeclaredWinner() == null) {
                player.playSound(player.getLocation(), "defeat", 500.0f, 1.0f);
                PacketUtils.sendTitle(player, "\u00a7d\u00a7lDRAW", "", 0, 100, 0);
                continue;
            }
            if (wp2.getTeam() == this.winEvent.getDeclaredWinner()) {
                player.playSound(player.getLocation(), "victory", 500.0f, 1.0f);
                PacketUtils.sendTitle(player, "\u00a76\u00a7lVICTORY!", "", 0, 100, 0);
                continue;
            }
            player.playSound(player.getLocation(), "defeat", 500.0f, 1.0f);
            PacketUtils.sendTitle(player, "\u00a7c\u00a7lDEFEAT", "", 0, 100, 0);
        }
        if (this.game.playersCount() >= 12 && DatabaseGameBase.previousGames.get(DatabaseGameBase.previousGames.size() - 1).isCounted()) {
            this.sendMessageToAllGamePlayer(this.game, "", false);
            this.sendMessageToAllGamePlayer(this.game, ChatColor.YELLOW.toString() + ChatColor.BOLD + "\u271a EXPERIENCE SUMMARY \u271a", true);
            for (WarlordsPlayer wp2 : PlayerFilter.playingGame(this.game)) {
                player = Bukkit.getPlayer((UUID)wp2.getUuid());
                if (player == null) continue;
                LinkedHashMap<String, Long> expSummary = ExperienceManager.getExpFromGameStats(wp2, false);
                long experienceEarnedUniversal = expSummary.values().stream().mapToLong(Long::longValue).sum();
                long experienceEarnedSpec = ExperienceManager.getSpecExpFromSummary(expSummary);
                long experienceOnSpec = ExperienceManager.getExperienceForSpec(wp2.getUuid(), wp2.getSpecClass());
                long experienceUniversal = ExperienceManager.getUniversalLevel(wp2.getUuid());
                StringBuilder specExpSummary = new StringBuilder();
                StringBuilder universalExpSummary = new StringBuilder();
                expSummary.forEach((s2, aLong) -> {
                    if (!(s2.equals("First Game of the Day") || s2.equals("Second Game of the Day") || s2.equals("Third Game of the Day"))) {
                        specExpSummary.append(ChatColor.AQUA).append((String)s2).append(ChatColor.WHITE).append(": ").append(ChatColor.DARK_GRAY).append("+").append(ChatColor.DARK_GREEN).append(aLong).append("\n");
                    }
                    universalExpSummary.append(ChatColor.AQUA).append((String)s2).append(ChatColor.WHITE).append(": ").append(ChatColor.DARK_GRAY).append("+").append(ChatColor.DARK_GREEN).append(aLong).append("\n");
                });
                specExpSummary.setLength(specExpSummary.length() - 1);
                universalExpSummary.setLength(universalExpSummary.length() - 1);
                ChatUtils.sendCenteredMessageWithEvents(player, Collections.singletonList(new TextComponentBuilder(ChatColor.GRAY + "+" + ChatColor.DARK_GREEN + NumberFormat.addCommaAndRound(experienceEarnedSpec) + " " + ChatColor.GOLD + wp2.getSpec().getClassName() + " Experience " + ChatColor.GRAY + "(" + wp2.getSpecClass().specType.chatColor + wp2.getSpecClass().name + ChatColor.GRAY + ")").setHoverText(specExpSummary.toString()).getTextComponent()));
                ExperienceManager.giveLevelUpMessage(player, experienceOnSpec, experienceOnSpec + experienceEarnedSpec);
                ChatUtils.sendCenteredMessageWithEvents(player, Collections.singletonList(new TextComponentBuilder(ChatColor.GRAY + "+" + ChatColor.DARK_AQUA + NumberFormat.addCommaAndRound(experienceEarnedUniversal) + " " + ChatColor.GOLD + "Universal Experience ").setHoverText(universalExpSummary.toString()).getTextComponent()));
                ExperienceManager.giveLevelUpMessage(player, experienceUniversal, experienceUniversal + experienceEarnedUniversal);
                ExperienceManager.cachedPlayerExpSummary.remove(wp2.getUuid());
            }
        }
        this.sendMessageToAllGamePlayer(this.game, "" + ChatColor.GREEN + ChatColor.BOLD + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac", true);
    }

    @Override
    public State run() {
        --this.timer;
        if (this.timer <= 0) {
            return new ClosedState(this.game);
        }
        return null;
    }

    @Override
    public void end() {
        this.game.removeAllPlayers();
    }

    @Override
    public void skipTimer() throws IllegalStateException {
        this.timer = 0;
    }

    @Override
    public void resetTimer() throws IllegalStateException {
        this.timer = 200;
    }

    public WarlordsGameTriggerWinEvent getWinEvent() {
        return this.winEvent;
    }

    private void sendMessageToAllGamePlayer(Game game, String message, boolean centered) {
        game.forEachOnlinePlayerWithoutSpectators((p, team) -> {
            if (centered) {
                ChatUtils.sendCenteredMessage(p, message);
            } else {
                p.sendMessage(message);
            }
        });
    }

    public void sendCenteredHoverableMessageToAllGamePlayer(Game game, List<TextComponent> message) {
        game.forEachOnlinePlayerWithoutSpectators((p, team) -> ChatUtils.sendCenteredMessageWithEvents(p, message));
    }
}

