/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option.marker.scoreboard;

import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class AbstractScoreboardHandler
implements ScoreboardHandler {
    protected final List<Consumer<ScoreboardHandler>> handlers = new CopyOnWriteArrayList<Consumer<ScoreboardHandler>>();

    @Override
    public Runnable registerChangeHandler(Consumer<ScoreboardHandler> onChange) {
        this.handlers.add(onChange);
        return () -> this.handlers.remove(onChange);
    }

    public void markChanged() {
        for (Consumer<ScoreboardHandler> handler : this.handlers) {
            handler.accept(this);
        }
    }

    public String toString() {
        return this.getClass().getName() + "{priority=" + this.getPriority(null) + ", group=" + this.getGroup() + ", contents=" + this.computeLines(null) + '}';
    }
}

