/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option.marker;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.MarkerOption;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.LocationMarker;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nullable;
import org.bukkit.Location;

public interface LobbyLocationMarker
extends LocationMarker {
    public boolean matchesTeam(Team var1);

    public static LobbyLocationMarker create(final Location location) {
        return new LobbyLocationMarker(){

            @Override
            public boolean matchesTeam(Team team) {
                return true;
            }

            @Override
            public Location getLocation() {
                return location;
            }
        };
    }

    public static LobbyLocationMarker create(final Location location, final Team t2) {
        return new LobbyLocationMarker(){

            @Override
            public boolean matchesTeam(Team team) {
                return t2 == team;
            }

            @Override
            public Location getLocation() {
                return location;
            }
        };
    }

    @Nullable
    public static LobbyLocationMarker getRandomLobbyLocation(Game game, Team team) {
        return LobbyLocationMarker.getLobbyLocation(game, team, Utils.randomElement(), Objects::nonNull);
    }

    @Nullable
    public static LobbyLocationMarker getFirstLobbyLocation(Game game, Team team) {
        return LobbyLocationMarker.getLobbyLocation(game, team, Collector.of(() -> new Pair<Object, Object>(null, null), (a, b) -> {
            if (a.getA() == null) {
                a.setA(b);
            }
        }, (a, b) -> a.getA() == null ? b : a, a -> (LobbyLocationMarker)a.getA(), new Collector.Characteristics[0]), Objects::nonNull);
    }

    public static <T> T getLobbyLocation(Game game, Team team, Collector<LobbyLocationMarker, ?, T> collector, Predicate<T> isAcceptable) {
        List<LobbyLocationMarker> lobbies = game.getMarkers(LobbyLocationMarker.class);
        T location = lobbies.stream().filter(e -> e.matchesTeam(team)).collect(collector);
        if (!isAcceptable.test(location)) {
            location = lobbies.stream().collect(collector);
        }
        return location;
    }

    default public Option asOption() {
        return new MarkerOption(this);
    }
}

