/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option.marker;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.flags.FlagInfo;
import com.ebicep.warlords.game.flags.FlagLocation;
import com.ebicep.warlords.game.flags.GroundFlagLocation;
import com.ebicep.warlords.game.flags.PlayerFlagLocation;
import com.ebicep.warlords.game.flags.SpawnFlagLocation;
import com.ebicep.warlords.game.option.marker.CompassTargetMarker;
import com.ebicep.warlords.game.option.marker.GameMarker;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.ChatColor;
import org.bukkit.Location;

public interface FlagHolder
extends CompassTargetMarker,
GameMarker {
    default public FlagLocation getFlag() {
        return this.getInfo().getFlag();
    }

    public FlagInfo getInfo();

    @Override
    default public Location getLocation() {
        return this.getFlag().getLocation();
    }

    default public Team getTeam() {
        return this.getInfo().getTeam();
    }

    default public void setFlag(FlagLocation newFlag) {
        this.getInfo().setFlag(newFlag);
    }

    default public FlagLocation update(Function<FlagInfo, FlagLocation> updater) {
        FlagInfo info = this.getInfo();
        FlagLocation old = info.getFlag();
        FlagLocation newFlag = updater.apply(info);
        if (newFlag != null && newFlag != old) {
            info.setFlag(newFlag);
        }
        return newFlag;
    }

    @Override
    default public int getCompassTargetPriority(WarlordsPlayer player) {
        return player.getTeam() == this.getTeam() ? 20 : 0;
    }

    @Override
    default public String getToolbarName(WarlordsPlayer player) {
        FlagLocation flag = this.getFlag();
        Team team = this.getTeam();
        Team playerTeam = player.getTeam();
        StringBuilder builder = new StringBuilder();
        if (flag.getLocation().getWorld() != player.getLocation().getWorld()) {
            return "";
        }
        double flagDistance = (double)Math.round(flag.getLocation().distance(player.getLocation()) * 10.0) / 10.0;
        builder.append(team.teamColor()).append(ChatColor.BOLD);
        if (playerTeam != team) {
            builder.append("ENEMY ");
        } else {
            builder.append("YOUR ");
        }
        if (flag instanceof PlayerFlagLocation || flag instanceof GroundFlagLocation) {
            if (flag instanceof GroundFlagLocation && playerTeam != team) {
                builder.append("ENEMY ");
            }
            builder.append("Flag ");
            if (flag instanceof PlayerFlagLocation) {
                builder.append(ChatColor.WHITE).append("is stolen ");
            } else if (flag instanceof GroundFlagLocation) {
                builder.append(ChatColor.GOLD).append("is dropped ");
            }
            builder.append(ChatColor.RED).append(flagDistance).append("m ").append(ChatColor.WHITE).append("away!");
        } else {
            builder.append(ChatColor.GREEN).append("Flag is safe");
        }
        return builder.toString();
    }

    public static List<FlagLocation> update(Game game, Function<FlagInfo, FlagLocation> updater) {
        List<FlagHolder> markers = game.getMarkers(FlagHolder.class);
        ArrayList<FlagLocation> newLocations = new ArrayList<FlagLocation>(markers.size());
        for (FlagHolder holder : markers) {
            newLocations.add(holder.update(updater));
        }
        return newLocations;
    }

    public static boolean dropFlagForPlayer(WarlordsPlayer player) {
        for (FlagHolder holder : player.getGame().getMarkers(FlagHolder.class)) {
            if (holder.update(i -> i.getFlag() instanceof PlayerFlagLocation && ((PlayerFlagLocation)i.getFlag()).getPlayer().equals(player) ? new GroundFlagLocation((PlayerFlagLocation)i.getFlag()) : null) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerHolderFlag(WarlordsPlayer player) {
        for (FlagHolder holder : player.getGame().getMarkers(FlagHolder.class)) {
            FlagLocation flag = holder.getFlag();
            if (!(flag instanceof PlayerFlagLocation) || !((PlayerFlagLocation)flag).getPlayer().equals(player)) continue;
            return true;
        }
        return false;
    }

    public static boolean playerTryingToPick(WarlordsPlayer player) {
        for (FlagHolder flagHolder : player.getGame().getMarkers(FlagHolder.class)) {
            FlagInfo flagInfo = flagHolder.getInfo();
            if (!(flagInfo.getFlag() instanceof SpawnFlagLocation) || flagInfo.getTeam() == player.getTeam() || !(flagInfo.getFlag().getLocation().distanceSquared(player.getLocation()) < 144.0)) continue;
            return true;
        }
        return false;
    }

    public static FlagHolder create(FlagInfo info) {
        return FlagHolder.create(() -> info);
    }

    public static FlagHolder create(final Supplier<FlagInfo> info) {
        return new FlagHolder(){

            @Override
            public FlagInfo getInfo() {
                return (FlagInfo)info.get();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("FlagHolder.create{");
                sb.append(info.get());
                sb.append('}');
                return sb.toString();
            }
        };
    }
}

